<?php

//Home Latest News Shortcode [home-news]
function homeNews_shortcode($atts) {
    ob_start();
    $atts = shortcode_atts(['category' => ''], $atts);

    $news_args = array(
		'post_type' => array('post'),
		'posts_per_page' => 3,
		'category_name' => '',
		);

    $news_query = new WP_Query($news_args);

    if ($news_query->have_posts()) : ?>
        <div class="container">
            <div class="row">
                <?php while ($news_query->have_posts()) :
				$news_query->the_post();
				$categories = get_the_category();
			    ?>
                    <div class="col-md-4 mb-4 fade-up">
                        <div class="news-card h-100">
                            <div class="news-image-container">
                                <a href="<?= esc_url(get_permalink()); ?>">
                                    <?php 
                                        if (has_post_thumbnail()) {
                                            the_post_thumbnail('medium', ['class' => 'news-image']); 
                                        } else {
                                            echo '<img src="' . esc_url(get_template_directory_uri()) . '/assets/images/default-featured.jpg" alt="Default Image" class="news-image"/>';
                                        }
                                    ?>
                                </a>
                             </div>
                            <div class="news-card-body">
                                <div class="news-card-content">
                                    <?php 
                                        $categories = get_the_terms(get_the_ID(), 'news_category');
                                        if ($categories && !is_wp_error($categories)) {
                                            foreach ($categories as $category) {
                                                echo '<div class="news-category-badge">' . esc_html($category->name) . '</div>';
                                            }
                                        }
                                    ?>
                                    <a href="<?= esc_url(get_permalink()); ?>">
                                        <h4 class="card-title fade-up mb-3 mt-3 text-white"><?= esc_html(get_the_title()); ?></h4>
                                    </a>
                                   <div class="post-excerpt text-white line-clamp">
                                        <?php the_excerpt(); ?>
                                    </div>
                                </div>
                                <a href="<?= esc_url(get_permalink()); ?>" class="read-more text-white">Read more →</a>
                                
                            </div>
                        </div>
                    </div>
                 
                <?php endwhile; ?>
                   <!--<div class="btn-container">-->
                   <!--     <button id="show-all" class="btn btn-outline-primary px-4 py-2">All News</button>-->
                   <!-- </div>-->
            </div>
        </div>
        <?php wp_reset_postdata(); ?>
    <?php else : ?>
        <p>No news found.</p>
    <?php endif;

    return ob_get_clean();
}
add_shortcode('home-news', 'homeNews_shortcode');

// Other Latest News Shortcode [other-news]
function otherNews_shortcode($atts) {
    ob_start();
    $news_args = [
        'post_type'      => 'news',
        'posts_per_page' => 10,
    ];

    $news_query = new WP_Query($news_args);

    if ($news_query->have_posts()) : ?>
        <div class="row">
            <?php while ($news_query->have_posts()) : $news_query->the_post(); ?>
                <div class="col-md-4 col-sm-12 kpy-other-news">
                    <article>
                        <div class="card border-0" data-aos="fade-up">
                            <a href="<?= esc_url(get_permalink()); ?>" class="p-0">  
                                <div class="post-thumbnail">
                                    <?php 
                                        if (has_post_thumbnail()) {
                                            the_post_thumbnail('medium'); 
                                        } else {
                                            echo '<img src="'. esc_url(get_template_directory_uri()) .'/assets/images/default-featured.jpg" alt="Default Image" class="img-fluid"/>';
                                        }
                                    ?>
                                </div>
                            </a>
                            <div class="card-body">
                                <h3><?= esc_html(get_the_title()); ?></h3>
                                <div class="catz">
                                    <i class="bi bi-calendar-check"></i> <?= esc_html(get_the_date()); ?>
                                </div>
                                <a href="<?= esc_url(get_permalink()); ?>" class="read-more btn btn-outline-info">Read More</a>
                            </div>
                        </div>
                    </article>
                </div>
            <?php endwhile;
            wp_reset_postdata(); ?>
        </div>
    <?php else : ?>
        <p>No news found.</p>
    <?php endif;

    return ob_get_clean();
}
add_shortcode('other-news', 'otherNews_shortcode');

?>
