<div class="menu_kipya menu-section">
    <div class="container">
        <!-- Logo on the Far Left -->
        <div class="logo-container">
            <?php
            $custom_logo_id = get_theme_mod('custom_logo');
            $logo_url = wp_get_attachment_image_src($custom_logo_id, 'full');
            if ($logo_url) {
                echo '<a href="' . esc_url(home_url('/')) . '">
                        <img src="' . esc_url($logo_url[0]) . '" class="img-fluid logo" alt="' . get_bloginfo('name') . '">
                      </a>';
            } else {
                echo '<a href="' . esc_url(home_url('/')) . '"><h1>' . get_bloginfo('name') . '</h1></a>';
            }
            ?>
        </div>

        <!-- Navigation in the Center -->
        <div class="nav-container">
            <nav class="navbar navbar-expand-lg">
                <div class="container-fluid">
                    <button class="navbar-toggler" type="button" data-bs-toggle="offcanvas" data-bs-target="#offcanvasNavbar" aria-controls="offcanvasNavbar">
                        <span class="navbar-toggler-icon"></span>
                    </button>

                    <div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasNavbar" aria-labelledby="offcanvasNavbarLabel">
                        <div class="offcanvas-header">
                            <h5 class="offcanvas-title text-white" id="offcanvasNavbarLabel">MENU</h5>
                            <button type="button" class="btn-close text-reset" data-bs-dismiss="offcanvas" aria-label="Close"></button>
                        </div>
                        <div class="offcanvas-body">
                            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                                <li class="menu-item nav-item d-block d-md-none text-white">
                                    <a href="<?= esc_url(home_url('/')); ?>" class="nav-link">Home</a>
                                </li>
                                <?php
                                wp_nav_menu(array(
                                    'theme_location' => 'primary',
                                    'container'      => false,
                                    'menu_class'     => 'navbar-nav mx-auto mb-2 mb-md-0',
                                    'fallback_cb'    => '__return_false',
                                    'items_wrap'     => '<ul id="%1$s" class="%2$s">%3$s</ul>',
                                    'depth'          => 2,
                                    'walker'         => new bootstrap_5_wp_nav_menu_walker()
                                ));
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </nav>
        </div>

        <!-- Phone Section on the Far Right -->
        <div class="contact-container">
            <div class="text-white">
                
                <div class="d-flex align-items-center">
                    <i class="bi bi-telephone-fill me-2" style="font-size: 1.9rem; color: #ffff;"></i>
                    <div>
                        <p class="mb-1" style="font-size: 0.7rem;">Have any questions?</p>
                        <a href="tel:+256200922336" class="text-white" style="text-decoration: none; font-size: 0.7rem;">(+256) 200 922 336</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

