jQuery(document).ready(function($) {
    // Initialize Isotope if filter buttons exist
    if ($('.team-template-filter').length) {
        var $grid = $('.team-template-members').isotope({
            itemSelector: '.team-template-member',
            layoutMode: 'fitRows'
        });

        // Filter items on button click
        $('.team-template-filter').on('click', 'button', function() {
            var filterValue = $(this).attr('data-filter');
            $grid.isotope({ filter: filterValue });
        });

        // Change active class on buttons
        $('.team-template-filter').each(function(i, buttonGroup) {
            var $buttonGroup = $(buttonGroup);
            $buttonGroup.on('click', 'button', function() {
                $buttonGroup.find('.active').removeClass('active');
                $(this).addClass('active');
            });
        });
    }
});