document.addEventListener("DOMContentLoaded", function() {
    if (typeof gsap !== 'undefined' && typeof ScrollTrigger !== 'undefined') {
        // Wait for images to load
        window.addEventListener('load', function() {
            const teamMembers = document.querySelector(".team-members");
            const rightContent = document.querySelector(".right-content");
            
            if (teamMembers && rightContent) {
                // Calculate the scrollable distance
                const scrollDistance = teamMembers.scrollHeight - rightContent.offsetHeight + 100;
                
                // Reset position
                gsap.set(".team-members", { y: 0 });
                
                // Animate the team members list
                gsap.to(".team-members", {
                    y: -scrollDistance,
                    ease: "none",
                    scrollTrigger: {
                        trigger: ".team-section",
                        pin: true,
                        start: "top top",
                        end: () => `+=${scrollDistance}`,
                        scrub: 1,
                        markers: false,
                        invalidateOnRefresh: true
                    }
                });
            }
        });
        
        // Handle window resize
        function handleResize() {
            ScrollTrigger.refresh();
        }
        window.addEventListener('resize', handleResize);
    }
});