<?php
/*
Template Name: Single Gallery
*/

get_header(); 
include get_template_directory() . '/inc/menus/menu.php'; 
?>

<main role="main">
    <?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );?>
	<section class="header-wrap" style="background: linear-gradient(to top, rgba(94, 196, 1, 0.05), rgba(94, 196, 1, 0.1)), url('<?php echo $backgroundImg[0]; ?>') no-repeat;background-size: cover;background-position: center center; ">
	    <div class="overlay">
	    <div class="page-title">
    		  <div class="container">
                <div class="row justify-content-between">
                <div class="col-lg-12 align-self-end"> <h1 class="entry-title gallery-title"><?php the_title(); ?></h1>
                </div>
                </div>
            </div>
	    </div>
	    </div>
    </section>

    <section>
        <div class="container">
            <div class="gallery-content-area section-pad">
                <?php
                if (have_posts()) : while (have_posts()) : the_post();
                    // Get gallery images
                    $gallery = get_post_gallery(get_the_ID(), false);
                    if ($gallery && isset($gallery['ids'])) :
                        $image_ids = explode(',', $gallery['ids']);
                ?>
                <div class="photo-gallery-breadcrumb mb-3" id="album-gallery"><a class="gallery-breadcrumb" href="https://www.lwegatech.net/nhplatform/photo-gallery/">Main Album</a>» <?php the_title(); ?>
                </div><!-- Gallery breadcrumb !-->
                    <?php the_content(); ?>
                <?php
                    else :
                        echo '<p>No images found in this gallery.</p>';
                    endif;
                endwhile; else :
                    echo '<p>Sorry, no posts matched your criteria.</p>';
                endif;
                ?>
            </div>
        </div>
    </section>
    <!-- /section -->
</main>

<?php get_footer(); ?>
