<?php /* Template Name: Front Page Template */ get_header(); 
include get_template_directory() . '/inc/menus/menu.php';
?>
<main role="main">
	<?php
	    include get_template_directory() . '/inc/slides/ken-burns-slides.php';
    ?>

<section class="home-intro">
	<div class="container">
		<div class="row align-items-center">
			<div class="col-lg-7 col-md-6 d-none d-md-block" data-aos="fade-up"><?php  dynamic_sidebar('home-intro-banner');?></div>
			<div class="col-lg-5 col-md-6" data-aos="fade-up" data-aos-delay="100"><?php  dynamic_sidebar('home-intro-text');?></div>
		</div>
	</div><!-- container !-->
</section>
<section class="home-intro-bottom">
	<div class="container">
		<div class="row align-items-center">
			<div class="col-lg-6 col-md-5 mb-3"><?php  dynamic_sidebar('home-intro-video');?></div>
			<div class="col-lg-6 col-md-7 mb-3">
				<div class="card card-body p-md-4">
					<div data-aos="fade-up mb-3">
						<?php  dynamic_sidebar('home-intro-features');?>
					</div>
					<div class="count p-md-3" data-aos="fade-up">
						<?php  dynamic_sidebar('home-intro-stats');?>
					</div>
				</div>
			</div><!-- col 8 !-->
		</div>
	</div><!-- container !-->
</section>

	
	<section>
		<?php if (have_posts()): while (have_posts()) : the_post(); ?>

			<!-- article -->
			<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>

				<?php the_content(); ?>

	</article>
			<!-- /article -->

		<?php endwhile; ?>

		<?php else: ?>

			<!-- article -->
			<article>

				<h2><?php _e( 'Sorry, nothing to display.', 'kipya' ); ?></h2>

			</article>
			<!-- /article -->

		<?php endif; ?>
		</section>
	<section class="home-services">
		<div class="container">
			<div class="row">
				<div class="col-lg-8 mx-auto text-center mb-3">
					<h2 data-aos="fade-up">Our Services</h2>
					<p data-aos="fade-up">At Job Connect, we ensure you have a reliable and agile workforce coupled with clear, effective and well-managed business processes so as to drive productivity and growth of your business with every resource applied</p>
				</div>
			</div>
			<div class="row">
				<div class="col-12"></div>
				<div class="col-lg-4 col-md-4">
					<a href="<?php the_permalink(); ?>recruitment-process-outsourcing">
					<div class="card card-body p-1 border-0" data-aos="fade-up" data-aos-delay="50">
						<img src="<?php echo get_template_directory_uri(); ?>/assets/images/jobconnect-contractual-processes.jpg" alt="Recruitment Process Outsourcing" class="img-fluid">
						<div class="content"><h3>Recruitment Process Outsourcing</h3></div>
					</div><!-- card !-->
					</a>
				</div>
				<div class="col-lg-4 col-md-4">
					<a href="<?php the_permalink(); ?>contractual-process-outsourcing">
					<div class="card card-body p-1 border-0" data-aos="fade-up" data-aos-delay="150">
						<img src="<?php echo get_template_directory_uri(); ?>/assets/images/jobconnect-Logistics-Management.jpg" alt="Contractual Process Outsourcing" class="img-fluid">
						<div class="content"><h3>Contractual Process Outsourcing</h3></div>
					</div><!-- card !-->
					</a>
				</div>
				<div class="col-lg-4 col-md-4">
					<a href="<?php the_permalink(); ?>warehouse-logistics-management">
					<div class="card card-body p-1 border-0" data-aos="fade-up" data-aos-delay="250">
						<img src="<?php echo get_template_directory_uri(); ?>/assets/images/jobconnect-warehouse.jpg" alt="Warehouse & Logistics Management" class="img-fluid">
						<div class="content"><h3>Warehouse & Logistics Management</h3></div>
					</div><!-- card !-->
					</a>
				</div>
			</div><!-- row !-->
			<div class="row home-newz mt-md-5 mb-md-5 mt-2">
				<div class="col-12 mb-3">
				<h2 class="text-center mb-1" data-aos="fade-up">The Latest from Job Connect</h2>
				<p class=" col-lg-8 mx-auto text-center mb-md-5" data-aos="fade-up">Stay informed with the latest facts, trends, and inspiration to help you hire top talent or make your next career move.</p>
				</div>
				<div class="col-lg-3 col-md-4 mb-3 px-md-1" data-aos="fade-up">
					<?php  dynamic_sidebar('home-intro-news');?>
				</div><!-- col !-->
				<div class="col-lg-6 col-md-4 mb-3" data-aos="fade-up">
					<?php  dynamic_sidebar('home-intro-job-listing');?>
				</div><!-- col !-->
				<div class="col-lg-3 col-md-4 mb-3 px-md-1" data-aos="fade-up">
					<?php  dynamic_sidebar('home-intro-blog');?>
				</div><!-- col !-->
			</div><!-- row !-->
		</div>
	</section>
	<?php edit_post_link(); ?>

</main> <!-- Main Area !-->
<?php get_footer(); ?>

