<?php /* Template Name: Water_projects Page Template */
    get_header(); 
    include get_template_directory() . '/inc/menus/menu.php'; 
?>
<style>
.partners{
    margin-top:50px;
}
    /* Downloads Table Styles */
.table-responsive {
    overflow-x: auto;
    margin-bottom: 30px;
}

.downloads-table {
    width: 100%;
    border-collapse: collapse;
    margin: 20px 0;
    font-size: 0.9rem;
}

.downloads-table th {
    background-color: #f5f5f5;
    text-align: left;
    padding: 12px 15px;
    font-weight: 600;
}

.downloads-table td {
    padding: 15px;
    vertical-align: top;
    border-bottom: 1px solid #eee;
}

.downloads-table tr:hover {
    background-color: #f9f9f9;
}

.pub-title {
    margin: 0 0 5px 0;
    font-size: .1rem;
    color: #1446a0;
}

.pub-title:hover {
    color: #0d3c8f;
}

.pub-link p {
    margin: 0;
    color: #666;
}
.sidebar{
    position:sticky;
}

.no-downloads {
    text-align: center;
    color: #666;
    font-style: italic;
    padding: 20px;
    background: #f9f9f9;
    border-radius: 8px;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .downloads-table td {
        padding: 10px;
    }
    
    .pub-title {
        font-size: 1rem;
    }
    
    .downloads-table small {
        font-size: 0.8rem;
    }
}{
        background: #eee;
        padding: 2px 8px;
        border-radius: 10px;
        font-size: 0.85em;
    }
</style>

<main role="main">
    <?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );?>
    <section class="header-wrap" style="background: linear-gradient(to top, rgba(94, 196, 1, 0.05), rgba(94, 196, 1, 0.1)), url('<?php echo $backgroundImg[0]; ?>') no-repeat;background-size: cover;background-position: center center; ">
        <div class="overlay">
            <div class="page-title">
                <div class="container">
                    <div class="row justify-content-between">
                        <div class="col-lg-12 align-self-end"> 
                            <h1 class="entry-title"><?php the_title(); ?></h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!-- Header Section -->
    
    <section>
        <div class="container page-content">
            <div class="row">
                 <div class="col-lg-8 col-sm-12 main-content">
                    <?php if (have_posts()): while (have_posts()) : the_post(); ?>
                        <!-- article -->
                        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                            <?php the_content(); ?>
                            <br class="clear">
                            <?php edit_post_link(); ?>
                        </article>
                        <!-- /article -->
                    <?php endwhile; ?>
                    <?php else: ?>
                        <!-- article -->
                        <article>
                            <h2><?php _e( 'Sorry, nothing to display.', 'kipya' ); ?></h2>
                        </article>
                        <!-- /article -->
                    <?php endif; ?>
                </div>
                         <div class="col-lg-4 col-sm-12 sidebar-content sidebar">
                            <?php
                            /**
                             * Display news cards based on categories selected in page settings
                             * 
                             * @param int $posts_per_page Number of posts to display (default: 3)
                             * @param string|array $category Optional. Force specific category slug(s)
                             * @return string HTML output
                             */
                            function env_display_news_cards($posts_per_page = 4, $category = '') {
                                ob_start();
                                // Get current page ID
                                $page_id = get_the_ID();
                                
                                // If no category specified, get from page settings
                                if (empty($category)) {
                                    $page_categories = get_post_meta($page_id, '_page_post_categories', true);
                                    
                                    // If page has specific categories set
                                    if (!empty($page_categories) && is_array($page_categories)) {
                                        $category = $page_categories; // Keep as array for proper filtering
                                    } else {
                                        // Fallback: Get first category of current page (if it's a post)
                                        if (is_singular('post')) {
                                            $post_categories = get_the_category($page_id);
                                            if (!empty($post_categories)) {
                                                $category = $post_categories[0]->slug;
                                            }
                                        }
                                    }
                                }
                                
                                // Prepare query arguments
                                $args = [
                                    'post_type' => 'post',
                                    'posts_per_page' => absint($posts_per_page),
                                    'post_status' => 'publish',
                                    'ignore_sticky_posts' => true
                                ];
                                
                                // Add category filtering if available
                                if (!empty($category)) {
                                    if (is_array($category)) {
                                        // Use tax_query for multiple categories (OR relationship)
                                        $args['tax_query'] = array(
                                            array(
                                                'taxonomy' => 'category',
                                                'field'    => 'slug',
                                                'terms'    => $category,
                                                'operator' => 'IN'
                                            )
                                        );
                                    } else {
                                        // Single category - use category_name
                                        $args['category_name'] = $category;
                                    }
                                }
                                
                                // Query posts
                                $news_query = new WP_Query($args);
                                
                                // Display posts
                                if ($news_query->have_posts()) {
                                    echo '<div class="env-news-wrapper">';
                                    
                                    while ($news_query->have_posts()) {
                                        $news_query->the_post();
                                        
                                        $image_url = get_the_post_thumbnail_url(get_the_ID(), 'medium');
                                        $title = get_the_title();
                                        $date = get_the_date();
                                        $permalink = get_permalink();
                                        $excerpt = get_the_excerpt();
                                        
                                      echo '<a href="' . esc_url($permalink) . '" class="env-news-card">';
                                        if ($image_url) {
                                            echo '<div class="env-news-image"><img src="' . esc_url($image_url) . '" alt="' . esc_attr($title) . '"></div>';
                                        }
                                        echo '<div class="env-news-content"><h3>' . esc_html($title) . '</h3><p class="env-news-date">' . esc_html($date) . '</p></div></a>';
                                    }
                                    echo '</div>';
                                    
                                    wp_reset_postdata();
                                } else {
                                    echo '<p class="env-no-news">No news posts found in the selected categories.</p>';
                                }
                                
                                return ob_get_clean();
                            }
        
                            /**
                             * Display download cards based on page settings or manual selection
                             * 
                             * @param int $posts_per_page Number of downloads to display
                             * @param string|array $category Manual category selection
                             * @param bool $use_page_settings Whether to use page settings (default: true)
                             * @return string HTML output
                             */
                            /**
         * Display downloads in table format based on page settings or manual selection
         * 
         * @param int $posts_per_page Number of downloads to display
         * @param string|array $category Manual category selection
         * @param bool $use_page_settings Whether to use page settings (default: true)
         * @return string HTML output
         */
       function env_display_downloads_cards($posts_per_page = -1, $category = '', $use_page_settings = true) {
    ob_start();

    // Get categories from page settings if enabled
    if ($use_page_settings && empty($category)) {
        $page_categories = get_post_meta(get_the_ID(), '_page_downloads_categories', true);
        if (!empty($page_categories)) {
            $category = $page_categories;
        }
    }

    $args = [
        'post_type' => 'downloads',
        'posts_per_page' => $posts_per_page,
        'post_status' => 'publish',
        'orderby' => 'date',
        'order' => 'DESC'
    ];

    // Handle category filtering
    if (!empty($category)) {
        $args['tax_query'] = [
            [
                'taxonomy' => 'file_category',
                'field' => 'slug',
                'terms' => is_array($category) ? $category : [$category],
            ]
        ];
    }

    $downloads_query = new WP_Query($args);
    $total_posts = $downloads_query->found_posts;
    $show_more = $total_posts > 5;
    $initial_limit = 5;

    if ($downloads_query->have_posts()) {
        echo '<div class="env-downloads-wrapper" style="display: flex; flex-direction: column; gap: 10px;">';
        
        $counter = 0;
        while ($downloads_query->have_posts()) {
            $downloads_query->the_post();
            $counter++;
            
            // Add hidden class to items beyond the initial limit
            $hidden_class = ($counter > $initial_limit) ? 'env-download-hidden' : '';
            
            $post_id = get_the_ID();
            $title = get_the_title();
            $date = get_the_date();
            $permalink = get_permalink();
            $file_url = get_post_meta($post_id, '_file_url', true);
            $download_count = get_post_meta($post_id, '_download_count', true);
            $download_count = $download_count ? $download_count : 0;
            $file_size = '';
            
            if ($file_url) {
                $headers = @get_headers($file_url, 1);
                $file_size = isset($headers['Content-Length']) ? size_format($headers['Content-Length']) : '';
            }

            echo '<div class="env-download-card ' . esc_attr($hidden_class) . '" style="border-bottom: 1px solid #ccc; padding-bottom: 10px;' . ($counter > $initial_limit ? ' display: none;' : '') . '">';
            echo '<h3 class="pub_title" style="margin: 0 0 5px; font-size: 18px;">
                    <a href="' . esc_url($permalink) . '" style="color: #1446a0; text-decoration: none;">' . esc_html($title) . '</a>
                    <img src="https://lwegatech.net/mwe/wp-content/uploads/2025/06/paper.png" alt="Paper Icon" style="width: 20px; margin-left: 8px; vertical-align: middle;" />
                  </h3>';
            echo '<p style="margin: 0; color: #666; font-size: 12px;">
                    ' . esc_html($date) . ' &nbsp;|&nbsp; Downloads: ' . esc_html($download_count) . ' &nbsp;|&nbsp; Size: ' . esc_html($file_size) . '
                  </p>';
            echo '</div>';
        }

        // Add See More/See Less buttons if there are more than initial limit items
        if ($show_more) {
            echo '<div class="env-downloads-toggle-buttons" style="margin-top: 15px; display: flex; gap: 10px;">';
            echo '<button class="btn btn-success env-see-more-btn" style="padding: 8px 15px; border: none; cursor: pointer;">
                    See More (+' . ($total_posts - $initial_limit) . ')
                  </button>';
            echo '<button class="btn btn-danger env-see-less-btn" style="padding: 8px 15px;  border: none; cursor: pointer; display: none;">
                    See Less
                  </button>';
            echo '</div>';
        }

        echo '</div>';
        
        //The JavaScript to handle the toggle functionality
        if ($show_more) {
            echo '<script>
                    document.addEventListener("DOMContentLoaded", function() {
                        const seeMoreBtn = document.querySelector(".env-see-more-btn");
                        const seeLessBtn = document.querySelector(".env-see-less-btn");
                        const hiddenItems = document.querySelectorAll(".env-download-hidden");
                        const initialLimit = ' . $initial_limit . ';
                        
                        seeMoreBtn.addEventListener("click", function() {
                            hiddenItems.forEach(item => {
                                item.style.display = "block";
                            });
                            seeMoreBtn.style.display = "none";
                            seeLessBtn.style.display = "block";
                        });
                        
                        seeLessBtn.addEventListener("click", function() {
                            const allItems = document.querySelectorAll(".env-download-card");
                            allItems.forEach((item, index) => {
                                if (index >= initialLimit) {
                                    item.style.display = "none";
                                }
                            });
                            seeMoreBtn.style.display = "block";
                            seeLessBtn.style.display = "none";
                        });
                    });
                  </script>';
        }
        
        wp_reset_postdata();
    } else {
        echo '<p class="no-downloads">No downloads found in selected categories.</p>';
    }

    return ob_get_clean();
}?>
        
                            <h3 class='wp-block-heading'>News</h3>
                            <?php echo env_display_news_cards(); // Will automatically use categories set in page ?>
        
                            <h3 class='wp-block-heading'>Publications</h3>
                            <?php echo env_display_downloads_cards(); ?>
                        </div>
                
            </div>
            <div class='row'>
                <div class="success-wrapper container-xxl" style="max-width:100%">
                    <?php 
                echo do_shortcode('[success_slider]');
                ?>
                </div>
                
            </div>
            <div class='row partners'>
                <h3 class="wp-block-heading">DEVELOPMENT PARTNERS</h3>
                <?php 
                echo do_shortcode('[associates]');
                ?>
            </div>
        </div>
    </section>
    <!-- /section -->
</main>

<?php get_footer(); ?>