<?php /* Template Name: Contact Page Template */ 
get_header();
include get_template_directory() . '/inc/menus/menu.php';
?>
<main role="main">
    <?php $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>
    <section class="header-wrap" style="background: linear-gradient(135deg, rgba(0, 87, 183, 0.0) 0%, rgba(0, 150, 255, 0.0) 100%), url('<?php echo $backgroundImg[0]; ?>') no-repeat; background-size: cover; background-position: center;">
        <div class="overlay">
            <div class="page-title">
                <div class="container">
                    <div class="row justify-content-between">
                        <div class="col-lg-12 align-self-end">
                            <h1 class="entry-title text-white"><?php the_title(); ?></h1>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section><!-- Header Section -->

    <section class="py-5">
        <div class="container">
            <div class="contact-flex-wrapper">
                <!-- Contact Card 1 -->
                <div class="contact-card">
                    <div class="contact-card-inner">
                        <i class="fas fa-map-marker-alt icon"></i>
                        <h4>Head Office Address</h4>
                        <p>
                            Ministry of Water and Environment<br>
                            Plot 3-7, Kabalega Crescent, Luzira<br>
                            P.O. Box 20026, Kampala, Uganda
                        </p>
                    </div>
                </div>

                <!-- Contact Card 2 -->
                <div class="contact-card">
                    <div class="contact-card-inner">
                        <i class="fas fa-phone-alt icon"></i>
                        <h4>Phone Contacts</h4>
                        <p>
                            
                            Toll Free:  0800 100 444<br>
                            Emergency:  +256 417 889 400
                        </p>
                    </div>
                </div>

                <!-- Contact Card 3 -->
                <div class="contact-card">
                    <div class="contact-card-inner">
                        <i class="fas fa-envelope icon"></i>
                        <h4>Email</h4>
                        <p>
                            <a href="mailto:mwe@mwe.go.ug">mwe@mwe.go.ug</a><br>
                        </p>
                    </div>
                </div>

                <!-- Contact Card 4 -->
                <div class="contact-card">
                    <div class="contact-card-inner">
                        <i class="fas fa-clock icon"></i>
                        <h4>Office Hours</h4>
                        <p>
                            Mon–Fri: 8:00 AM – 5:00 PM<br>
                            Sat & Sun: Closed
                        </p>
                    </div>
                </div>

                <!-- Contact Card 5 -->
                <div class="contact-card">
                    <div class="contact-card-inner">
                        <i class="fas fa-globe-africa icon"></i>
                        <h4>Official Website</h4>
                        <p>
                            <a href="https://www.mwe.go.ug" target="_blank">www.mwe.go.ug</a>
                        </p>
                    </div>
                </div>
                <div class="contact-card">
                    <div class="contact-card-inner">
                        <i class="fas fa-building icon"></i>
                        <h4>Regional Offices</h4>
                        <p>
                            <strong>Northern Region:</strong> +256 000 000 000<br>
                            <strong>Eastern Region:</strong> +256 000 000 000<br>
                            <strong>Western Region:</strong> +256 000 000 000
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Map Section -->
    <section class="pb-5">
        <div class="container">
            <div class="map-container">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3989.7639575873923!2d32.64754407349251!3d0.29909716405510267!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x177dbe954cb93705%3A0x7a612134c18f16c0!2sMinistry%20Of%20Water%20and%20Environment!5e0!3m2!1sen!2sug!4v1750323504124!5m2!1sen!2sug" width="100%" height="450" style="border:0;" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
            </div>
        </div>
    </section>

    <!-- Additional Content Section -->
    <section class="py-4 bg-light">
        <div class="container">
            <?php if (have_posts()) : while (have_posts()) : the_post(); ?>
                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                    <?php the_content(); ?>
                    <?php edit_post_link(); ?>
                </article>
            <?php endwhile; endif; ?>
        </div>
    </section>
</main>

<style>
    /* Contact Cards Styling */
    .contact-flex-wrapper {
    display: grid;
    grid-template-columns: repeat(auto-fit, minmax(280px, 1fr));
    gap: 30px;
    margin: 5px 0;
}

.contact-card {
    background: white;
    border-radius: 12px;
    padding: 35px 30px;
    box-shadow: 0 10px 30px rgba(0, 87, 183, 0.08);
    transition: all 0.3s ease;
    border: 1px solid rgba(0, 87, 183, 0.1);
    position: relative;
   
   
}

.contact-card::before {
    content: '';
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 5px;
    background: linear-gradient(90deg, #0057B7 0%, #00A1E0 100%);
    transition: height 0.3s ease;
}

.contact-card:hover {
    transform: translateY(-5px);
    box-shadow: 0 15px 35px rgba(0, 87, 183, 0.12);
}

.contact-card:hover::before {
    height: 8px;
}

.contact-card .icon {
    font-size: 2.5rem;
    color: #28a745;
    margin-bottom: 20px;
    background: rgba(0, 87, 183, 0.1);
    width: 70px;
    height: 70px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.3s ease;
}

.contact-card:hover .icon {
    background: #28a745;
    color: white;
    transform: rotate(5deg) scale(1.1);
}

.contact-card h4 {
    color: #0057B7;
    font-size: 1.25rem;
    margin-bottom: 15px;
    font-weight: 600;
    position: relative;
    padding-bottom: 10px;
}

.contact-card h4::after {
    content: '';
    position: absolute;
    bottom: 0;
    left: 0;
    width: 50px;
    height: 2px;
    background: rgba(0, 87, 183, 0.3);
    transition: width 0.3s ease;
}

.contact-card:hover h4::after {
    width: 80px;
    background: #0057B7;
}

.contact-card p {
    color: #555;
    line-height: 1.7;
    font-size: 1rem;
    margin-bottom: 0;
}

.contact-card a {
    color: #0057B7;
    text-decoration: none;
    font-weight: 500;
    transition: all 0.2s ease;
    border-bottom: 1px dashed rgba(0, 87, 183, 0.3);
    padding-bottom: 2px;
}

.contact-card a:hover {
    color: #003366;
    border-bottom-color: #0057B7;
}

/* Responsive adjustments */
@media (max-width: 768px) {
    .contact-flex-wrapper {
        grid-template-columns: 1fr;
        gap: 20px;
    }
    
    .contact-card {
        padding: 25px 20px;
    }
}

    /* Map Styling */
    .map-container {
        border-radius: 10px;
        overflow: hidden;
        box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        border: 1px solid rgba(0, 0, 0, 0.1);
    }

    @media (max-width: 768px) {
        .contact-flex-wrapper {
            grid-template-columns: 1fr;
        }
        
        .contact-card-inner {
            padding: 20px;
        }
    }
</style>

<?php get_footer(); ?>