<?php
    get_header(); 
    include get_template_directory() . '/inc/menus/menu.php'; 
?>

<main role="main">
    <?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );?>
	<section class="header-wrap" style="background: linear-gradient(to top, rgba(94, 196, 1, 0.05), rgba(94, 196, 1, 0.1)), url('<?php echo $backgroundImg[0]; ?>') no-repeat;background-size: cover;background-position: center center; ">
	    <div class="overlay">
	    <div class="page-title">
    		  <div class="container">
                <div class="row justify-content-between">
                <div class="col-lg-12 align-self-end"> <h1 class="entry-title gallery-title"><?php the_title(); ?></h1>
                </div>
                </div>
            </div>
	    </div>
	    </div>
    </section>

    <section class="py-md-5 py-2">
        <div class="container">
            <div class="row">
                <div class="col-xl-9 col-lg-8 mb-3 mygallery">
                    <?php
                    if (have_posts()) :
                        while (have_posts()) : the_post();

                            // Get the first gallery in the post
                            $gallery = get_post_gallery(get_the_ID(), false);

                            if ($gallery && isset($gallery['ids'])) :
                                $image_ids = explode(',', $gallery['ids']);
                                ?>
                                <div class="row g-2">
                                   <?php foreach ($image_ids as $image_id) :
                                        $image_url = wp_get_attachment_image_url($image_id, 'large'); // Large image for lightbox
                                        $thumbnail_url = wp_get_attachment_image_url($image_id, 'full'); // Original size for grid display
                                        ?>
                                        <div class="col-md-4 col-6">
                                            <a href="<?php echo esc_url($image_url); ?>" class="glightbox" data-gallery="gallery">
                                                <img 
                                                    src="<?php echo esc_url($thumbnail_url); ?>" 
                                                    alt="<?php echo esc_attr(get_the_title($image_id)); ?>" 
                                                    class="img-fluid rounded ksmall" 
                                                    style="width: 100%; height: auto;" // Maintains original aspect ratio
                                                >
                                            </a>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                                <?php
                            else :
                                echo '<p>No images found in this gallery.</p>';
                            endif;

                            
                        endwhile;
                    else :
                        echo '<p>Sorry, no posts matched your criteria.</p>';
                    endif;
                    ?>
                </div>
                <div class="col-xl-3 col-lg-4 mb-3 about-side">
                    <h3>More Gallaries</h3>
                    <?php include get_template_directory() . '/inc/related-galleries.php'; ?>
                </div>
            </div>
            
        </div>
    </section>
</main>
<!-- Include Lightbox JS -->
<script>
    document.addEventListener('DOMContentLoaded', function () {
        const lightbox = GLightbox({
            selector: '.glightbox'
        });
    });
</script>
<?php get_footer(); ?>
