<?php 
if (is_singular('events')) { get_header(); 
    include get_template_directory() . '/inc/menus/menu.php'; 
	
	$post_id = get_the_ID();
    $text = get_the_content();
    $url =  get_post_meta(get_the_ID(), '_link', true);
    $location =  get_post_meta(get_the_ID(), '_location', true);
    $start_date = get_post_meta(get_the_ID(), '_start_date', true);
	$end_date = get_post_meta(get_the_ID(), '_end_date', true);
    $formatted_start_date = date('jS, F Y', strtotime($start_date)); // Format for Date
    $formatted_start_month = date('F', strtotime($start_date)); // Format for Month
    $formatted_start_time = date('g:i A', strtotime($start_date)); // Format for Time
	$formatted_end_date = date('jS, F Y', strtotime($end_date)); // Format for Date

	?>
	<main role="main">
		<?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );?>
		<section class="header-wrap" style="background: linear-gradient(to top, rgba(94, 196, 1, 0.05), rgba(94, 196, 1, 0.1)), url('<?php echo $backgroundImg[0]; ?>') no-repeat;background-size: cover;background-position: center center; ">
		    <div class="overlay">
		    <div class="page-title">
        		  <div class="container">
                    <div class="row justify-content-between">
                    <div class="col-lg-12 align-self-end"> <h1 class="entry-title"><?php the_title(); ?></h1>
                    </div>
                    </div>
                </div>
		    </div>
		    </div>
        </section><!-- Header Section !-->
		<section>
		    <div class="container page-content2">
		        <div class="row">
		            <div class="col-lg-9 col-md-9 col-sm-9" data-aos="fade up"><div class="post-content">
		        <?php if (have_posts()): while (have_posts()) : the_post(); ?>
				<!-- article -->
				<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
				
					<!-- post thumbnail -->
        			<div class="post-thumbnail mt-3">
        			<?php if ( has_post_thumbnail()) : // Check if Thumbnail exists ?>
        				<?php the_post_thumbnail(); // Fullsize image for the single post ?>
        			<?php endif; ?>
        			</div>
        			<!-- /post thumbnail -->
					<hr>
					<?php the_content(); ?>
				
				<!-- social media sharing !-->
				<div class="d-flex bd-highlight mb-1 single-event">
                            <div class="bd-highlight p-1">
                                <small class="text-muted">share this article</small>
                            </div>
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?= esc_url(get_permalink()); ?>" target="_blank" rel="noopener noreferrer" title="Facebook">
                                <small>Share on <i class="bi bi-facebook"></i> </small>
                                </a>
                            </div><!-- Facebook !-->
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-twitter" href="https://twitter.com/intent/tweet?url=<?= esc_url(get_permalink()); ?>&text=<?= the_title(); ?>" target="_blank" rel="noopener noreferrer" title="Twitter">
                                <small> Share on <i class="bi bi-twitter-x"></i></small>
                                </a>
                            </div><!-- Twitter !-->
                            <div class="bd-highlight p-1">
                                <a class="btn btn-sm btn-whatsapp" href="whatsapp://send?text=Check out this product: <?= the_title(); ?> - <?= esc_url(get_permalink());?>" data-action="share/whatsapp/share" title="WhatsApp">
                                <small><i class="bi bi-whatsapp"></i> WhatsApp</small>
                                </a>
                            </div><!-- WhatsApp !-->
                        </div><!-- social sharing !-->
				<!-- End of Social Media sharing !-->
		        </div>
		        </div>
		        <div class="col-lg-3 col-md-3 col-sm-3">
					<div class="card card-body ev-details shadow mb-3">
						<h4>Details</h4>
						<div class="d-flex bd-highlight mb-3">
							<div class="bd-highlight p-1 align-self-center">
								<i class="bi bi-calendar me-2"></i>
							</div>
							<div class="bd-highlight p-1">
								<span style="font-weight:600;display:flex;"><small>Start Date:</small></span>   
								<?= esc_html($formatted_start_date); ?>

								<?php if($formatted_end_date):?>
									<span style="font-weight:600;display:flex;mt-2"><small>End Date:</small></span>
									<?= esc_html($formatted_start_date); ?>
								<?php endif;?>
							</div>
						</div><!-- item !-->
						<div class="d-flex bd-highlight mb-3">
							<div class="bd-highlight p-1 align-self-center">
							<i class="bi bi-geo-alt"></i>
							</div>
							<div class="bd-highlight p-1">
								<span style="font-weight:600;display:flex;"><small>Location</small><br/></span>   
								<?= esc_html($location); ?>
							</div>
						</div><!-- item !-->
						
					</div>
		            <div class="about-side">
		                <h3>Latest Stories</h3>
		                <?php
                        include get_template_directory() . '/inc/related-news.php';
                        ?>

		            </div>
		        </div>
		        </div>
				<?php edit_post_link(); ?>

			</article>
			<!-- /article -->

		<?php endwhile; ?>

		<?php else: ?>

			<!-- article -->
			<article>

				<h2><?php _e( 'Sorry, nothing to display.', 'kipya' ); ?></h2>

			</article>
			<!-- /article -->

		<?php endif; ?>
		    </div>
		</section>
		<div class="mb-md-5 mt-3"></div>
		<!-- /section -->
 </main>
<?php 
} else {
    // If the post type is not "downloads", you can display a message or redirect to another page
    echo '<p>Sorry, this page is only for Events.</p>';
}
get_footer(); ?>