<?php
/**
 * Template Name: Departments + News + Downloads
 * Template Post Type: page
 */

get_header();
include get_template_directory() . '/inc/menus/menu.php';

// Get page background image
$backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full');
?>

<!-- 📌 Header Section -->
<section class="header-wrap" style="background: linear-gradient(to top, rgba(94, 196, 1, 0.05), rgba(94, 196, 1, 0.1)), url('<?php echo esc_url($backgroundImg[0]); ?>') no-repeat; background-size: cover; background-position: center center;">
  <div class="overlay">
    <div class="page-title">
      <div class="container">
        <div class="row justify-content-between">
          <div class="col-lg-12 align-self-end">
            <h1 class="entry-title"><?php the_title(); ?></h1>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>

<!-- 📌 Main Content Container -->
<div class="container">
    
     <!-- ✅ Default Page Content (optional content from editor) -->
  <div class="row" style="margin-top: 40px;">
    <?php
    if (have_posts()) :
        while (have_posts()) : the_post();
            the_content();
        endwhile;
    endif;
    ?>
  </div>

  <!-- ✅ Umbrella & Zones Tabs Shortcode -->
  <div style="margin-top: 40px;">
      <?php
      $page_ID = get_the_ID();
      $departments_cat = get_post_meta($page_ID, '_page_post_categories', true);
      if (is_array($departments_cat)) {
          $departments_cat = reset($departments_cat);
      }

      if (!empty($departments_cat)) {
          echo do_shortcode('[umbrella_zones_tabs category="' . esc_attr($departments_cat) . '"]');
      } else {
          echo '<p>No Umbrellas/Zonsz Available yet</p>';
      }
    ?>
  </div>



  <!-- ✅ Projects Section -->
  <div style="margin-top: 60px;">
    <h2 class="wp-block-heading">Projects</h2>
    <?php
      $page_ID = get_the_ID();
      $departments_cat = get_post_meta($page_ID, '_page_post_categories', true);
      if (is_array($departments_cat)) {
          $departments_cat = reset($departments_cat);
      }

      if (!empty($departments_cat)) {
          echo do_shortcode('[departments category="' . esc_attr($departments_cat) . '"]');
      } else {
          echo '<p>No Projects available yet</p>';
      }
    ?>
  </div>

  <!-- ✅ News & Downloads Section -->
  <div class="row" style="margin-top: 60px;">
    <div class="col-md-6">
      <h3 class="wp-block-heading">News</h3>
      <?php echo env_display_news_cards(); ?>
    </div>

    <div class="col-md-6">
      <h3 class="wp-block-heading">Publications</h3>
      <?php echo env_display_downloads_cards(); ?>
    </div>
  </div>

</div>

<?php
// 📌 News Function
function env_display_news_cards($posts_per_page = -1, $category = '') {
  ob_start();
  $page_id = get_the_ID();

  if (empty($category)) {
    $page_categories = get_post_meta($page_id, '_page_post_categories', true);
    if (!empty($page_categories) && is_array($page_categories)) {
      $category = $page_categories;
    } else if (is_singular('post')) {
      $post_categories = get_the_category($page_id);
      if (!empty($post_categories)) {
        $category = $post_categories[0]->slug;
      }
    }
  }

  $args = [
    'post_type' => 'post',
    'posts_per_page' => $posts_per_page,
    'post_status' => 'publish',
    'ignore_sticky_posts' => true,
  ];

  if (!empty($category)) {
    if (is_array($category)) {
      $args['tax_query'] = [[
        'taxonomy' => 'category',
        'field'    => 'slug',
        'terms'    => $category,
        'operator' => 'IN'
      ]];
    } else {
      $args['category_name'] = $category;
    }
  }

  $news_query = new WP_Query($args);

  if ($news_query->have_posts()) {
    echo '<div class="env-news-wrapper">';
    while ($news_query->have_posts()) {
      $news_query->the_post();
      $image_url = get_the_post_thumbnail_url(get_the_ID(), 'medium');
      $title = get_the_title();
      $date = get_the_date();
      $permalink = get_permalink();

      echo '<a href="' . esc_url($permalink) . '" class="env-news-card">';
      if ($image_url) {
        echo '<div class="env-news-image"><img src="' . esc_url($image_url) . '" alt="' . esc_attr($title) . '"></div>';
      }
      echo '<div class="env-news-content"><h3>' . esc_html($title) . '</h3><p class="env-news-date">' . esc_html($date) . '</p></div>';
      echo '</a>';
    }
    echo '</div>';
    wp_reset_postdata();
  } else {
    echo '<p class="env-no-news">No News Available yet.</p>';
  }

  return ob_get_clean();
}

// 📌 Downloads Function
function env_display_downloads_cards($posts_per_page = -1, $category = '', $use_page_settings = true) {
    ob_start();

    if ($use_page_settings && empty($category)) {
        $category = get_post_meta(get_the_ID(), '_page_downloads_categories', true);
    }

    $args = [
        'post_type' => 'downloads',
        'posts_per_page' => $posts_per_page,
        'post_status' => 'publish',
        'orderby' => 'date',
        'order' => 'DESC',
    ];

    if (!empty($category)) {
        $args['tax_query'] = [[
            'taxonomy' => 'file_category',
            'field'    => 'slug',
            'terms'    => is_array($category) ? $category : [$category],
        ]];
    }

    $downloads_query = new WP_Query($args);
    $total_posts = $downloads_query->found_posts;
    $initial_limit = 5; // Set how many to show initially
    $count = 0;

    if ($downloads_query->have_posts()) {
        echo '<div class="env-downloads-wrapper" style="display: flex; flex-direction: column; gap: 10px;">';

        while ($downloads_query->have_posts()) {
            $downloads_query->the_post();
            $post_id = get_the_ID();
            $title = get_the_title();
            $date = get_the_date();
            $permalink = get_permalink();
            $file_url = get_post_meta($post_id, '_file_url', true);
            $download_count = get_post_meta($post_id, '_download_count', true) ?: 0;
            $file_size = '';

            if ($file_url) {
                $headers = @get_headers($file_url, 1);
                $file_size = isset($headers['Content-Length']) ? size_format($headers['Content-Length']) : '';
            }

            $hidden_class = ($count >= $initial_limit) ? 'env-download-hidden' : '';
            $display_style = ($count >= $initial_limit) ? 'display:none;' : '';

            echo '<div class="env-download-card ' . $hidden_class . '" style="border-bottom: 1px solid #ccc; padding-bottom: 10px; ' . $display_style . '">';
            echo '<h3 style="margin: 0 0 5px; font-size: 18px;">
                    <a href="' . esc_url($permalink) . '" style="color: #1446a0; text-decoration: none;">' . esc_html($title) . '</a>
                    <img src="https://lwegatech.net/mwe/wp-content/uploads/2025/06/paper.png" alt="Paper Icon" style="width: 20px; margin-left: 8px; vertical-align: middle;" />
                  </h3>';
            echo '<p style="margin: 0; color: #666; font-size: 12px;">' . esc_html($date) . ' | Downloads: ' . esc_html($download_count) . ' | Size: ' . esc_html($file_size) . '</p>';
            echo '</div>';

            $count++;
        }

        echo '</div>';

        // Toggle buttons and script
        if ($total_posts > $initial_limit) {
            echo '<div class="env-downloads-toggle-buttons" style="margin-top: 15px; display: flex; gap: 10px;">';
            echo '<button class="btn btn-success env-see-more-btn" style="padding: 8px 15px; border: none; cursor: pointer;">
                    See More (+' . ($total_posts - $initial_limit) . ')
                  </button>';
            echo '<button class="btn btn-danger env-see-less-btn" style="padding: 8px 15px; border: none; cursor: pointer; display: none;">
                    See Less
                  </button>';
            echo '</div>';

            echo '<script>
                    document.addEventListener("DOMContentLoaded", function() {
                        const seeMoreBtn = document.querySelector(".env-see-more-btn");
                        const seeLessBtn = document.querySelector(".env-see-less-btn");
                        const hiddenItems = document.querySelectorAll(".env-download-hidden");
                        const initialLimit = ' . $initial_limit . ';

                        seeMoreBtn.addEventListener("click", function() {
                            hiddenItems.forEach(item => item.style.display = "block");
                            seeMoreBtn.style.display = "none";
                            seeLessBtn.style.display = "inline-block";
                        });

                        seeLessBtn.addEventListener("click", function() {
                            hiddenItems.forEach(item => item.style.display = "none");
                            seeMoreBtn.style.display = "inline-block";
                            seeLessBtn.style.display = "none";
                        });
                    });
                  </script>';
        }

        wp_reset_postdata();
    } else {
        echo '<p class="no-downloads">No Publications Available yet.</p>';
    }

    return ob_get_clean();
}


get_footer();
