jQuery(document).ready(function($) {
    function initializeCarousel(selector) {
        var $carousel = $(selector);
        var totalItems = $carousel.find('.item').length;
        
        // Destroy any existing instance
        if ($carousel.hasClass('owl-loaded')) {
            $carousel.trigger('destroy.owl.carousel');
            $carousel.find('.owl-stage-outer').children().unwrap();
        }

        $carousel.owlCarousel({
            loop: false,
            rewind: true,
            margin: 15,
            nav: true,
            dots: true,
            autoplay: false,
            smartSpeed: 600,
            stagePadding: 20,
            lazyLoad: false,
            navText: [
                '<span class="custom-prev">&#9665;</span>',
                '<span class="custom-next">&#9655;</span>'
            ],
            responsive: {
                0: { items: 1, stagePadding: 10 },
                600: { items: 2, stagePadding: 15 },
                1000: { items: 4, stagePadding: 20 }
            }
        });

        // Force equal heights
        setTimeout(function() {
            equalizeHeights(selector);
        }, 300);
    }

    function equalizeHeights(selector) {
        var maxHeight = 0;
        $(selector + ' .item .card').each(function() {
            $(this).css('height', 'auto');
            var thisHeight = $(this).outerHeight();
            if (thisHeight > maxHeight) {
                maxHeight = thisHeight;
            }
        }).css('height', maxHeight + 'px');
    }

    // Initialize all carousels
    initializeCarousel('#newsCarousel');
    initializeCarousel('#eventsCarousel');
    initializeCarousel('#mediaCarousel');

    // Reinitialize on tab change
    $('#myTab a').on('shown.bs.tab', function(e) {
        var target = $(e.target).attr('href');
        if (target === '#news-tab-pane') {
            initializeCarousel('#newsCarousel');
        } else if (target === '#events-tab-pane') {
            initializeCarousel('#eventsCarousel');
        } else if (target === '#media-tab-pane') {
            initializeCarousel('#mediaCarousel');
        }
    });

    // Handle window resize
    $(window).on('resize', function() {
        equalizeHeights('#newsCarousel');
        equalizeHeights('#eventsCarousel');
        equalizeHeights('#mediaCarousel');
    });
});


