<div class="success-story-card">
    <?php if (has_post_thumbnail($post->ID)) : ?>
        <div class="card-img-top" style="height: 200px; overflow: hidden;">
            <a href="<?php echo get_permalink($post); ?>">
                <?php echo get_the_post_thumbnail($post->ID, $atts['image_size'], [
                    'class' => 'w-100 h-100',
                    'style' => 'object-fit: cover;'
                ]); ?>
            </a>
        </div>
    <?php endif; ?>
    
    <div class="card-body">
        <h5 class="card-title">
            <a href="<?php echo get_permalink($post); ?>">
                <?php echo esc_html($post->post_title); ?>
            </a>
        </h5>
        
        <?php if ($atts['show_excerpt'] === 'true') : ?>
            <p class="card-text">
                <?php echo wp_trim_words(get_the_excerpt($post), 15); ?>
            </p>
        <?php endif; ?>
        
        <div class="card-footer bg-white border-top-0">
            <?php if ($atts['show_date'] === 'true') : ?>
                <small class="text-muted">
                    <?php echo get_the_date('M j, Y', $post); ?>
                </small>
            <?php endif; ?>
            
            <a href="<?php echo get_permalink($post); ?>" class="btn btn-primary btn-sm float-end">
                Read More
            </a>
        </div>
    </div>
</div>