<!-- News Loop -->
<?php
$current_post_id = get_the_ID();

// Get the latest 5 news articles excluding the current one
$news_args = array(
    'post_type' => 'post',
    'posts_per_page' => 3,
    'category_name' => 'news, blog',
    'post__not_in' => array($current_post_id) // Exclude the current post
);

$news_query = new WP_Query($news_args);

if ($news_query->have_posts()) :
?>
<div class="row">
    <?php while ($news_query->have_posts()) : $news_query->the_post(); ?>
    <div class="col-12">
        <article>
            <a href="<?= esc_url(get_permalink()); ?>">
                <div class="card shadow-sm mb-3 border-0" data-aos="fade-up">
                    <div class="post-thumbnail">
                        <?php // Display the post thumbnail
                        if (has_post_thumbnail()) {
                            the_post_thumbnail();
                        } else {
                            echo '<img src="' . get_template_directory_uri() . '/assets/images/placeholder-image.jpg" alt="Afiego" class="img-fluid"/>';
                        }
                        ?>
                    </div>
                    <div class="card-body">
                        <h5><?php the_title(); ?></h5>
                        <div class="catz">
                            <i class="bi bi-calendar-check"></i> <?php
                            $post_date = get_the_date();
                            echo $post_date;
                            ?>
                        </div><!-- Date !-->
                        <!--<a href="<?= esc_url(get_permalink()); ?>" class="btn btn-outline-info read-more">Read More</a> !-->
                    </div><!-- card body !-->
                </div><!-- card !-->
            </a>
        </article>
    </div><!-- col !-->
    <?php endwhile;
    wp_reset_postdata();
    ?>
</div><!-- Row !-->
<?php
else :
    echo 'No news found.';
endif;
?>
