<?php

//Home Latest News 
function homeNews_shortcode($atts) {
    ob_start(); // Start output buffering
    $atts = shortcode_atts(['category' => ''], $atts);
    $news_args = array(
        'post_type' => array('post'),
        'posts_per_page' => 3,
        'tax_query' => [
            [
                'taxonomy' => 'category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ],
        ],
    );
    $news_query = new WP_Query($news_args);

    if ($news_query->have_posts()) : ?>
            <?php while ($news_query->have_posts()) :
                $news_query->the_post();
            ?>
            <article>
                
                <div class="row kpy-front-news" data-aos="fade-up">
                    <div class="col-4">
                        <a href="<?= esc_url(get_permalink()); ?>">
                            <?php 
                                if (has_post_thumbnail()) {
                                    the_post_thumbnail('thumbnail'); 
                                } else {
                                    echo '<img src="' . get_template_directory_uri() . '/assets/images/default-featured.jpg" alt="Default Image" class="img-fluid"/>';
                                }
                            ?>
                        </a>
                    </div>
                    <div class="col-8">
                     <a href="<?= esc_url(get_permalink()); ?>">
                        <h4><?php the_title(); ?></h4>
                        <div class="catz">
                            <?php echo get_the_date(); ?>
                        </div>
                        </a>
                    </div>
                </div>
                
            </article>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
    <?php else : ?>
        <p>No news found.</p>
    <?php endif;

    return ob_get_clean(); // Return the buffered content
}

// Register the shortcode
add_shortcode('home-news', 'homeNews_shortcode');

//Other Latest News 
function otherNews_shortcode($atts) {
    ob_start(); // Start output buffering

	$news_args = array(
		'post_type' => array('post'),
		'posts_per_page' => 3,
		'category_name' => 'news, blog',
		);
	?>																
	<?php $news_query = new WP_Query($news_args);?>
		<?php if ($news_query->have_posts()) : ?>
		<div class="row">
			<?php while ($news_query->have_posts()) :
				$news_query->the_post();
				$categories = get_the_category();
			?>
			<div class="col-md-4 col-sm-12 kpy-other-news">
				<article>
                    <div class="card border-0" data-aos="fade-up">
                        <a href="<?= esc_url(get_permalink()); ?>" class="p-0">  
                             
							<div class="post-thumbnail">
								<?php // Display the post thumbnail
									if (has_post_thumbnail()) {
										the_post_thumbnail('medium'); 
									}else{
										echo '<img src="'. get_template_directory_uri().'/assets/images/default-featured.jpg" alt="jC" class="img-fluid"/>';
									}
								?> 
								</div>
						</a>
                        <div class="card-body">
                            <h3><?php the_title(); ?></h3>
							<div class="catz">
									<i class="bi bi-calendar-check"></i> <?php
									$post_date = get_the_date();
									echo $post_date;
									?>
							</div><!-- Date !-->
							<a href="<?= esc_url(get_permalink()); ?>" class="read-more btn btn-outline-info">Read More</a>
                        </div>
                    </div>
				</article>
			</div><!-- col !-->
			<?php endwhile;
				wp_reset_postdata();
			else :
				echo 'No news found.';
			endif;
			?>
	</div><!-- Row !-->
    <?php

    return ob_get_clean(); // Return the buffered content
}

// Register the shortcode
add_shortcode('other-news', 'otherNews_shortcode');