<?php
// Register MWE News Custom Post Type
function mwe_register_news_post_type() {
    register_post_type('mwe_news',
        array(
            'labels' => array(
                'name' => __('MWE News'),
                'singular_name' => __('MWE News')
            ),
            'public' => true,
            'has_archive' => true,
            'supports' => array('title', 'editor', 'thumbnail'),
            'menu_icon' => 'dashicons-media-text',
        )
    );
}
add_action('init', 'mwe_register_news_post_type');

// Add External URL Meta Box
function mwe_news_add_meta_boxes() {
    add_meta_box(
        'mwe_news_link', 
        'Article Link',
        'mwe_news_link_meta_box_callback',
        'mwe_news',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'mwe_news_add_meta_boxes');

function mwe_news_link_meta_box_callback($post) {
    wp_nonce_field('mwe_news_save_meta_box_data', 'mwe_news_meta_box_nonce');

    $link_url = get_post_meta($post->ID, '_mwe_link_url', true);

    echo '<p><label for="mwe_link_url">Full Article URL (will open in new tab):</label>';
    echo '<input type="url" id="mwe_link_url" name="mwe_link_url" value="' . esc_attr($link_url) . '" style="width:100%;" placeholder="https://example.com/full-article" /></p>';
}

function mwe_news_save_meta_box_data($post_id) {
    if (!isset($_POST['mwe_news_meta_box_nonce']) || !wp_verify_nonce($_POST['mwe_news_meta_box_nonce'], 'mwe_news_save_meta_box_data')) {
        return;
    }
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    if (isset($_POST['post_type']) && 'mwe_news' == $_POST['post_type']) {
        if (!current_user_can('edit_post', $post_id)) {
            return;
        }
    }

    if (isset($_POST['mwe_link_url'])) {
        update_post_meta($post_id, '_mwe_link_url', esc_url_raw($_POST['mwe_link_url']));
    }
}
add_action('save_post', 'mwe_news_save_meta_box_data');

// MWE News Shortcode with all requested modifications
function mwe_news_shortcode() {
    ob_start(); 

    $news_args = array(
        'post_type' => 'mwe_news',
        'posts_per_page' => -1,
        'orderby' => 'date',
        'order' => 'DESC'
    );

    $news_query = new WP_Query($news_args);

    if ($news_query->have_posts()) : ?>
        <div class="mwe-news-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 24px; padding: 20px; max-width: 1200px; margin: 0 auto;">
            <?php while ($news_query->have_posts()) :
                $news_query->the_post();
                $external_url = get_post_meta(get_the_ID(), '_mwe_link_url', true);
                $date = get_the_date('F j, Y');
                ?>
                <div class="mwe-news-card" style="background-color: #ffffff; border-radius: 10px; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.06); overflow: hidden; display: flex; flex-direction: column; transition: all 0.3s ease;">
                    <?php if (!empty($external_url)) : ?>
                        <a href="<?php echo esc_url($external_url); ?>" target="_blank" rel="noopener noreferrer" style="text-decoration: none; color: inherit;">
                    <?php endif; ?>
                    
                    <?php if (has_post_thumbnail()) : ?>
                        <div class="card-image" style="width: 100%; height: 200px; overflow: hidden;">
                            <?php the_post_thumbnail('medium', ['style' => 'width: 100%; height: 100%; object-fit: cover; transition: transform 0.3s ease;']); ?>
                        </div>
                    <?php else : ?>
                        <div class="card-image" style="width: 100%; height: 200px; overflow: hidden; background-color: #f3f4f6; display: flex; align-items: center; justify-content: center;">
                            <span style="color: #9ca3af;">No Image</span>
                        </div>
                    <?php endif; ?>
                    
                    <div class="mwe-news-card-content" style="padding: 20px; display: flex; flex-direction: column; flex-grow: 1;">
                        <h3 style="font-size: clamp(16px, 2vw, 18px); margin: 0 0 10px; color: #1f2937; font-weight: 600; line-height: 1.4; text-align: center; transition: color 0.3s ease;"><?php the_title(); ?></h3>
                        
                        <div style="display: flex; align-items: center; justify-content: center; margin-bottom: 15px;">
                            <span style="color: #6b7280; font-size: 14px;"><?php echo $date; ?></span>
                        </div>
                    </div>
                    
                    <?php if (!empty($external_url)) : ?>
                        </a>
                    <?php endif; ?>
                    
                    <?php if (!empty($external_url)) : ?>
                        <div style="margin-top: auto; text-align: center; padding: 0 20px 20px;">
                            <a href="<?php echo esc_url($external_url); ?>" class="btn btn-outline-primary see-full-news" style="border: 2px solid var(--kpy-primary); color: var(--kpy-primary); padding: 10px 20px; border-radius: 25px; font-size: 14px; text-decoration: none; transition: all 0.3s ease; display: inline-block; cursor: pointer; background-color: transparent;" target="_blank" rel="noopener noreferrer" onmouseover="this.style.backgroundColor='var(--kpy-primary)'; this.style.color='#ffffff'" onmouseout="this.style.backgroundColor='transparent'; this.style.color='var(--kpy-primary)'">Read Full Article</a>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endwhile;
            wp_reset_postdata(); ?>
        </div>
    <?php else :
        echo '<p style="text-align: center; color: #6b7280;">No news articles available at the moment.</p>';
    endif;

    return ob_get_clean();
}
add_shortcode('mwe_news', 'mwe_news_shortcode');