<?php
function gallery_cards_shortcode($atts) {
    ob_start();
    
    // Shortcode attributes
    $atts = shortcode_atts(array(
        'posts_per_page' => 12,
        'category' => 'photo-gallery'
    ), $atts);
    
    // Pagination
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    
    // Query arguments
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['posts_per_page'],
        'category_name' => $atts['category'],
        'paged' => $paged
    );
    
    $gallery_query = new WP_Query($args);
    
    if ($gallery_query->have_posts()) : ?>
        <div class="gallery-cards-container">
            <div class="gallery-grid">
                <?php while ($gallery_query->have_posts()) : $gallery_query->the_post(); ?>
                    <div class="gallery-card">
                        <a href="<?php the_permalink(); ?>" class="gallery-card-link">
                            <div class="gallery-thumbnail-wrapper">
                                <?php if (has_post_thumbnail()) : ?>
                                    <?php the_post_thumbnail('large', array('class' => 'gallery-thumbnail')); ?>
                                <?php else : ?>
                                    <img src="<?php echo esc_url(get_template_directory_uri() . '/assets/images/photo-placeholder.jpg'); ?>" 
                                         alt="<?php esc_attr(the_title()); ?>" 
                                         class="gallery-thumbnail">
                                <?php endif; ?>
                                <div class="gallery-title-overlay">
                                    <h3 class="gallery-title"><?php the_title(); ?></h3>
                                </div>
                            </div>
                        </a>
                    </div>
                <?php endwhile; ?>
            </div>
            
            <!-- Pagination -->
            <div class="gallery-pagination">
                <?php
                echo paginate_links(array(
                    'total' => $gallery_query->max_num_pages,
                    'current' => $paged,
                    'prev_text' => __('<span class="pagination-arrow">&larr;</span> Previous'),
                    'next_text' => __('Next <span class="pagination-arrow">&rarr;</span>'),
                    'type' => 'list',
                    'mid_size' => 2
                ));
                ?>
            </div>
        </div>
        
        <style>
        .gallery-cards-container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 20px;
        }
        
        .gallery-grid {
            display: grid;
            grid-template-columns: repeat(auto-fill, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .gallery-card {
            position: relative;
            border-radius: 8px;
            overflow: hidden;
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
            aspect-ratio: 1/1;
        }
        
        .gallery-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 8px 16px rgba(0,0,0,0.2);
        }
        
        .gallery-thumbnail-wrapper {
            position: relative;
            width: 100%;
            height: 100%;
        }
        
        .gallery-thumbnail {
            width: 100%;
            height: 100%;
            object-fit: cover;
            display: block;
            transition: transform 0.5s ease;
        }
        
        .gallery-card:hover .gallery-thumbnail {
            transform: scale(1.05);
        }
        
        .gallery-title-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            padding: 20px;
            background: linear-gradient(to top, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0) 100%);
            color: #fff;
        }
        
        .gallery-title {
            margin: 0;
            font-size: 1.2rem;
            line-height: 1.3;
            text-shadow: 1px 1px 3px rgba(0,0,0,0.5);
            transform: translateY(10px);
            transition: transform 0.3s ease;
            opacity: 0.9;
        }
        
        .gallery-card:hover .gallery-title {
            transform: translateY(0);
            opacity: 1;
        }
        
        .gallery-card-link {
            display: block;
            height: 100%;
            text-decoration: none;
            color: inherit;
        }
        
        .gallery-pagination {
            display: flex;
            justify-content: center;
            margin-top: 40px;
        }
        
        .gallery-pagination .page-numbers {
            display: flex;
            list-style: none;
            padding: 0;
            margin: 0;
            gap: 8px;
        }
        
        .gallery-pagination .page-numbers li a,
        .gallery-pagination .page-numbers li span {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 40px;
            height: 40px;
            padding: 0 10px;
            border-radius: 6px;
            background: #f8f9fa;
            color: #495057;
            text-decoration: none;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        
        .gallery-pagination .page-numbers li a:hover {
            background: #228b22;
            color: #fff;
        }
        
        .gallery-pagination .page-numbers li span.current {
            background: #228b22;
            color: #fff;
        }
        
        .gallery-pagination .page-numbers li .pagination-arrow {
            margin: 0 5px;
        }
        
        @media (max-width: 768px) {
            .gallery-grid {
                grid-template-columns: repeat(auto-fill, minmax(200px, 1fr));
                gap: 15px;
            }
            
            .gallery-title-overlay {
                padding: 15px;
            }
            
            .gallery-title {
                font-size: 1rem;
            }
        }
        
        @media (max-width: 480px) {
            .gallery-grid {
                grid-template-columns: 1fr 1fr;
                gap: 10px;
            }
            
            .gallery-title-overlay {
                padding: 10px;
            }
        }
        </style>
        
    <?php else : ?>
        <p class="no-galleries">No photo galleries found.</p>
    <?php endif;
    
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('mwe_gallery', 'gallery_cards_shortcode');