<?php
function enqueue_owl_carousel_assets() {
    wp_enqueue_style('owl-carousel-css', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css');
    wp_enqueue_style('owl-theme-css', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css');
    wp_enqueue_script('jquery');
    wp_enqueue_script('owl-carousel-js', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js', array('jquery'), '', true);
    wp_enqueue_script('custom-owl-js', get_template_directory_uri() . '/js/custom-owl.js', array('jquery', 'owl-carousel-js'), '', true);
}
add_action('wp_enqueue_scripts', 'enqueue_owl_carousel_assets');

function generate_news_carousel() {
    $carousel = '<div id="newsCarousel" class="owl-carousel owl-theme fade-up">';
    $args = array(
        'post_type' => 'post',
        'posts_per_page' => 12,
        'category_name' => 'news,blog',
        'order' => 'DESC',
    );
    $query = new WP_Query($args);
    $post_count = $query->post_count;
    $items_needed = max(4, $post_count);

    for ($i = 0; $i < $items_needed; $i++) {
        if ($i < $post_count) {
            $query->the_post();
            $image = get_the_post_thumbnail(null, 'medium', array('class' => 'card-img-top'));
            $carousel .= '
            <div class="item kpy-news">
                <div class="card kpy-news-card shadow-sm border-0">
                    <div class="post-thumbnail">' .
                        ($image ? $image : '<img class="card-img-top" src="' . get_template_directory_uri() . '/assets/images/photo-placeholder.jpg" alt="No Image">') .
                    '</div>
                    <div class="card-body" style="position: relative;">
                        <h5 class="card-title">' .wp_trim_words(get_the_title(), 5)  . '</h5>
                        <p class="card-date"><i class="bi bi-calendar-check"></i> ' . get_the_date() . '</p>
                        <br>
                        <a href="' . get_permalink() . '" class="btn btn-outline-info read-more" style="position: absolute;">Read More</a>
                    </div>
                </div>
            </div>';
        } else {
            $carousel .= '
            <div class="item kpy-news">
                <div class="card shadow-sm border-0" style="visibility: hidden;">
                    <div class="post-thumbnail">
                        <img class="card-img-top" src="' . get_template_directory_uri() . '/assets/images/photo-placeholder.jpg" alt="Placeholder">
                    </div>
                    <div class="card-body">
                        <h5 class="card-title">Coming Soon</h5>
                        <p class="card-date"><i class="bi bi-calendar-check"></i></p>
                        <a href="#" class="btn btn-outline-info read-more disabled">Read More</a>
                    </div>
                </div>
            </div>';
        }
    }
    wp_reset_postdata();
    $carousel .= '</div>';
    return $carousel;
}

function generate_events_carousel() {
    $carousel = '<div id="eventsCarousel" class="owl-carousel owl-theme fade-up">';
    $args = array(
        'post_type' => 'events',
        'posts_per_page' => 12,
        'order' => 'DESC',
    );
    $query = new WP_Query($args);
    $post_count = $query->post_count;
    $items_needed = max(4, $post_count);

    for ($i = 0; $i < $items_needed; $i++) {
        if ($i < $post_count && $query->have_posts()) {
            $query->the_post();
            $image = get_the_post_thumbnail(null, 'medium', array('class' => 'card-img-top'));
            $post_id = get_the_ID();
            $location = get_post_meta($post_id, '_location', true);
            $start_date = get_post_meta($post_id, '_start_date', true);
            $formatted_start_date = $start_date ? date('jS, F Y', strtotime($start_date)) : 'Date TBD';

            $carousel .= '
            <div class="item kpy-events">
                <div class="card shadow-sm border-0">
                    <div class="post-thumbnail">' .
                        ($image ? $image : '<img class="card-img-top" src="' . get_template_directory_uri() . '/photo-placeholder.jpg" alt="Event Image">') .
                    '</div>
                    <div class="card-body">
                        <div class="event-date-badge">
                            <span class="event-month">' . ($start_date ? date('M', strtotime($start_date)) : '') . '</span>
                            <span class="event-day">' . ($start_date ? date('d', strtotime($start_date)) : '') . '</span>
                        </div>
                        <h5 class="card-title">' . get_the_title() . '</h5>
                        <div class="event-meta">
                            <p class="card-text"><i class="bi bi-calendar-check"></i> ' . esc_html($formatted_start_date) . '</p>
                            <p class="location"><i class="bi bi-geo-alt"></i> ' . ($location ? esc_html($location) : 'Location TBD') . '</p>
                        </div>
                        <a href="' . get_permalink() . '" class="btn btn-outline-info read-more">View Details</a>
                    </div>
                </div>
            </div>';
        } else {
            $carousel .= '
            <div class="item kpy-events">
                <div class="card shadow-sm border-0 h-100" style="visibility: hidden;">
                    <div class="post-thumbnail">
                        <img class="card-img-top" src="' . get_template_directory_uri() . '/photo-placeholder.jpg" alt="Upcoming Event">
                    </div>
                    <div class="card-body">
                        <div class="event-date-badge">
                            <span class="event-month"></span>
                            <span class="event-day"></span>
                        </div>
                        <h3 class="card-title">More Events Coming Soon</h3>
                        <div class="event-meta">
                            <p class="card-text"><i class="bi bi-calendar-check"></i> Date TBD</p>
                            <p class="card-text"><i class="bi bi-clock"></i> Time TBD</p>
                            <p class="location"><i class="bi bi-geo-alt"></i> Location TBD</p>
                        </div>
                        <a href="#" class="btn btn-outline-info read-more disabled">Details</a>
                    </div>
                </div>
            </div>';
        }
    }
    wp_reset_postdata();
    $carousel .= '</div>';
    return $carousel;
}

function get_download_category_list($category_slug, $limit = 6) {
    $args = array(
        'post_type' => 'dlm_download',
        'posts_per_page' => $limit,
        'tax_query' => array(
            array(
                'taxonomy' => 'dlm_download_category',
                'field'    => 'slug',
                'terms'    => $category_slug,
            ),
        ),
    );
    $query = new WP_Query($args);
    $output = '<div class="row">';
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $download_link = get_permalink();
            $output .= '
            <div class="col-md-6 mb-3">
                <div class="card shadow-sm p-3 border-0 h-100">
                    <h5 class="card-title">' . get_the_title() . '</h5>
                    <p><i class="bi bi-calendar"></i> ' . get_the_date() . '</p>
                    <a href="' . esc_url($download_link) . '" class="btn btn-outline-info read-more">Download</a>
                </div>
            </div>';
        }
    } else {
        $output .= '<div class="col-12"><p>No items found.</p></div>';
    }
    wp_reset_postdata();
    $output .= '</div>';
    return $output;
}


function generate_media_carousel() {
    $carousel = '<div id="mediaCarousel" class="owl-carousel owl-theme">';
    $args = array(
        'post_type' => 'page',
        'posts_per_page' => 4,
        'category_name' => 'media',
    );
    $query = new WP_Query($args);
    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $carousel .= '<div class="item kpy-media"><div class="card">' . get_the_content() . '</div></div>';
        }
    }
    wp_reset_postdata();
    $carousel .= '</div>';
    return $carousel;
}

function news_events_media_tabs_shortcode($atts) {
    $news_content = '<div class="tab-pane fade py-3 active show" id="news-tab-pane">' . generate_news_carousel() . '</div>';
    $events_content = '<div class="tab-pane fade py-3" id="events-tab-pane">' . generate_events_carousel() . '</div>';
    $media_content = '
    <div class="tab-pane fade py-3" id="media-tab-pane">
        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="twitter-embed p-3">
                    <h3>Latest from MWE</h3>
                    <blockquote class="twitter-tweet"><a href="https://x.com/min_waterug"></a></blockquote>
                    <a href="https://x.com/min_waterug" target="_blank" class="view-more">View More on X</a>
                </div>
                <script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
            </div>
            <div class="col-md-6 mb-3">
                <iframe width="560" height="450" src="https://www.youtube.com/embed/pv4-taOT0QA?si=50j1NIs_7njnUZPH" title="YouTube video player" frameborder="0" allowfullscreen></iframe>
            </div>
        </div>
    </div>';

    // Get the Bids & Tenders content using env_bids_cards shortcode
    $bids_content = '<div class="tab-pane fade py-3" id="bids-tab-pane">';
    $bids_content .= do_shortcode('[env_downloads_cards_two_columns posts="4" category="bids-tenders"]
');
    $bids_content .= '</div>';

    // Get the Jobs & Careers content using original layout
    $jobs_content = '<div class="tab-pane fade py-3" id="jobs-tab-pane">';
    $jobs_content .= do_shortcode('[env_downloads_cards_two_columns posts="4" category="jobs-careers"]');
    $jobs_content .= '</div>';

    return '
    <div class="col-md-12 bhf fade-up">
        <ul class="nav nav-pills flex-column flex-sm-row nav-tabs mb-md-3" id="myTab">
            <li class="nav-item"><a class="nav-link active" id="news-tab" data-bs-toggle="tab" href="#news-tab-pane">Latest News</a></li>
            <li class="nav-item"><a class="nav-link" id="events-tab" data-bs-toggle="tab" href="#events-tab-pane">Events</a></li>
            <li class="nav-item"><a class="nav-link" id="media-tab" data-bs-toggle="tab" href="#media-tab-pane">Media</a></li>
            <li class="nav-item"><a class="nav-link" id="events-tab" data-bs-toggle="tab" href="#bids-tab-pane">Bids & Tenders</a></li>
            <li class="nav-item"><a class="nav-link" id="events-tab" data-bs-toggle="tab" href="#jobs-tab-pane">Jobs & Careers</a></li>
        </ul>
        <div class="tab-content">' . $news_content . $events_content . $media_content . $bids_content . $jobs_content . '</div>
    </div>';
}
add_shortcode('news_events_tabs', 'news_events_media_tabs_shortcode');
