<?php
function allMinisters_shortcode() {
    ob_start(); // Start output buffering

	$news_args = array(
		'post_type' => array('page'),
		'posts_per_page' => 6,
		'page_category' => 'ministers',
		'order' => 'ASC'
		);
	?>																
	<?php $news_query = new WP_Query($news_args);?>
		<?php if ($news_query->have_posts()) : ?>
		<div class="row">
			<?php while ($news_query->have_posts()) :
				$news_query->the_post();
				$categories = get_the_category();
				 
                // Array of border colors (add your preferred colors)
                $border_colors = ['#0078a0', '#8a2be2', '#e63946', '#2a9d8f', '#f4a261'];
                $random_color = $border_colors[array_rand($border_colors)];
			?>
			<div class="col-sm-6 display-ministers">
				<article data-border-color="<?php echo esc_attr($random_color); ?>">
					<a href="<?= esc_url(get_permalink()); ?>">
						<div class="card shadow-sm mb-2 border-0" data-aos="fade-up">
							
							<div class="post-thumbnail">
									<?php // Display the post thumbnail
										if (has_post_thumbnail()) {
											the_post_thumbnail('medium'); 
										}else{
											echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="MWE" class="img-fluid"/>';
										}
									?>
									
							</div>
						</div><!-- card !-->
						<h6 class="minister-title" style="color:<?php echo esc_attr($random_color);?> background:transparent;"><? the_title();?></h6>
						</a>
				</article>
			</div><!-- col !-->
			<?php endwhile;
				wp_reset_postdata();
			else :
				echo 'No news found.';
			endif;
			?>
	</div><!-- Row !-->
    <?php

    return ob_get_clean(); // Return the buffered content
}

// Register the shortcode
add_shortcode('show_ministers', 'allMinisters_shortcode');

?>