<?php
// === [env_news_cards] SHORTCODE ===
function env_dynamic_news_cards_shortcode($atts) {
    ob_start();

    $atts = shortcode_atts([
        'posts' => -1,
        'category' => '',
    ], $atts, 'env_news_cards');

    $args = [
        'post_type' => 'post',
        'posts_per_page' => intval($atts['posts']),
    ];

    if (!empty($atts['category'])) {
        $args['category_name'] = sanitize_text_field($atts['category']);
    }

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        echo '<div class="env-news-wrapper">';
        while ($query->have_posts()) {
            $query->the_post();
            $image_url = get_the_post_thumbnail_url(get_the_ID(), 'medium');
            $title = get_the_title();
            $date = get_the_date();
            $permalink = get_permalink();

            echo '<a href="' . esc_url($permalink) . '" class="env-news-card">';
            if ($image_url) {
                echo '<div class="env-news-image"><img src="' . esc_url($image_url) . '" alt="' . esc_attr($title) . '"></div>';
            }
            echo '<div class="env-news-content">';
            echo '<h3>' . esc_html($title) . '</h3>';
            echo '<p class="env-news-date">' . esc_html($date) . '</p>';
            echo '</div></a>';
        }
        echo '</div>';
        wp_reset_postdata();
    }

    return ob_get_clean();
}
add_shortcode('env_news_cards', 'env_dynamic_news_cards_shortcode');




// === [env_downloads_cards] SHORTCODE ===
function env_downloads_cards_shortcode($atts) {
    ob_start();

    $atts = shortcode_atts([
        'posts' => -1,
        'category' => '',
    ], $atts, 'env_downloads_cards');

    $args = [
        'post_type' => 'downloads',
        'posts_per_page' => intval($atts['posts']),
    ];

    if (!empty($atts['category'])) {
        $args['tax_query'] = [
            [
                'taxonomy' => 'file_category',
                'field' => 'slug',
                'terms' => sanitize_text_field($atts['category']),
            ],
        ];
    }

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        echo '<div class="env-downloads-wrapper" style="display: flex; flex-direction: column; gap: 10px;">';
        while ($query->have_posts()) {
            $query->the_post();
            $post_id = get_the_ID();
            $title = get_the_title();
            $date = get_the_date();
            $permalink = get_permalink();
            $file_url = get_post_meta($post_id, '_file_url', true);
            $download_count = get_post_meta($post_id, '_download_count', true) ?: 0;
            $file_size = '';

            if ($file_url) {
                $headers = @get_headers($file_url, 1);
                $file_size = isset($headers['Content-Length']) ? size_format($headers['Content-Length']) : '';
            }

            echo '<div class="env-download-card" style="border-bottom: 1px solid #ccc; padding-bottom: 10px;">';
            echo '<h3 style="margin: 0 0 5px; font-size: 18px;">
                    <a href="' . esc_url($permalink) . '" class="download-title-link" style="color: #1446a0; text-decoration: none;">' . esc_html($title) . '</a>
                    <img src="https://lwegatech.net/mwe/wp-content/uploads/2025/06/paper.png" alt="Paper Icon" style="width: 20px; margin-left: 8px; vertical-align: middle;" />
                  </h3>';
            echo '<p style="margin: 0; color: #666; font-size: 12px;">
                    ' . esc_html($date) . ' &nbsp;|&nbsp; Downloads: ' . esc_html($download_count) . ' &nbsp;|&nbsp; Size: ' . esc_html($file_size) . '
                  </p>';
            echo '</div>';
        }
        echo '</div>';
        wp_reset_postdata();
    }

    return ob_get_clean();
}
add_shortcode('env_downloads_cards', 'env_downloads_cards_shortcode');





// Downloads Headings Shortcode
function env_downloads_headings_shortcode($atts) {
    ob_start();
    $atts = shortcode_atts([
        'posts' => 3,
        'category' => ''
    ], $atts, 'env_downloads_headings');

    $args = [
        'post_type' => 'downloads',
        'posts_per_page' => $atts['posts'],
        'orderby' => 'date' 
    ];

    if (!empty($atts['category'])) {
        $args['category_name'] = sanitize_text_field($atts['category']);
    }

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        echo '<div class="env-downloads-headings">';
        while ($query->have_posts()) {
            $query->the_post();
            $title = get_the_title();
            $permalink = get_permalink();
            echo '<h5 style="margin: 0 0 8px; font-size: 16px;">
                    <a href="' . esc_url($permalink) . '" style="color: #052C65; font-family: Open Sans; font-size: 16px;">
                        ' . esc_html($title) . '
                    </a>
                  </h5>';
        }
        echo '</div>';
        wp_reset_postdata();
    }

    return ob_get_clean();
}
add_shortcode('env_downloads_headings', 'env_downloads_headings_shortcode');


// Full Downloads Cards Shortcode   NOT IN USE
function env_fulldownloads_cards_shortcode($atts) {
    ob_start();

    $atts = shortcode_atts([
        'posts' => 3,
        'category' => '',
    ], $atts, 'env_fulldownloads_cards');

    $args = [
        'post_type' => 'downloads',
        'posts_per_page' => intval($atts['posts']),
    ];

    if (!empty($atts['category'])) {
        $args['category_name'] = sanitize_text_field($atts['category']);
    }

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        echo '<div class="env-downloads-wrapper" style="display: flex; flex-direction: column; gap: 20px;">';

        while ($query->have_posts()) {
            $query->the_post();
            $title = get_the_title();
            $permalink = get_permalink();
            $post_id = get_the_ID();

            // Get download count
            $download_count = (int) get_post_meta($post_id, 'download_count', true);

            // Get file download link
            $download_link = add_query_arg([
                'download_file' => 'true',
                'post_id' => $post_id,
            ], home_url('/'));

            echo '<div class="env-download-card" style="display: flex; border-top: 1px solid #052C65; padding-top: 10px;">';
            echo '<div style="flex: 0 0 120px; padding-right: 10px;">';
            echo '<img src="https://lwegatech.net/mwe/wp-content/uploads/2025/06/paper.png" alt="Paper Icon" style="width: 100px;" />';
            echo '</div>';
            echo '<div style="flex: 1;">';
            echo '<p style="margin: 0 0 8px; font-weight: bold;">Downloads: ' . esc_html($download_count) . '</p>';
            echo '<h3 style="margin: 0;">';
            echo '<a href="' . esc_url($permalink) . '" style="color: #1a1a5e; text-decoration: none; font-size: 18px; font-weight: 700;">' . esc_html($title) . '</a>';
            echo '</h3>';
            echo '<p><a href="' . esc_url($download_link) . '" style="color: #0073aa;">Download</a></p>';
            echo '</div>';
            echo '</div>';
        }

        echo '</div>';
        wp_reset_postdata();
    }

    return ob_get_clean();
}
add_shortcode('env_fulldownloads_cards', 'env_fulldownloads_cards_shortcode');




function env_downloads_cards_two_columns_shortcode($atts) {
    ob_start();

    // Accept shortcode attributes
    $atts = shortcode_atts([
        'posts' => 6,
        'category' => '',
    ], $atts, 'env_downloads_cards_two_columns');

    // Prepare query arguments
    $args = [
        'post_type' => 'downloads',
        'posts_per_page' => intval($atts['posts']),
    ];

    // Add taxonomy filter if category is set
    if (!empty($atts['category'])) {
        $args['tax_query'] = [
            [
                'taxonomy' => 'file_category',
                'field' => 'slug',
                'terms' => sanitize_text_field($atts['category']),
            ],
        ];
    }

    // Run the query
    $query = new WP_Query($args);

    // Output the cards in two columns
    if ($query->have_posts()) {
        echo '<div class="env-downloads-grid" style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 15px;">';
        while ($query->have_posts()) {
            $query->the_post();
            $title = get_the_title();
            $date = get_the_date();
            $permalink = get_permalink();
            $download_count = function_exists('get_field') ? get_field('download_count') : '1';

            echo '<div class="env-download-card" style="border: 1px solid #ccc; padding: 15px; border-radius: 6px; background-color: #e8f9e3">';
            echo '<h3 style="margin: 0 0 5px; font-size: 18px;"><a href="' . esc_url($permalink) . '" style="color: #1446a0; text-decoration: none;">' . esc_html($title) . '</a></h3>';
            echo '<p class="env-download-date" style="margin: 0 0 5px; color: #666;">' . esc_html($date) . '</p>';
            echo '<p style="margin: 0; color: #0073aa;">Downloads: ' . esc_html($download_count) . '</p>';
            echo '</div>';
        }
        echo '</div>';
        wp_reset_postdata();
    } else {
        // Fallback message based on category
        if ($atts['category'] === 'bids-tenders') {
            echo '<p>There are no Bids & Tenders at this time.</p>';
        } elseif ($atts['category'] === 'jobs-careers') {
            echo '<p>There are no Jobs & Careers at this time.</p>';
        } else {
            echo '<p>No downloads found.</p>';
        }
    }

    return ob_get_clean();
}
add_shortcode('env_downloads_cards_two_columns', 'env_downloads_cards_two_columns_shortcode');





// Handle AJAX filtering
function filter_downloads_by_file_category() {
    $slug = sanitize_text_field($_POST['category_slug']);
    echo do_shortcode('[publications category="' . $slug . '"]');
    wp_die();
}
add_action('wp_ajax_filter_downloads_by_file_category', 'filter_downloads_by_file_category');
add_action('wp_ajax_nopriv_filter_downloads_by_file_category', 'filter_downloads_by_file_category');

// PUBLICATIONS PAGE DISPLAY AND FUNCTIONALITY


function downloads_shortcode($atts) {
    // Define shortcode attributes
    $atts = shortcode_atts(
        array(
            'category' => '',
            'number' => 70,
            'order' => 'DESC',
        ),
        $atts,
        'downloads'
    );

    $downloads_args = array(
        'post_type' => 'downloads',
        'posts_per_page' => $atts['number'],
        'orderby' => 'date',
        'order' => $atts['order'],
    );

    if (!empty($atts['category'])) {
        $downloads_args['tax_query'] = array(
            array(
                'taxonomy' => 'file_category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

    $downloads_query = new WP_Query($downloads_args);

    ob_start();
    ?>

    <div class="row publications">
        <div class="col-md-12">
            <div class="table-responsive">
                <table id="downloads-table" class="table expandable-table w-100 dataTable no-footer" style="width: 100%">
                    <thead>
                        <tr>
                            <th></th>
                            <th></th>
                            <th class="d-none"></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        while ($downloads_query->have_posts()) : $downloads_query->the_post();
                            $post_id = get_the_ID();
                            $file_url = get_post_meta($post_id, '_file_url', true);
                            $file_size = '';
                            $downloadCount = get_post_meta($post_id, '_download_count', true);

                            if ($file_url) {
                                $headers = get_headers($file_url, 1);
                                $file_size = isset($headers['Content-Length']) ? size_format($headers['Content-Length']) : '';
                            }
                        ?>
                            <tr>
                                <!-- Paper Icon Image -->
                                <td width="20%">
                                    <img src="https://lwegatech.net/mwe/wp-content/uploads/2025/06/paper.png" alt="Paper Icon" style="width: 100px;" />
                                </td>

                                <!-- Content Block -->
                                <td width="80%">
                                    <div class="py-1">
                                        <small>Downloads: <?= $downloadCount; ?> | Size: <?= $file_size; ?></small>
                                    </div>
                                    <a href="<?= esc_url(get_permalink()); ?>"><h4 class="pub-title"><?php the_title(); ?></h4></a>
                                    <div class="pub-link">
                                        <p><?php esc_html(the_content()); ?></p>
                                    </div>
                                </td>

                                <!-- Hidden Download Button -->
                                <td class="d-none">
                                    <div class="pub-download">
                                        <a href="<?= $file_url; ?>" target="_blank" onclick="updateDownloadCount(<?= $post_id; ?>)">Download</a>
                                    </div>
                                    <script>
                                        function updateDownloadCount(post_id) {
                                            jQuery.ajax({
                                                type: 'POST',
                                                url: '<?php echo admin_url("admin-ajax.php"); ?>',
                                                data: {
                                                    action: 'update_download_count',
                                                    post_id: post_id
                                                },
                                                success: function(response) {
                                                    console.log('Download count updated successfully.');
                                                }
                                            });
                                        }
                                    </script>
                                </td>
                            </tr>
                        <?php endwhile; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <?php
    return ob_get_clean();
}
add_shortcode('publications', 'downloads_shortcode');



function downloads_category_menu_shortcode($atts) {
    // Only get parent (top-level) categories
    $categories = get_terms(array(
        'taxonomy' => 'file_category',
        'hide_empty' => true,
        'orderby' => 'name',
        'parent' => 0, // This line ensures only top-level categories are returned
    ));

    if (empty($categories) || is_wp_error($categories)) {
        return '<div class="downloads-category-menu-notice">No categories available</div>';
    }

    ob_start(); ?>

    <div class="downloads-category-menu">
        <h4 class="category-menu-title">Browse Publications</h4>
        <ul class="category-menu-list">
            <?php foreach ($categories as $category): 
                $link = get_term_link($category); ?>
                <li class="category-menu-item">
                    <a href="<?php echo esc_url($link); ?>" class="category-menu-link">
                        <span class="category-name"><?php echo esc_html($category->name); ?></span>
                        <span class="category-count">(<?php echo esc_html($category->count); ?>)</span>
                    </a>
                </li>
            <?php endforeach; ?>
        </ul>
    </div>

    <style>
    .downloads-category-menu {
        background: #fff;
        padding: 20px;
        border-radius: 8px;
        box-shadow: 0 2px 10px rgba(0,0,0,0.05);
    }
    .category-menu-title {
        font-size: 1.2rem;
        font-weight: 600;
        margin-bottom: 15px;
    }
    .category-menu-list {
        list-style: none;
        padding: 0;
        margin: 0;
    }
    .category-menu-item {
        margin-bottom: 8px;
    }
    .category-menu-link {
        text-decoration: none;
        color: #333;
        display: flex;
        justify-content: space-between;
        padding: 10px;
        border-radius: 5px;
        transition: background 0.3s, color 0.3s;
    }
    .category-menu-link:hover {
        background: #f0f0f0;
        color: #007bff;
    }
    .category-count {
        background: #eee;
        padding: 2px 8px;
        border-radius: 10px;
        font-size: 0.85em;
    }
    </style>

    <?php
    return ob_get_clean();
}
add_shortcode('downloads_category_menu', 'downloads_category_menu_shortcode');




function umbrella_zones_tabs_shortcode($atts) {
    ob_start();
    ?>
    <div class="col-md-12 bhf fade-up">
        <ul class="nav nav-pills flex-column flex-sm-row nav-tabs mb-md-3" id="myTab">
            <li class="nav-item">
                <a class="nav-link active" id="events-tab" data-bs-toggle="tab" href="#zones-tab-pane" data-bs-toggle="tooltip" title="Water Management Zones">WMZ</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="events-tab" data-bs-toggle="tab" href="#umbrella-tab-pane" data-bs-toggle="tooltip" title="Umbrellas">Umbrellas</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="events-tab" data-bs-toggle="tab" href="#wfdfs-tab-pane" data-bs-toggle="tooltip" title="Water For Domestic & Sanitation">WFDFS</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="events-tab" data-bs-toggle="tab" href="#rwrcs-tab-pane" data-bs-toggle="tooltip" title="Rural Water Supply Regional centres">RWRCS</a>
            </li>
            <li class="nav-item">
                <a class="nav-link" id="events-tab" data-bs-toggle="tab" href="#wfpcs-tab-pane" data-bs-toggle="tooltip" title="Water For Production Centres">WFPCs</a>
            </li>
        </ul>

        <div class="tab-content">
            <div class="tab-pane fade py-3 active show" id="zones-tab-pane">
                <?php echo umbrella_zones_generate_flat_cards('zones'); ?>
            </div>
            <div class="tab-pane fade py-3" id="umbrella-tab-pane">
                <?php echo umbrella_zones_generate_flat_cards('umbrella'); ?>
            </div>
            <div class="tab-pane fade py-3" id="wfdfs-tab-pane">
                <?php echo umbrella_zones_generate_flat_cards('wfdfs'); ?>
            </div>
            <div class="tab-pane fade py-3" id="rwrcs-tab-pane">
                <?php echo umbrella_zones_generate_flat_cards('rwrcs'); ?>
            </div>
            <div class="tab-pane fade py-3" id="wfpcs-tab-pane">
                <?php echo umbrella_zones_generate_flat_cards('wfpcs'); ?>
            </div>
        </div>
    </div>

    <script>
    // Initialize Bootstrap tooltips
    document.addEventListener('DOMContentLoaded', function () {
        var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'));
        tooltipTriggerList.forEach(function (tooltipTriggerEl) {
            new bootstrap.Tooltip(tooltipTriggerEl);
        });
    });
    </script>
    <?php
    return ob_get_clean();
}
add_shortcode('umbrella_zones_tabs', 'umbrella_zones_tabs_shortcode');




function umbrella_zones_generate_flat_cards($group_slug) {
    $output = '';

    $group_term = get_term_by('slug', $group_slug, 'page_category');
    if (!$group_term) {
        return '<p>Invalid group: ' . esc_html($group_slug) . '</p>';
    }

    $query = new WP_Query([
        'post_type' => 'page',
        'posts_per_page' => -1,
        'orderby' => 'title',
        'order' => 'ASC',
        'tax_query' => [[
            'taxonomy' => 'page_category',
            'field' => 'term_id',
            'terms' => $group_term->term_id,
        ]],
    ]);

    if ($query->have_posts()) {
        $output .= '
        <style>
        .env-downloads-scroll::-webkit-scrollbar {
            display: none;
        }
        .env-download-card {
            position: relative;
            overflow: hidden;
        }
        .card-overlay {
            position: absolute;
            bottom: 0;
            left: 0;
            right: 0;
            background: rgba(0, 0, 0, 0.7);
            color: #fff;
            font-weight: 900;
            padding: 10px;
            text-align: center;
            font-size: 14px;
            opacity: 0;
            transition: opacity 0.3s ease-in-out;
        }
        .env-download-card:hover .card-overlay {
            opacity: 1;
        }
        </style>
        <div style="position: relative; width: 100%; margin-bottom: 20px;">
            <div class="env-downloads-scroll" style="
                display: flex;
                overflow-x: auto;
                gap: 16px;
                padding-bottom: 10px;
                -webkit-overflow-scrolling: touch;
                scroll-snap-type: x mandatory;
                scrollbar-width: none;
                -ms-overflow-style: none;
            ">
                <div class="scroll-arrow-right">→</div>
        ';

        while ($query->have_posts()) {
            $query->the_post();
            $title = get_the_title();
            $permalink = get_permalink();
            $thumbnail = get_the_post_thumbnail_url(get_the_ID(), 'medium');

            // Get terms and filter out the group term
            $terms = wp_get_post_terms(get_the_ID(), 'page_category');
            $departments = array_filter($terms, function($term) use ($group_term) {
                return $term->term_id !== $group_term->term_id;
            });
            $department_names = wp_list_pluck($departments, 'name');
            $department_text = $department_names ? implode(', ', $department_names) : 'No Department';

            $output .= '<div class="env-download-card" style="
                flex: 0 0 auto;
                width: 220px;
                background: #fff;
                border: 1px solid #ddd;
                border-radius: 8px;
                box-shadow: 0 2px 8px rgba(0,0,0,0.05);
                display: flex;
                flex-direction: column;
                scroll-snap-align: start;
                position: relative;
            ">';

            if ($thumbnail) {
                $output .= '<a href="' . esc_url($permalink) . '">
                    <img src="' . esc_url($thumbnail) . '" alt="' . esc_attr($title) . '" style="
                        width: 100%;
                        height: 160px;
                        object-fit: cover;
                    ">
                </a>';
            }

            $output .= '
                <div class="card-overlay">' . esc_html($department_text) . '</div>
                <div style="padding: 12px; text-align: center;">
                    <h3 style="margin: 0; font-size: 16px;">
                        <a href="' . esc_url($permalink) . '" style="color: #1c5c1c; text-decoration: none;">' . esc_html($title) . '</a>
                    </h3>
                </div>
            ';

            $output .= '</div>';
        }

        $output .= '</div>'; // end scroll
        $output .= '</div>'; // end container
        wp_reset_postdata();
    } else {
        $output .= '<p>No ' . esc_html(strtoupper($group_slug)) . ' available yet.</p>';
    }

    return $output;
}

