<?php
function allDepartments_shortcode($atts) {
    ob_start();

    if (is_page()) {
        $post_id = get_the_ID();
        $default_cat = get_post_meta($post_id, 'departments_category', true);
        if (empty($atts['category']) && !empty($default_cat)) {
            $atts['category'] = $default_cat;
        }
    }

    $atts = shortcode_atts([
        'category' => '',
        'number' => -1,
        'order' => 'rand',
    ], $atts, 'departments');

    $args = [
        'post_type' => 'page',
        'posts_per_page' => intval($atts['number']),
        'orderby' => 'date',
        'order' => $atts['order'],
    ];

    $tax_query = [];

    // Include category if provided
    if (!empty($atts['category'])) {
        $tax_query[] = [
            'taxonomy' => 'page_category',
            'field'    => 'slug',
            'terms'    => sanitize_text_field($atts['category']),
        ];
    }

    // Exclude 'zones' and 'umbrella'
    $tax_query[] = [
        'taxonomy' => 'page_category',
        'field'    => 'slug',
        'terms'    => ['zones', 'umbrella'],
        'operator' => 'NOT IN',
    ];

    if (!empty($tax_query)) {
        // If more than one condition, relation is 'AND' by default
        $args['tax_query'] = $tax_query;
    }

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        echo '<div class="row">';
        echo '<div class="department-cards-row-wrapper"><div class="row no-gutters">';
        while ($query->have_posts()) {
            $query->the_post();
            $image = get_the_post_thumbnail_url(get_the_ID(), 'large');
            echo '<div class="col-lg-3 col-md-4 col-sm-6 col-12">';
            echo '<a href="' . esc_url(get_permalink()) . '" class="env-card-horizontal" style="background-image: url(' . esc_url($image) . ');">';
            echo '<div class="env-card-overlay">';
            echo '<h3>' . get_the_title() . '</h3>';
            echo '<p>' . wp_trim_words(get_the_excerpt(), 15) . '</p>';
            echo '</div></a></div>';
        }
        echo '</div></div></div>';
        wp_reset_postdata();
    } else {
        echo '<p>Not projects available yet.</p>';
    }

    return ob_get_clean();
}
add_shortcode('departments', 'allDepartments_shortcode');





// Headings only shortcode
// Headings only shortcode using a CSS class
function departmentHeadings_shortcode($atts) {
    ob_start();

    $atts = shortcode_atts(
        array(
            'category' => 'dept',
            'number' => 6,
            'order' => 'DESC',
            
        ),
        $atts,
        'department_headings'
    );

    $depts_args = array(
        'post_type' => 'page',
        'posts_per_page' => $atts['number'],
        'orderby' => 'rand',
        'order' => $atts['order'],
    );

    if (!empty($atts['category'])) {
        $depts_args['tax_query'] = array(
            array(
                'taxonomy' => 'page_category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

    $depts_query = new WP_Query($depts_args);

    if ($depts_query->have_posts()) {
        while ($depts_query->have_posts()) {
            $depts_query->the_post();
            $title = get_the_title();
            $permalink = get_permalink();

            echo '<h5 class="department-heading">
                    <a href="' . esc_url($permalink) . '">' . esc_html($title) . '</a>
                  </h5>';
        }
        wp_reset_postdata();
    }

    return ob_get_clean();
}
add_shortcode('department_headings', 'departmentHeadings_shortcode');
function projectHeadings_shortcode($atts) {
    ob_start();

    $atts = shortcode_atts(
        array(
            'category' => 'project',
            'number' => 6,
            'order' => 'DESC',
            
        ),
        $atts,
        'department_headings'
    );

    $depts_args = array(
        'post_type' => 'page',
        'posts_per_page' => $atts['number'],
        'orderby' => 'rand',
        'order' => $atts['order'],
    );

    if (!empty($atts['category'])) {
        $depts_args['tax_query'] = array(
            array(
                'taxonomy' => 'page_category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }

    $depts_query = new WP_Query($depts_args);

    if ($depts_query->have_posts()) {
        while ($depts_query->have_posts()) {
            $depts_query->the_post();
            $title = get_the_title();
            $trimmed   = wp_trim_words($title, 6, '...');
            $permalink = get_permalink();

            echo '<h5 class="department-heading">
                    <a href="' . esc_url($permalink) . '">' . esc_html($trimmed) . '</a>
                  </h5>';
        }
        wp_reset_postdata();
    }

    return ob_get_clean();
}
add_shortcode('project_headings', 'ProjectHeadings_shortcode');



