<?php
function allNews_shortcode() {
    ob_start(); // Start output buffering
    // Get current page number
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $news_args = array(
        'post_type'      => 'post',
        'posts_per_page' => 12, // Show 12 posts per page
        'category_name' => 'news',
        'paged'         => $paged, // Enable pagination
    );
    $news_query = new WP_Query($news_args);
    if ($news_query->have_posts()) : ?>
        <div class="row">
            <?php while ($news_query->have_posts()) :
                $news_query->the_post();
                $categories = get_the_category();
            ?>
                <div class="col-md-3 col-sm-6 kpy-news">
                    <article>
                        <a href="<?php echo esc_url(get_permalink()); ?>">
                            <div class="card mb-3 border-0" data-aos="fade-up">
                                <div class="post-thumbnail">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('medium'); 
                                    } else {
                                        echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="'.esc_attr(get_the_title()).'" class="img-fluid"/>';
                                    } ?>
                                </div>
                                <div class="card-body">
                                    <h3 class="card-title"><?php the_title(); ?></h3>
                                    <div class="catz">
                                        <i class="bi bi-calendar-check"></i> 
                                        <?php echo get_the_date(); ?>
                                    </div>
                                    <a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-outline-info read-more">Read More</a>
                                </div>
                            </div>
                        </a>
                    </article>
                </div>
            <?php endwhile; ?>
        </div>
        <!-- Enhanced Pagination -->
        <div class="news-pagination">
            <?php
            echo paginate_links(array(
                'total'     => $news_query->max_num_pages,
                'current'   => max(1, $paged),
                'prev_text' => __('<i class="bi bi-chevron-left"></i> Previous'),
                'next_text' => __('Next <i class="bi bi-chevron-right"></i>'),
                'type'      => 'list',
                'mid_size'  => 2,
                'end_size'  => 1,
            ));
            ?>
        </div>
        
        <style>
        .card-title {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            text-overflow: ellipsis;
            min-height: 3em; 
            line-height: 1.5em;
            margin-bottom: 0.75rem;
        }
        
        /* Ensure consistent card heights */
        .kpy-news .card {
            height: 100%;
            display: flex;
            flex-direction: column;
        }
        
        .kpy-news .card-body {
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }
        
        .kpy-news .card-body .read-more {
            margin-top: auto;
        }
        
        .news-pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 40px 0 20px 0;
            padding: 20px 0;
        }
        
        .news-pagination .page-numbers {
            display: flex;
            list-style: none;
            padding: 0;
            margin: 0;
            gap: 8px;
            align-items: center;
        }
        
        .news-pagination .page-numbers li {
            margin: 0;
        }
        
        .news-pagination .page-numbers a,
        .news-pagination .page-numbers span {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 44px;
            height: 44px;
            padding: 8px 12px;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            color: #495057;
            text-decoration: none;
            font-weight: 500;
            font-size: 14px;
            transition: all 0.3s ease;
            background-color: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        .news-pagination .page-numbers a:hover {
            background-color: #228b22;
            border-color: #138496;
            color: #fff;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(23, 162, 184, 0.3);
        }
        
        .news-pagination .page-numbers .current {
            background-color: #228b22;
            border-color: #138496;
            color: #fff;
            cursor: default;
            box-shadow: 0 4px 8px rgba(23, 162, 184, 0.3);
        }
        
        .news-pagination .page-numbers .prev,
        .news-pagination .page-numbers .next {
            padding: 8px 16px;
            min-width: auto;
            font-weight: 600;
        }
        
        .news-pagination .page-numbers .prev:hover,
        .news-pagination .page-numbers .next:hover {
            background-color: #228b22;
            border-color: #138496;
        }
        
        .news-pagination .page-numbers .dots {
            border: none;
            background: none;
            color: #6c757d;
            cursor: default;
            box-shadow: none;
        }
        
        .news-pagination .page-numbers .dots:hover {
            background: none;
            border: none;
            transform: none;
            box-shadow: none;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .success-pagination .page-numbers {
                gap: 4px;
            }
            
            .news-pagination .page-numbers a,
            .news-pagination .page-numbers span {
                min-width: 36px;
                height: 36px;
                font-size: 13px;
                padding: 6px 10px;
            }
            
            .news-pagination .page-numbers .prev,
            .news-pagination .page-numbers .next {
                padding: 6px 12px;
            }
        }
        
        @media (max-width: 480px) {
            .news-pagination .page-numbers .prev span,
            .news-pagination .page-numbers .next span {
                display: none;
            }
            
            .news-pagination .page-numbers .prev:after {
                content: '‹';
                font-size: 18px;
                font-weight: bold;
            }
            
            .news-pagination .page-numbers .next:after {
                content: '›';
                font-size: 18px;
                font-weight: bold;
            }
        }
        </style>
        
    <?php else :
        echo 'No news found.';
    endif;
    wp_reset_postdata();
    return ob_get_clean();
}
// Register the shortcode
add_shortcode('all_news', 'allNews_shortcode');


//Autonomous agencies sidebar list
function list_autonomous_agencies_pages() {
  
    // Query pages with the custom taxonomy term 'autonomous-agencies'
    $args = array(
        'post_type' => 'page',
        'posts_per_page' => -1,
        'orderby' => 'rand', // random order
        'tax_query' => array(
            array(
                'taxonomy' => 'page_category', 
                'field'    => 'slug',
                'terms'    => 'autonomous-agencies',
            ),
        ),
    );

    $query = new WP_Query($args);
    $output = '<ul>';

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $output .= '<li><a href="' . get_permalink() . '">' . get_the_title() . '</a></li>';
        }
    } else {
        $output .= '<li>No pages found.</li>';
    }

    $output .= '</ul>';
    wp_reset_postdata();

    return $output;
}
add_shortcode('autonomous_agencies_pages', 'list_autonomous_agencies_pages');
function mwe_autonomous_agencies_cards_shortcode( $atts ) {
    ob_start();

    // Query pages with the category "autonomous agencies"
    $query = new WP_Query( array(
        'post_type'      => 'page',
        'posts_per_page' => -1,
        'orderby'        => 'title',
        'order'          => 'ASC',
        'tax_query'      => array(
            array(
                'taxonomy' => 'page_category',
                'field'    => 'slug',
                'terms'    => 'autonomous-agencies',
            ),
        ),
    ) );

    if ( $query->have_posts() ) {
        echo '<div class="mwe-cards-container" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">';

        while ( $query->have_posts() ) {
            $query->the_post();
            $title = get_the_title();
            $permalink = get_permalink();
            $thumbnail = get_the_post_thumbnail( get_the_ID(), 'medium', [ 'style' => 'width:100%; height:200px;' ] );

            echo '<div class="mwe-card" style="border: 1px solid #ddd; border-radius: 10px; overflow: hidden; box-shadow: 0 2px 6px rgba(0,0,0,0.1);">';
            echo '<a href="' . esc_url( $permalink ) . '">';
            echo $thumbnail;
            echo '<div style="padding: 15px;"><h3 style="margin: 0; font-size: 1.2em; display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; text-overflow: ellipsis; min-height: 3em; line-height: 1.5em;">' . esc_html( $title ) . '</h3></div>';
            echo '</a>';
            echo '</div>';
        }

        echo '</div>';
    } else {
        echo '<p>No agencies found.</p>';
    }

    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode( 'agency_cards', 'mwe_autonomous_agencies_cards_shortcode' );

//success stories carousel

// Add custom meta box for page settings
function add_success_stories_meta_box() {
    add_meta_box(
        'success_stories_settings',
        'Success Stories Settings',
        'success_stories_meta_box_callback',
        'page',
        'side',
        'default'
    );
}
add_action('add_meta_boxes', 'add_success_stories_meta_box');

// Meta box callback function
function success_stories_meta_box_callback($post) {
    // Add nonce for security
    wp_nonce_field('success_stories_meta_box', 'success_stories_meta_box_nonce');
    
    // Get current value
    $selected_category = get_post_meta($post->ID, '_success_stories_category', true);
    
    // Get all categories that are children of "Success Stories" category
    $success_stories_parent = get_category_by_slug('success-stories');
    
    if ($success_stories_parent) {
        $subcategories = get_categories(array(
            'parent' => $success_stories_parent->term_id,
            'hide_empty' => false,
            'orderby' => 'name',
            'order' => 'ASC'
        ));
        
        echo '<label for="success_stories_category"><strong>Select Success Stories Subcategory:</strong></label><br>';
        echo '<select id="success_stories_category" name="success_stories_category" style="width: 100%; margin-top: 5px;">';
        echo '<option value="">-- Select Subcategory --</option>';
        
        foreach ($subcategories as $category) {
            $selected = ($selected_category == $category->slug) ? 'selected' : '';
            echo '<option value="' . esc_attr($category->slug) . '" ' . $selected . '>';
            echo esc_html($category->name) . ' (' . $category->count . ' posts)';
            echo '</option>';
        }
        
        echo '</select>';
        echo '<p style="margin-top: 10px; font-size: 12px; color: #666;">This will be used by the [success_slider] shortcode on this page.</p>';
    } else {
        echo '<p style="color: #d63384;">Success Stories parent category not found. Please create a category with slug "success-stories" first.</p>';
    }
}

// Save meta box data
function save_success_stories_meta_box($post_id) {
    // Check if nonce is valid
    if (!isset($_POST['success_stories_meta_box_nonce']) || 
        !wp_verify_nonce($_POST['success_stories_meta_box_nonce'], 'success_stories_meta_box')) {
        return;
    }
    
    // Check if user has permission to edit the post
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }
    
    // Don't save on autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    
    // Save the data
    if (isset($_POST['success_stories_category'])) {
        update_post_meta($post_id, '_success_stories_category', sanitize_text_field($_POST['success_stories_category']));
    }
}
add_action('save_post', 'save_success_stories_meta_box');

// Updated shortcode function
function success_stories_slider($atts) {
    global $post;
    
    // Set default attributes
    $atts = shortcode_atts([
        'category' => '',           // Category slug or ID
        'posts_per_slide' => 4,     // Number of posts per slide (desktop)
        'posts_per_slide_tablet' => 2, // Number of posts per slide (tablet)
        'posts_per_slide_mobile' => 1, // Number of posts per slide (mobile)
        'total_posts' => 9,         // Total number of posts to show
        'show_excerpt' => 'false',   // Show excerpt or not
        'show_date' => 'true',      // Show date or not
        'show_author' => 'false',   // Show author or not
        'image_size' => 'medium',   // Featured image size
        'slider_height' => '400px', // Slider height
        'autoplay' => 'true',       // Auto-play slider
        'autoplay_delay' => '5000',  // Auto-play delay in milliseconds
        'use_page_setting' => 'true' // Use page setting for category
    ], $atts, 'success_slider');

    // Check if we should use page setting and no category is specified in shortcode
    if ($atts['use_page_setting'] === 'true' && empty($atts['category']) && is_page() && $post) {
        $page_category = get_post_meta($post->ID, '_success_stories_category', true);
        if (!empty($page_category)) {
            $atts['category'] = $page_category;
        }
    }

    // Validate category
    if (empty($atts['category'])) {
        return '';
    }

    // Determine if category is ID or slug
    if (is_numeric($atts['category'])) {
        $query_args = [
            'cat' => $atts['category']
        ];
    } else {
        $query_args = [
            'category_name' => $atts['category']
        ];
    }

    // Get posts from the specified category
    $posts = get_posts(array_merge($query_args, [
        'numberposts' => $atts['total_posts'],
        'post_status' => 'publish',
        'orderby' => 'date',
        'order' => 'DESC'
    ]));

    if (empty($posts)) {
        $category_obj = get_category_by_slug($atts['category']);
        $category_name = $category_obj ? $category_obj->name : $atts['category'];
       
        return '';
    }

    // Generate unique slider ID
    $slider_id = 'success-stories-swiper-' . uniqid();

    // Start building the slider HTML
    ob_start();
    ?>
    <br>
    <h3 class="wp-block-heading" style="color: var(--kpy-primary);">SUCCESS STORIES</h3>
    
    <div id="<?php echo $slider_id; ?>" class="swiper success-stories-swiper">
        <div class="container-xxl swiper-wrapper">
            <?php
            foreach ($posts as $post) {
                setup_postdata($post);
                ?>
                <div class="swiper-slide">
                    <div class="card h-100 border-0 shadow-sm">
                        <?php if (has_post_thumbnail($post->ID)) : ?>
                            <div class="card-img-wrapper position-relative overflow-hidden" style="height: 200px;">
                                <a href="<?php echo get_permalink($post); ?>">
                                    <?php echo get_the_post_thumbnail($post->ID, $atts['image_size'], [
                                        'class' => 'card-img-top w-100 h-100',
                                        'style' => 'object-fit: cover;'
                                    ]); ?>
                                </a>
                            </div>
                        <?php endif; ?>
                        
                        <div class="card-body d-flex flex-column">
                            <h5 class="card-title" style="display: -webkit-box; -webkit-line-clamp: 2; -webkit-box-orient: vertical; overflow: hidden; text-overflow: ellipsis; min-height: 3em; line-height: 1.5em;">
                                <a href="<?php echo get_permalink($post); ?>" class="text-decoration-none">
                                    <?php echo esc_html($post->post_title); ?>
                                </a>
                            </h5>
                            
                            <?php if ($atts['show_excerpt'] === 'true') : ?>
                                <p class="card-text flex-grow-1">
                                    <?php echo wp_trim_words(get_the_excerpt($post), 15); ?>
                                </p>
                            <?php endif; ?>
                            
                            <div class="mt-auto">
                                <?php if ($atts['show_date'] === 'true') : ?>
                                    <small class="text-muted d-block">
                                        <?php echo get_the_date('M j, Y', $post); ?>
                                    </small>
                                <?php endif; ?>
                                <a href="<?php echo esc_url(get_permalink($post)); ?>" class="btn btn-outline-primary">Read More</a>
                                <?php if ($atts['show_author'] === 'true') : ?>
                                    <small class="text-muted d-block">
                                        By <?php echo get_the_author_meta('display_name', $post->post_author); ?>
                                    </small>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
                <?php
            }
            wp_reset_postdata();
            ?>
        </div>
        
        <!-- Navigation buttons -->
        <div class="swiper-button-next"></div>
        <div class="swiper-button-prev"></div>
        
        <!-- Pagination dots -->
        <div class="swiper-pagination"></div>
    </div>

    <!-- Load Swiper CSS -->
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/Swiper/11.0.5/swiper-bundle.min.css">

    <!-- Custom Styles -->
    <style>
    .swiper-wrapper{
        width:100%;
    }
        .success-stories-swiper {
            min-height: <?php echo $atts['slider_height']; ?>;
            position: relative;
            padding-bottom: 50px; /* Space for pagination */
        }
        
        .success-stories-swiper .swiper-slide {
            height: auto;
            padding: 0 10px;
        }
        
        .success-stories-swiper .card {
            transition: all 0.3s ease;
            border-radius: 10px;
            overflow: hidden;
            height: 100%;
        }
        
        .success-stories-swiper .card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.15) !important;
        }
        
        .success-stories-swiper .card-title a {
            color: #333;
            font-weight: 600;
            line-height: 1.3;
        }
        
        .success-stories-swiper .card-title a:hover {
            color: var(--kpy-primary, #007bff);
        }
        
        .success-stories-swiper .card-img-wrapper {
            transition: transform 0.3s ease;
        }
        
        .success-stories-swiper .card:hover .card-img-wrapper {
            transform: scale(1.05);
        }
        
        .success-stories-swiper .card-body {
            padding: 1.5rem 1.25rem;
        }
        
        /* Navigation buttons */
        .success-stories-swiper .swiper-button-next,
        .success-stories-swiper .swiper-button-prev {
            color: #333;
            background-color: rgba(255, 255, 255, 0.9);
            border-radius: 50%;
            width: 40px;
            height: 40px;
            margin-top: -20px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            transition: all 0.3s ease;
        }
        
        .success-stories-swiper .swiper-button-next:hover,
        .success-stories-swiper .swiper-button-prev:hover {
            background-color: rgba(255, 255, 255, 1);
            color: var(--kpy-primary, #007bff);
            transform: scale(1.1);
        }
        
        .success-stories-swiper .swiper-button-next::after,
        .success-stories-swiper .swiper-button-prev::after {
            font-size: 16px;
            font-weight: bold;
        }
        
        /* Pagination */
        .success-stories-swiper .swiper-pagination {
            bottom: 0;
        }
        
        .success-stories-swiper .swiper-pagination-bullet {
            width: 12px;
            height: 12px;
            background-color: rgba(0,0,0,0.3);
            margin: 0 4px;
            transition: all 0.3s ease;
        }
        
        .success-stories-swiper .swiper-pagination-bullet-active {
            background-color: var(--kpy-primary, #007bff);
            transform: scale(1.2);
        }
        
        /* Responsive adjustments */
        @media (max-width: 576px) {
            .success-stories-swiper {
                min-height: auto;
            }
            
            .success-stories-swiper .card-img-wrapper {
                height: 200px !important;
            }
            
            .success-stories-swiper .card-body {
                padding: 1.25rem 1rem;
            }
            
            .success-stories-swiper .card-title {
                font-size: 1.1rem;
            }
            
            .success-stories-swiper .swiper-button-next,
            .success-stories-swiper .swiper-button-prev {
                width: 35px;
                height: 35px;
                margin-top: -17.5px;
            }
            
            .success-stories-swiper .swiper-button-next::after,
            .success-stories-swiper .swiper-button-prev::after {
                font-size: 14px;
            }
        }
        
        /* Tablet optimizations */
        @media (min-width: 577px) and (max-width: 991px) {
            .success-stories-swiper .card-title {
                font-size: 1.15rem;
            }
        }
        
        /* Alert styles */
        .alert {
            padding: 1rem;
            margin-bottom: 1rem;
            border: 1px solid transparent;
            border-radius: 0.375rem;
        }
        
        .alert-info {
            color: #0c5460;
            background-color: #d1ecf1;
            border-color: #bee5eb;
        }
        
        .alert-warning {
            color: #664d03;
            background-color: #fff3cd;
            border-color: #ffecb5;
        }
    </style>

    <!-- Load Swiper JS and Initialize -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/Swiper/11.0.5/swiper-bundle.min.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const swiper = new Swiper('#<?php echo $slider_id; ?>', {
                // Basic settings
                loop: true,
                centeredSlides: false,
                spaceBetween: 20,
                
                // Responsive breakpoints
                slidesPerView: <?php echo $atts['posts_per_slide_mobile']; ?>,
                breakpoints: {
                    577: {
                        slidesPerView: <?php echo $atts['posts_per_slide_tablet']; ?>,
                        spaceBetween: 20
                    },
                    992: {
                        slidesPerView: <?php echo $atts['posts_per_slide']; ?>,
                        spaceBetween: 30
                    }
                },
                
                // Navigation
                navigation: {
                    nextEl: '#<?php echo $slider_id; ?> .swiper-button-next',
                    prevEl: '#<?php echo $slider_id; ?> .swiper-button-prev',
                },
                
                // Pagination
                pagination: {
                    el: '#<?php echo $slider_id; ?> .swiper-pagination',
                    clickable: true,
                },
                
                <?php if ($atts['autoplay'] === 'true') : ?>
                // Autoplay
                autoplay: {
                    delay: <?php echo $atts['autoplay_delay']; ?>,
                    disableOnInteraction: false,
                    pauseOnMouseEnter: true,
                },
                <?php endif; ?>
                
                // Touch settings
                touchRatio: 1,
                touchAngle: 45,
                grabCursor: true,
                
                // Smooth transitions
                speed: 600,
                effect: 'slide',
                
                // Accessibility
                a11y: {
                    prevSlideMessage: 'Previous slide',
                    nextSlideMessage: 'Next slide',
                    paginationBulletMessage: 'Go to slide {{index}}',
                }
            });
        });
    </script>

    <?php
    return ob_get_clean();
}
add_shortcode('success_slider','success_stories_slider');


// Add custom column to pages list to show selected category
function add_success_stories_column($columns) {
    $columns['success_stories_category'] = 'Success Stories Category';
    return $columns;
}
add_filter('manage_pages_columns', 'add_success_stories_column');

// Populate the custom column
function populate_success_stories_column($column, $post_id) {
    if ($column === 'success_stories_category') {
        $category_slug = get_post_meta($post_id, '_success_stories_category', true);
        if (!empty($category_slug)) {
            $category = get_category_by_slug($category_slug);
            if ($category) {
                echo '<span class="dashicons dashicons-category"></span> ' . esc_html($category->name);
            } else {
                echo '<span style="color: #d63384;">Category not found</span>';
            }
        } else {
            echo '<span style="color: #6c757d;">—</span>';
        }
    }
}
add_action('manage_pages_custom_column', 'populate_success_stories_column', 10, 2);

function allsuccess_shortcode() {
    ob_start(); // Start output buffering
    // Get current page number
    $paged = (get_query_var('paged')) ? get_query_var('paged') : 1;
    $news_args = array(
        'post_type'      => array('post'),
        'posts_per_page' => 12, // Show 12 posts per page
        'category_name'  => 'success-stories',
        'paged'         => $paged, // Enable pagination
    );
    $news_query = new WP_Query($news_args);
    if ($news_query->have_posts()) : ?>
        <div class="row">
            <?php while ($news_query->have_posts()) :
                $news_query->the_post();
                $categories = get_the_category();
            ?>
                <div class="col-md-3 col-sm-6 kpy-news">
                    <article>
                        <a href="<?php echo esc_url(get_permalink()); ?>">
                            <div class="card mb-3 border-0" data-aos="fade-up">
                                <div class="post-thumbnail">
                                    <?php if (has_post_thumbnail()) {
                                        the_post_thumbnail('medium'); 
                                    } else {
                                        echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="'.esc_attr(get_the_title()).'" class="img-fluid"/>';
                                    } ?>
                                </div>
                                <div class="card-body">
                                    <h3 class="card-title"><?php 
                                        ob_start();
                                        the_title();
                                        $title = ob_get_clean();
                                        echo wp_trim_words($title, 7); 
                                    ?></h3>
                                    <div class="catz">
                                        <i class="bi bi-calendar-check"></i> 
                                        <?php echo get_the_date(); ?>
                                    </div>
                                    <a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-outline-info read-more">Read More</a>
                                </div>
                            </div>
                        </a>
                    </article>
                </div>
            <?php endwhile; ?>
        </div>
        <!-- Enhanced Pagination -->
        <div class="success-pagination">
            <?php
            echo paginate_links(array(
                'total'     => $news_query->max_num_pages,
                'current'   => max(1, $paged),
                'prev_text' => __('<i class="bi bi-chevron-left"></i> Previous'),
                'next_text' => __('Next <i class="bi bi-chevron-right"></i>'),
                'type'      => 'list',
                'mid_size'  => 2,
                'end_size'  => 1,
            ));
            ?>
        </div>
        
        <style>
        /* Card title styling to limit to 2 lines */
        .card-title {
            display: -webkit-box;
            -webkit-line-clamp: 2;
            -webkit-box-orient: vertical;
            overflow: hidden;
            text-overflow: ellipsis;
            min-height: 3em;
            line-height: 1.5em;
            margin-bottom: 0.75rem;
        }
        
        /* Ensure consistent card heights */
        .kpy-news .card {
            height: 100%;
            display: flex;
            flex-direction: column;
        }
        
        .kpy-news .card-body {
            flex-grow: 1;
            display: flex;
            flex-direction: column;
        }
        
        .kpy-news .card-body .read-more {
            margin-top: auto;
        }
        
        .success-pagination {
            display: flex;
            justify-content: center;
            align-items: center;
            margin: 40px 0 20px 0;
            padding: 20px 0;
        }
        
        .success-pagination .page-numbers {
            display: flex;
            list-style: none;
            padding: 0;
            margin: 0;
            gap: 8px;
            align-items: center;
        }
        
        .success-pagination .page-numbers li {
            margin: 0;
        }
        
        .success-pagination .page-numbers a,
        .success-pagination .page-numbers span {
            display: inline-flex;
            align-items: center;
            justify-content: center;
            min-width: 44px;
            height: 44px;
            padding: 8px 12px;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            color: #495057;
            text-decoration: none;
            font-weight: 500;
            font-size: 14px;
            transition: all 0.3s ease;
            background-color: #fff;
            box-shadow: 0 2px 4px rgba(0,0,0,0.05);
        }
        
        .success-pagination .page-numbers a:hover {
            background-color: #228b22;
            border-color: #138496;
            color: #fff;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(23, 162, 184, 0.3);
        }
        
        .success-pagination .page-numbers .current {
            background-color: #228b22;
            border-color: #138496;
            color: #fff;
            cursor: default;
            box-shadow: 0 4px 8px rgba(23, 162, 184, 0.3);
        }
        
        .success-pagination .page-numbers .prev,
        .success-pagination .page-numbers .next {
            padding: 8px 16px;
            min-width: auto;
            font-weight: 600;
        }
        
        .success-pagination .page-numbers .prev:hover,
        .success-pagination .page-numbers .next:hover {
            background-color: #228b22;
            border-color: #138496;
        }
        
        .success-pagination .page-numbers .dots {
            border: none;
            background: none;
            color: #6c757d;
            cursor: default;
            box-shadow: none;
        }
        
        .success-pagination .page-numbers .dots:hover {
            background: none;
            border: none;
            transform: none;
            box-shadow: none;
        }
        
        /* Responsive adjustments */
        @media (max-width: 768px) {
            .success-pagination .page-numbers {
                gap: 4px;
            }
            
            .success-pagination .page-numbers a,
            .success-pagination .page-numbers span {
                min-width: 36px;
                height: 36px;
                font-size: 13px;
                padding: 6px 10px;
            }
            
            .success-pagination .page-numbers .prev,
            .success-pagination .page-numbers .next {
                padding: 6px 12px;
            }
        }
        
        @media (max-width: 480px) {
            .success-pagination .page-numbers .prev span,
            .success-pagination .page-numbers .next span {
                display: none;
            }
            
            .success-pagination .page-numbers .prev:after {
                content: '‹';
                font-size: 18px;
                font-weight: bold;
            }
            
            .success-pagination .page-numbers .next:after {
                content: '›';
                font-size: 18px;
                font-weight: bold;
            }
        }
        </style>
        
    <?php else :
        echo 'No success stories found.';
    endif;
    wp_reset_postdata();
    return ob_get_clean();
}
add_shortcode('all_success', 'allsuccess_shortcode');
function gallery_lightbox_shortcode($atts) {
    // Extract shortcode attributes
    extract(shortcode_atts(array(
        'id' => '',
    ), $atts));

    if (empty($id)) return '';

    // Get the gallery images
    $images = get_post_gallery_images($id);
    $output = '<div class="gallery-lightbox">';

    foreach ($images as $image) {
        // Get attachment ID from URL
        $attachment_id = attachment_url_to_postid($image);
        
        // Get caption
        $caption = wp_get_attachment_caption($attachment_id);
        
        $output .= '<div class="gallery-item">';
        $output .= '<a href="' . esc_url($image) . '" data-lightbox="gallery" data-title="' . esc_attr($caption) . '">';
        $output .= '<img src="' . esc_url($image) . '" alt="' . esc_attr($caption) . '">';
        $output .= '</a>';
        
        if ($caption) {
            $output .= '<div class="gallery-caption">' . esc_html($caption) . '</div>';
        }
        
        $output .= '</div>';
    }

    $output .= '</div>';

    return $output;
}
add_shortcode('gallery_lightbox', 'gallery_lightbox_shortcode');