<?php
function display_about_departments_shortcode($atts) {
    ob_start();

    $args = array(
        'post_type' => 'page',
        'posts_per_page' => -1,
        'orderby' => 'rand', // random order
        'tax_query' => array(
            array(
                'taxonomy' => 'page_category', 
                'field'    => 'slug',
                'terms'    => 'dept',
            ),
        ),
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        // Inline style for the grid layout
        echo '<style>
            .about-departments {
                display: grid;
                grid-template-columns: repeat(3, 1fr);
                gap: 20px;
            }
            @media (max-width: 768px) {
                .about-departments {
                    grid-template-columns: repeat(2, 1fr);
                }
            }
            @media (max-width: 480px) {
                .about-departments {
                    grid-template-columns: 1fr;
                }
            }
        </style>';
        
        echo '<div class="about-departments">';
        while ($query->have_posts()) {
            $query->the_post();
            echo '<div class="card card-body about-department">';
            echo '<h3><a href="' . esc_url(get_permalink()) . '">' . get_the_title() . '</a></h3>';
            echo '</div>';
        }
        echo '</div>';
    }

    wp_reset_postdata();

    return ob_get_clean();
}
add_shortcode('about_departments', 'display_about_departments_shortcode');