<!Doctype html>
<html <?php language_attributes(); ?> class="no-js">
	<head>
		<meta charset="<?php bloginfo('charset'); ?>">
		<title>
    <?php
      $seo_title = get_post_meta(get_the_ID(), '_seo_title', true);
      if (!empty($seo_title)) {echo esc_html($seo_title);} else {echo esc_html(get_the_title());}
    ?>
		</title>
		<meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
		<meta name="viewport" content="width=device-width, initial-scale=1">
		<meta name="description" content="
      <?php
      $seo_description = get_post_meta(get_the_ID(), '_seo_description', true);
      if (!empty($seo_description)) { echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());}
      ?>
    ">
    <meta name="keywords" content="
      <?php
      $seo_keywords = get_post_meta(get_the_ID(), '_seo_keywords', true);
      if (!empty($seo_keywords)) {echo esc_html($seo_keywords);} else {echo esc_html('Ministry of Water and Environment Uganda, Water Resources Uganda, Sanitation Policies, Environmental Conservation Uganda, Sustainable Water Management, Climate Resilience Uganda, MWE Projects, Uganda Water Sector');}
      ?>
    ">
		<!-- Open Graph and Twitter Card Meta Tags -->
    <meta property="og:title" content="
      <?php
        if (!empty($seo_title)) {echo esc_html($seo_title);} else {echo esc_html(get_the_title());}
      ?>
    "/>
    <meta property="og:description" content="
      <?php
        if (!empty($seo_description)) {echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());}
      ?>
    "/>
    <meta property="og:image" content="
      <?php
      $featured_image = get_the_post_thumbnail_url();
      $default_image=  get_template_directory() . '/assets/images/ministry-of-water-environment.jpg'; 
      if (!empty($featured_image)) {echo esc_url($featured_image);} else {echo esc_url($default_image);}
      ?>
    " />
    <meta property="og:url" content="<?php the_permalink(); ?>" />
    <meta name="twitter:title" content="
      <?php
      if (!empty($seo_title)) {echo esc_html($seo_title);} else {echo esc_html(get_the_title());}
      ?>
    "/>
    <meta name="twitter:description" content="
      <?php
      if (!empty($seo_description)) {echo esc_html($seo_description);} else {echo esc_html(get_the_excerpt());} 
      ?>
    "/>
    <meta name="twitter:image" content="
      <?php
      if (!empty($featured_image)) {echo esc_url($featured_image);} else {echo esc_url($default_image);}
      ?>
    "/>
    <meta name="twitter:url" content="<?php the_permalink(); ?>" />
		  <meta name="google-site-verification" content="Sk61s_LXBI0q4E5gbDGbnmSTqiUJFFC1zBgwWLIXQ64" />
		    <link href="//www.google-analytics.com" rel="dns-prefetch">
        <link href="<?php echo get_template_directory_uri(); ?>/favicon.png" rel="shortcut icon">
        <link rel="preconnect" href="https://fonts.googleapis.com">
        <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
        <link href="https://fonts.googleapis.com/css2?family=Lato:ital,wght@0,100;0,300;0,400;0,700;0,900;1,100;1,300;1,400;1,700;1,900&family=Open+Sans:ital,wght@0,300..800;1,300..800&family=Roboto+Condensed:ital,wght@0,100..900;1,100..900&family=Tangerine:wght@400;700&display=swap" rel="stylesheet">
        <!-- Add the Font Awesome CSS -->
        <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/5.15.4/css/all.min.css">
		  <!--Popup Modal-->
        <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>   		
        <?php wp_head(); ?>

	</head>
	<body <?php body_class(); ?>>
	