<?php
/**
 * Kipya functions and definitions.
 *
 * @link https://afiego.org
 *
 * @package Kipya
 */
set_time_limit(300); // Set to a higher value if needed
if ( ! function_exists( 'kipya_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 */
	function kipya_setup() {
		// Make the theme available for translation.
		load_theme_textdomain( 'kipya', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

        //Upload Logo in website.
        add_theme_support('custom-logo');

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable support for Post Thumbnails on posts and pages.
		add_theme_support( 'post-thumbnails' );

		// Register navigation menus.
		register_nav_menus( array(
			'primary'   => esc_html__( 'Primary Menu', 'kipya' ),
			'top-menu'  => esc_html__( 'Top Menu', 'kipya' ),
            'sidebar'   => esc_html__( 'Sidebar Menu', 'kipya' ),
            'footer'    => esc_html__( 'Footer Menu', 'kipya' ),
		) );

		// Switch default core markup for search form, comment form, and comments to output valid HTML5.
		add_theme_support( 'kipya', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'kipya_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

        /**
		 * Enable support for the following post formats:
		 * aside, gallery, quote, image, and video
		 */
        add_theme_support( 'post-formats', array( 'aside', 'gallery', 'quote', 'image', 'video' ) );
	}
endif;
add_action( 'after_setup_theme', 'kipya_setup' );

// Enqueue styles.
function kipya_styles() {
    wp_register_style('kipya-style', get_template_directory_uri() . '/style.css', array(), '1.0.0', 'all');
    wp_register_style('custom', get_template_directory_uri() . '/assets/css/custom.css', array(), '1.0.0', 'all');
    wp_register_style('bootstrap.min', get_template_directory_uri() . '/assets/vendor/bootstrap/css/bootstrap.min.css', array(), '5.3.2', 'all');
    wp_register_style('bootstrap-icons', get_template_directory_uri() . '/assets/vendor/bootstrap-icons/font/bootstrap-icons.min.css', array(), '1.11.3', 'all');
    wp_register_style('aos', get_template_directory_uri() . '/assets/vendor/aos/aos.css', array(), '2.3.4', 'all');
    wp_register_style('swiper', get_template_directory_uri() . '/assets/vendor/swiper/swiper.min.css', array(), '5.4.5', 'all');
    wp_register_style('toastr.min', get_template_directory_uri() . '/assets/vendor/toastr/toastr.min.css', array(), '2.1.3', 'all');
    wp_register_style('datatables.min', get_template_directory_uri() . '/assets/vendor/DataTables/datatables.min.css', array(), '1.13.3', 'all');



    wp_enqueue_style( 'kipya-style');
    wp_enqueue_style( 'custom');
    wp_enqueue_style( 'bootstrap.min');
    wp_enqueue_style( 'bootstrap-icons');
    wp_enqueue_style( 'aos');
    wp_enqueue_style( 'swiper');
    wp_enqueue_style( 'toastr.min');
    wp_enqueue_style( 'datatables.min');
}
add_action( 'wp_enqueue_scripts', 'kipya_styles' );

// Enqueue scripts.
function kipya_scripts() {

    wp_enqueue_script( 'bootstrap-script', get_template_directory_uri() . '/assets/vendor/bootstrap/js/bootstrap.bundle.min.js', array(), '4.5.2', 'all');
    wp_enqueue_script( 'aos-script', get_template_directory_uri() . '/assets/vendor/aos/aos.js', array(), '2.3.4', 'all');
    wp_enqueue_script( 'swiper-script', get_template_directory_uri() . '/assets/vendor/swiper/swiper.min.js', array(), '5.4.5', 'all');
    wp_enqueue_script( 'toastr-script', get_template_directory_uri() . '/assets/vendor/toastr/toastr.min.js', array(), '2.1.3', 'all');
    wp_enqueue_script( 'jquery-script', get_template_directory_uri() . '/assets/vendor/jquery/jquery-3.7.1.min.js', array( ), '3.7.1', 'all');
    wp_enqueue_script( 'kipya-script', get_template_directory_uri() . '/assets/js/main.js', array(), '1.0.0', 'all');
    wp_enqueue_script( 'search-script', get_template_directory_uri() . '/assets/js/search.js', array(), '1.0.0', 'all');
    wp_enqueue_script( 'datatables.min', get_template_directory_uri() . '/assets/vendor/DataTables/datatables.min.js', array(), '1.13.3', 'all');
    //wp_enqueue_script( 'custom-owl', get_template_directory_uri() . '/assets/js/custom-owl.js', array(), '6.8.1', 'all');

    // Pass the ajaxurl to search.js
    wp_localize_script('search-script', 'kipya_ajax_object', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
    ));
}
//add_action( 'wp_enqueue_scripts', 'kipya_scripts' );
add_action('wp_footer','kipya_scripts');

// ligtbox-gallery
function enqueue_custom_scripts() {
    // Enqueue lightbox library
    wp_enqueue_style('lightbox-css', 'https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/css/lightbox.min.css');
    wp_enqueue_script('lightbox-js', 'https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/js/lightbox.min.js', array('jquery'), null, true);

    // Enqueue custom JavaScript
    wp_enqueue_script('custom-gallery-lightbox', get_template_directory_uri() . '/assets/js/gallery-lightbox.js', array('jquery'), null, true);

    // Enqueue custom AJAX script for projects page
    if (is_page('projects-page')) {
        wp_enqueue_script('custom-ajax-script', get_template_directory_uri() . '/assets/js/custom-ajax-script.js', array('jquery'), null, true);
        wp_localize_script('custom-ajax-script', 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));
    }
}
add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');

function enqueue_glightbox() {
    wp_enqueue_script('glightbox', 'https://cdn.jsdelivr.net/npm/glightbox/dist/js/glightbox.min.js', array(), null, true);
    wp_enqueue_style('glightbox-css', 'https://cdn.jsdelivr.net/npm/glightbox/dist/css/glightbox.min.css');
}
add_action('wp_enqueue_scripts', 'enqueue_glightbox');
// Auto-version CSS files
function kipya_css_version($src) {
    if(strpos($src, 'ver=')) {
        $src = remove_query_arg('ver', $src);
        $src = add_query_arg('ver', time(), $src);
    }
    return $src;
}
add_filter('style_loader_src', 'kipya_css_version', 9999);

// If Dynamic Sidebar Exists
if (function_exists('register_sidebar'))
{
    // Define Sidebar Widget Area 1
    register_sidebar(array(
        'name' => __('Widget Area 1', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'widget-area-1',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));

    // Define Sidebar Widget Area 2
    register_sidebar(array(
        'name' => __('Widget Area 2', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'widget-area-2',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    
    register_sidebar( array(
        'name'          => esc_html__( 'Top Left', 'kipya' ),
        'id'            => 'topl',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Top Right', 'kipya' ),
        'id'            => 'topr',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Search Area', 'kipya' ),
        'id'            => 'searchi',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Quick Number', 'kipya' ),
        'id'            => 'inno',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Menu Right', 'kipya' ),
        'id'            => 'nav-right',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar(array(
        'name' => __('Services Sidebar', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'servsidebar',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    register_sidebar( array(
        'name'          => esc_html__( 'Advert Top', 'kipya' ),
        'id'            => 'advtop',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
     register_sidebar( array(
        'name'          => esc_html__( 'Newsletter', 'kipya' ),
        'id'            => 'footernewz',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Starter', 'kipya' ),
        'id'            => 'footeri',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer A', 'kipya' ),
        'id'            => 'footera',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer B', 'kipya' ),
        'id'            => 'footerb',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer C', 'kipya' ),
        'id'            => 'footerc',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer D', 'kipya' ),
        'id'            => 'footerd',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
     register_sidebar( array(
        'name'          => esc_html__( 'Copyright Links', 'kipya' ),
        'id'            => 'footer-links',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    
}
// Register multiple widget areas grouped under "Home Page"
function register_homepage_widgets() {
    // Group Title: Home Page
    register_sidebar(array(
        'name' => __('Home Page: Intro Banner', 'kipya'),
        'description' => __('Widget area for the top banner on the home page.', 'kipya'),
        'id' => 'home-intro-banner',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));

    register_sidebar(array(
        'name' => __('Home Page: Intro Text Section', 'kipya'),
        'description' => __('Widget area for the Intro section on the home page.', 'kipya'),
        'id' => 'home-intro-text',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));

    register_sidebar(array(
        'name' => __('Home Page: Intro Video Section', 'kipya'),
        'description' => __('Widget area for the Intro video section on the home page.', 'kipya'),
        'id' => 'home-intro-video',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));

    register_sidebar(array(
        'name' => __('Home Page: Intro Features', 'kipya'),
        'description' => __('Widget area for the Features section on the home page.', 'kipya'),
        'id' => 'home-intro-features',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    
    register_sidebar(array(
        'name' => __('Home Page: Intro Stats', 'kipya'),
        'description' => __('Widget area for the intro stats on the home page.', 'kipya'),
        'id' => 'home-intro-stats',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));

    register_sidebar(array(
        'name' => __('Home Page: News', 'kipya'),
        'description' => __('Widget area for the Features section on the home page.', 'kipya'),
        'id' => 'home-intro-news',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    register_sidebar(array(
        'name' => __('Home Page: Job Listing', 'kipya'),
        'description' => __('Widget area for the Features section on the home page.', 'kipya'),
        'id' => 'home-intro-job-listing',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    register_sidebar(array(
        'name' => __('Home Page: Blog', 'kipya'),
        'description' => __('Widget area for the Features section on the home page.', 'kipya'),
        'id' => 'home-intro-blog',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
}
add_action('widgets_init', 'register_homepage_widgets');

//Activate Excerpt in PAGES
function enable_page_excerpts() {
    add_post_type_support('page', 'excerpt');
}
add_action('init', 'enable_page_excerpts');




//Custom BOOTSTRAP Menu 
include get_template_directory() . '/inc/bootstrap-5-wordpress-navbar-walker.php';
include get_template_directory() . '/inc/custom-nav-walker.php';

//Custom Post Type :: SEO 
include get_template_directory() . '/inc/seo-post-types.php';
include get_template_directory() . '/inc/add_page_category.php';

//Custom Post Type :: SEARCH
include get_template_directory() . '/inc/ajax-search.php';

//Custom Post Type :: SLIDING PHOTOS 
include get_template_directory() . '/inc/slides-post-types.php';

//Custom Post Type :: DOWNLOADS
include get_template_directory() . '/inc/downloads-post-types.php';

//Custom Post Type :: TEAMS
include get_template_directory() . '/inc/team-post-types.php';
include get_template_directory() . '/inc/partners-post-types.php';
include get_template_directory() . '/inc/all_partners-page.php';
include get_template_directory() . '/inc/departments-shortcode.php';

// Shortcode :: AOS
include get_template_directory() . '/inc/aos-animation.php'; 
include get_template_directory() . '/inc/breadcrumbs.php'; 

//ALL News Shortcode
include get_template_directory() . '/inc/all_news-shortcode.php';
include get_template_directory() . '/inc/news_front.php'; 
include get_template_directory() . '/inc/about-departments-shortcode.php';

//Duplicate Pages
include get_template_directory() . '/inc/duplicate-page.php'; 

//ALL Upcoming Events
include get_template_directory() . '/inc/upcoming-events-post-types.php';
include get_template_directory() . '/inc/more-upcoming-events.php'; 
// include get_template_directory() . '/inc/events_front.php';

//ALL Associates Shortcode


//ALL Publications Shortcode
include get_template_directory() . '/inc/home-pubs-shortcode.php';
include get_template_directory() . '/inc/home-display-ministers-shortcode.php';
include get_template_directory() . '/inc/home-tabs-news-events-shortcode.php';
include get_template_directory() . '/inc/env-cards.php';
include get_template_directory() . '/inc/mwe_news-shortcode.php';
include get_template_directory() . '/inc/mwe-gallery-shortcode.php';


//Accordion
include get_template_directory() . '/inc/accordion.php';


// //FORM PROCESSOR
// include get_template_directory() . '/inc/process-form.php'; 

//BACK BUTTON (previous page)
add_action( 'back_button', 'kipya_back_button' );
function kipya_back_button() {
    if ( wp_get_referer() ) {
        $back_text = __( '&laquo; BACK' );
        $button    = "\n<button id='my-back-button' class='btn button my-back-button' onclick='javascript:history.back()'>$back_text</button>";
        echo ( $button );
    }
}

// Pagination for paged posts, Page 1, Page 2, Page 3, with Next and Previous Links, No plugin
function html5wp_pagination()
{
    global $wp_query;
    $big = 999999999;
    echo paginate_links(array(
        'base' => str_replace($big, '%#%', get_pagenum_link($big)),
        'format' => '?paged=%#%',
        'current' => max(1, get_query_var('paged')),
        'total' => $wp_query->max_num_pages
    ));
}
function enqueue_datatables_assets() {
    wp_enqueue_style('datatables-css', 'https://cdn.datatables.net/1.11.3/css/jquery.dataTables.min.css');
    wp_enqueue_script('datatables-js', 'https://cdn.datatables.net/1.11.3/js/jquery.dataTables.min.js', array('jquery'), null, true);
}
add_action('wp_enqueue_scripts', 'enqueue_datatables_assets');

// Custom Excerpts
function html5wp_index($length) // Create 20 Word Callback for Index page Excerpts, call using html5wp_excerpt('html5wp_index');
{
    return 50;
}

// Create 40 Word Callback for Custom Post Excerpts, call using html5wp_excerpt('html5wp_custom_post');
function html5wp_custom_post($length)
{
    return 50;
}

//Allow upload of SVG Images
function enable_svg_support($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'enable_svg_support');

// Create the Custom Excerpts callback
function html5wp_excerpt($length_callback = '', $more_callback = '')
{
    global $post;
    if (function_exists($length_callback)) {
        add_filter('excerpt_length', $length_callback);
    }
    if (function_exists($more_callback)) {
        add_filter('excerpt_more', $more_callback);
    }
    $output = get_the_excerpt();
    $output = apply_filters('wptexturize', $output);
    $output = apply_filters('convert_chars', $output);
    $output = '<p>' . $output . '</p>';
    echo $output;
}

// Custom View Article link to Post
function html5_blank_view_article($more)
{
    global $post;
    return '... <a class="view-article" href="' . get_permalink($post->ID) . '">' . __('Read More', 'kipya') . '</a>';
}

// Remove Admin bar
function remove_admin_bar() {
    return false;
}
add_filter('show_admin_bar', 'remove_admin_bar');

// Remove 'text/css' from our enqueued stylesheet
function html5_style_remove($tag)
{
    return preg_replace('~\s+type=["\'][^"\']++["\']~', '', $tag);
}

// Remove thumbnail width and height dimensions that prevent fluid images in the_thumbnail
function remove_thumbnail_dimensions( $html )
{
    $html = preg_replace('/(width|height)=\"\d*\"\s/', "", $html);
    return $html;
}







// PUBLICATION FILTER AJAX HANDLER

// AJAX handler to filter downloads by category
add_action('wp_ajax_filter_downloads_by_file_category', 'ajax_filter_downloads_by_file_category');
add_action('wp_ajax_nopriv_filter_downloads_by_file_category', 'ajax_filter_downloads_by_file_category');

function ajax_filter_downloads_by_file_category() {
    $slug = isset($_POST['category_slug']) ? sanitize_text_field($_POST['category_slug']) : '';
    echo do_shortcode('[publications category="' . esc_attr($slug) . '"]');
    wp_die();
}

function enqueue_filter_scripts() {
    wp_enqueue_script('jquery');
}
add_action('wp_enqueue_scripts', 'enqueue_filter_scripts');



// ENV_CARDS DOWNLOAD HANDLER

add_action('wp_ajax_update_download_count', 'update_download_count_callback');
add_action('wp_ajax_nopriv_update_download_count', 'update_download_count_callback');

function update_download_count_callback() {
    if (isset($_POST['post_id'])) {
        $post_id = intval($_POST['post_id']);
        $count = get_post_meta($post_id, '_download_count', true);
        $count = $count ? intval($count) + 1 : 1;
        update_post_meta($post_id, '_download_count', $count);
        wp_send_json_success('Count updated');
    } else {
        wp_send_json_error('No post ID provided');
    }
}

add_action('template_redirect', 'redirect_file_category_to_pretty_url');

function redirect_file_category_to_pretty_url() {
    if (is_tax('file_category')) {
        $term = get_queried_object();
        if ($term && !is_wp_error($term)) {
            $slug = $term->slug;

            // Construct the target URL
            $target_url = home_url("/$slug/");

            // If we're not already at that pretty URL, redirect
            if (trailingslashit($_SERVER['REQUEST_URI']) !== trailingslashit(parse_url($target_url, PHP_URL_PATH))) {
                wp_redirect($target_url, 301);
                exit;
            }
        }
    }
}

function add_theme_color_class($classes) {
    if (is_page()) {
        $theme_color = get_post_meta(get_the_ID(), 'theme_color', true);
        if ($theme_color === 'blue') {
            $classes[] = 'theme-blue';
        } elseif ($theme_color === 'green') {
            $classes[] = 'theme-green';
        }
    }
    return $classes;
}
add_filter('body_class', 'add_theme_color_class');

/**
 * Add metabox to pages for selecting post categories
 */
function add_post_category_to_pages() {
    // Add metabox to page edit screen
    add_meta_box(
        'page_post_categories',
        'Display Post Categories',
        'render_page_post_categories',
        'page',
        'side'
    );
}
add_action('add_meta_boxes', 'add_post_category_to_pages');

/**
 * Render the category selection interface
 */
function render_page_post_categories($post) {
    // Get saved categories - this ensures previously saved selections are retrieved
    $selected_categories = get_post_meta($post->ID, '_page_post_categories', true);
    
    // Ensure we have an array to work with
    if (!is_array($selected_categories)) {
        $selected_categories = array();
    }
    
    // Get all post categories
    $categories = get_categories(array(
        'taxonomy' => 'category',
        'hide_empty' => false,
        'orderby' => 'name',
        'order' => 'ASC'
    ));
    
    // Security field
    wp_nonce_field('save_page_post_categories', 'page_post_categories_nonce');
    
    echo '<p>Select which post categories this page should display:</p>';
    
    if (!empty($categories)) {
        echo '<ul style="max-height:200px; overflow-y:auto; margin:0; padding:0; list-style:none;">';
        foreach ($categories as $category) {
            // Check if this category is in the saved selections
            $checked = in_array($category->slug, $selected_categories) ? 'checked="checked"' : '';
            
            echo '<li style="margin:5px 0;">';
            echo '<label style="display:block; padding:2px 0;">';
            echo '<input type="checkbox" name="page_post_categories[]" value="' . esc_attr($category->slug) . '" ' . $checked . ' style="margin-right:5px;"> ';
            echo esc_html($category->name) . ' (' . $category->count . ' posts)';
            echo '</label>';
            echo '</li>';
        }
        echo '</ul>';
        
        // Add a "Select All" and "Clear All" helper
        echo '<p style="margin-top:10px;">';
        echo '<a href="#" onclick="jQuery(\'#page_post_categories input[type=checkbox]\').prop(\'checked\', true); return false;" style="text-decoration:none;">Select All</a> | ';
        echo '<a href="#" onclick="jQuery(\'#page_post_categories input[type=checkbox]\').prop(\'checked\', false); return false;" style="text-decoration:none;">Clear All</a>';
        echo '</p>';
    } else {
        echo '<p><em>No categories found. Create some post categories first.</em></p>';
    }
    
    // Show currently selected categories for reference
    if (!empty($selected_categories)) {
        echo '<div style="margin-top:15px; padding:10px; background:#f9f9f9; border-left:4px solid #0073aa;">';
        echo '<strong>Currently displaying posts from:</strong><br>';
        foreach ($selected_categories as $cat_slug) {
            $cat_obj = get_category_by_slug($cat_slug);
            if ($cat_obj) {
                echo '<span style="display:inline-block; margin:2px 5px 2px 0; padding:2px 6px; background:#0073aa; color:white; border-radius:3px; font-size:11px;">' . esc_html($cat_obj->name) . '</span>';
            }
        }
        echo '</div>';
    }
}

/**
 * Save the selected categories when page is saved
 */
function save_page_post_categories($post_id) {
    // Check if this is an autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    
    // Verify nonce for security
    if (!isset($_POST['page_post_categories_nonce']) || 
        !wp_verify_nonce($_POST['page_post_categories_nonce'], 'save_page_post_categories')) {
        return;
    }
    
    // Check user permissions
    if (!current_user_can('edit_page', $post_id)) {
        return;
    }
    
    // Check if we're saving a page (not a post or other post type)
    if (get_post_type($post_id) !== 'page') {
        return;
    }
    
    // Save categories or delete if none selected
    if (isset($_POST['page_post_categories']) && !empty($_POST['page_post_categories'])) {
        // Sanitize the input
        $categories = array_map('sanitize_text_field', $_POST['page_post_categories']);
        // Remove any empty values
        $categories = array_filter($categories);
        // Update the meta
        update_post_meta($post_id, '_page_post_categories', $categories);
    } else {
        // No categories selected, remove the meta
        delete_post_meta($post_id, '_page_post_categories');
    }
}

// Hook into save_post instead of save_page for broader compatibility
add_action('save_post', 'save_page_post_categories');

/**
 * Add some basic styling to the metabox
 */
function page_post_categories_admin_styles() {
    global $pagenow, $post_type;
    
    // Only load on page edit screens
    if (($pagenow === 'post.php' || $pagenow === 'post-new.php') && $post_type === 'page') {
        echo '<style>
            #page_post_categories input[type="checkbox"] {
                margin-right: 8px !important;
            }
            #page_post_categories label {
                cursor: pointer;
                padding: 3px 0;
                display: block;
            }
            #page_post_categories label:hover {
                background-color: #f0f0f1;
                padding-left: 5px;
                margin-left: -5px;
            }
        </style>';
    }
}
add_action('admin_head', 'page_post_categories_admin_styles');

/**
/**
 * Add metabox to pages for selecting download categories
 */
function add_downloads_category_to_pages() {
    add_meta_box(
        'page_downloads_categories',
        'Display Downloads Categories',
        'render_page_downloads_categories',
        'page',
        'side'
    );
}
add_action('add_meta_boxes', 'add_downloads_category_to_pages');

/**
 * Render the downloads category selection interface
 */
function render_page_downloads_categories($post) {
    // Get saved categories - ensures previously saved selections are retrieved
    $selected_categories = get_post_meta($post->ID, '_page_downloads_categories', true);
    
    // Ensure we have an array to work with
    if (!is_array($selected_categories)) {
        $selected_categories = array();
    }
    
    // Get all download categories
    $categories = get_terms([
        'taxonomy' => 'file_category',
        'hide_empty' => false,
        'orderby' => 'name',
        'order' => 'ASC'
    ]);
    
    // Security field
    wp_nonce_field('save_page_downloads_categories', 'page_downloads_categories_nonce');
    
    echo '<p>Select which download categories this page should display:</p>';
    
    if (!empty($categories) && !is_wp_error($categories)) {
        echo '<ul style="max-height:200px; overflow-y:auto; margin:0; padding:0; list-style:none;">';
        foreach ($categories as $category) {
            // Check if this category is in the saved selections
            $checked = in_array($category->slug, $selected_categories) ? 'checked="checked"' : '';
            
            echo '<li style="margin:5px 0;">';
            echo '<label style="display:block; padding:2px 0; cursor:pointer;">';
            echo '<input type="checkbox" name="page_downloads_categories[]" value="' . esc_attr($category->slug) . '" ' . $checked . ' style="margin-right:5px;"> ';
            echo esc_html($category->name) . ' (' . $category->count . ' files)';
            echo '</label>';
            echo '</li>';
        }
        echo '</ul>';
        
        // Add helper links
        echo '<p style="margin-top:10px;">';
        echo '<a href="#" onclick="jQuery(\'#page_downloads_categories input[type=checkbox]\').prop(\'checked\', true); return false;" style="text-decoration:none;">Select All</a> | ';
        echo '<a href="#" onclick="jQuery(\'#page_downloads_categories input[type=checkbox]\').prop(\'checked\', false); return false;" style="text-decoration:none;">Clear All</a>';
        echo '</p>';
    } else {
        echo '<p><em>No download categories found. Create some file categories first.</em></p>';
    }
    
    // Show currently selected categories for reference
    if (!empty($selected_categories)) {
        echo '<div style="margin-top:15px; padding:10px; background:#f9f9f9; border-left:4px solid #0073aa;">';
        echo '<strong>Currently displaying downloads from:</strong><br>';
        foreach ($selected_categories as $cat_slug) {
            $cat_obj = get_term_by('slug', $cat_slug, 'file_category');
            if ($cat_obj) {
                echo '<span style="display:inline-block; margin:2px 5px 2px 0; padding:2px 6px; background:#0073aa; color:white; border-radius:3px; font-size:11px;">' . esc_html($cat_obj->name) . '</span>';
            }
        }
        echo '</div>';
    }
}

/**
 * Save the selected download categories when page is saved
 */
function save_page_downloads_categories($post_id) {
    // Check if this is an autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    
    // Verify nonce for security
    if (!isset($_POST['page_downloads_categories_nonce']) || 
        !wp_verify_nonce($_POST['page_downloads_categories_nonce'], 'save_page_downloads_categories')) {
        return;
    }
    
    // Check user permissions
    if (!current_user_can('edit_page', $post_id)) {
        return;
    }
    
    // Check if we're saving a page (not a post or other post type)
    if (get_post_type($post_id) !== 'page') {
        return;
    }
    
    // Save categories or delete if none selected
    if (isset($_POST['page_downloads_categories']) && !empty($_POST['page_downloads_categories'])) {
        // Sanitize the input
        $categories = array_map('sanitize_text_field', $_POST['page_downloads_categories']);
        // Remove any empty values
        $categories = array_filter($categories);
        // Update the meta
        update_post_meta($post_id, '_page_downloads_categories', $categories);
    } else {
        // No categories selected, remove the meta
        delete_post_meta($post_id, '_page_downloads_categories');
    }
}

// Hook into save_post instead of save_page for better compatibility
add_action('save_post', 'save_page_downloads_categories');

/**
 * Add some basic styling to the downloads metabox
 */
function page_downloads_categories_admin_styles() {
    global $pagenow, $post_type;
    
    // Only load on page edit screens
    if (($pagenow === 'post.php' || $pagenow === 'post-new.php') && $post_type === 'page') {
        echo '<style>
            #page_downloads_categories input[type="checkbox"] {
                margin-right: 8px !important;
            }
            #page_downloads_categories label {
                cursor: pointer;
                padding: 3px 0;
                display: block;
            }
            #page_downloads_categories label:hover {
                background-color: #f0f0f1;
                padding-left: 5px;
                margin-left: -5px;
            }
        </style>';
    }
}
add_action('admin_head', 'page_downloads_categories_admin_styles');

function register_page_categories_taxonomy() {
    register_taxonomy('page_category', 'page', [
        'label' => 'Page Categories',
        'hierarchical' => true,
        'show_ui' => true,
        'show_in_rest' => true,
        'rewrite' => ['slug' => 'page-category'],
    ]);
}
add_action('init', 'register_page_categories_taxonomy');

/*
**************************
*************************
Gallery functionality
*************************
*************************
*/
function load_custom_single_template($template) {
    if (is_single() && in_category('photo-gallery')) {
        $new_template = locate_template(array('single-gallery.php'));
        if ($new_template) {
            return $new_template;
        }
    }
    if (is_singular('events')) {
        $eve_template = locate_template(array('single-event.php'));
        if ($eve_template) {
            return $eve_template;
        }
    }
    return $template;
}
add_filter('single_template', 'load_custom_single_template');

function force_gallery_links_to_media($block_content, $block) {
    if ($block['blockName'] === 'core/gallery' && !empty($block['innerBlocks'])) {
        foreach ($block['innerBlocks'] as &$innerBlock) {
            if ($innerBlock['blockName'] === 'core/image' && isset($innerBlock['attrs']['id'])) {
                $image_id = $innerBlock['attrs']['id'];
                $image_url = wp_get_attachment_url($image_id);
                if ($image_url) {
                    $innerBlock['attrs']['linkDestination'] = 'media';
                    $innerBlock['attrs']['href'] = $image_url;
                }
            }
        }
    }
    return $block_content;
}
add_filter('render_block', 'force_gallery_links_to_media', 10, 2);

/*
************************************************
************************************************
Project parnter selection
************************************************
************************************************
*/
function partner_category_meta_box() {
    add_meta_box(
        'partner_category_box',              // ID
        'Partner Category',                 // Title
        'render_partner_category_box',      // Callback
        'page',                             // Post type
        'side',                             // Context
        'default'                           // Priority
    );
}
add_action('add_meta_boxes', 'partner_category_meta_box');

function render_partner_category_box($post) {
    $selected = get_post_meta($post->ID, '_partner_category', true);
    $terms = get_terms(array(
        'taxonomy' => 'partner_category',
        'hide_empty' => false,
    ));

    if (!empty($terms) && !is_wp_error($terms)) {
        echo '<select name="partner_category" style="width: 100%;">';
        echo '<option value="">-- Select Partner Category --</option>';
        foreach ($terms as $term) {
            echo '<option value="' . esc_attr($term->slug) . '" ' . selected($selected, $term->slug, false) . '>' . esc_html($term->name) . '</option>';
        }
        echo '</select>';
    } else {
        echo 'No categories found.';
    }

    // Add nonce
    wp_nonce_field('save_partner_category_meta', 'partner_category_nonce');
}

function save_partner_category_meta($post_id) {
    // Check nonce
    if (!isset($_POST['partner_category_nonce']) || !wp_verify_nonce($_POST['partner_category_nonce'], 'save_partner_category_meta')) {
        return;
    }

    // Avoid autosave
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) return;

    // Check permissions
    if (!current_user_can('edit_page', $post_id)) return;

    // Save the value
    if (isset($_POST['partner_category'])) {
        update_post_meta($post_id, '_partner_category', sanitize_text_field($_POST['partner_category']));
    }
}
add_action('save_post', 'save_partner_category_meta');



