<?php
/**
 * Template Name: Donate Page
 */

// Process form submission at the very top
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['donation_submitted'])) {
    // Verify nonce for security
    if (!isset($_POST['donation_nonce']) || !wp_verify_nonce($_POST['donation_nonce'], 'donation_form_action')) {
        wp_die('Security verification failed');
    }

    // Sanitize and validate input
    $donor_name = sanitize_text_field($_POST['donor_name']);
    $donor_email = sanitize_email($_POST['donor_email']);
    $donor_phone = sanitize_text_field($_POST['donor_phone']);
    $donation_amount = floatval($_POST['donation_amount']);
    $payment_method = sanitize_text_field($_POST['payment_method']);
    $project = sanitize_text_field($_POST['project']);
    $transaction_reference = sanitize_text_field($_POST['transaction_reference']);
    $donor_message = sanitize_textarea_field($_POST['donor_message']);
    
    // Handle file upload securely
    $receipt_url = '';
    if (!empty($_FILES['receipt_upload']['name'])) {
        require_once(ABSPATH . 'wp-admin/includes/file.php');
        
        $upload_overrides = array(
            'test_form' => false,
            'mimes' => array(
                'jpg|jpeg' => 'image/jpeg',
                'png' => 'image/png',
                'pdf' => 'application/pdf'
            )
        );
        
        $uploaded_file = wp_handle_upload($_FILES['receipt_upload'], $upload_overrides);
        
        if ($uploaded_file && !isset($uploaded_file['error'])) {
            $receipt_url = $uploaded_file['url'];
        }
    }
    
    // Create donation post
    $donation_post = array(
        'post_title'    => 'Donation from ' . $donor_name . ' - ' . $donation_amount,
        'post_content'  => "Donor: $donor_name\nEmail: $donor_email\nPhone: $donor_phone\nAmount: $donation_amount\nMethod: $payment_method\nProject: $project\nReference: $transaction_reference\nMessage: $donor_message\nReceipt: $receipt_url",
        'post_status'   => 'private',
        'post_type'     => 'donation',
    );
    
    // Insert the post
    $post_id = wp_insert_post($donation_post);
    
    if ($post_id && !is_wp_error($post_id)) {
        // Send email notification to admin
        $to = get_option('admin_email');
        $subject = 'New Donation Received: ' . $donation_amount;
        $message = "New donation details:\n\n";
        $message .= "Donor: $donor_name\n";
        $message .= "Email: $donor_email\n";
        $message .= "Phone: $donor_phone\n";
        $message .= "Amount: $donation_amount\n";
        $message .= "Payment Method: $payment_method\n";
        $message .= "Project: $project\n";
        $message .= "Reference: $transaction_reference\n";
        $message .= "Message: $donor_message\n";
        
        if ($receipt_url) {
            $message .= "Receipt: $receipt_url\n";
        }
        
        wp_mail($to, $subject, $message);
        
        // Redirect to prevent form resubmission
        wp_redirect(add_query_arg('donation_success', '1', get_permalink()));
        exit;
    }
}


get_header(); 
include get_template_directory() . '/inc/menus/menu.php'; 
?>



<main>
    <?php $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>
    


<section class="hero-section" style="background-image: url('<?php echo esc_url($backgroundImg[0]); ?>');">
    <!-- Bigger floating spiritual elements -->
    <div class="spiritual-element cross" style="top:15%; left:5%; animation-delay:0s;">✝</div>
    <div class="spiritual-element dove" style="top:25%; right:10%; animation-delay:1s;">🕊</div>
    <div class="spiritual-element halo" style="bottom:30%; left:15%; animation-delay:2s;">☀</div>
    <div class="spiritual-element cross" style="bottom:20%; right:5%; animation-delay:1.5s;">✟</div>
    <div class="spiritual-element dove" style="top:60%; left:20%; animation-delay:2.5s;">🕊</div>
    
    <div class="hero-overlay">
        <div class="hero-content">
            <h1 class="hero-title"><?php the_title(); ?></h1>
            <div class="hero-breadcrumb">
                <a href="<?php echo esc_url(home_url()); ?>">Home</a> / <?php the_title(); ?>
            </div>
        </div>
    </div>

 
</section>

  <!-- Add this inside your <body> -->
<div class="floating-circles">
  <span></span>
  <span></span>
  <span></span>
  <span></span>
  <span></span>
</div>

    <!-- Payment Options Section -->
    <section class="modern-payment-options">
        <h2 class="modern-section-title">Choose Your Payment Method</h2>
        
        <div class="modern-payment-cards">
            <!-- Bank Transfer Card -->
            <div class="modern-payment-card">
                <h3 class="modern-card-title">
                    <i class="fas fa-university modern-card-icon"></i>
                    Bank Transfer
                </h3>
                <p>Make a direct transfer to our ministry account</p>
                
                <div class="modern-card-details">
                    <div class="modern-detail-item">
                        <span class="modern-detail-label">Bank Name:</span>
                        <span class="modern-detail-value">Kavod True light Youth Hub International</span>
                    </div>
                    <div class="modern-detail-item">
                        <span class="modern-detail-label">Account Name:</span>
                        <span class="modern-detail-value">King Ministry</span>
                    </div>
                    <div class="modern-detail-item">
                        <span class="modern-detail-label">Account Number:</span>
                        <span class="modern-detail-value">6009012506</span>
                    </div>
                </div>
            </div>
            
            <!-- Mobile Money Card -->
            <div class="modern-payment-card">
                <h3 class="modern-card-title">
                    <i class="fas fa-mobile-alt modern-card-icon"></i>
                    Mobile Money
                </h3>
                <p>Quick and convenient mobile payments</p>
                
                <div class="modern-card-details">
                    <div class="modern-detail-item">
                        <span class="modern-detail-label">Provider:</span>
                        <span class="modern-detail-value">MTN Mobile Money</span>
                    </div>
                    <div class="modern-detail-item">
                        <span class="modern-detail-label">Phone Number:</span>
                        <span class="modern-detail-value"> 0760940165</span>
                    </div>
                    <div class="modern-detail-item">
                        <span class="modern-detail-label">Account Name:</span>
                        <span class="modern-detail-value">Kavod True Light</span>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Donation Form Section -->
    <section class="modern-donation-form-section">
        <div class="modern-form-container">
            <div class="modern-form-card">
                <?php if (isset($_GET['donation_success'])) : ?>
                    <div class="modern-success-message">
                        <i class="fas fa-check-circle modern-success-icon"></i>
                        <h3 class="modern-success-title">Donation Received!</h3>
                        <p class="modern-success-text">Thank you for your generous support. Your contribution will make a meaningful difference in our ministry. We've sent a confirmation to your email address.</p>
                        <a href="<?php echo home_url('/'); ?>" class="modern-back-btn">Return to Homepage</a>
                    </div>
                <?php else : ?>
                
                <h2 class="modern-form-title">Donation Details</h2>
                <p class="modern-form-description">Please complete this form to verify your donation and help us properly acknowledge your gift</p>
                
                <form id="modern-donation-form" method="post" enctype="multipart/form-data">
                    <?php wp_nonce_field('donation_form_action', 'donation_nonce'); ?>
                    
                    <div class="modern-form-grid">
                        <div class="modern-form-group">
                            <label for="modern_donor_name" class="modern-form-label">Full Name *</label>
                            <input type="text" id="modern_donor_name" name="donor_name" class="modern-form-input" required>
                        </div>
                        
                        <div class="modern-form-group">
                            <label for="modern_donor_email" class="modern-form-label">Email *</label>
                            <input type="email" id="modern_donor_email" name="donor_email" class="modern-form-input" required>
                        </div>
                        
                        <div class="modern-form-group">
                            <label for="modern_donor_phone" class="modern-form-label">Phone Number</label>
                            <input type="tel" id="modern_donor_phone" name="donor_phone" class="modern-form-input">
                        </div>
                        
                        <div class="modern-form-group">
                            <label for="modern_donation_amount" class="modern-form-label">Amount (UGX) *</label>
                            <input type="number" id="modern_donation_amount" name="donation_amount" min="1" class="modern-form-input" required>
                        </div>
                        
                        <div class="modern-form-group">
                            <label for="modern_payment_method" class="modern-form-label">Payment Method *</label>
                            <select id="modern_payment_method" name="payment_method" class="modern-form-select" required>
                                <option value="">Select Method</option>
                                <option value="Bank Transfer">Bank Transfer</option>
                                <option value="Mobile Money">Mobile Money</option>
                                <option value="Credit Card">Credit Card</option>
                                <option value="Other">Other</option>
                            </select>
                        </div>
                        
                        <div class="modern-form-group">
                            <label for="modern_project" class="modern-form-label">Designated Project</label>
                            <select id="modern_project" name="project" class="modern-form-select">
                                <option value="">General Ministry Fund</option>
                                <option value="Youth Programs">Youth Programs</option>
                                <option value="Community Outreach">Community Outreach</option>
                                <option value="Facility Development">Facility Development</option>
                                <option value="Other">Other Purpose</option>
                            </select>
                        </div>
                        
                        <div class="modern-form-group">
                            <label for="modern_transaction_ref" class="modern-form-label">Transaction Reference *</label>
                            <input type="text" id="modern_transaction_ref" name="transaction_reference" class="modern-form-input" required>
                            <span class="modern-form-help">The reference number from your payment confirmation</span>
                        </div>
                        
                        <div class="modern-form-group" >
                            <label for="modern_receipt_upload" class="modern-form-label">Payment Proof *</label>
                            <input type="file" id="modern_receipt_upload" name="receipt_upload" class="modern-form-file" accept=".jpg,.jpeg,.png,.pdf" required>
                            <span class="modern-form-help">Upload screenshot or receipt (JPG, PNG, or PDF - max 2MB)</span>
                        </div>
                        
                        <div class="modern-form-group">
                            <label for="modern_donor_message" class="modern-form-label">Special Instructions</label>
                            <textarea id="modern_donor_message" name="donor_message" class="modern-form-textarea"></textarea>
                        </div>
                        
                        <input type="hidden" name="donation_submitted" value="1">
                        <button type="submit" class="modern-submit-btn">
                            <i class="fas fa-paper-plane"></i> Submit Donation
                        </button>
                    </div>
                </form>
                
                <?php endif; ?>
            </div>
        </div>
    </section>
</main>

<script>
jQuery(document).ready(function($) {
    // Enhanced form validation with real-time feedback
    $('#modern-donation-form').on('submit', function(e) {
        var valid = true;
        
        // Clear previous error states
        $(this).find('.modern-form-input, .modern-form-select').css('border-color', 'rgba(var(--kpy-primary-rgb), 0.2)');
        
        // Validate required fields
        $(this).find('[required]').each(function() {
            if (!$(this).val().trim()) {
                $(this).css('border-color', '#e74c3c');
                valid = false;
            }
        });
        
        // Validate email format
        var email = $('#modern_donor_email').val();
        if (email && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
            $('#modern_donor_email').css('border-color', '#e74c3c');
            valid = false;
        }
        
        // Validate file upload
        var fileInput = $('#modern_receipt_upload')[0];
        if (fileInput.files.length === 0) {
            $('#modern_receipt_upload').css('border-color', '#e74c3c');
            valid = false;
        } else {
            var file = fileInput.files[0];
            var validTypes = ['image/jpeg', 'image/png', 'application/pdf'];
            if (validTypes.indexOf(file.type) === -1) {
                alert('Please upload a JPG, PNG, or PDF file');
                valid = false;
            }
            if (file.size > 2 * 1024 * 1024) {
                alert('File size must be less than 2MB');
                valid = false;
            }
        }
        
        if (!valid) {
            e.preventDefault();
            $('html, body').animate({
                scrollTop: $("#modern-donation-form").offset().top - 100
            }, 500);
            
            // Add error message
            if (!$('#form-error-message').length) {
                $('#modern-donation-form').prepend(
                    '<div id="form-error-message" style="color: #e74c3c; margin-bottom: 1.5rem; grid-column: 1 / -1; text-align: center;">' +
                    'Please fill in all required fields correctly.' +
                    '</div>'
                );
            }
            
            return false;
        }
        
        // Show loading state
        $(this).find('button[type="submit"]')
            .html('<i class="fas fa-spinner fa-spin"></i> Processing...')
            .prop('disabled', true);
    });
    
    // Real-time validation for email
    $('#modern_donor_email').on('blur', function() {
        var email = $(this).val();
        if (email && !/^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email)) {
            $(this).css('border-color', '#e74c3c');
        } else {
            $(this).css('border-color', 'rgba(var(--kpy-primary-rgb), 0.2)');
        }
    });
});
</script>

<?php get_footer(); ?>