<?php /* Template Name: Liberty Scope Contact Page Template */ get_header(); 
    include get_template_directory() . '/inc/menus/menu.php'; 
    
    // Handle form submission (same as before)
    if (isset($_POST['contact_submitted'])) {
        $name = sanitize_text_field($_POST['contact_name']);
        $email = sanitize_email($_POST['contact_email']);
        $phone = sanitize_text_field($_POST['contact_phone']);
        $subject = sanitize_text_field($_POST['contact_subject']);
        $message = sanitize_textarea_field($_POST['contact_message']);
        
        $post_content = "Name: $name\n";
        $post_content .= "Email: $email\n";
        $post_content .= "Phone: $phone\n";
        $post_content .= "Subject: $subject\n\n";
        $post_content .= "Message:\n$message";
        
        $contact_post = array(
            'post_title' => 'New Contact: ' . $name . ' - ' . $subject,
            'post_content' => $post_content,
            'post_status' => 'private',
            'post_type' => 'contact_submission',
        );
        
        $post_id = wp_insert_post($contact_post);
        
        if ($post_id) {
            $submission_success = true;
        }
    }
?>

<main role="main">
    
<?php 
$backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); 
?>

<section class="ls-hero-section" style="background-image: url('<?php echo esc_url($backgroundImg[0]); ?>');">
    <div class="ls-hero-overlay">
        <div class="ls-hero-content" data-aos="fade-up">
            <h1 class="ls-hero-title" data-aos="fade-up"><?php the_title(); ?></h1>
            <div class="ls-hero-breadcrumb" data-aos="fade-up">
                <a href="<?php echo esc_url(home_url()); ?>">Home</a> / <?php the_title(); ?>
            </div>
        </div>
    </div>
    <!-- SVG curved bottom -->
    <svg class="curved-bottom" viewBox="0 0 2100 150" preserveAspectRatio="none">
        <path d="M0,0 C700,180 1400,180 2100,0 L2100,150 L0,150 Z" fill="#ffffff"/>
    </svg>
</section>

<div class="ls-contact-container">
    <?php if (have_posts()): while (have_posts()) : the_post(); ?>
        <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
            <?php the_content(); ?>
            
            <?php if (isset($submission_success) && $submission_success): ?>
            <div class="ls-contact-success-popup" data-aos="fade-up">
                <div class="ls-success-content">
                    <div class="ls-checkmark">
                        <svg viewBox="0 0 52 52">
                            <circle cx="26" cy="26" r="25" fill="var(--ls-primary)"/>
                            <path fill="none" stroke="#fff" stroke-width="4" d="M14.1 27.2l7.1 7.2 16.7-16.8"/>
                        </svg>
                    </div>
                    <h3>Message Sent Successfully!</h3>
                    <p>Thank you for contacting Liberty Scope. We've received your message and will respond within 24 hours.</p>
                    <button class="ls-close-popup">Close</button>
                </div>
            </div>
            <?php endif; ?>
            
        </article>
    <?php endwhile; endif; ?>
    
    <!-- Liberty Scope Contact Layout - Two Columns -->
    <div class="ls-contact-layout">
        <!-- Left Column - Contact Info -->
        <div class="ls-contact-info-col">
            <div class="ls-contact-info-card" data-aos="fade-right">
                <h3 class="ls-contact-info-title" data-aos="fade-up">Get In Touch</h3>
                
                <div class="ls-contact-info-item" data-aos="fade-up">
                    <div class="ls-contact-icon" data-aos="fade-up">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="var(--ls-primary)">
                            <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5c-1.38 0-2.5-1.12-2.5-2.5s1.12-2.5 2.5-2.5 2.5 1.12 2.5 2.5-1.12 2.5-2.5 2.5z"/>
                        </svg>
                    </div>
                    <div class="ls-contact-text" data-aos="fade-up">
                        <h4>Office Address</h4>
                        <p>Plot 32, Lumumba Avenue<br>Padre Pio House, Floor 5<br>P.O. Box 108841, Kampala - Uganda</p>
                    </div>
                </div>
                
                <div class="ls-contact-info-item" data-aos="fade-up">
                    <div class="ls-contact-icon" data-aos="fade-up">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="var(--ls-primary)">
                            <path d="M20 4H4c-1.1 0-1.99.9-1.99 2L2 18c0 1.1.9 2 2 2h16c1.1 0 2-.9 2-2V6c0-1.1-.9-2-2-2zm0 4l-8 5-8-5V6l8 5 8-5v2z"/>
                        </svg>
                    </div>
                    <div class="ls-contact-text" data-aos="fade-up">
                        <h4>Email Address</h4>
                        <p>info@libertyscope.co.ug<br>www.libertyscope.co.ug</p>
                    </div>
                </div>
                
                <div class="ls-contact-info-item" data-aos="fade-up">
                    <div class="ls-contact-icon" data-aos="fade-up">
                        <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="var(--ls-primary)">
                            <path d="M20.01 15.38c-1.23 0-2.42-.2-3.53-.56-.35-.12-.74-.03-1.01.24l-1.57 1.97c-2.83-1.35-5.48-3.9-6.89-6.83l1.95-1.66c.27-.28.35-.67.24-1.02-.37-1.11-.56-2.3-.56-3.53 0-.54-.45-.99-.99-.99H4.19C3.65 3 3 3.24 3 3.99 3 13.28 10.73 21 20.01 21c.71 0 .99-.63.99-1.18v-3.45c0-.54-.45-.99-.99-.99z"/>
                        </svg>
                    </div>
                    <div class="ls-contact-text" data-aos="fade-up">
                        <h4>Phone Numbers</h4>
                        <p>+256 777 461 759<br>+256 706 960 708</p>
                    </div>
                </div>
                
                <div class="ls-contact-hours" data-aos="fade-up">
                    <h4>Business Hours</h4>
                    <p>Monday - Friday: 8:00 AM - 6:00 PM<br>
                    Saturday: 9:00 AM - 4:00 PM<br>
                    Sunday: Closed</p>
                </div>
                
                <div class="ls-services-highlight" data-aos="fade-up">
                    <h4>Our Services</h4>
                    <div class="ls-service-tags" data-aos="fade-up">
                        <span class="ls-tag ls-construction" data-aos="fade-up">Civil Engineering</span>
                        <span class="ls-tag ls-water" data-aos="fade-up">Water Works</span>
                        <span class="ls-tag ls-supply" data-aos="fade-up">General Supplies</span>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Right Column - Contact Form -->
        <div class="ls-contact-form-col">
            <div class="ls-contact-form-card" data-aos="fade-left">
                <h3 class="ls-form-title" data-aos="fade-up">Send Us a Message</h3>
                <p class="ls-form-subtitle" data-aos="fade-up">Ready to discuss your project? Fill out the form below and our team will get back to you promptly.</p>
                
                <form id="ls-contact-form" method="post" class="ls-contact-form">
                    <div class="ls-form-group">
                        <label for="ls_contact_name" data-aos="fade-up">Full Name <span>*</span></label>
                        <input type="text" id="ls_contact_name" name="contact_name" required>
                    </div>
                    
                    <div class="ls-form-row">
                        <div class="ls-form-group ls-form-half">
                            <label for="ls_contact_email" data-aos="fade-up">Email Address <span>*</span></label>
                            <input type="email" id="ls_contact_email" name="contact_email" required>
                        </div>
                        <div class="ls-form-group ls-form-half">
                            <label for="ls_contact_phone" data-aos="fade-up">Phone Number</label>
                            <input type="tel" id="ls_contact_phone" name="contact_phone">
                        </div>
                    </div>
                    
                    <div class="ls-form-group">
                        <label for="ls_contact_subject" data-aos="fade-up">Subject <span>*</span></label>
                        <select id="ls_contact_subject" name="contact_subject" required>
                            <option value="" data-aos="fade-up">Select a service...</option>
                            <option value="Civil Engineering" data-aos="fade-up">Civil Engineering</option>
                            <option value="Water Works" data-aos="fade-up">Water Works</option>
                            <option value="General Supplies" data-aos="fade-up">General Supplies</option>
                            <option value="Project Consultation" data-aos="fade-up">Project Consultation</option>
                            <option value="Other" data-aos="fade-up">Other</option>
                        </select>
                    </div>
                    
                    <div class="ls-form-group">
                        <label for="ls_contact_message" data-aos="fade-up">Project Details <span>*</span></label>
                        <textarea id="ls_contact_message" name="contact_message" rows="6" placeholder="Tell us about your project requirements..." required></textarea>
                    </div>
                    
                    <div class="ls-form-submit">
                        <button type="submit" name="contact_submitted" style="display:inline-flex;align-items:center;padding:12px 24px;background:rgba(229,62,62,0.1);color:var(--ls-primary);border-radius:8px;font-weight:600;transition:all var(--ls-transition);text-decoration:none;border:2px solid transparent;cursor:pointer;font-family:var(--ls-font-primary);" onmouseover="this.style.background='var(--ls-primary)';this.style.color='var(--ls-white)';this.style.borderColor='var(--ls-primary)';this.style.transform='translateY(-2px)';" onmouseout="this.style.background='rgba(229,62,62,0.1)';this.style.color='var(--ls-primary)';this.style.borderColor='transparent';this.style.transform='translateY(0)';">
                            Submit Request
                            <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg" style="margin-left:8px;">
                                <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                            </svg>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>
    
    <!-- Map Section - Full Width Row -->
    <div class="ls-map-section">
        <div class="ls-contact-map-card">
            <div class="ls-map-header">
                <div class="ls-map-info">
                    <h3 class="ls-map-title" data-aos="fade-up">Visit Our Office</h3>
                    <div class="ls-company-highlight" data-aos="fade-up">
                        <h4>Liberty Scope Ltd</h4>
                        <p>Your trusted partner for innovative and sustainable solutions in civil engineering, water works, and general supplies across Uganda.</p>
                    </div>
                </div>
                <div class="ls-map-directions">
                    <a href="https://maps.google.com?daddr=Plot+32+Lumumba+Avenue+Kampala+Uganda" target="_blank" class="ls-directions-btn">
                        Get Directions
                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                            <path d="M5 12H19M19 12L12 5M19 12L12 19" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                        </svg>
                    </a>
                </div>
            </div>
            <div class="ls-map-container">
                <iframe src="https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d3989.756845934086!2d32.58263731475308!3d0.31539989978553544!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x177dbc0f8d4f3f85%3A0x8d4a3f4b5c7e8f9a!2sLumumba%20Avenue%2C%20Kampala%2C%20Uganda!5e0!3m2!1sen!2sus!4v1620000000000!5m2!1sen!2sus" 
                        width="100%" height="100%" style="border:0;" allowfullscreen="" loading="lazy"></iframe>
            </div>
        </div>
    </div>
</div>

</main>

<script>
jQuery(document).ready(function($) {
    // Show success popup if submission was successful
    <?php if (isset($submission_success) && $submission_success): ?>
        $('.ls-contact-success-popup').addClass('active');
    <?php endif; ?>
    
    // Close popup handler
    $('.ls-close-popup').on('click', function() {
        $('.ls-contact-success-popup').removeClass('active');
    });
});
</script>

<style>
    /*==========================================================
Liberty Scope Contact Page Styles
==========================================================*/

/* Hero Section */
.ls-hero-section {background:var(--gradient-hero);min-height:400px;display:flex;align-items:center;justify-content:center;position:relative;background-size:cover;background-position:center;background-attachment:fixed;}
.ls-hero-overlay {position:absolute;top:0;left:0;width:100%;height:100%;display:flex;align-items:center;justify-content:center;}
.ls-hero-content {text-align:center;color:var(--ls-white);max-width:800px;padding:0 var(--ls-space-md);}
.ls-hero-title {font-size:3.5rem;font-weight:800;margin-bottom:var(--ls-space-sm);text-shadow:2px 2px 4px rgba(0,0,0,0.3);}
.ls-hero-breadcrumb {font-size:1.1rem;opacity:0.9;text-transform:uppercase;letter-spacing:1px;}
.ls-hero-breadcrumb a {color:var(--ls-primary-light);text-decoration:none;transition:color var(--ls-transition);}
.ls-hero-breadcrumb a:hover {color:var(--ls-white);}
.curved-bottom {position:absolute;bottom:0;left:0;width:100%;height:80px;z-index:1;}

/* Main Container */
.ls-contact-container {max-width:1400px;margin:-90px auto 100px;padding:0 var(--ls-space-md);position:relative;z-index:2;}

/* Contact Layout - Two Columns */
.ls-contact-layout {display:grid;grid-template-columns:1fr 1fr;gap:var(--ls-space-lg);margin-top:50px;}
.ls-contact-info-col,.ls-contact-form-col {display:flex;flex-direction:column;}

/* Map Section - Full Width Row */
.ls-map-section {margin-top:var(--ls-space-xl);width:100%;}
.ls-map-header {display:flex;justify-content:space-between;align-items:flex-start;margin-bottom:var(--ls-space-md);flex-wrap:wrap;gap:var(--ls-space-md);}
.ls-map-info {flex:1;min-width:300px;}
.ls-map-directions {flex-shrink:0;}

/* Card Styles */
.ls-contact-info-card,.ls-contact-form-card,.ls-contact-map-card {background:var(--ls-white);border-radius:12px;box-shadow:var(--ls-shadow-lg);padding:var(--ls-space-lg);height:100%;border:1px solid var(--ls-light-grey);transition:transform var(--ls-transition);}
.ls-contact-info-card:hover,.ls-contact-form-card:hover,.ls-contact-map-card:hover {transform:translateY(-5px);}

/* Section Titles */
.ls-contact-info-title,.ls-form-title,.ls-map-title {font-family:var(--ls-font-heading);font-size:2rem;margin-bottom:var(--ls-space-md);position:relative;padding-bottom:15px;color:var(--ls-base);}
.ls-contact-info-title:after,.ls-form-title:after,.ls-map-title:after {content:'';position:absolute;bottom:0;left:0;width:60px;height:4px;background:var(--gradient-primary);border-radius:2px;}

/* Contact Info Items */
.ls-contact-info-item {display:flex;align-items:flex-start;margin-bottom:var(--ls-space-md);padding:var(--ls-space-sm);border-radius:8px;transition:background var(--ls-transition);}
.ls-contact-info-item:hover {background:var(--ls-bg-secondary);}
.ls-contact-icon {flex-shrink:0;width:60px;height:60px;background:var(--gradient-primary);border-radius:50%;display:flex;align-items:center;justify-content:center;margin-right:var(--ls-space-sm);box-shadow:var(--ls-shadow);}
.ls-contact-icon svg {width:28px;height:28px;}
.ls-contact-text h4 {font-size:1.2rem;margin-bottom:5px;color:var(--ls-base);font-family:var(--ls-font-heading);font-weight:600;}
.ls-contact-text p {margin:0;color:var(--ls-grey);line-height:1.6;font-weight:400;}

/* Contact Hours */
.ls-contact-hours {margin-top:var(--ls-space-lg);padding-top:var(--ls-space-md);border-top:2px solid var(--ls-light-grey);}
.ls-contact-hours h4 {font-size:1.2rem;margin-bottom:var(--ls-space-sm);color:var(--ls-base);font-family:var(--ls-font-heading);font-weight:600;}
.ls-contact-hours p {margin:0;color:var(--ls-grey);line-height:1.7;}

/* Services Highlight */
.ls-services-highlight {margin-top:var(--ls-space-lg);padding-top:var(--ls-space-md);border-top:2px solid var(--ls-light-grey);}
.ls-services-highlight h4 {font-size:1.2rem;margin-bottom:var(--ls-space-sm);color:var(--ls-base);font-family:var(--ls-font-heading);font-weight:600;}
.ls-service-tags {display:flex;flex-wrap:wrap;gap:10px;}
.ls-tag {display:inline-block;padding:8px 16px;border-radius:20px;font-size:0.85rem;font-weight:500;color:var(--ls-white);text-transform:uppercase;letter-spacing:0.5px;}
.ls-tag.ls-construction {background:var(--ls-construction-orange);}
.ls-tag.ls-water {background:var(--ls-water-blue);}
.ls-tag.ls-supply {background:var(--ls-supply-green);}

/* Form Styles */
.ls-form-subtitle {color:var(--ls-grey);margin-bottom:var(--ls-space-lg);font-size:1.1rem;line-height:1.6;}
.ls-form-group {margin-bottom:var(--ls-space-md);}
.ls-form-group label {display:block;margin-bottom:8px;font-weight:600;color:var(--ls-base);font-family:var(--ls-font-heading);}
.ls-form-group label span {color:var(--ls-primary);}
.ls-form-group input,.ls-form-group textarea,.ls-form-group select {width:100%;padding:15px 20px;border:2px solid var(--ls-light-grey);border-radius:8px;font-family:var(--ls-font-primary);font-size:1rem;transition:all var(--ls-transition);background:var(--ls-white);}
.ls-form-group input:focus,.ls-form-group textarea:focus,.ls-form-group select:focus {outline:none;border-color:var(--ls-primary);box-shadow:0 0 0 3px rgba(229,62,62,0.1);transform:translateY(-2px);}
.ls-form-row {display:flex;gap:var(--ls-space-md);}
.ls-form-half {flex:1;}
.ls-form-submit {margin-top:var(--ls-space-lg);}
.ls-submit-btn {display:inline-flex;align-items:center;justify-content:center;padding:15px 30px;background:var(--gradient-primary);color:var(--ls-white);border:none;border-radius:8px;font-weight:600;font-size:1.1rem;cursor:pointer;transition:all var(--ls-transition);text-transform:uppercase;letter-spacing:0.5px;box-shadow:var(--ls-shadow);}
.ls-submit-btn svg {margin-left:10px;transition:transform var(--ls-transition);}
.ls-submit-btn:hover {transform:translateY(-3px);box-shadow:var(--ls-shadow-lg);}
.ls-submit-btn:hover svg {transform:translateX(5px);}

/* Map Styles */
.ls-map-container {height:450px;border-radius:10px;overflow:hidden;box-shadow:var(--ls-shadow);}
.ls-map-container iframe {width:100%;height:100%;border:none;}
.ls-directions-btn {display:inline-flex;align-items:center;padding:12px 24px;background:rgba(229,62,62,0.1);color:var(--ls-primary);border-radius:8px;font-weight:600;transition:all var(--ls-transition);text-decoration:none;border:2px solid transparent;}
.ls-directions-btn svg {margin-left:8px;}
.ls-directions-btn:hover {background:var(--ls-primary);color:var(--ls-white);border-color:var(--ls-primary);transform:translateY(-2px);}

/* Company Highlight */
.ls-company-highlight h4 {font-size:1.2rem;margin-bottom:var(--ls-space-sm);color:var(--ls-primary);font-family:var(--ls-font-heading);font-weight:700;}
.ls-company-highlight p {margin:0;color:var(--ls-grey);line-height:1.6;font-style:italic;}

/* Success Popup */
.ls-contact-success-popup {position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(26,32,44,0.8);display:flex;align-items:center;justify-content:center;z-index:9999;opacity:0;visibility:hidden;transition:all var(--ls-transition);backdrop-filter:blur(5px);}
.ls-contact-success-popup.active {opacity:1;visibility:visible;}
.ls-success-content {background:var(--ls-white);padding:var(--ls-space-xl);border-radius:15px;text-align:center;max-width:450px;position:relative;transform:translateY(30px);transition:all var(--ls-transition);box-shadow:var(--ls-shadow-lg);}
.ls-contact-success-popup.active .ls-success-content {transform:translateY(0);}
.ls-checkmark {width:90px;height:90px;margin:0 auto var(--ls-space-md);}
.ls-checkmark svg {width:100%;height:100%;}
.ls-success-content h3 {font-size:1.8rem;margin-bottom:var(--ls-space-sm);color:var(--ls-primary);font-family:var(--ls-font-heading);}
.ls-success-content p {margin-bottom:var(--ls-space-lg);color:var(--ls-grey);line-height:1.6;}
.ls-close-popup {background:var(--gradient-primary);color:var(--ls-white);border:none;padding:12px 30px;border-radius:8px;cursor:pointer;transition:all var(--ls-transition);font-weight:600;text-transform:uppercase;letter-spacing:0.5px;}
.ls-close-popup:hover {transform:translateY(-2px);box-shadow:var(--ls-shadow);}

/* Responsive Design */
@media (max-width:1200px){.ls-contact-layout{grid-template-columns:1fr;gap:var(--ls-space-md);}.ls-map-header{flex-direction:column;align-items:flex-start;}}
@media (max-width:768px){.ls-hero-title{font-size:2.5rem;}.ls-form-row{flex-direction:column;gap:0;}.ls-service-tags{justify-content:center;}.ls-map-header{flex-direction:column;text-align:center;}.ls-map-info{text-align:left;}.curved-bottom{height:60px;}}
@media (max-width:480px){.ls-hero-section{padding:80px 0 120px;}.ls-contact-container{margin:-60px auto 50px;padding:0 var(--ls-space-sm);}.ls-contact-info-card,.ls-contact-form-card,.ls-contact-map-card{padding:var(--ls-space-md);}.ls-hero-title{font-size:2rem;}.ls-map-container{height:300px;}.curved-bottom{height:40px;}}-hero-title{font-size:2.5rem;}.ls-form-row{flex-direction:column;gap:0;}.ls-service-tags{justify-content:center;}}
@media (max-width:480px){.ls-hero-section{padding:80px 0 120px;}.ls-contact-container{margin:-60px auto 50px;padding:0 var(--ls-space-sm);}.ls-contact-info-card,.ls-contact-form-card,.ls-contact-map-card{padding:var(--ls-space-md);}.ls-hero-title{font-size:2rem;}}

</style>

<?php get_footer(); ?>