<?php 
get_header(); 
include get_template_directory() . '/inc/menus/menu.php'; 
?>

<main role="main">
    <?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' ); ?>
    
    <?php if (have_posts()): while (have_posts()) : the_post(); ?>
        
        <?php 
        // Check if post has 'projects' category
        if (has_category('projects')): 
            // Get WordPress custom fields
            $project_date = get_post_meta(get_the_ID(), 'project_date', true);
            $project_client = get_post_meta(get_the_ID(), 'client', true);
        ?>
        
            <!-- PROJECTS LAYOUT -->
            <div class="header-wrap1" style="background: linear-gradient(90deg, rgba(6, 6, 5, 0.8), rgba(12, 12, 12, 0.5)), url('<?php echo $backgroundImg[0]; ?>') no-repeat;background-size: cover;background-position: center center;">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12 entry-title" data-aos="fade-up">
                            <?php custom_breadcrumb(); ?>
                        </div>
                    </div>
                </div>
                
                <svg class="curved-bottom" viewBox="0 0 2100 150" preserveAspectRatio="none">
        <path d="M0,0 C700,180 1400,180 2100,0 L2100,150 L0,150 Z" fill="#ffffff"/>
    </svg>
            </div>
            
            
            
            <section>
                <div class="container page-content2 py-md-4 py-2">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-9" data-aos="fade-up">
                            <div class="post-content">
                                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                                    <!-- Project-specific content -->
                                    <div class="project-meta mb-4">
                                        <?php if ($project_date): ?>
                                            <p class="project-date"><strong>Project Date:</strong> <?php echo esc_html($project_date); ?></p>
                                        <?php endif; ?>
                                        <?php if ($project_client): ?>
                                            <p class="project-client"><strong>Client:</strong> <?php echo esc_html($project_client); ?></p>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <h1 class="entry-title"><?php the_title(); ?></h1>
                                    
                                    <?php the_content(); ?>
                                    
                                    <!-- Project-specific social sharing -->
                                    <div class="d-flex justify-content-center bd-highlight mb-1">
                                        <div class="bd-highlight p-1">
                                            <small class="text-muted">share this project</small>
                                        </div>
                                        <div class="bd-highlight p-1">
                                            <a class="btn btn-sm btn-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?= esc_url(get_permalink()); ?>" target="_blank" rel="noopener noreferrer" title="Facebook">
                                                <small>Share on <i class="bi bi-facebook"></i> </small>
                                            </a>
                                        </div>
                                        <div class="bd-highlight p-1">
                                            <a class="btn btn-sm btn-twitter" href="https://twitter.com/intent/tweet?url=<?= esc_url(get_permalink()); ?>&text=<?= the_title(); ?>" target="_blank" rel="noopener noreferrer" title="Twitter">
                                                <small> Share on <i class="bi bi-twitter-x"></i></small>
                                            </a>
                                        </div>
                                        <div class="bd-highlight p-1">
                                            <a class="btn btn-sm btn-whatsapp" href="whatsapp://send?text=Check out this project: <?= the_title(); ?> - <?= esc_url(get_permalink());?>" data-action="share/whatsapp/share" title="WhatsApp">
                                                <small><i class="bi bi-whatsapp"></i> WhatsApp</small>
                                            </a>
                                        </div>
                                    </div>
                                </article>
                            </div>
                        </div>
                        
                        <!-- SIDEBAR WITH RELATED PROJECTS -->
                        <div class="col-lg-3 col-md-3 col-sm-3">
                            <div class="about-side">
                                <h3>Related Projects</h3>
                                <?php
                                // Get related projects (other posts in 'projects' category)
                                $current_post_id = get_the_ID();
                                $projects_category = get_category_by_slug('projects');
                                
                                if ($projects_category) {
                                    $related_args = array(
                                        'category__in' => array($projects_category->term_id),
                                        'post__not_in' => array($current_post_id),
                                        'posts_per_page' => 5,
                                        'orderby' => 'date',
                                        'order' => 'DESC'
                                    );
                                    
                                    $related_projects = new WP_Query($related_args);
                                    
                                    if ($related_projects->have_posts()) {
                                        echo '<ul class="related-projects-list">';
                                        while ($related_projects->have_posts()) {
                                            $related_projects->the_post();
                                            echo '<li class="related-project-item">';
                                            echo '<a href="' . get_permalink() . '" class="d-block mb-2">';
                                            if (has_post_thumbnail()) {
                                                echo '<div class="related-project-thumb">';
                                                the_post_thumbnail('thumbnail', array('class' => 'img-fluid'));
                                                echo '</div>';
                                            }
                                            echo '<h6 class="related-project-title">' . get_the_title() . '</h6>';
                                            echo '<small class="text-muted">' . get_the_date('M j, Y') . '</small>';
                                            echo '</a>';
                                            echo '</li>';
                                        }
                                        echo '</ul>';
                                        wp_reset_postdata();
                                    } else {
                                        echo '<p>No other projects found.</p>';
                                    }
                                }
                                ?>
                            </div>
                        </div>
                    </div>
                    
                    <?php edit_post_link(); ?>
                </div>
            </section>
            
            <!-- PROJECT GALLERY AT THE BOTTOM -->
            <?php 
            // Get attached images for gallery
            $attachments = get_attached_media('image', get_the_ID());
            if ($attachments): ?>
            <section class="project-gallery-section bg-light py-5">
                <div class="container">
                    <div class="row">
                        <div class="col-12">
                            <h3 class="text-center mb-4">Project Gallery</h3>
                            <div class="project-gallery row">
                                <?php foreach ($attachments as $attachment): ?>
                                    <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                                        <div class="gallery-item">
                                            <a href="<?php echo wp_get_attachment_image_url($attachment->ID, 'large'); ?>" data-lightbox="project-gallery">
                                                <?php echo wp_get_attachment_image($attachment->ID, 'medium', false, array('class' => 'img-fluid rounded')); ?>
                                            </a>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </section>
            <?php endif; ?>
        
        <?php else: ?>
        
            <!-- BLOGS LAYOUT (Your original layout) -->
            <div class="header-wrap1" style="background: linear-gradient(90deg, rgba(6, 6, 5, 0.8), rgba(12, 12, 12, 0.5)), url('<?php echo $backgroundImg[0]; ?>') no-repeat;background-size: cover;background-position: center center;">
                <div class="container">
                    <div class="row">
                        <div class="col-lg-12 entry-title" data-aos="fade-up">
                            <?php custom_breadcrumb(); ?>
                        </div>
                    </div>
                </div>
                <svg class="curved-bottom" viewBox="0 0 2100 150" preserveAspectRatio="none">
        <path d="M0,0 C700,180 1400,180 2100,0 L2100,150 L0,150 Z" fill="#ffffff"/>
    </svg>
            </div>
            
            <section>
                <div class="container page-content2 py-md-4 py-2">
                    <div class="row">
                        <div class="col-lg-9 col-md-9 col-sm-9" data-aos="fade-up">
                            <div class="post-content">
                                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
                                    <!-- post thumbnail -->
                                    <div class="post-thumbnail">
                                        <?php if (has_post_thumbnail()): ?>
                                            <?php the_post_thumbnail(); ?>
                                        <?php endif; ?>
                                    </div>
                                    <!-- /post thumbnail -->
                                    
                                    <h1 class="entry-title"><?php the_title(); ?></h1>
                                    <p class="author date post-details"><?php the_time('F j, Y'); ?></p>
                                    
                                    <?php the_content(); ?>
                                    
                                    <!-- Blog-specific social sharing -->
                                    <div class="d-flex justify-content-center bd-highlight mb-1">
                                        <div class="bd-highlight p-1">
                                            <small class="text-muted">share this article</small>
                                        </div>
                                        <div class="bd-highlight p-1">
                                            <a class="btn btn-sm btn-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?= esc_url(get_permalink()); ?>" target="_blank" rel="noopener noreferrer" title="Facebook">
                                                <small>Share on <i class="bi bi-facebook"></i> </small>
                                            </a>
                                        </div>
                                        <div class="bd-highlight p-1">
                                            <a class="btn btn-sm btn-twitter" href="https://twitter.com/intent/tweet?url=<?= esc_url(get_permalink()); ?>&text=<?= the_title(); ?>" target="_blank" rel="noopener noreferrer" title="Twitter">
                                                <small> Share on <i class="bi bi-twitter-x"></i></small>
                                            </a>
                                        </div>
                                        <div class="bd-highlight p-1">
                                            <a class="btn btn-sm btn-whatsapp" href="whatsapp://send?text=Check out this article: <?= the_title(); ?> - <?= esc_url(get_permalink());?>" data-action="share/whatsapp/share" title="WhatsApp">
                                                <small><i class="bi bi-whatsapp"></i> WhatsApp</small>
                                            </a>
                                        </div>
                                    </div>
                                </article>
                            </div>
                        </div>
                        
                        <div class="col-lg-3 col-md-3 col-sm-3">
                            <div class="about-side">
                                <h3>Latest Stories</h3>
                                <?php include get_template_directory() . '/inc/related-news.php'; ?>
                            </div>
                        </div>
                    </div>
                    
                    <?php edit_post_link(); ?>
                </div>
            </section>
        
        <?php endif; ?>
        
    <?php endwhile; else: ?>
        
        <!-- article -->
        <article>
            <h2><?php _e( 'Sorry, nothing to display.', 'kipya' ); ?></h2>
        </article>
        <!-- /article -->
        
    <?php endif; ?>
</main>


<?php

// Get gallery images from WordPress metabox
$gallery_images = get_post_meta(get_the_ID(), 'gallery_images', true);

// If no metabox images, fallback to attached media
if (empty($gallery_images)) {
    $attachments = get_attached_media('image', get_the_ID());
    if ($attachments) {
        $gallery_images = array();
        foreach ($attachments as $attachment) {
            $gallery_images[] = array(
                'image' => wp_get_attachment_image_url($attachment->ID, 'large'),
                'thumbnail' => wp_get_attachment_image_url($attachment->ID, 'medium'),
                'title' => get_the_title($attachment->ID),
                'caption' => $attachment->post_excerpt
            );
        }
    }
}

// Check if we have images to display
if (!empty($gallery_images) && is_array($gallery_images)): 
    $is_project = has_category('projects');
    $gallery_title = $is_project ? 'Project Gallery' : 'Blog Gallery';
    $gallery_subtitle = $is_project ? 'Explore the visual journey of this project' : 'Visual highlights from this blog';
?>

<!-- ENHANCED GALLERY SECTION -->
<section class="ls-gallery-section">
    <div class="ls-gallery-container">
        <div class="row">
            <div class="col-12">
                <div class="ls-gallery-header" data-aos="fade-up">
                    <h2 class="ls-gallery-title"><?php echo esc_html($gallery_title); ?></h2>
                    <p class="ls-gallery-subtitle"><?php echo esc_html($gallery_subtitle); ?></p>
                </div>
                
                <div class="ls-gallery-grid" data-aos="fade-up" data-aos-delay="200">
                    <?php 
                    $image_count = 0;
                    foreach ($gallery_images as $index => $image): 
                        $image_count++;
                        
                        // Handle different image data structures
                        if (is_array($image)) {
                            $image_url = isset($image['image']) ? $image['image'] : (isset($image['url']) ? $image['url'] : '');
                            $thumbnail_url = isset($image['thumbnail']) ? $image['thumbnail'] : $image_url;
                            $image_title = isset($image['title']) ? $image['title'] : '';
                            $image_caption = isset($image['caption']) ? $image['caption'] : '';
                        } else {
                            // If it's just a URL string
                            $image_url = $image;
                            $thumbnail_url = $image;
                            $image_title = 'Gallery Image ' . $image_count;
                            $image_caption = '';
                        }
                        
                        if (empty($image_url)) continue;
                    ?>
                    
                    <div class="ls-gallery-item" data-aos="zoom-in" data-aos-delay="<?php echo ($index * 100) + 300; ?>">
                        <img src="<?php echo esc_url($thumbnail_url); ?>" 
                             alt="<?php echo esc_attr($image_title ? $image_title : 'Gallery image ' . ($index + 1)); ?>" 
                             class="ls-gallery-image"
                             loading="lazy">
                        
                        <div class="ls-gallery-overlay">
                            <div class="ls-gallery-icon">
                                <i class="bi bi-zoom-in" aria-hidden="true"></i>
                            </div>
                        </div>
                        
                        <?php if ($image_title || $image_caption): ?>
                        <div class="ls-gallery-caption">
                            <?php if ($image_title): ?>
                                <div class="ls-gallery-caption-title"><?php echo esc_html($image_title); ?></div>
                            <?php endif; ?>
                            <?php if ($image_caption): ?>
                                <div class="ls-gallery-caption-text"><?php echo esc_html($image_caption); ?></div>
                            <?php endif; ?>
                        </div>
                        <?php endif; ?>
                        
                        <!-- Lightbox trigger -->
                        <a href="<?php echo esc_url($image_url); ?>" 
                           class="ls-gallery-link" 
                           data-lightbox="gallery-<?php echo get_the_ID(); ?>"
                           data-title="<?php echo esc_attr($image_title); ?>"
                           style="position: absolute; top: 0; left: 0; width: 100%; height: 100%; z-index: 10;">
                           <span class="sr-only">View full size image</span>
                        </a>
                    </div>
                    
                    <?php endforeach; ?>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Enhanced Lightbox JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    const galleryLinks = document.querySelectorAll('.ls-gallery-link');
    
    // Simple lightbox functionality
    galleryLinks.forEach(link => {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            
            const imgUrl = this.getAttribute('href');
            const imgTitle = this.getAttribute('data-title') || '';
            
            // Create lightbox overlay
            const lightbox = document.createElement('div');
            lightbox.className = 'ls-lightbox-overlay';
            lightbox.innerHTML = `
                <div class="ls-lightbox-content">
                    <button class="ls-lightbox-close" aria-label="Close lightbox">&times;</button>
                    <img src="${imgUrl}" alt="${imgTitle}" class="ls-lightbox-image">
                    ${imgTitle ? `<div class="ls-lightbox-caption">${imgTitle}</div>` : ''}
                </div>
            `;
            
            // Add lightbox styles
            lightbox.style.cssText = `
                position: fixed; top: 0; left: 0; width: 100%; height: 100%; 
                background: rgba(0, 0, 0, 0.9); display: flex; align-items: center; 
                justify-content: center; z-index: 9999; opacity: 0; 
                transition: opacity 0.3s ease;
            `;
            
            const content = lightbox.querySelector('.ls-lightbox-content');
            content.style.cssText = `
                position: relative; max-width: 90%; max-height: 90%; 
                display: flex; flex-direction: column; align-items: center;
            `;
            
            const closeBtn = lightbox.querySelector('.ls-lightbox-close');
            closeBtn.style.cssText = `
                position: absolute; top: -40px; right: 0; background: none; 
                border: none; color: white; font-size: 30px; cursor: pointer; 
                z-index: 10000; width: 40px; height: 40px; display: flex; 
                align-items: center; justify-content: center;
            `;
            
            const img = lightbox.querySelector('.ls-lightbox-image');
            img.style.cssText = `
                max-width: 100%; max-height: calc(100vh - 100px); 
                object-fit: contain; border-radius: 8px;
            `;
            
            const caption = lightbox.querySelector('.ls-lightbox-caption');
            if (caption) {
                caption.style.cssText = `
                    color: white; text-align: center; margin-top: 20px; 
                    font-size: 16px; max-width: 600px;
                `;
            }
            
            document.body.appendChild(lightbox);
            document.body.style.overflow = 'hidden';
            
            // Fade in
            setTimeout(() => lightbox.style.opacity = '1', 10);
            
            // Close functionality
            const closeLightbox = () => {
                lightbox.style.opacity = '0';
                setTimeout(() => {
                    if (lightbox.parentNode) {
                        document.body.removeChild(lightbox);
                        document.body.style.overflow = '';
                    }
                }, 300);
            };
            
            closeBtn.addEventListener('click', closeLightbox);
            lightbox.addEventListener('click', function(e) {
                if (e.target === lightbox) closeLightbox();
            });
            
            // ESC key support
            const handleEsc = (e) => {
                if (e.key === 'Escape') {
                    closeLightbox();
                    document.removeEventListener('keydown', handleEsc);
                }
            };
            document.addEventListener('keydown', handleEsc);
        });
    });
});
</script>

<?php endif; ?>

<?php get_footer(); ?>