<?php
/**
 * Template Name: Single Group
 * Template Post Type: group
 */
 include get_template_directory() . '/inc/menus/menu.php'; 
get_header(); ?>
<!-- Enqueue GLightbox manually if not already added -->
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/glightbox/dist/css/glightbox.min.css">


<main role="main">

<?php $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>

<div>
    <?php while (have_posts()) : the_post(); 
        $location      = get_post_meta(get_the_ID(), '_rohi_group_location', true);
        $contact       = get_post_meta(get_the_ID(), '_rohi_group_contact', true);
        $meeting_times = get_post_meta(get_the_ID(), '_rohi_group_meeting_times', true);
    ?>
    
    <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
        <section>
            <div class="header-wrap1" 
                style="background: linear-gradient(90deg, rgba(6, 6, 5, 0.8), rgba(12, 12, 12, 0.5)), 
                       url('<?php echo esc_url($backgroundImg[0]); ?>') no-repeat;
                       background-size: cover;
                       background-position: center center;">
                
                <div class="container">
                     <div class="row">
                        <div class="col-lg-12 entry-title" data-aos="fade-up">
                            <h1><?php the_title(); ?></h1>
                            <?php custom_breadcrumb(); ?>
                        </div>
                    </div>
                </div><!-- .container -->
            </div><!-- .header-wrap1 -->
        </section>


        <div class="rohi-single-group-container">
        <div class="rohi-single-group-content">
            <div class="rohi-group-details">
                <div class="rohi-group-description">
                    <?php the_content(); ?>
                </div>
                
                <div class="rohi-join-section">
                    <h2>Join This Group</h2>
                    <p>Interested in joining our community? Fill out the form below and we'll get in touch with you shortly.</p>
                    
                    <form id="rohi-group-join-form" class="rohi-join-form">
                        <?php wp_nonce_field('rohi_group_details_nonce', 'rohi_group_join_nonce'); ?>
                        <input type="hidden" name="group_id" value="<?php the_ID(); ?>">
                        <input type="hidden" name="group_title" value="<?php the_title_attribute(); ?>">
                        
                        <div class="rohi-form-row">
                          <div class="rohi-form-group">
                            <label for="name">Full Name *</label>
                            <input type="text" id="name" name="name" required>
                          </div>
                          <div class="rohi-form-group">
                            <label for="location">Your Location *</label>
                            <input type="text" id="location" name="location" required>
                          </div>
                          <div class="rohi-form-group">
                            <label for="phone">Phone Number *</label>
                            <input type="tel" id="phone" name="phone" required>
                          </div>
                        </div>
                        
                        
                        <div class="rohi-form-submit">
                            <button type="submit" class="rohi-submit-button">Submit Request</button>
                        </div>
                        
                        <div id="rohi-form-message"></div>
                    </form>
                </div>
            </div>
            
            <div class="rohi-group-sidebar">
                <div class="rohi-group-info-card">
                    <h3>Group Information</h3>
                    <div class="rohi-info-list">
                        <?php if ($location) : ?>
                            <div class="rohi-info-item">
                                <i class="fas fa-map-marker-alt"></i>
                                <div>
                                    <strong>Location</strong>
                                    <span><?php echo esc_html($location); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($contact) : ?>
                            <div class="rohi-info-item">
                                <i class="fas fa-phone"></i>
                                <div>
                                    <strong>Contact</strong>
                                    <span><?php echo esc_html($contact); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($meeting_times) : ?>
                            <div class="rohi-info-item">
                                <i class="fas fa-clock"></i>
                                <div>
                                    <strong>Meeting Times</strong>
                                    <span><?php echo esc_html($meeting_times); ?></span>
                                </div>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                
                <div class="rohi-other-groups">
                    <h3>Other Groups</h3>
                    <?php
                    $other_groups = new WP_Query(array(
                        'post_type' => 'group',
                        'posts_per_page' => 3,
                        'post__not_in' => array(get_the_ID()),
                        'orderby' => 'rand'
                    ));
                    
                    if ($other_groups->have_posts()) :
                        while ($other_groups->have_posts()) : $other_groups->the_post();
                            $other_location = get_post_meta(get_the_ID(), '_rohi_group_location', true);
                            ?>
                            <div class="rohi-other-group-item">
                                <a href="<?php the_permalink(); ?>">
                                    <?php if (has_post_thumbnail()) : ?>
                                        <div class="rohi-other-group-thumb">
                                            <?php the_post_thumbnail('thumbnail'); ?>
                                        </div>
                                    <?php endif; ?>
                                    <div class="rohi-other-group-info">
                                        <h4><?php the_title(); ?></h4>
                                        <?php if ($other_location) : ?>
                                            <span><i class="fas fa-map-marker-alt"></i> <?php echo esc_html($other_location); ?></span>
                                        <?php endif; ?>
                                    </div>
                                </a>
                            </div>
                        <?php endwhile;
                        wp_reset_postdata();
                    else : ?>
                        <p>No other groups available at the moment.</p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
        </div>
    </article>
    
    <?php endwhile; ?>
    <main></main>
</div>



<script>
jQuery(document).ready(function($) {
    $('#rohi-group-join-form').on('submit', function(e) {
        e.preventDefault();
        
        var form = $(this);
        var formData = new FormData(form[0]);
        var messageContainer = $('#rohi-form-message');
        
        // Add AJAX action
        formData.append('action', 'rohi_submit_group_join_request');
        
        $.ajax({
            url: '<?php echo admin_url('admin-ajax.php'); ?>',
            type: 'POST',
            data: formData,
            processData: false,
            contentType: false,
            dataType: 'json',
            beforeSend: function() {
                $('.rohi-submit-button').text('Submitting...').prop('disabled', true);
                messageContainer.hide().removeClass('success error');
            },
            success: function(response) {
                if (response.success) {
                    messageContainer.html(response.message || 'Thank you! Your request has been submitted.').addClass('success').show();
                    form[0].reset();
                } else {
                    messageContainer.html(response.message || 'An error occurred. Please try again.').addClass('error').show();
                }
            },
            error: function(xhr, status, error) {
                messageContainer.html('Error: ' + error).addClass('error').show();
            },
            complete: function() {
                $('.rohi-submit-button').text('Submit Request').prop('disabled', false);
                
                // Scroll to message
                $('html, body').animate({
                    scrollTop: messageContainer.offset().top - 100
                }, 500);
            }
        });
    });
});
</script>

<?php get_footer(); ?>