<?php
/**
 * Template Name: Service Detail Template
 */

get_header();
include get_template_directory() . '/inc/menus/menu.php'; 

// Get the current service post
global $post;

// Get all meta values
$hero_title = get_post_meta($post->ID, '_service_hero_title', true);
$hero_subtitle = get_post_meta($post->ID, '_service_hero_subtitle', true);
$hero_description = get_post_meta($post->ID, '_service_hero_description', true);
$hero_stats_projects = get_post_meta($post->ID, '_service_stats_projects', true);
$hero_stats_success = get_post_meta($post->ID, '_service_stats_success', true);
$hero_stats_years = get_post_meta($post->ID, '_service_stats_years', true);
$hero_image = get_post_meta($post->ID, '_service_hero_image', true);

$services = array();
for ($i = 1; $i <= 3; $i++) {
    $services[] = array(
        'title' => get_post_meta($post->ID, '_service_' . $i . '_title', true),
        'description' => get_post_meta($post->ID, '_service_' . $i . '_description', true),
        'list_1' => get_post_meta($post->ID, '_service_' . $i . '_list_1', true),
        'list_2' => get_post_meta($post->ID, '_service_' . $i . '_list_2', true),
        'list_3' => get_post_meta($post->ID, '_service_' . $i . '_list_3', true),
        'icon' => get_post_meta($post->ID, '_service_' . $i . '_icon', true)
    );
}

$process_steps = array();
for ($i = 1; $i <= 4; $i++) {
    $process_steps[] = array(
        'title' => get_post_meta($post->ID, '_process_' . $i . '_title', true),
        'description' => get_post_meta($post->ID, '_process_' . $i . '_description', true)
    );
}

// Default values if empty
if (empty($hero_title)) $hero_title = 'Professional Service Solutions';
if (empty($hero_subtitle)) $hero_subtitle = 'Expert services for all your needs';
?>

<main role="main">
    <?php
    $backgroundImg = wp_get_attachment_image_src(
      get_post_thumbnail_id( $post->ID ),
      'full'
    );
    ?>
    <section class="hero-section" style="height:350px; position:relative;">
      <?php if ( $backgroundImg ): ?>
        <div class="hero-bg-image" style="background-image:url('<?php echo esc_url( $backgroundImg[0] ); ?>');"></div>
      <?php endif; ?>
      <div class="hero-overlay">
        <div class="hero-content">
          <?php
          // Display custom breadcrumb first
            if ( function_exists('custom_breadcrumb') ) {
              custom_breadcrumb();
            }
          ?>
        </div>
      </div>
      <!-- SVG curved bottom -->
      <svg class="curved-bottom" viewBox="0 0 2100 150" preserveAspectRatio="none">
        <path d="M0,0 C700,180 1400,180 2100,0 L2100,150 L0,150 Z" fill="#ffffff" />
      </svg>
    </section>

    <!-- Service Hero Section -->
    <section class="service-hero-section">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-lg-6">
                    <h1 class="service-hero-title"><?php echo esc_html($hero_title); ?></h1>
                    <p class="service-hero-subtitle"><?php echo esc_html($hero_subtitle); ?></p>
                    <p class="service-hero-description"><?php echo esc_html($hero_description); ?></p>
                    
                    <div class="service-hero-stats">
                        <div class="service-stat">
                            <span class="service-stat-number"><?php echo esc_html($hero_stats_projects); ?>+</span>
                            <span class="service-stat-label">Projects Completed</span>
                        </div>
                        <div class="service-stat">
                            <span class="service-stat-number"><?php echo esc_html($hero_stats_success); ?>%</span>
                            <span class="service-stat-label">Success Rate</span>
                        </div>
                        <div class="service-stat">
                            <span class="service-stat-number"><?php echo esc_html($hero_stats_years); ?>+</span>
                            <span class="service-stat-label">Years Experience</span>
                        </div>
                    </div>
                    
                    <div class="service-hero-actions">
                        <a href="https://lwegatech.net/liberty-scope/contact/" class="btn btn-danger">Get Free Quote</a>
                        <a href="https://lwegatech.net/liberty-scope/services/" class="btn btn-outline-danger ms-3">Our Services</a>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="service-hero-image">
                        <?php if ($hero_image) : ?>
                            <img src="<?php echo esc_url($hero_image); ?>" alt="<?php echo esc_attr($hero_title); ?>" class="img-fluid rounded shadow-lg">
                        <?php else : ?>
                            <div class="service-image-placeholder rounded shadow-lg"></div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Services Section -->
    <section id="services" class="service-services-section">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-lg-8 mx-auto">
                    <h2 class="service-section-title">Our Service Offerings</h2>
                    <p class="service-section-subtitle">Comprehensive solutions for all your needs</p>
                </div>
            </div>
            <div class="row g-4">
                <?php foreach ($services as $index => $service) : ?>
                    <?php if (!empty($service['title'])) : ?>
                        <div class="col-md-6 col-lg-4">
                            <div class="card service-card h-100 shadow-ls">
                                <div class="card-body text-center p-4">
                                    <div class="service-icon bg-water-light rounded-circle d-inline-flex align-items-center justify-content-center p-4 mb-4">
                                        <i class="<?php echo esc_attr($service['icon']); ?> fa-3x text-water"></i>
                                    </div>
                                    <h4 class="mb-3"><?php echo esc_html($service['title']); ?></h4>
                                    <p class="text-muted"><?php echo esc_html($service['description']); ?></p>
                                    <ul class="list-unstyled text-start">
                                        <?php if (!empty($service['list_1'])) : ?>
                                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i><?php echo esc_html($service['list_1']); ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($service['list_2'])) : ?>
                                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i><?php echo esc_html($service['list_2']); ?></li>
                                        <?php endif; ?>
                                        <?php if (!empty($service['list_3'])) : ?>
                                            <li class="mb-2"><i class="fas fa-check text-success me-2"></i><?php echo esc_html($service['list_3']); ?></li>
                                        <?php endif; ?>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

    <!-- Process Section -->
    <section class="service-process-section">
        <div class="container">
            <div class="row text-center mb-5">
                <div class="col-lg-8 mx-auto">
                    <h2 class="service-section-title">Our Process</h2>
                    <p class="service-section-subtitle">How we deliver quality services</p>
                </div>
            </div>
            <div class="row g-4">
                <?php foreach ($process_steps as $index => $step) : ?>
                    <?php if (!empty($step['title'])) : ?>
                        <div class="col-md-6 col-lg-3">
                            <div class="text-center">
                                <div class="service-step-number mx-auto"><?php echo $index + 1; ?></div>
                                <h4 class="mb-3"><?php echo esc_html($step['title']); ?></h4>
                                <p class="text-muted"><?php echo esc_html($step['description']); ?></p>
                            </div>
                        </div>
                    <?php endif; ?>
                <?php endforeach; ?>
            </div>
        </div>
    </section>

</main>

<?php get_footer(); ?>