<?php
get_header();
include get_template_directory() . '/inc/menus/menu.php';
?>
<main role="main">
  <?php
    $backgroundImg = wp_get_attachment_image_src(
      get_post_thumbnail_id( $post->ID ),
      'full'
    );
  ?>
  <section
    class="hero-section"
    style="height:350px; position:relative;"
  >
    <?php if ( $backgroundImg ): ?>
      <div
        class="hero-bg-image"
        style="background-image:url('<?php echo esc_url( $backgroundImg[0] ); ?>');"
      ></div>
    <?php endif; ?>
    <div class="hero-overlay">
      <div class="hero-content">
        <?php
        // Display custom breadcrumb first
          if ( function_exists('custom_breadcrumb') ) {
            custom_breadcrumb();
          }
        ?>
      </div>
    </div>
    <!-- SVG curved bottom -->
    <svg
      class="curved-bottom"
      viewBox="0 0 2100 150"
      preserveAspectRatio="none"
    >
      <path
        d="M0,0 C700,180 1400,180 2100,0 L2100,150 L0,150 Z"
        fill="#ffffff"
      />
    </svg>
  </section>
  <?php if ( have_posts() ) : while ( have_posts() ) : the_post(); ?>
    <article
      id="post-<?php the_ID(); ?>"
      <?php post_class(); ?>
    >
      <?php the_content(); ?>
      <div class="floating-circles">
        <span></span><span></span><span></span><span></span><span></span>
      </div>
    </article>
  <?php endwhile; endif; ?>
</main>
<?php get_footer(); ?>