<section class="main-slider">
    <?php
    $slider_query = new WP_Query([
        'post_type'      => 'slides',
        'posts_per_page' => -1
    ]);
    ?>
    <div class="swiper-container thm-swiper__slider" data-swiper-options='{
        "slidesPerView": 1,
        "loop": true,
        "effect": "fade",
        "pagination": {
            "el": "#main-slider-pagination",
            "type": "bullets",
            "clickable": true
        },
        "navigation": {
            "nextEl": "#main-slider__swiper-button-next",
            "prevEl": "#main-slider__swiper-button-prev"
        },
        "autoplay": {
            "delay": 5000
        }
    }'>
        <div class="swiper-wrapper">
            <?php if ($slider_query->have_posts()): ?>
                <?php while ($slider_query->have_posts()): $slider_query->the_post();
                    $title        = get_the_title();
                    $description  = get_the_excerpt();
                    $url          = get_post_meta(get_the_ID(), 'slide_url', true);
                    $backgroundImg = get_the_post_thumbnail_url(get_the_ID(), 'full');
                ?>
                    <div class="swiper-slide">
                        <div class="image-layer" style="background-image: url('<?= esc_url($backgroundImg); ?>');"></div>
                        <div class="slider-overlay"></div>
                        <div class="container">
                            <div class="row">
                                <div class="col-xl-12">
                                    <div class="main-slider-content">
                                        <div class="main-slider-content__inner">
                                            <div class="big-title">
                                                <h2><?= esc_html($title) ?></h2>
                                            </div>
                                            <div class="text">
                                                <p><?= esc_html($description) ?></p>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <!-- Buttons positioned at center bottom -->
                        <div class="bottom-buttons-container">
                            <div class="hero-buttons">
                                <a href="<?= home_url('https://lwegatech.net/liberty-scope/services/'); ?>" class="buttons buttons-learn-more">Learn More</a>
                                <a href="<?= home_url('https://lwegatech.net/liberty-scope/contact/'); ?>" class="buttons buttons-get-quote">Get a Quote</a>
                            </div>
                        </div>
                        <!-- SVG curved bottom -->
                        <svg class="curved-bottom" viewBox="0 0 2100 150" preserveAspectRatio="none">
                            <path d="M0,0 C700,180 1400,180 2100,0 L2100,150 L0,150 Z" fill="#ffffff"/>
                        </svg>
                    </div>
                <?php endwhile; ?>
            <?php endif; ?>
        </div>
    </div>
    <?php wp_reset_postdata(); ?>
</section>