<!-- Main Header Section -->
<section class="header-section">
<?php
// Custom Walker Class for mega dropdown navigation with grandchildren support
class Mega_Menu_Walker extends Walker_Nav_Menu {
    private $has_grandchildren = false;
    
    function start_lvl(&$output, $depth = 0, $args = null) {
        if ($depth == 0) {
            // Determine if this should be a mega menu or simple dropdown
            if ($this->has_grandchildren) {
                $output .= '<div class="mega-menu"><div class="mega-menu-content">';
            } else {
                $output .= '<ul class="simple-dropdown">';
            }
        } else {
            $output .= '<ul class="sub-menu">';
        }
    }
    
    function end_lvl(&$output, $depth = 0, $args = null) {
        if ($depth == 0) {
            if ($this->has_grandchildren) {
                $output .= '</div></div>';
            } else {
                $output .= '</ul>';
            }
            $this->has_grandchildren = false; // Reset for next menu item
        } else {
            $output .= '</ul>';
        }
    }
    
    function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
        $classes = empty($item->classes) ? array() : (array) $item->classes;
        $classes[] = 'menu-item-' . $item->ID;
        
        // Check if item has children
        $has_children = in_array('menu-item-has-children', $classes);
        
        // For top-level items, check if any children have children (grandchildren)
        if ($depth == 0 && $has_children) {
            $this->has_grandchildren = $this->check_for_grandchildren($item->ID);
            if ($this->has_grandchildren) {
                $classes[] = 'has-mega-menu';
            } else {
                $classes[] = 'has-simple-dropdown';
            }
        }
        
        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
        $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
        
        if ($depth == 0) {
            $output .= '<li' . $class_names . '>';
        } elseif ($depth == 1 && $this->has_grandchildren) {
            // This is a category in mega menu
            $output .= '<div class="mega-menu-column"><div class="mega-menu-category">';
        } else {
            $output .= '<li' . $class_names . '>';
        }
        
        $atts = array();
        $atts['title']  = !empty($item->attr_title) ? $item->attr_title : '';
        $atts['target'] = !empty($item->target) ? $item->target : '';
        $atts['rel']    = !empty($item->xfn) ? $item->xfn : '';
        $atts['href']   = !empty($item->url) ? $item->url : '';
        
        if ($depth == 0) {
            $atts['class'] = 'nav-link' . ($has_children ? ' dropdown-toggle' : '');
            if ($has_children) {
              $atts['class'] .= ' dropdown-toggle';
            }
        }
        
        $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args, $depth);
        
        $attributes = '';
        foreach ($atts as $attr => $value) {
            if (!empty($value)) {
                $value = ('href' === $attr) ? esc_url($value) : esc_attr($value);
                $attributes .= ' ' . $attr . '="' . $value . '"';
            }
        }
        
        $item_output = $args->before;
        $item_output .= '<a' . $attributes . '>';
        $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
        if ($depth == 0 && $has_children) {
            $item_output .= ' <i class=""></i>';
        }
        $item_output .= '</a>';
        $item_output .= $args->after;
        
        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    }
    
    function end_el(&$output, $item, $depth = 0, $args = null) {
        if ($depth == 0) {
            $output .= '</li>';
        } elseif ($depth == 1 && $this->has_grandchildren) {
            $output .= '</div></div>';
        } else {
            $output .= '</li>';
        }
    }
    
    // Helper function to check if a menu item has grandchildren
    private function check_for_grandchildren($parent_id) {
        $menu_items = wp_get_nav_menu_items(get_nav_menu_locations()['primary']);
        if (!$menu_items) return false;
        
        $children = array();
        foreach ($menu_items as $item) {
            if ($item->menu_item_parent == $parent_id) {
                $children[] = $item->ID;
            }
        }
        
        foreach ($children as $child_id) {
            foreach ($menu_items as $item) {
                if ($item->menu_item_parent == $child_id) {
                    return true; // Found a grandchild
                }
            }
        }
        
        return false;
    }
}

// Sidebar Walker Class
class Sidebar_Menu_Walker extends Walker_Nav_Menu {
  function start_lvl(&$output, $depth = 0, $args = null) {
    $output .= '<ul class="dropdown-menu show">';
  }
  
  function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
    $classes = empty($item->classes) ? array() : (array) $item->classes;
    $classes[] = 'menu-item-' . $item->ID;
    
    if ($args->walker->has_children) {
      $classes[] = 'menu-item-has-children';
    }
    
   $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
$class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
    
    $output .= '<li' . $class_names . '>';
    
    $atts = array();
    $atts['title']  = !empty($item->attr_title) ? $item->attr_title : '';
    $atts['target'] = !empty($item->target)     ? $item->target     : '';
    $atts['rel']    = !empty($item->xfn)        ? $item->xfn        : '';
    $atts['href']   = !empty($item->url)        ? $item->url        : '';
    $atts['class']  = 'nav-link';
    
    $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args, $depth);
    
    $attributes = '';
    foreach ($atts as $attr => $value) {
      if (!empty($value)) {
        $value = ('href' === $attr) ? esc_url($value) : esc_attr($value);
        $attributes .= ' ' . $attr . '="' . $value . '"';
      }
    }
    
    $item_output = $args->before;
    $item_output .= '<a' . $attributes . '>';
    $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
    $item_output .= '</a>';
    $item_output .= $args->after;
    
    $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
  }
}

// Mobile Walker Class
class Mobile_Menu_Walker extends Walker_Nav_Menu {
    function start_lvl(&$output, $depth = 0, $args = null) {
        $output .= '<ul class="mobile-submenu">';
    }
    
    function end_lvl(&$output, $depth = 0, $args = null) {
        $output .= '</ul>';
    }
    
    function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
        $classes = empty($item->classes) ? array() : (array) $item->classes;
        $classes[] = 'menu-item-' . $item->ID;
        
        $has_children = in_array('menu-item-has-children', $classes);
        if ($has_children) {
            $classes[] = 'has-children';
        }
        
        $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
        $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
        
        $output .= '<li' . $class_names . '>';
        
        $atts = array();
        $atts['title'] = !empty($item->attr_title) ? $item->attr_title : '';
        $atts['target'] = !empty($item->target) ? $item->target : '';
        $atts['rel'] = !empty($item->xfn) ? $item->xfn : '';
        $atts['href'] = !empty($item->url) ? $item->url : '';
        $atts['class'] = 'mobile-nav-link';
        
        $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args, $depth);
        
        $attributes = '';
        foreach ($atts as $attr => $value) {
            if (!empty($value)) {
                $value = ('href' === $attr) ? esc_url($value) : esc_attr($value);
                $attributes .= ' ' . $attr . '="' . $value . '"';
            }
        }
        
        $item_output = $args->before;
        $item_output .= '<a' . $attributes . '>';
        $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
        if ($has_children) {
            $item_output .= ' <i class="bi bi-chevron-down mobile-dropdown-arrow"></i>';
        }
        $item_output .= '</a>';
        $item_output .= $args->after;
        
        $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
    }
}
?>
<?php wp_head(); ?>

<body <?php body_class(); ?>>

<!-- Main Header -->
<header class="main-header py-3" id="mainHeader">
  <div class="container-fluid px-0">
    <div class="d-flex align-items-center justify-content-between">
      <!-- Logo - Left Side (Transparent) -->
      <div class="header-logo-section">
        <div class="header-logo">
          <?php
            $custom_logo_id = get_theme_mod('custom_logo');
            $logo = wp_get_attachment_image_src($custom_logo_id, 'full');
            if ($logo) {
              echo '<a href="' . esc_url(home_url('/')) . '"><img src="' . esc_url($logo[0]) . '" alt="' . get_bloginfo('name') . '" class="logo-img"></a>';
            } else {
              echo '<a href="' . esc_url(home_url('/')) . '" class="text-decoration-none">';
              echo '<span class="logo-text fw-bold fs-3">' . get_bloginfo('name') . '</span>';
              echo '</a>';
            }
          ?>
        </div>
      </div>

      <!-- Center Navigation Menu (White Background) -->
      <div class="header-nav-section">
        <nav class="header-nav d-none d-lg-block">
          <?php
            wp_nav_menu(array(
              'theme_location' => 'primary',
              'container' => false,
              'menu_class' => 'nav header-menu d-flex align-items-center',
              'fallback_cb' => '__return_false',
              'depth' => 4,
              'walker' => new Mega_Menu_Walker()
            ));
          ?>
        </nav>
      </div>

      <!-- Right Side Actions (Transparent) -->
      <div class="header-actions-section">
        <div class="header-actions d-flex align-items-center">
          <!-- Search Toggle -->
          <button class="search-toggle me-3" id="searchToggle">
            <i class="bi bi-search"></i>
          </button>

          <!-- Mobile Nav Toggle (NEW - Only visible on mobile) -->
          <button class="mobile-nav-toggle me-3 d-lg-none" id="mobileNavToggle">
            <div class="bi bi-grid">
              <span></span>
              <span></span>
              <span></span>
              <span></span>
            </div>
          </button>

          <!-- Sidebar Menu Toggle -->
          <button class="sidebar-menu-toggle" id="sidebarMenuToggle">
            <i class="bi bi-list"></i>
          </button>
        </div>
      </div>
    </div>

    <!-- Search Bar (Hidden by default) -->
    <div class="header-search-bar" id="headerSearchBar">
      <div class="row justify-content-center mt-3">
        <div class="col-md-6">
          <div class="input-group">
            <input type="search" id="header-search-input" placeholder="Search..." class="form-control">
            <button type="submit" class="btn btn-primary">
              <i class="bi bi-search"></i>
            </button>
          </div>
          <div id="header-search-results"></div>
        </div>
      </div>
    </div>
  </div>
</header>

<!-- Mobile Navigation Menu -->
<div class="mobile-nav-menu" id="mobileNavMenu">
    <div class="mobile-nav-header">
        <h5 class="mobile-nav-title">Liberty Scope Menu</h5>
        <button class="mobile-nav-close" id="mobileNavClose">
            <i class="bi bi-x-lg"></i>
        </button>
    </div>
    
    <nav class="mobile-nav-content">
        <?php
        wp_nav_menu(array(
            'theme_location' => 'primary',
            'container' => false,
            'menu_class' => 'mobile-nav-list',
            'fallback_cb' => '__return_false',
            'depth' => 3,
            'walker' => new Mobile_Menu_Walker()
        ));
        ?>
    </nav>
</div>

<!-- Mobile Navigation Overlay -->
<div class="mobile-nav-overlay" id="mobileNavOverlay"></div>

<!-- Sidebar Menu (Simplified with Contact & Socials) -->
<div class="sidebar-menu" id="sidebarMenu">
    <button class="close-btn" id="sidebarMenuClose">
        <i class="bi bi-x-lg"></i>
    </button>
    
    <!-- Social Media (First) -->
    <div class="sidebar-social mb-4">
        <h5 class="text-white mb-3">Follow Us</h5>
        <div class="d-flex justify-content-center gap-3">
            <?php 
            $social_links = array(
                'twitter' => 'https://x.com/Liberty_Scope?s=09',
                'youtube' => '#',
                'linkedin' => 'http://www.linkedin.com/in/liberty-scope-2421b3387'
            );
            
            foreach ($social_links as $platform => $url) {
                echo '<a href="'.esc_url($url).'" class="social-icon">';
                echo '<i class="bi bi-'.$platform.'"></i>';
                echo '</a>';
            }
            ?>
        </div>
    </div>

<!-- Contact Information (Second) -->
<div class="sidebar-contact mb-4">
    <h5 class="text-white mb-3">Contact Us</h5>
    
    <!-- Three Column Layout -->
    <div style="display: flex; justify-content: space-between; gap: 20px; flex-wrap: wrap;">
        
        <!-- Phone Column -->
        <div class="contact-item" style="flex: 1; min-width: 180px;">
            <i class="bi bi-telephone-fill text-primary me-2"></i>
            <div>
                <span class="text-white-75 d-block" style="font-size: 12px; opacity: 0.8;">Call us any time</span>
                <a href="tel:+256777461759" class="text-white-75 text-decoration-none">+256 777461759/706960708</a>
            </div>
        </div>
        
        <!-- Location Column -->
        <div class="contact-item" style="flex: 1; min-width: 200px;">
            <i class="bi bi-geo-alt-fill text-primary me-2"></i>
            <div>
                <span class="text-white-75 d-block" style="font-size: 12px; opacity: 0.8;">Company Location</span>
                <div>
                    <span class="text-white-75 d-block">Plot 32, Lumumba Avenue</span>
                    <span class="text-white-75 d-block">Padre Pio House, 5th Floor</span>
                    <span class="text-white-75 d-block">P. O. Box 108841, Kampala-Uganda</span>
                </div>
            </div>
        </div>
        
        <!-- Email Column -->
        <div class="contact-item" style="flex: 1; min-width: 180px;">
            <i class="bi bi-envelope-fill text-primary me-2"></i>
            <div>
                <span class="text-white-75 d-block" style="font-size: 12px; opacity: 0.8;">Your Email</span>
                <a href="mailto:info@libertyscope.co.ug" class="text-white-75 text-decoration-none">info@libertyscope.co.ug</a>
            </div>
        </div>
        
    </div>
    
    <!-- Working Hours Below -->
    <div class="contact-item mt-3" style="text-align: center; padding-top: 15px; border-top: 1px solid rgba(255,255,255,0.1);">
        <i class="bi bi-clock-fill text-primary me-2"></i>
        <span class="text-white-75">Mon - Fri: 8:00 AM - 6:00 PM</span>
    </div>
</div>

    <!-- Project Images (Last) -->
    <div class="sidebar-gallery mb-4">
<?php echo do_shortcode('[sidebar_projects]'); ?>
    </div>
</div>

<!-- Overlay -->
<div class="overlay" id="overlay"></div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const header = document.getElementById('mainHeader');
    const searchToggle = document.getElementById('searchToggle');
    const headerSearchBar = document.getElementById('headerSearchBar');
    const sidebarToggle = document.getElementById('sidebarMenuToggle');
    const sidebarClose = document.getElementById('sidebarMenuClose');
    const sidebarMenu = document.getElementById('sidebarMenu');
    const overlay = document.getElementById('overlay');
    
    // Mobile nav elements
    const mobileNavToggle = document.getElementById('mobileNavToggle');
    const mobileNavClose = document.getElementById('mobileNavClose');
    const mobileNavMenu = document.getElementById('mobileNavMenu');
    const mobileNavOverlay = document.getElementById('mobileNavOverlay');
    
    // Add scroll effect
    window.addEventListener('scroll', function() {
        if (window.scrollY > 50) {
            header.classList.add('scrolled');
        } else {
            header.classList.remove('scrolled');
        }
    });

    // Toggle header search
    searchToggle.addEventListener('click', function() {
        headerSearchBar.classList.toggle('active');
        if (headerSearchBar.classList.contains('active')) {
            document.getElementById('header-search-input').focus();
        }
    });
    
    // Toggle sidebar menu
    sidebarToggle.addEventListener('click', function() {
        sidebarMenu.classList.add('active');
        overlay.classList.add('active');
        document.body.style.overflow = 'hidden';
    });
    
    // Close sidebar menu
    sidebarClose.addEventListener('click', function() {
        closeSidebar();
    });
    
    overlay.addEventListener('click', function() {
        closeSidebar();
    });
    
    function closeSidebar() {
        sidebarMenu.classList.remove('active');
        overlay.classList.remove('active');
        document.body.style.overflow = '';
    }

    // Mobile navigation functionality
    if (mobileNavToggle) {
        mobileNavToggle.addEventListener('click', function() {
            mobileNavMenu.classList.add('active');
            mobileNavOverlay.classList.add('active');
            document.body.style.overflow = 'hidden';
        });
    }
    
    if (mobileNavClose) {
        mobileNavClose.addEventListener('click', function() {
            closeMobileNav();
        });
    }
    
    if (mobileNavOverlay) {
        mobileNavOverlay.addEventListener('click', function() {
            closeMobileNav();
        });
    }
    
    function closeMobileNav() {
        mobileNavMenu.classList.remove('active');
        mobileNavOverlay.classList.remove('active');
        document.body.style.overflow = '';
    }

    // Mobile dropdown toggle functionality
    document.querySelectorAll('.mobile-nav-list .has-children > a').forEach(function(link) {
        link.addEventListener('click', function(e) {
            e.preventDefault();
            const parent = this.parentElement;
            const submenu = parent.querySelector('.mobile-submenu');
            const arrow = this.querySelector('.mobile-dropdown-arrow');
            
            if (submenu) {
                parent.classList.toggle('expanded');
                if (parent.classList.contains('expanded')) {
                    submenu.style.maxHeight = submenu.scrollHeight + 'px';
                    arrow.style.transform = 'rotate(180deg)';
                } else {
                    submenu.style.maxHeight = '0';
                    arrow.style.transform = 'rotate(0deg)';
                }
            }
        });
    });

    // Enhanced dropdown hover effects based on menu type
    document.querySelectorAll('.has-mega-menu').forEach(function(item) {
        let hoverTimeout;
        
        item.addEventListener('mouseenter', function() {
            clearTimeout(hoverTimeout);
            const megaMenu = this.querySelector('.mega-menu');
            if (megaMenu) {
                megaMenu.style.display = 'block';
            }
        });
        
        item.addEventListener('mouseleave', function() {
            const megaMenu = this.querySelector('.mega-menu');
            if (megaMenu) {
                hoverTimeout = setTimeout(() => {
                    megaMenu.style.display = 'none';
                }, 100);
            }
        });
    });

    // Simple dropdown hover effects
    document.querySelectorAll('.has-simple-dropdown').forEach(function(item) {
        let hoverTimeout;
        
        item.addEventListener('mouseenter', function() {
            clearTimeout(hoverTimeout);
            const simpleDropdown = this.querySelector('.simple-dropdown');
            if (simpleDropdown) {
                simpleDropdown.style.display = 'block';
            }
        });
        
        item.addEventListener('mouseleave', function() {
            const simpleDropdown = this.querySelector('.simple-dropdown');
            if (simpleDropdown) {
                hoverTimeout = setTimeout(() => {
                    simpleDropdown.style.display = 'none';
                }, 100);
            }
        });
    });
});

document.addEventListener('DOMContentLoaded', function() {
    const headerInput = document.getElementById('header-search-input');
    const headerResult = document.getElementById('header-search-results');

    // Header search functionality
    headerInput.addEventListener('keyup', function() {
        const query = this.value.trim();

        if (query.length === 0) {
            headerResult.innerHTML = '';
            return;
        }

        if (query.length < 2) {
            headerResult.innerHTML = '';
            return;
        }

        fetch('<?php echo admin_url("admin-ajax.php"); ?>?action=live_search&term=' + encodeURIComponent(query))
            .then(response => response.text())
            .then(html => {
                headerResult.innerHTML = html;
            });
    });
});
</script>

<?php wp_footer(); ?>
</section>
<!-- End Header Section -->