<?php
/**
 * Dynamic Services Category Shortcode with Liberty News Card Styles
 * Add this code to your theme's functions.php file
 * 
 * Usage: [services_category slug="civil-works"]
 * Usage: [services_category slug="water-works"]
 * Usage: [services_category slug="general-supplies"]
 */

function display_services_by_category($atts) {
    // Extract shortcode attributes
    $atts = shortcode_atts(
        array(
            'slug' => 'civil-works',
            'posts_per_page' => -1,
        ),
        $atts,
        'services_category'
    );

    // Query pages with the specified page_category
    $args = array(
        'post_type' => 'page',
        'posts_per_page' => $atts['posts_per_page'],
        'tax_query' => array(
            array(
                'taxonomy' => 'page_category',
                'field' => 'slug',
                'terms' => $atts['slug'],
            ),
        ),
        'orderby' => 'title',
        'order' => 'ASC',
    );

    $services_query = new WP_Query($args);

    // Start output buffering
    ob_start();

    if ($services_query->have_posts()) : ?>
        <div class="liberty-news-wrapper">
            <div class="liberty-news-container">
                <div class="liberty-news-grid">
                    <?php while ($services_query->have_posts()) : $services_query->the_post(); 
                        $featured_image = get_the_post_thumbnail_url(get_the_ID(), 'large');
                        $excerpt = wp_trim_words(get_the_excerpt(), 10, '...');
                        $permalink = get_permalink();
                        $title = get_the_title();
                    ?>
                        <div class="liberty-news-card">
                            <div class="liberty-news-image">
                                <?php if ($featured_image) : ?>
                                    <img src="<?php echo esc_url($featured_image); ?>" alt="<?php echo esc_attr($title); ?>" class="liberty-news-img">
                                <?php else : ?>
                                    <div class="liberty-news-img" style="background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); display: flex; align-items: center; justify-content: center; color: white; font-size: 18px; font-weight: bold;">
                                        <?php echo esc_html($title); ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                            
                            <div class="liberty-news-content">
                                <div class="liberty-news-meta">
                                    <h3 class="liberty-news-title">
                                        <a href="<?php echo esc_url($permalink); ?>"><?php echo esc_html($title); ?></a>
                                    </h3>
                                </div>
                                
                                <p class="liberty-news-excerpt"><?php echo esc_html($excerpt); ?></p>
                                
                                <div class="liberty-news-footer">
                                    <a href="<?php echo esc_url($permalink); ?>" class="liberty-news-btn">
                                        Read More
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                                            <path d="M5 12h14M12 5l7 7-7 7"/>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                </div>
            </div>
        </div>
    <?php else : ?>
        <div class="liberty-news-wrapper">
            <div class="liberty-news-container">
                <p style="text-align: center; padding: 40px 0; color: #666;">No services found in this category.</p>
            </div>
        </div>
    <?php endif;

    wp_reset_postdata();
    return ob_get_clean();
}

// Register the shortcode
add_shortcode('services_category', 'display_services_by_category');