<?php

function liberty_homepage_shortcode($atts) {
    $atts = shortcode_atts(array(
        'hero_title' => 'We Help You Build Modern Infrastructure',
        'hero_subtitle' => 'Liberty Scope delivers comprehensive engineering solutions across construction, water systems, civil works, and supply chain management with unwavering commitment to quality and innovation.',
    ), $atts);
    
    ob_start(); ?>
    
    <div class="liberty-homepage-wrapper">
       
  <!--HERO-->
<section class="ls-hero-section">
    <div class="ls-floating-dots-pattern">
        <?php for($row = 0; $row < 10; $row++): ?>
            <?php for($col = 0; $col < 25; $col++): ?>
                <div class="ls-pattern-dot" style="top: <?php echo $row * 10; ?>%; left: <?php echo $col * 4; ?>%;"></div>
            <?php endfor; ?>
        <?php endfor; ?>
    </div>
    
    <div class="container-fluid">
        <div class="row align-items-center">
            <div class="col-lg-6">
                <div class="ls-hero-content" data-aos="fade-up">
                    <div class="ls-hero-badge" data-aos="fade-up">About Us</div>
                    <h1 class="ls-hero-title" data-aos="fade-up">Welcome to <span class="ls-hero-brand"><i class="ls-company-icon">🏗️</i> Liberty Scope</span></h1>
                    
                    <p class="ls-hero-subtitle" data-aos="fade-up">Liberty Scope Ltd is a Ugandan company established in Kampala with a vision to deliver innovative and sustainable solutions in civil engineering, water works, and general supplies.</p>
                    
                    <p class="ls-hero-description" data-aos="fade-up">We provide high-quality, cost-effective civil works, water projects, and supply services that improve infrastructure and enhance livelihoods in Uganda and beyond with integrity, quality, and innovation.</p>
                    
                    <div class="ls-hero-stats" data-aos="fade-left">
                        <div class="ls-hero-stat" data-aos="fade-left">
                            <div class="ls-stat-number" data-count="100" data-duration="3000" data-suffix="+">0+</div>
                            <div class="ls-stat-text" data-aos="fade-left">
                                <span class="ls-stat-label" data-aos="fade-up">Successful</span>
                                <span class="ls-stat-value" data-aos="fade-up">PROJECTS</span>
                            </div>
                        </div>
                        <div class="ls-hero-stat" data-aos="fade-up">
                            <div class="ls-stat-number" data-count="3" data-duration="2000">0</div>
                            <div class="ls-stat-text" data-aos="fade-up">
                                <span class="ls-stat-label" data-aos="fade-up">Core</span>
                                <span class="ls-stat-value" data-aos="fade-up">SERVICES</span>
                            </div>
                        </div>
                    </div>
                    
                    <button class="buttons buttons-get-quote" data-aos="fade-up">READ MORE</button>
                </div>
            </div>
            
            <div class="col-lg-6">
                <div class="ls-hero-images-container" data-aos="fade-left">
                    <div class="ls-hero-image ls-hero-image-main" style="background-image: url('https://lwegatech.net/liberty-scope/wp-content/uploads/2025/09/civil-construction1.jpg');">
                    </div>
                    <div class="ls-hero-image ls-hero-image-office" style="background-image: url('https://lwegatech.net/liberty-scope/wp-content/uploads/2025/09/general-supplies.jpg');">
                    </div>
                    <div class="ls-hero-image ls-hero-image-stool" style="background-image: url('https://lwegatech.net/liberty-scope/wp-content/uploads/2025/09/borewell.jpg'); height: 250px;">
                    </div>
                    <div class="ls-hero-image ls-hero-image-food" style="background-image: url('https://lwegatech.net/liberty-scope/wp-content/uploads/2025/09/general-supplies.jpg');">
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <div class="ls-hero-decorative-elements">
        <div class="ls-floating-shape ls-shape-1"></div>
        <div class="ls-floating-shape ls-shape-2"></div>
        <div class="ls-floating-shape ls-shape-3"></div>
    </div>
</section>
       
        <!-- RELAXER SECTION -->
        <section class="ls-relaxer-section" data-aos="fade-up">
            <div class="container">
                <div class="row">
                    <div class="col-lg-6">
                        <div class="ls-services-badge" data-aos="fade-up">Why Choose Us</div>
                        <h2 class="ls-relaxer-title" data-aos="fade-up">Shaping Success, From Concept to Concrete</h2>
                        <!--<p class="ls-relaxer-subtitle" data-aos="fade-up">Our expertise is your advantage.</p>-->
                        <p class="ls-relaxer-description" data-aos="fade-up">Your success is our ultimate goal. We're committed to understanding your unique needs and delivering customized solutions that meet and exceed your expectations.Partner with us, and experience the difference that comes from working with a company that puts your vision first.</p>
                        <a href="https://lwegatech.net/liberty-scope/contact" class="buttons buttons-get-quote">Contact Us →</a>
                    </div>
                    <div class="col-lg-6">
                        <div class="ls-relaxer-benefits">
                            <div class="ls-benefit-item" data-aos="fade-up">
                                <div class="ls-benefit-icon" data-aos="fade-up">
                                    <span>+</span>
                                </div>
                                <div class="ls-benefit-content" data-aos="fade-up">
                                    <h4 class="ribbon-content">High-quality workmanship</h4>
                                </div>
                            </div>
                            <div class="ls-benefit-item" data-aos="fade-up">
                                <div class="ls-benefit-icon">
                                    <span>💰</span>
                                </div>
                                <div class="ls-benefit-content" data-aos="fade-up">
                                    <h4 class="ribbon-content">Competitive pricing</h4>
                                </div>
                            </div>
                            <div class="ls-benefit-item" data-aos="fade-up">
                                <div class="ls-benefit-icon">
                                    <span>🏖️</span>
                                </div>
                                <div class="ls-benefit-content" data-aos="fade-up">
                                    <h4 class="ribbon-content">Tailored solutions to client needs</h4>
                                </div>
                            </div>
                            <div class="ls-benefit-item" data-aos="fade-up">
                                <div class="ls-benefit-icon">
                                    <span>🏛️</span>
                                </div>
                                <div class="ls-benefit-content" data-aos="fade-up">
                                    <h4 class="ribbon-content">Timely delivery and efficient service</h4>
                                </div>
                            </div>
                            <div class="ls-benefit-item" data-aos="fade-up">
                                <div class="ls-benefit-icon">
                                    <span>🚗</span>
                                </div>
                                <div class="ls-benefit-content" data-aos="fade-up">
                                    <h4 class="ribbon-content">Reliable contractor and supplier</h4>
                                </div>
                            </div>
                            <div class="ls-benefit-item" data-aos="fade-up">
                                <div class="ls-benefit-icon">
                                    <span>📈</span>
                                </div>
                                <div class="ls-benefit-content" >
                                    <h4 class="ribbon-content">Innovative and sustainable solutions</h4>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Rest of your sections remain the same -->
        
    </div>
    
    <script>
    jQuery(document).ready(function($) {
        // Counter animation function
        function animateCounter(element) {
            const target = parseInt(element.getAttribute('data-count'));
            const duration = parseInt(element.getAttribute('data-duration')) || 2000;
            const suffix = element.getAttribute('data-suffix') || '';
            const startTime = performance.now();
            const startValue = 0;
            
            function updateCounter(currentTime) {
                const elapsed = currentTime - startTime;
                const progress = Math.min(elapsed / duration, 1);
                
                // Easing function for smooth animation
                const easeOutQuart = 1 - Math.pow(1 - progress, 4);
                const currentValue = Math.floor(startValue + (target - startValue) * easeOutQuart);
                
                element.textContent = currentValue + suffix;
                
                if (progress < 1) {
                    requestAnimationFrame(updateCounter);
                }
            }
            
            requestAnimationFrame(updateCounter);
        }
        
        // Intersection Observer for counter animation
        const observer = new IntersectionObserver((entries) => {
            entries.forEach(entry => {
                if (entry.isIntersecting) {
                    const counters = entry.target.querySelectorAll('.ls-stat-number');
                    counters.forEach(counter => {
                        animateCounter(counter);
                    });
                    observer.unobserve(entry.target);
                }
            });
        }, { threshold: 0.5 });
        
        // Observe the hero stats section
        const heroStats = document.querySelector('.ls-hero-stats');
        if (heroStats) {
            observer.observe(heroStats);
        }
    });
    </script>
    
        

<?php
// Define the specific service categories we want to display
$service_categories = array('civil-works', 'water-works', 'general-supplies');
$services_data = array();

// Query for each specific service category
foreach ($service_categories as $category_slug) {
    $service_query = new WP_Query(array(
        'post_type' => 'service',
        'name' => $category_slug,
        'posts_per_page' => 1,
        'post_status' => 'publish'
    ));
    
    if ($service_query->have_posts()) {
        while ($service_query->have_posts()) {
            $service_query->the_post();
            $services_data[] = array(
                'title' => get_the_title(),
                'excerpt' => get_the_excerpt(),
                'permalink' => get_the_permalink(),
                'featured_image' => get_the_post_thumbnail_url(get_the_ID(), 'large'),
                'slug' => $category_slug
            );
        }
        wp_reset_postdata();
    }
}

// Fallback services if not enough found
$fallback_services = array(
    array(
        'title' => 'Civil Works',
        'excerpt' => 'Comprehensive civil engineering solutions for infrastructure development and construction projects.',
        'featured_image' => 'https://lwegatech.net/liberty-scope/wp-content/uploads/2025/09/civil-works.jpg',
        'permalink' => 'https://lwegatech.net/liberty-scope/civil-works/',
        'slug' => 'civil-works'
    ),
    array(
        'title' => 'Water Works', 
        'excerpt' => 'Advanced water management systems and sustainable water infrastructure solutions.',
        'featured_image' => 'https://lwegatech.net/liberty-scope/wp-content/uploads/2025/09/water-works-1.jpg',
        'permalink' => 'https://lwegatech.net/liberty-scope/water-works/',
        'slug' => 'water-works'
    ),
    array(
        'title' => 'General Supplies',
        'excerpt' => 'Quality materials and equipment supply for construction and engineering projects.',
        'featured_image' => 'https://lwegatech.net/liberty-scope/wp-content/uploads/2025/09/general-supplies.jpg',
        'permalink' => 'https://lwegatech.net/liberty-scope/general-supplies/',
        'slug' => 'general-supplies'
    )
);

// Fill missing services with fallbacks
while (count($services_data) < 3) {
    $missing_index = count($services_data);
    if (isset($fallback_services[$missing_index])) {
        $services_data[] = $fallback_services[$missing_index];
    } else {
        break;
    }
}
?>

<!-- SERVICES SECTION -->
<section class="ls-services-section">
    <div class="container">
        <div class="ls-services-header">
            <span class="ls-services-badge">Work with us</span>
            <h2 class="ls-services-title">Our Services</h2>
            <p class="ls-services-subtitle">People are the key to our success. That's why we want to attract the best talent in the industry to join our group of businesses and work with us to engineer the future.</p>
        </div>
        
        <div class="ls-services-grid">
            <!-- Main Large Service Card -->
            <?php if (isset($services_data[0])) : $service = $services_data[0]; ?>
            <div class="ls-service-card ls-service-card-large">
                <div class="ls-service-image" style="background-image: url('<?php echo esc_url($service['featured_image']); ?>');">
                    <div class="ls-service-overlay">
                        <div class="ls-service-content">
                            <h3 class="ls-service-title"><?php echo esc_html($service['title']); ?></h3>
                            <?php if ($service['excerpt']) : ?>
                                <p class="ls-service-excerpt"><?php echo esc_html(wp_trim_words($service['excerpt'], 20, '...')); ?></p>
                            <?php endif; ?>
                            <a href="<?php echo esc_url($service['permalink']); ?>" class="ls-service-link">
                                <span>Read more</span>
                                <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                    <path d="M5 12h14m-7-7l7 7-7 7" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                </svg>
                            </a>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
            
            <!-- Right Side Smaller Cards -->
            <div class="ls-services-right">
                <?php for ($i = 1; $i < 3; $i++) : ?>
                    <?php if (isset($services_data[$i])) : $service = $services_data[$i]; ?>
                    <div class="ls-service-card ls-service-card-small">
                        <div class="ls-service-image" style="background-image: url('<?php echo esc_url($service['featured_image']); ?>');">
                            <div class="ls-service-overlay">
                                <div class="ls-service-content">
                                    <h3 class="ls-service-title"><?php echo esc_html($service['title']); ?></h3>
                                    <a href="<?php echo esc_url($service['permalink']); ?>" class="ls-service-link">
                                        <span>Read more</span>
                                        <svg width="16" height="16" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5 12h14m-7-7l7 7-7 7" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"/>
                                        </svg>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endif; ?>
                <?php endfor; ?>
            </div>
        </div>
    </div>
</section>

    </div>
    
    <?php
    return ob_get_clean();
}

// Register the shortcode
add_shortcode('liberty_homepage', 'liberty_homepage_shortcode');




// CLIENTS
function liberty_scope_clients_split_shortcode() {
    ob_start();
    ?>
    <section class="ls-clients-showcase">
        <div class="ls-clients-wrapper">
            <!-- Card 1 -->
            <div class="ls-clients-split">
                <div class="ls-clients-image-side" style="background-image: url('https://www.independent.co.ug/wp-content/uploads/2024/04/parliament-3.jpg');"></div>
                <div class="ls-clients-content-side">
                    <div class="ls-clients-content">
                        <h3 class="ls-clients-title">Government Agencies</h3>
                        <p class="ls-clients-description">Ministries, municipalities, and districts needing construction, water works, and supply services.</p>
                        <button type="button" class="ls-clients-read-more-btn" data-bs-toggle="modal" data-bs-target="#lsClientsModal">Read More</button>
                    </div>
                </div>
            </div>

            <!-- Card 2 -->
            <div class="ls-clients-split">
                <div class="ls-clients-image-side" style="background-image: url('https://i.pinimg.com/1200x/83/28/23/8328231af44c1cd6fa5c4080bbf3bdf6.jpg');"></div>
                <div class="ls-clients-content-side">
                    <div class="ls-clients-content">
                        <h3 class="ls-clients-title">Commercial Clients</h3>
                        <p class="ls-clients-description">Developers, contractors, and companies requiring reliable project execution.</p>
                        <button type="button" class="ls-clients-read-more-btn" data-bs-toggle="modal" data-bs-target="#lsClientsModal">Read More</button>
                    </div>
                </div>
            </div>

            <!-- Card 3 -->
            <div class="ls-clients-split">
                <div class="ls-clients-image-side" style="background-image: url('https://i.pinimg.com/736x/53/cb/5d/53cb5df018e6bfeed78adf040941d937.jpg');"></div>
                <div class="ls-clients-content-side">
                    <div class="ls-clients-content">
                        <h3 class="ls-clients-title">NGOs & Development Partners</h3>
                        <p class="ls-clients-description">Organizations supporting infrastructure and WASH programs.</p>
                        <button type="button" class="ls-clients-read-more-btn" data-bs-toggle="modal" data-bs-target="#lsClientsModal">Read More</button>
                    </div>
                </div>
            </div>

            <!-- Card 4 -->
            <div class="ls-clients-split">
                <div class="ls-clients-image-side" style="background-image: url('https://i.pinimg.com/1200x/8b/92/69/8b92698156fdff06c4c656c22078a91c.jpg');"></div>
                <div class="ls-clients-content-side">
                    <div class="ls-clients-content">
                        <h3 class="ls-clients-title">Homeowners & Communities</h3>
                        <p class="ls-clients-description">Individuals and cooperatives in need of water systems and household infrastructure.</p>
                        <button type="button" class="ls-clients-read-more-btn" data-bs-toggle="modal" data-bs-target="#lsClientsModal">Read More</button>
                    </div>
                </div>
            </div>
        </div>

        <!-- Modal -->
        <div class="modal fade" id="lsClientsModal" tabindex="-1" aria-labelledby="lsClientsModalLabel" aria-hidden="true">
            <div class="modal-dialog modal-lg">
                <div class="modal-content ls-clients-modal-content">
                    <div class="modal-header ls-clients-modal-header">
                        <h5 class="modal-title" id="lsClientsModalLabel">Client Categories & Benefits</h5>
                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    </div>
                    <div class="modal-body ls-clients-modal-body">
                        <h6>Target Audience</h6>
                        <ul>
                            <li><strong>Government Agencies:</strong> Ministries, municipalities, and districts needing construction, water works, and supply services.</li>
                            <li><strong>Commercial Clients:</strong> Developers, contractors, and companies requiring reliable project execution.</li>
                            <li><strong>NGOs & Development Partners:</strong> Organizations supporting infrastructure and WASH programs.</li>
                            <li><strong>Homeowners & Communities:</strong> Individuals and cooperatives in need of water systems and household infrastructure.</li>
                        </ul>
                        <hr>
                        <h6>Benefits of Working with Liberty Scope</h6>
                        <ul>
                            <li>High-quality workmanship</li>
                            <li>Competitive pricing</li>
                            <li>Tailored solutions to client needs</li>
                            <li>Timely delivery and efficient service</li>
                        </ul>
                    </div>
                    <div class="modal-footer ls-clients-modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php
    return ob_get_clean();
}
add_shortcode('liberty_scope_clients_split', 'liberty_scope_clients_split_shortcode');







// Register Custom Post Type for Services
function liberty_scope_register_services_cpt() {
    $labels = array(
        'name'                  => _x('Services', 'Post Type General Name', 'liberty-scope'),
        'singular_name'         => _x('Service', 'Post Type Singular Name', 'liberty-scope'),
        'menu_name'             => __('Services', 'liberty-scope'),
        'name_admin_bar'        => __('Service', 'liberty-scope'),
        'archives'              => __('Service Archives', 'liberty-scope'),
        'attributes'            => __('Service Attributes', 'liberty-scope'),
        'parent_item_colon'     => __('Parent Service:', 'liberty-scope'),
        'all_items'             => __('All Services', 'liberty-scope'),
        'add_new_item'          => __('Add New Service', 'liberty-scope'),
        'add_new'               => __('Add New', 'liberty-scope'),
        'new_item'              => __('New Service', 'liberty-scope'),
        'edit_item'             => __('Edit Service', 'liberty-scope'),
        'update_item'           => __('Update Service', 'liberty-scope'),
        'view_item'             => __('View Service', 'liberty-scope'),
        'view_items'            => __('View Services', 'liberty-scope'),
        'search_items'          => __('Search Service', 'liberty-scope'),
        'not_found'             => __('Not found', 'liberty-scope'),
        'not_found_in_trash'    => __('Not found in Trash', 'liberty-scope'),
        'featured_image'        => __('Service Image', 'liberty-scope'),
        'set_featured_image'    => __('Set service image', 'liberty-scope'),
        'remove_featured_image' => __('Remove service image', 'liberty-scope'),
        'use_featured_image'    => __('Use as service image', 'liberty-scope'),
        'insert_into_item'      => __('Insert into service', 'liberty-scope'),
        'uploaded_to_this_item' => __('Uploaded to this service', 'liberty-scope'),
        'items_list'            => __('Services list', 'liberty-scope'),
        'items_list_navigation' => __('Services list navigation', 'liberty-scope'),
        'filter_items_list'     => __('Filter services list', 'liberty-scope'),
    );
    $args = array(
        'label'                 => __('Service', 'liberty-scope'),
        'description'           => __('Liberty Scope Services', 'liberty-scope'),
        'labels'                => $labels,
        'supports'              => array('title', 'editor', 'thumbnail', 'excerpt', 'custom-fields'),
        'taxonomies'            => array('service_category'),
        'hierarchical'          => false,
        'public'                => true,
        'show_ui'               => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'menu_icon'             => 'dashicons-hammer',
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => true,
        'exclude_from_search'   => false,
        'publicly_queryable'    => true,
        'capability_type'       => 'page',
    );
    register_post_type('liberty_service', $args);
}
add_action('init', 'liberty_scope_register_services_cpt', 0);

// Register Custom Taxonomy for Service Categories
function liberty_scope_register_service_taxonomy() {
    $labels = array(
        'name' => _x('Service Categories', 'taxonomy general name', 'liberty-scope'),
        'singular_name' => _x('Service Category', 'taxonomy singular name', 'liberty-scope'),
        'search_items' => __('Search Service Categories', 'liberty-scope'),
        'all_items' => __('All Service Categories', 'liberty-scope'),
        'parent_item' => __('Parent Service Category', 'liberty-scope'),
        'parent_item_colon' => __('Parent Service Category:', 'liberty-scope'),
        'edit_item' => __('Edit Service Category', 'liberty-scope'),
        'update_item' => __('Update Service Category', 'liberty-scope'),
        'add_new_item' => __('Add New Service Category', 'liberty-scope'),
        'new_item_name' => __('New Service Category Name', 'liberty-scope'),
        'menu_name' => __('Service Categories', 'liberty-scope'),
    );

    $args = array(
        'hierarchical' => true,
        'labels' => $labels,
        'show_ui' => true,
        'show_admin_column' => true,
        'query_var' => true,
        'rewrite' => array('slug' => 'service-category'),
    );

    register_taxonomy('service_category', array('liberty_service'), $args);
}
add_action('init', 'liberty_scope_register_service_taxonomy', 0);

// Add meta boxes for service details
function liberty_scope_add_service_meta_boxes() {
    add_meta_box(
        'liberty_scope_service_details',
        'Service Details',
        'liberty_scope_service_details_callback',
        'liberty_service',
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'liberty_scope_add_service_meta_boxes');

function liberty_scope_service_details_callback($post) {
    wp_nonce_field('liberty_scope_service_details_nonce', 'liberty_scope_service_details_nonce');
    
    $duration = get_post_meta($post->ID, '_service_duration', true);
    $features = get_post_meta($post->ID, '_service_features', true);
    $button_text = get_post_meta($post->ID, '_service_button_text', true);
    $button_url = get_post_meta($post->ID, '_service_button_url', true);
    
    echo '<p><label for="service_duration">Duration: </label>';
    echo '<input type="text" id="service_duration" name="service_duration" value="' . esc_attr($duration) . '" size="25" /></p>';
    
    echo '<p><label for="service_features">Features (one per line): </label>';
    echo '<textarea id="service_features" name="service_features" rows="5" cols="50">' . esc_textarea($features) . '</textarea></p>';
    
    echo '<p><label for="service_button_text">Button Text: </label>';
    echo '<input type="text" id="service_button_text" name="service_button_text" value="' . esc_attr($button_text) . '" size="25" /></p>';
    
    echo '<p><label for="service_button_url">Button URL: </label>';
    echo '<input type="text" id="service_button_url" name="service_button_url" value="' . esc_attr($button_url) . '" size="25" /></p>';
}

function liberty_scope_save_service_details($post_id) {
    if (!isset($_POST['liberty_scope_service_details_nonce']) || 
        !wp_verify_nonce($_POST['liberty_scope_service_details_nonce'], 'liberty_scope_service_details_nonce')) {
        return;
    }
    
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }
    
    if (isset($_POST['service_duration'])) {
        update_post_meta($post_id, '_service_duration', sanitize_text_field($_POST['service_duration']));
    }
    
    if (isset($_POST['service_features'])) {
        update_post_meta($post_id, '_service_features', sanitize_textarea_field($_POST['service_features']));
    }
    
    if (isset($_POST['service_button_text'])) {
        update_post_meta($post_id, '_service_button_text', sanitize_text_field($_POST['service_button_text']));
    }
    
    if (isset($_POST['service_button_url'])) {
        update_post_meta($post_id, '_service_button_url', sanitize_text_field($_POST['service_button_url']));
    }
}
add_action('save_post', 'liberty_scope_save_service_details');

// Shortcode to display services
function liberty_scope_services_shortcode($atts) {
    $atts = shortcode_atts(array(
        'category' => '',
        'limit' => -1
    ), $atts, 'liberty_services');
    
    $args = array(
        'post_type' => 'liberty_service',
        'posts_per_page' => $atts['limit'],
        'post_status' => 'publish'
    );
    
    if (!empty($atts['category'])) {
        $args['tax_query'] = array(
            array(
                'taxonomy' => 'service_category',
                'field' => 'slug',
                'terms' => $atts['category']
            )
        );
    }
    
    $services = new WP_Query($args);
    
    if (!$services->have_posts()) {
        return '<p>No services found.</p>';
    }
    
    ob_start();
    ?>
    <div class="liberty-services-wrapper">
        <div class="liberty-services-container">
            <?php while ($services->have_posts()) : $services->the_post(); 
                $duration = get_post_meta(get_the_ID(), '_service_duration', true);
                $features = get_post_meta(get_the_ID(), '_service_features', true);
                $button_text = get_post_meta(get_the_ID(), '_service_button_text', true);
                $button_url = get_post_meta(get_the_ID(), '_service_button_url', true);
                
                if (empty($button_text)) {
                    $button_text = 'Learn More';
                }
                
                $feature_list = !empty($features) ? explode("\n", $features) : array();
                
                // Determine service type based on category for styling
                $service_class = '';
                $categories = get_the_terms(get_the_ID(), 'service_category');
                if (!empty($categories)) {
                    $category_slug = $categories[0]->slug;
                    if (strpos($category_slug, 'civil') !== false || strpos($category_slug, 'construction') !== false) {
                        $service_class = 'ls-construction';
                    } elseif (strpos($category_slug, 'water') !== false) {
                        $service_class = 'ls-water';
                    } elseif (strpos($category_slug, 'supply') !== false) {
                        $service_class = 'ls-supply';
                    }
                }
            ?>
            <div class="liberty-service-card <?php echo esc_attr($service_class); ?>">
                <?php if (has_post_thumbnail()) : ?>
                <div class="liberty-service-image">
                    <?php the_post_thumbnail('medium', array('alt' => get_the_title())); ?>
                </div>
                <?php endif; ?>
                
                <div class="liberty-service-content">
                    <h3><?php the_title(); ?></h3>
                    <div class="liberty-service-excerpt"><?php the_excerpt(); ?></div>
                    
                    <?php if (!empty($duration)) : ?>
                    <div class="liberty-service-duration"><?php echo esc_html($duration); ?></div>
                    <?php endif; ?>
                    
                    <?php if (!empty($feature_list)) : ?>
                    <ul class="liberty-service-features">
                        <?php foreach (array_slice($feature_list, 0, 4) as $feature) : ?>
                        <li><i class="fas fa-check-circle"></i> <?php echo esc_html(trim($feature)); ?></li>
                        <?php endforeach; ?>
                    </ul>
                    <?php endif; ?>
                    
                    <?php if (!empty($button_url)) : ?>
                    <a href="<?php echo esc_url($button_url); ?>" class="liberty-btn"><?php echo esc_html($button_text); ?></a>
                    <?php endif; ?>
                </div>
            </div>
            <?php endwhile; wp_reset_postdata(); ?>
        </div>
    </div>
    <?php
    return ob_get_clean();
}
add_shortcode('liberty_services', 'liberty_scope_services_shortcode');



?>