<?php
// OUR BACKGROUND PAGE SHORTCODE

// Our Story Section
function liberty_our_story_section() {
    ob_start();
    ?>
    <section class="liberty-our-story">
        <div class="container">
            <div class="liberty-story-grid" data-aos="fade-up">
                <div class="liberty-story-images" data-aos="fade-left">
                    <div class="liberty-image-main">
                        <img src="https://i.pinimg.com/1200x/f2/f5/8a/f2f58a8ecea69ab8e5f0939e6d094b51.jpg" alt="Modern Construction" />
                    </div>
                    <div class="liberty-image-secondary">
                        <img src="https://i.pinimg.com/736x/3b/22/64/3b2264ca23820c25831c917f99c24f25.jpg" alt="Water Infrastructure" />
                    </div>
                    <div class="liberty-experience-badge">
                        <span>Professional Excellence</span>
                        <span>Multi-Disciplinary Expertise</span>
                    </div>
                </div>
                <div class="liberty-story-content" data-aos="fade-up">
                    <h2>HISTORY <span class="liberty-text-primary">of Our Creation</span></h2>
                    <p>Liberty Scope Ltd emerged from a vision to deliver innovative and sustainable solutions in Uganda's growing infrastructure sector. Established in Kampala, we recognized the critical need for reliable civil engineering, water works, and supply services.</p>
                    <p>Our journey began with a commitment to excellence and has evolved into a trusted partnership with government agencies, commercial clients, NGOs, and communities across Uganda.</p>
                    <div class="liberty-story-features">
                        <div class="liberty-feature-item">
                            <span class="liberty-check">✓</span>
                            <span>Multi-disciplinary Expertise</span>
                        </div>
                        <div class="liberty-feature-item">
                            <span class="liberty-check">✓</span>
                            <span>Proven Track Record</span>
                        </div>
                        <div class="liberty-feature-item">
                            <span class="liberty-check">✓</span>
                            <span>On-time Delivery</span>
                        </div>
                        <div class="liberty-feature-item">
                            <span class="liberty-check">✓</span>
                            <span>Budget Compliance</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php
    return ob_get_clean();
}


// Mission Vision Section
function liberty_mission_vision_section() {
    ob_start();
    ?>
    <section class="liberty-mission-vision">
        <div class="container">
            <div class="liberty-mv-grid">
                <div class="liberty-mission-card" data-aos="fade-right">
                    <div class="liberty-mv-image">
                        <img src="https://i.pinimg.com/1200x/7c/78/ef/7c78ef01228525663b9bc032553326fc.jpg" alt="Our Mission" />
                        <div class="liberty-mv-overlay" data-aos="fade-up">
                            <h3>Our Mission</h3>
                        </div>
                    </div>
                    <div class="liberty-mv-content" data-aos="fade-up">
                        <p>To provide high-quality, cost-effective civil works, water projects, and supply services that improve infrastructure and enhance livelihoods in Uganda and beyond.</p>
                        <div class="liberty-mv-features" data-aos="fade-up">
                            <div class="liberty-mv-item" data-aos="fade-up">
                                <span class="liberty-icon" data-aos="fade-right">🎯</span>
                                <span>Quality Excellence</span>
                            </div>
                            <div class="liberty-mv-item" data-aos="fade-up">
                                <span class="liberty-icon" data-aos="fade-right">💧</span>
                                <span>Sustainable Solutions</span>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="liberty-vision-card" data-aos="fade-left">
                    <div class="liberty-mv-image">
                        <img src="https://i.pinimg.com/736x/21/74/70/217470d5f1a49c580f06cff2e13c1d96.jpg" alt="Our Vision" />
                        <div class="liberty-mv-overlay liberty-vision-overlay" data-aos="fade-up">
                            <h3>Our Values</h3>
                        </div>
                    </div>
                    <div class="liberty-mv-content" data-aos="fade-up">
                        <div class="liberty-values-grid" data-aos="fade-up">
                            <div class="liberty-value-item" data-aos="fade-up">
                                <h4>Integrity</h4>
                                <p>Upholding honesty and transparency in all operations</p>
                            </div>
                            <div class="liberty-value-item" data-aos="fade-up">
                                <h4>Innovation</h4>
                                <p>Embracing modern technologies and methods</p>
                            </div>
                            <div class="liberty-value-item" data-aos="fade-up">
                                <h4>Quality</h4>
                                <p>Delivering durable and sustainable solutions</p>
                            </div>
                            <div class="liberty-value-item" data-aos="fade-up">
                                <h4>Community</h4>
                                <p>Prioritizing local employment and training</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <?php
    return ob_get_clean();
}

// Main About Us Shortcode
function liberty_about_us_shortcode($atts) {
    $sections = '';
    $sections .= liberty_our_story_section();
    $sections .= liberty_mission_vision_section();
    return $sections;
}

// Register shortcode
add_shortcode('liberty_about_us', 'liberty_about_us_shortcode');



// WHAT WE DO PAGE SHORTCODE

function liberty_scope_what_we_do_page() {
    ob_start();
    ?>
    
    <div class="ls-what-we-do">

        <!-- Services Overview -->
        <section id="services" class="ls-services-section py-5 bg-light">
            <div class="container py-5">
                <div class="row mb-5">
                    <div class="col-lg-6 mx-auto text-center">
                        <h2 class="h1 fw-bold mb-3" data-aos="fade-up">What We Do</h2>
                        <div class="ls-title-divider mx-auto mb-4" style="height:4px; width:80px; background:var(--ls-primary);" data-aos="fade-up"></div>
                        <p class="lead" data-aos="fade-up">We provide comprehensive infrastructure solutions across multiple sectors with a commitment to quality and innovation.</p>
                    </div>
                </div>
                
                <div class="row g-4">
                    <div class="col-md-4">
                        <div class="card ls-service-card h-100 border-0 shadow-ls hover-lift" data-aos="fade-right">
                            <div class="card-body text-center p-4">
                                <div class="ls-service-icon mx-auto mb-4 rounded-circle d-flex align-items-center justify-content-center" style="width:80px; height:80px; background:var(--ls-primary);">
                                    <i class="fas fa-hard-hat text-white fs-2" data-aos="fade-up"></i>
                                </div>
                                <h3 class="h4 fw-bold mb-3" data-aos="fade-up">Civil Works</h3>
                                <p class="mb-0" data-aos="fade-up">Residential and commercial construction, road works, drainage systems, and structural renovations with precision engineering.</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card ls-service-card h-100 border-0 shadow-ls hover-lift" data-aos="fade-right">
                            <div class="card-body text-center p-4">
                                <div class="ls-service-icon mx-auto mb-4 rounded-circle d-flex align-items-center justify-content-center" style="width:80px; height:80px; background:var(--ls-water-blue);">
                                    <i class="fas fa-tint text-white fs-2" data-aos="fade-up"></i>
                                </div>
                                <h3 class="h4 fw-bold mb-3" data-aos="fade-up">Water Works</h3>
                                <p class="mb-0" data-aos="fade-up">Borehole drilling, water supply systems, solar-powered irrigation, and water treatment facilities for sustainable water access.</p>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-md-4">
                        <div class="card ls-service-card h-100 border-0 shadow-ls hover-lift">
                            <div class="card-body text-center p-4" data-aos="fade-up">
                                <div class="ls-service-icon mx-auto mb-4 rounded-circle d-flex align-items-center justify-content-center" style="width:80px; height:80px; background:var(--ls-supply-green);">
                                    <i class="fas fa-truck-loading text-white fs-2" data-aos="fade-up"></i>
                                </div>
                                <h3 class="h4 fw-bold mb-3" data-aos="fade-up">General Supplies</h3>
                                <p class="mb-0" data-aos="fade-up">Quality construction materials, office supplies, solar equipment, and agricultural inputs from trusted suppliers.</p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
        
        
    <!--<section class="liberty-services-grid">-->
    <!--    <div class="container">-->
    <!--        <div class="liberty-section-header" data-aos="fade-up">-->
    <!--            <h2>Our Creative <span class="liberty-text-primary" data-aos="fade-up">SERVICES</span></h2>-->
    <!--            <p>Comprehensive solutions in civil engineering, water works, and general supplies tailored to meet diverse client needs across Uganda.</p>-->
    <!--        </div>-->
    <!--        <div class="liberty-services-container">-->
    <!--            <div class="liberty-service-card liberty-service-primary" data-aos="fade-right">-->
    <!--                <div class="liberty-service-image">-->
    <!--                    <img src="https://i.pinimg.com/736x/01/79/45/0179454fd288e10643c01182eca8a3b5.jpg" alt="Civil Engineering" />-->
    <!--                </div>-->
    <!--                <div class="liberty-service-content" data-aos="fade-up">-->
    <!--                    <h3 data-aos="fade-up">Civil Engineering</h3>-->
    <!--                    <p data-aos="fade-up">Comprehensive infrastructure development including roads, buildings, and structural engineering projects for sustainable community growth.</p>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--            <div class="liberty-service-card liberty-service-secondary" data-aos="fade-right">-->
    <!--                <div class="liberty-service-image">-->
    <!--                    <img src="https://i.pinimg.com/1200x/95/e5/e1/95e5e1c5adc52c8cb87a730eb1192885.jpg" alt="Water Works" />-->
    <!--                </div>-->
    <!--                <div class="liberty-service-content" data-aos="fade-up">-->
    <!--                    <h3 data-aos="fade-up">Water Infrastructure</h3>-->
    <!--                    <p data-aos="fade-up">Advanced water systems, treatment facilities, and distribution networks ensuring clean water access for communities and businesses.</p>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--            <div class="liberty-service-card liberty-service-tertiary" data-aos="fade-right">-->
    <!--                <div class="liberty-service-image">-->
    <!--                    <img src="https://i.pinimg.com/1200x/49/c8/0c/49c80cb6ed72eb00ece93671886eb402.jpg" alt="Project Management" />-->
    <!--                </div>-->
    <!--                <div class="liberty-service-content" data-aos="fade-up">-->
    <!--                    <h3 data-aos="fade-up">Project Implementation</h3>-->
    <!--                    <p data-aos="fade-up">End-to-end project management with professional engineers and skilled technicians ensuring quality delivery.</p>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--            <div class="liberty-service-card liberty-service-quaternary" data-aos="fade-right">-->
    <!--                <div class="liberty-service-image">-->
    <!--                    <img src="https://i.pinimg.com/736x/46/06/e6/4606e6ed6db487e57590e5e9e76fc66b.jpg" alt="General Supplies" />-->
    <!--                </div>-->
    <!--                <div class="liberty-service-content" data-aos="fade-up">-->
    <!--                    <h3 data-aos="fade-up">General Supplies</h3>-->
    <!--                    <p data-aos="fade-up">Reliable procurement and supply services for construction materials, equipment, and specialized products.</p>-->
    <!--                </div>-->
    <!--            </div>-->
    <!--        </div>-->
    <!--    </div>-->
    <!--</section>-->

        <!-- Mission & Vision -->
        <!--<section class="ls-mission-vision py-5">-->
        <!--    <div class="container py-5">-->
        <!--        <div class="row g-5">-->
        <!--            <div class="col-lg-6">-->
        <!--                <div class="ls-mission-card p-5 rounded-3 shadow-ls h-100" style="background:var(--ls-bg-secondary);" data-aos="fade-up">-->
        <!--                    <div class="d-flex align-items-center mb-4">-->
        <!--                        <div class="ls-icon-wrapper me-3 rounded-circle d-flex align-items-center justify-content-center" style="width:60px; height:60px; background:var(--ls-primary);">-->
        <!--                            <i class="fas fa-bullseye text-white fs-4"></i>-->
        <!--                        </div>-->
        <!--                        <h2 class="h3 fw-bold mb-0" data-aos="fade-up">Our Mission</h2>-->
        <!--                    </div>-->
        <!--                    <p class="mb-0" data-aos="fade-up">To provide high-quality, cost-effective civil works, water projects, and supply services that improve infrastructure and enhance livelihoods in Uganda and beyond.</p>-->
        <!--                </div>-->
        <!--            </div>-->
                    
        <!--            <div class="col-lg-6">-->
        <!--                <div class="ls-vision-card p-5 rounded-3 shadow-ls h-100" style="background:var(--ls-bg-secondary);" data-aos="fade-up">-->
        <!--                    <div class="d-flex align-items-center mb-4">-->
        <!--                        <div class="ls-icon-wrapper me-3 rounded-circle d-flex align-items-center justify-content-center" style="width:60px; height:60px; background:var(--ls-secondary);">-->
        <!--                            <i class="fas fa-eye text-white fs-4"></i>-->
        <!--                        </div>-->
        <!--                        <h2 class="h3 fw-bold mb-0" data-aos="fade-up">Our Vision</h2>-->
        <!--                    </div>-->
        <!--                    <p class="mb-0" data-aos="fade-up">To be Uganda's leading provider of innovative and sustainable infrastructure solutions, recognized for excellence in engineering, commitment to community impact, and ethical business practices.</p>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</section>-->

        <!-- Careers Support Section -->
        <section class="ls-careers-support py-5 bg-light">
            <div class="container py-5">
                <div class="row align-items-center">
                    <div class="col-lg-6 mb-5 mb-lg-0">
                        <h2 class="h1 fw-bold mb-4" data-aos="fade-up">Building Careers Alongside Infrastructure</h2>
                        <p class="lead mb-4" data-aos="fade-up">At Liberty Scope Ltd, we believe that our greatest asset is our people. We're committed to fostering talent and providing opportunities for professional growth in Uganda's construction and engineering sectors.</p>
                        <div class="d-flex">
                            <div class="me-4">
                                <h3 class="h2 fw-bold text-danger" data-aos="fade-up">50+</h3>
                                <p class="mb-0" data-aos="fade-up">Skilled Professionals</p>
                            </div>
                            <div class="me-4">
                                <h3 class="h2 fw-bold text-danger" data-aos="fade-up">15+</h3>
                                <p class="mb-0" data-aos="fade-up">Engineering Experts</p>
                            </div>
                            <div>
                                <h3 class="h2 fw-bold text-danger" data-aos="fade-up">80%</h3>
                                <p class="mb-0" data-aos="fade-up">Local Workforce</p>
                            </div>
                        </div>
                    </div>
                    <div class="col-lg-6">
                        <img src="https://i.pinimg.com/736x/5e/b7/43/5eb743dfc61221afbaa6aa92181aac9b.jpg" alt="Liberty Scope Team" class="img-fluid rounded-3 shadow-ls">
                    </div>
                </div>
            </div>
        </section>

        <!-- Manager's Message -->
        <!--<section class="ls-manager-message py-5 gradient-primary">-->
        <!--    <div class="container py-5">-->
        <!--        <div class="row justify-content-center">-->
        <!--            <div class="col-lg-8 text-center text-white">-->
        <!--                <div class="ls-manager-image mx-auto mb-4 rounded-circle overflow-hidden" style="width:120px; height:120px;">-->
        <!--                    <img src="https://i.pinimg.com/736x/5c/7c/3c/5c7c3cf03f60cfda2e8017ea2f83c178.jpg" alt="Project Manager" class="img-fluid">-->
        <!--                </div>-->
        <!--                <h2 class="h3 fw-bold mb-3" data-aos="fade-up">Message from Our Project Manager</h2>-->
        <!--                <blockquote class="ls-blockquote fs-4 fst-italic mb-4" data-aos="fade-up">"At Liberty Scope, we don't just build infrastructure—we build futures. Every project is an opportunity to develop skills, empower communities, and create lasting positive impact. Join us in shaping Uganda's tomorrow."</blockquote>-->
        <!--                <div class="ls-manager-info">-->
        <!--                    <h4 class="fw-bold mb-1" data-aos="fade-up">James Mukasa</h4>-->
        <!--                    <p class="mb-0" data-aos="fade-up">Senior Project Manager</p>-->
        <!--                </div>-->
        <!--            </div>-->
        <!--        </div>-->
        <!--    </div>-->
        <!--</section>-->

        
    </div>
    
    <?php
    return ob_get_clean();
}
add_shortcode('liberty_scope_what_we_do', 'liberty_scope_what_we_do_page');

?>