<?php
/**
 * Kipya functions and definitions.
 *
 * @link https://urreno.org
 *
 * @package Kipya
 */
set_time_limit(300); // Set to a higher value if needed
if ( ! function_exists( 'kipya_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 */
	function kipya_setup() {
		// Make the theme available for translation.
		load_theme_textdomain( 'kipya', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

        //Upload Logo in website.
        add_theme_support('custom-logo');

		// Let WordPress manage the document title.
		add_theme_support( 'title-tag' );

		// Enable support for Post Thumbnails on posts and pages.
		add_theme_support( 'post-thumbnails' );

		// Register navigation menus.
		register_nav_menus( array(
			'primary'   => esc_html__( 'Primary Menu', 'kipya' ),
			'top-menu'  => esc_html__( 'Top Menu', 'kipya' ),
            'sidebar'   => esc_html__( 'Sidebar Menu', 'kipya' ),
            'footer'    => esc_html__( 'Footer Menu', 'kipya' ),
		) );

		// Switch default core markup for search form, comment form, and comments to output valid HTML5.
		add_theme_support( 'kipya', array(
			'search-form',
			'comment-form',
			'comment-list',
			'gallery',
			'caption',
		) );

		// Set up the WordPress core custom background feature.
		add_theme_support( 'custom-background', apply_filters( 'kipya_custom_background_args', array(
			'default-color' => 'ffffff',
			'default-image' => '',
		) ) );

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

        /**
		 * Enable support for the following post formats:
		 * aside, gallery, quote, image, and video
		 */
        add_theme_support( 'post-formats', array( 'aside', 'gallery', 'quote', 'image', 'video' ) );
	}
endif;
add_action( 'after_setup_theme', 'kipya_setup' );

// Enqueue styles.
function kipya_styles() {
    wp_register_style('kipya-style', get_template_directory_uri() . '/style.css', array(), '1.0.0', 'all');
    wp_register_style('custom', get_template_directory_uri() . '/assets/css/custom.css', array(), '1.0.0', 'all');
    wp_register_style('animate', get_template_directory_uri() . '/assets/css/animate.css', array(), '4.1.1', 'all');
    wp_register_style('bootstrap.min', get_template_directory_uri() . '/assets/vendor/bootstrap/css/bootstrap.min.css', array(), '5.3.2', 'all');
    wp_register_style('bootstrap-icons', get_template_directory_uri() . '/assets/vendor/bootstrap-icons/font/bootstrap-icons.min.css', array(), '1.11.3', 'all');
    wp_register_style('aos', get_template_directory_uri() . '/assets/vendor/aos/aos.css', array(), '2.3.4', 'all');
    wp_register_style('swiper', get_template_directory_uri() . '/assets/vendor/swiper/swiper.min.css', array(), '5.4.5', 'all');
    wp_register_style('toastr.min', get_template_directory_uri() . '/assets/vendor/toastr/toastr.min.css', array(), '2.1.3', 'all');
    wp_register_style('datatables.min', get_template_directory_uri() . '/assets/vendor/DataTables/datatables.min.css', array(), '1.13.3', 'all');



    wp_enqueue_style( 'kipya-style');
    wp_enqueue_style( 'custom');
    wp_enqueue_style( 'bootstrap.min');
    wp_enqueue_style( 'bootstrap-icons');
    wp_enqueue_style( 'aos');
    wp_enqueue_style( 'swiper');
    wp_enqueue_style( 'toastr.min');
    wp_enqueue_style( 'datatables.min');
}
add_action( 'wp_enqueue_scripts', 'kipya_styles' );

// Enqueue scripts.
function kipya_scripts() {

    wp_enqueue_script( 'bootstrap-script', get_template_directory_uri() . '/assets/vendor/bootstrap/js/bootstrap.bundle.min.js', array(), '4.5.2', 'all');
    wp_enqueue_script( 'aos-script', get_template_directory_uri() . '/assets/vendor/aos/aos.js', array(), '2.3.4', 'all');
    wp_enqueue_script( 'swiper-script', get_template_directory_uri() . '/assets/vendor/swiper/swiper.min.js', array(), '5.4.5', 'all');
    wp_enqueue_script( 'toastr-script', get_template_directory_uri() . '/assets/vendor/toastr/toastr.min.js', array(), '2.1.3', 'all');
    wp_enqueue_script( 'jquery-script', get_template_directory_uri() . '/assets/vendor/jquery/jquery-3.7.1.min.js', array( ), '3.7.1', 'all');
    wp_enqueue_script( 'kipya-script', get_template_directory_uri() . '/assets/js/main.js', array(), '1.0.0', 'all');
    wp_enqueue_script( 'search-script', get_template_directory_uri() . '/assets/js/search.js', array(), '1.0.0', 'all');
    wp_enqueue_script( 'datatables.min', get_template_directory_uri() . '/assets/vendor/DataTables/datatables.min.js', array(), '1.13.3', 'all');

    // Pass the ajaxurl to search.js
    wp_localize_script('search-script', 'kipya_ajax_object', array(
        'ajaxurl' => admin_url('admin-ajax.php'),
    ));
}
//add_action( 'wp_enqueue_scripts', 'kipya_scripts' );
add_action('wp_footer','kipya_scripts');

// ligtbox-gallery
function enqueue_custom_scripts() {
    // Enqueue lightbox library
    wp_enqueue_style('lightbox-css', 'https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/css/lightbox.min.css');
    wp_enqueue_script('lightbox-js', 'https://cdnjs.cloudflare.com/ajax/libs/lightbox2/2.11.3/js/lightbox.min.js', array('jquery'), null, true);

    // Enqueue custom JavaScript
    wp_enqueue_script('custom-gallery-lightbox', get_template_directory_uri() . '/assets/js/gallery-lightbox.js', array('jquery'), null, true);

    // Enqueue custom AJAX script for projects page
    if (is_page('projects-page')) {
        wp_enqueue_script('custom-ajax-script', get_template_directory_uri() . '/assets/js/custom-ajax-script.js', array('jquery'), null, true);
        wp_localize_script('custom-ajax-script', 'ajax_object', array('ajax_url' => admin_url('admin-ajax.php')));
    }
}
add_action('wp_enqueue_scripts', 'enqueue_custom_scripts');

// If Dynamic Sidebar Exists
if (function_exists('register_sidebar'))
{
    // Define Sidebar Widget Area 1
    register_sidebar(array(
        'name' => __('Widget Area 1', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'widget-area-1',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));

    // Define Sidebar Widget Area 2
    register_sidebar(array(
        'name' => __('Widget Area 2', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'widget-area-2',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    
    register_sidebar( array(
        'name'          => esc_html__( 'Top Left', 'kipya' ),
        'id'            => 'topl',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Top Right', 'kipya' ),
        'id'            => 'topr',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Search Area', 'kipya' ),
        'id'            => 'searchi',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Quick Number', 'kipya' ),
        'id'            => 'inno',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Menu Right', 'kipya' ),
        'id'            => 'nav-right',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
    register_sidebar(array(
        'name' => __('Services Sidebar', 'kipya'),
        'description' => __('Description for this widget-area...', 'kipya'),
        'id' => 'servsidebar',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
    register_sidebar( array(
        'name'          => esc_html__( 'Advert Top', 'kipya' ),
        'id'            => 'advtop',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h3 class="widget-title">',
        'after_title'   => '</h3>',
    ) );
     register_sidebar( array(
        'name'          => esc_html__( 'Newsletter', 'kipya' ),
        'id'            => 'footernewz',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer Starter', 'kipya' ),
        'id'            => 'footeri',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer A', 'kipya' ),
        'id'            => 'footera',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer B', 'kipya' ),
        'id'            => 'footerb',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
	register_sidebar( array(
        'name'          => esc_html__( 'Footer C', 'kipya' ),
        'id'            => 'footerc',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
    register_sidebar( array(
        'name'          => esc_html__( 'Footer D', 'kipya' ),
        'id'            => 'footerd',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
     register_sidebar( array(
        'name'          => esc_html__( 'Copyright Links', 'kipya' ),
        'id'            => 'footer-links',
        'description'   => esc_html__( 'Add widgets here.', 'kipya' ),
        'before_widget' => '<section id="%1$s" class="widget %2$s">',
        'after_widget'  => '</section>',
        'before_title'  => '<h4 class="widget-title">',
        'after_title'   => '</h4>',
    ) );
}

//Activate Excerpt in PAGES
function enable_page_excerpts() {
    add_post_type_support('page', 'excerpt');
}
add_action('init', 'enable_page_excerpts');

/*
**************************
*************************
Gallery functionality
*************************
*************************
*/
function load_custom_single_template($template) {
    if (is_single() && in_category('photo-gallery')) {
        $new_template = locate_template(array('single-gallery.php'));
        if ($new_template) {
            return $new_template;
        }
    }
    if (is_singular('events')) {
        $eve_template = locate_template(array('single-event.php'));
        if ($eve_template) {
            return $eve_template;
        }
    }
    return $template;
}
add_filter('single_template', 'load_custom_single_template');

function force_gallery_links_to_media($block_content, $block) {
    if ($block['blockName'] === 'core/gallery' && !empty($block['innerBlocks'])) {
        foreach ($block['innerBlocks'] as &$innerBlock) {
            if ($innerBlock['blockName'] === 'core/image' && isset($innerBlock['attrs']['id'])) {
                $image_id = $innerBlock['attrs']['id'];
                $image_url = wp_get_attachment_url($image_id);
                if ($image_url) {
                    $innerBlock['attrs']['linkDestination'] = 'media';
                    $innerBlock['attrs']['href'] = $image_url;
                }
            }
        }
    }
    return $block_content;
}
add_filter('render_block', 'force_gallery_links_to_media', 10, 2);

//Custom BOOTSTRAP Menu 
include get_template_directory() . '/inc/bootstrap-5-wordpress-navbar-walker.php';
include get_template_directory() . '/inc/custom-nav-walker.php';

//Custom Post Type :: SEO 
include get_template_directory() . '/inc/seo-post-types.php';

//Custom Post Type :: SEARCH
include get_template_directory() . '/inc/ajax-search.php';

//Custom Post Type :: SLIDING PHOTOS 
include get_template_directory() . '/inc/slides-post-types.php';

//Add Page Category
include get_template_directory() . '/inc/add_page_category.php';

//Custom Post Type :: DOWNLOADS
include get_template_directory() . '/inc/downloads-post-types.php';
include get_template_directory() . '/inc/youtube-playlist.php';
//Custom Post Type :: TEAMS
include get_template_directory() . '/inc/team-post-types.php';

//Custom Post Type :: PARTNERS
include get_template_directory() . '/inc/partners-post-types.php';
//Custom Post Type :: directory
include get_template_directory() . '/inc/directory-post-types.php';

//Custom Post Type :: upcoming-events
include get_template_directory() . '/inc/upcoming-events-post-types.php';

// Shortcode :: AOS
include get_template_directory() . '/inc/aos-animation.php'; 


//Breadcrumb
include get_template_directory() . '/inc/breadcrumbs.php'; 

//Accordion
include get_template_directory() . '/inc/accordion.php';

//ALL News Shortcode
include get_template_directory() . '/inc/all_news-shortcode.php'; 
include get_template_directory() . '/inc/group-posttype.php'; 


//Duplicate Pages
include get_template_directory() . '/inc/duplicate-page.php'; 
include get_template_directory() . '/inc/publications.php'; 

//ALL Associates Shortcode
include get_template_directory() . '/inc/all_partners-page.php'; 

//All Liberty Scope Shortcode
include get_template_directory() . '/inc/activity-shortcode.php';
include get_template_directory() . '/inc/about-us.php';
include get_template_directory() . '/inc/general-pages.php';
include get_template_directory() . '/inc/allprojects-shortcode.php';

// //FORM PROCESSOR
// include get_template_directory() . '/inc/process-form.php'; 

function allow_video_featured_image($mime_types) {
    // Allow video formats for uploads
    $mime_types['mp4'] = 'video/mp4';
    $mime_types['webm'] = 'video/webm';
    $mime_types['ogg'] = 'video/ogg';
    return $mime_types;
}
add_filter('upload_mimes', 'allow_video_featured_image');


//BACK BUTTON (previous page)
add_action( 'back_button', 'kipya_back_button' );
function kipya_back_button() {
    if ( wp_get_referer() ) {
        $back_text = __( '&laquo; BACK' );
        $button    = "\n<button id='my-back-button' class='btn button my-back-button' onclick='javascript:history.back()'>$back_text</button>";
        echo ( $button );
    }
}

// Pagination for paged posts, Page 1, Page 2, Page 3, with Next and Previous Links, No plugin
function html5wp_pagination()
{
    global $wp_query;
    $big = 999999999;
    echo paginate_links(array(
        'base' => str_replace($big, '%#%', get_pagenum_link($big)),
        'format' => '?paged=%#%',
        'current' => max(1, get_query_var('paged')),
        'total' => $wp_query->max_num_pages
    ));
}

// Custom Excerpts
function html5wp_index($length) // Create 20 Word Callback for Index page Excerpts, call using html5wp_excerpt('html5wp_index');
{
    return 50;
}

// Create 40 Word Callback for Custom Post Excerpts, call using html5wp_excerpt('html5wp_custom_post');
function html5wp_custom_post($length)
{
    return 50;
}

//Allow upload of SVG Images
function enable_svg_support($mimes) {
    $mimes['svg'] = 'image/svg+xml';
    return $mimes;
}
add_filter('upload_mimes', 'enable_svg_support');

// Create the Custom Excerpts callback
function html5wp_excerpt($length_callback = '', $more_callback = '')
{
    global $post;
    if (function_exists($length_callback)) {
        add_filter('excerpt_length', $length_callback);
    }
    if (function_exists($more_callback)) {
        add_filter('excerpt_more', $more_callback);
    }
    $output = get_the_excerpt();
    $output = apply_filters('wptexturize', $output);
    $output = apply_filters('convert_chars', $output);
    $output = '<p>' . $output . '</p>';
    echo $output;
}

// Custom View Article link to Post
function html5_blank_view_article($more)
{
    global $post;
    return '... <a class="view-article" href="' . get_permalink($post->ID) . '">' . __('Read More', 'kipya') . '</a>';
}

// Remove Admin bar
function remove_admin_bar() {
    return false;
}
add_filter('show_admin_bar', 'remove_admin_bar');

// Remove 'text/css' from our enqueued stylesheet
function html5_style_remove($tag)
{
    return preg_replace('~\s+type=["\'][^"\']++["\']~', '', $tag);
}

// Remove thumbnail width and height dimensions that prevent fluid images in the_thumbnail
function remove_thumbnail_dimensions( $html )
{
    $html = preg_replace('/(width|height)=\"\d*\"\s/', "", $html);
    return $html;
}


/**
 * Load custom post types
 */
require_once get_template_directory() . '/inc/custom-post-types/load.php';

function rotary_enqueue_font_awesome() {
    wp_enqueue_style('font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', array(), '6.4.0');
}
add_action('wp_enqueue_scripts', 'rotary_enqueue_font_awesome');


function mytheme_enqueue_scroll_effect() {
    // Enqueue your JS
    wp_enqueue_script(
        'fadeup-effect', // Handle name
        get_template_directory_uri() . 'assets/js/main.js', // File path
        array(), 
        null, 
        true 
    );
}
add_action('wp_enqueue_scripts', 'mytheme_enqueue_scroll_effect');

add_action( 'wp_ajax_nopriv_live_search', 'live_search_callback' );
add_action( 'wp_ajax_live_search', 'live_search_callback' );

function live_search_callback() {
  $term = isset( $_GET['term'] ) ? sanitize_text_field( $_GET['term'] ) : '';

  $args = array(
    's'              => $term,
    'post_status'    => 'publish',
    'posts_per_page' => 5
  );

  $query = new WP_Query( $args );

  if ( $query->have_posts() ) {
    echo '<ul class="list-unstyled m-0">';
    while ( $query->have_posts() ) {
      $query->the_post();
      echo '<li><a href="' . get_permalink() . '">' . get_the_title() . '</a></li>';
    }
    echo '</ul>';
  } else {
    echo '<p class="m-0">No results found.</p>';
  }

  wp_die();
}

function register_my_menu() {
  register_nav_menu('primary', 'Primary Menu');
}
add_action('after_setup_theme', 'register_my_menu');






// Add meta boxes for service template
function add_service_meta_boxes() {
    add_meta_box('service_hero_meta', 'Hero Section', 'service_hero_meta_callback', 'page', 'normal', 'high');
    add_meta_box('service_services_meta', 'Services Section', 'service_services_meta_callback', 'page', 'normal', 'high');
    add_meta_box('service_process_meta', 'Process Section', 'service_process_meta_callback', 'page', 'normal', 'high');
}
add_action('add_meta_boxes', 'add_service_meta_boxes');

// Hero section meta box
function service_hero_meta_callback($post) {
    wp_nonce_field('service_meta_box', 'service_meta_box_nonce');
    
    $hero_title = get_post_meta($post->ID, '_service_hero_title', true);
    $hero_subtitle = get_post_meta($post->ID, '_service_hero_subtitle', true);
    $hero_description = get_post_meta($post->ID, '_service_hero_description', true);
    $stats_projects = get_post_meta($post->ID, '_service_stats_projects', true);
    $stats_success = get_post_meta($post->ID, '_service_stats_success', true);
    $stats_years = get_post_meta($post->ID, '_service_stats_years', true);
    $hero_image = get_post_meta($post->ID, '_service_hero_image', true);
    
    echo '<p><label for="service_hero_title">Hero Title:</label>';
    echo '<input type="text" id="service_hero_title" name="service_hero_title" value="' . esc_attr($hero_title) . '" style="width:100%;"></p>';
    
    echo '<p><label for="service_hero_subtitle">Hero Subtitle:</label>';
    echo '<input type="text" id="service_hero_subtitle" name="service_hero_subtitle" value="' . esc_attr($hero_subtitle) . '" style="width:100%;"></p>';
    
    echo '<p><label for="service_hero_description">Hero Description:</label>';
    echo '<textarea id="service_hero_description" name="service_hero_description" style="width:100%;height:100px;">' . esc_textarea($hero_description) . '</textarea></p>';
    
    echo '<div style="display:flex;gap:20px;margin-bottom:20px;">';
    echo '<div><label for="service_stats_projects">Projects Completed:</label>';
    echo '<input type="number" id="service_stats_projects" name="service_stats_projects" value="' . esc_attr($stats_projects) . '" style="width:100%;"></div>';
    
    echo '<div><label for="service_stats_success">Success Rate (%):</label>';
    echo '<input type="number" id="service_stats_success" name="service_stats_success" value="' . esc_attr($stats_success) . '" style="width:100%;"></div>';
    
    echo '<div><label for="service_stats_years">Years Experience:</label>';
    echo '<input type="number" id="service_stats_years" name="service_stats_years" value="' . esc_attr($stats_years) . '" style="width:100%;"></div>';
    echo '</div>';
    
    echo '<p><label for="service_hero_image">Hero Image URL:</label>';
    echo '<input type="text" id="service_hero_image" name="service_hero_image" value="' . esc_attr($hero_image) . '" style="width:80%;">';
    echo '<button type="button" class="button" id="service_hero_image_button" style="margin-left:10px;">Upload Image</button></p>';
    echo '<script>
    jQuery(document).ready(function($){
        $("#service_hero_image_button").click(function(e) {
            e.preventDefault();
            var image = wp.media({ 
                title: "Upload Image",
                multiple: false
            }).open()
            .on("select", function(e){
                var uploaded_image = image.state().get("selection").first();
                var image_url = uploaded_image.toJSON().url;
                $("#service_hero_image").val(image_url);
            });
        });
    });
    </script>';
}

// Services section meta box
function service_services_meta_callback($post) {
    for ($i = 1; $i <= 3; $i++) {
        $service_title = get_post_meta($post->ID, '_service_' . $i . '_title', true);
        $service_description = get_post_meta($post->ID, '_service_' . $i . '_description', true);
        $service_list_1 = get_post_meta($post->ID, '_service_' . $i . '_list_1', true);
        $service_list_2 = get_post_meta($post->ID, '_service_' . $i . '_list_2', true);
        $service_list_3 = get_post_meta($post->ID, '_service_' . $i . '_list_3', true);
        $service_icon = get_post_meta($post->ID, '_service_' . $i . '_icon', true);
        
        echo '<div style="border:1px solid #ddd;padding:15px;margin-bottom:20px;">';
        echo '<h3>Service ' . $i . '</h3>';
        
        echo '<p><label for="service_' . $i . '_title">Service Title:</label>';
        echo '<input type="text" id="service_' . $i . '_title" name="service_' . $i . '_title" value="' . esc_attr($service_title) . '" style="width:100%;"></p>';
        
        echo '<p><label for="service_' . $i . '_description">Service Description:</label>';
        echo '<textarea id="service_' . $i . '_description" name="service_' . $i . '_description" style="width:100%;height:80px;">' . esc_textarea($service_description) . '</textarea></p>';
        
        echo '<p><label for="service_' . $i . '_icon">FontAwesome Icon Class:</label>';
        echo '<input type="text" id="service_' . $i . '_icon" name="service_' . $i . '_icon" value="' . esc_attr($service_icon) . '" style="width:100%;" placeholder="fas fa-water">';
        echo '<small>Find icons at <a href="https://fontawesome.com/icons" target="_blank">FontAwesome</a></small></p>';
        
        echo '<p><label>List Items:</label>';
        echo '<input type="text" id="service_' . $i . '_list_1" name="service_' . $i . '_list_1" value="' . esc_attr($service_list_1) . '" style="width:100%;margin-bottom:5px;" placeholder="List item 1">';
        echo '<input type="text" id="service_' . $i . '_list_2" name="service_' . $i . '_list_2" value="' . esc_attr($service_list_2) . '" style="width:100%;margin-bottom:5px;" placeholder="List item 2">';
        echo '<input type="text" id="service_' . $i . '_list_3" name="service_' . $i . '_list_3" value="' . esc_attr($service_list_3) . '" style="width:100%;" placeholder="List item 3"></p>';
        
        echo '</div>';
    }
}

// Process section meta box
function service_process_meta_callback($post) {
    for ($i = 1; $i <= 4; $i++) {
        $process_title = get_post_meta($post->ID, '_process_' . $i . '_title', true);
        $process_description = get_post_meta($post->ID, '_process_' . $i . '_description', true);
        
        echo '<div style="border:1px solid #ddd;padding:15px;margin-bottom:20px;">';
        echo '<h3>Process Step ' . $i . '</h3>';
        
        echo '<p><label for="process_' . $i . '_title">Step Title:</label>';
        echo '<input type="text" id="process_' . $i . '_title" name="process_' . $i . '_title" value="' . esc_attr($process_title) . '" style="width:100%;"></p>';
        
        echo '<p><label for="process_' . $i . '_description">Step Description:</label>';
        echo '<textarea id="process_' . $i . '_description" name="process_' . $i . '_description" style="width:100%;height:80px;">' . esc_textarea($process_description) . '</textarea></p>';
        
        echo '</div>';
    }
}



// Save meta box data
function save_service_meta_boxes($post_id) {
    if (!isset($_POST['service_meta_box_nonce']) || !wp_verify_nonce($_POST['service_meta_box_nonce'], 'service_meta_box')) {
        return;
    }
    
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    
    if (!current_user_can('edit_page', $post_id)) {
        return;
    }
    
    // Save hero data
    if (isset($_POST['service_hero_title'])) {
        update_post_meta($post_id, '_service_hero_title', sanitize_text_field($_POST['service_hero_title']));
    }
    if (isset($_POST['service_hero_subtitle'])) {
        update_post_meta($post_id, '_service_hero_subtitle', sanitize_text_field($_POST['service_hero_subtitle']));
    }
    if (isset($_POST['service_hero_description'])) {
        update_post_meta($post_id, '_service_hero_description', sanitize_textarea_field($_POST['service_hero_description']));
    }
    if (isset($_POST['service_stats_projects'])) {
        update_post_meta($post_id, '_service_stats_projects', sanitize_text_field($_POST['service_stats_projects']));
    }
    if (isset($_POST['service_stats_success'])) {
        update_post_meta($post_id, '_service_stats_success', sanitize_text_field($_POST['service_stats_success']));
    }
    if (isset($_POST['service_stats_years'])) {
        update_post_meta($post_id, '_service_stats_years', sanitize_text_field($_POST['service_stats_years']));
    }
    if (isset($_POST['service_hero_image'])) {
        update_post_meta($post_id, '_service_hero_image', esc_url_raw($_POST['service_hero_image']));
    }
    
    // Save services data
    for ($i = 1; $i <= 3; $i++) {
        if (isset($_POST['service_' . $i . '_title'])) {
            update_post_meta($post_id, '_service_' . $i . '_title', sanitize_text_field($_POST['service_' . $i . '_title']));
        }
        if (isset($_POST['service_' . $i . '_description'])) {
            update_post_meta($post_id, '_service_' . $i . '_description', sanitize_textarea_field($_POST['service_' . $i . '_description']));
        }
        if (isset($_POST['service_' . $i . '_list_1'])) {
            update_post_meta($post_id, '_service_' . $i . '_list_1', sanitize_text_field($_POST['service_' . $i . '_list_1']));
        }
        if (isset($_POST['service_' . $i . '_list_2'])) {
            update_post_meta($post_id, '_service_' . $i . '_list_2', sanitize_text_field($_POST['service_' . $i . '_list_2']));
        }
        if (isset($_POST['service_' . $i . '_list_3'])) {
            update_post_meta($post_id, '_service_' . $i . '_list_3', sanitize_text_field($_POST['service_' . $i . '_list_3']));
        }
        if (isset($_POST['service_' . $i . '_icon'])) {
            update_post_meta($post_id, '_service_' . $i . '_icon', sanitize_text_field($_POST['service_' . $i . '_icon']));
        }
    }
    
    // Save process data
    for ($i = 1; $i <= 4; $i++) {
        if (isset($_POST['process_' . $i . '_title'])) {
            update_post_meta($post_id, '_process_' . $i . '_title', sanitize_text_field($_POST['process_' . $i . '_title']));
        }
        if (isset($_POST['process_' . $i . '_description'])) {
            update_post_meta($post_id, '_process_' . $i . '_description', sanitize_textarea_field($_POST['process_' . $i . '_description']));
        }
    }
    
    // Save testimonials data
    for ($i = 1; $i <= 3; $i++) {
        if (isset($_POST['testimonial_' . $i . '_text'])) {
            update_post_meta($post_id, '_testimonial_' . $i . '_text', sanitize_textarea_field($_POST['testimonial_' . $i . '_text']));
        }
        if (isset($_POST['testimonial_' . $i . '_author'])) {
            update_post_meta($post_id, '_testimonial_' . $i . '_author', sanitize_text_field($_POST['testimonial_' . $i . '_author']));
        }
        if (isset($_POST['testimonial_' . $i . '_role'])) {
            update_post_meta($post_id, '_testimonial_' . $i . '_role', sanitize_text_field($_POST['testimonial_' . $i . '_role']));
        }
    }
}
add_action('save_post', 'save_service_meta_boxes');




// 1. Allow a query var we can use in the read-more links
function mytheme_add_query_var( $vars ) {
    $vars[] = 'project_view';
    return $vars;
}
add_filter( 'query_vars', 'mytheme_add_query_var' );

// 2. Helper to build the read-more URL (use this in allprojects-shortcode.php)
function mytheme_project_read_more_url( $post_id = 0 ) {
    if ( ! $post_id ) {
        $post_id = get_the_ID();
    }
    $permalink = get_permalink( $post_id );
    // Append query var so we can detect it and load the custom template
    $url = add_query_arg( 'project_view', $post_id, $permalink );
    return esc_url( $url );
}

// 3. Load custom template when query var is present
function mytheme_load_project_template( $template ) {
    // Only act when our query var is present
    $project_view = get_query_var( 'project_view' );
    if ( empty( $project_view ) ) {
        return $template;
    }

    // optionally validate the ID
    $post = get_post( intval( $project_view ) );
    if ( ! $post || 'publish' !== $post->post_status ) {
        return $template;
    }

    // Path to your custom template file inside the active theme
    $custom_template = get_stylesheet_directory() . '/single-project-template.php';

    if ( file_exists( $custom_template ) ) {
        return $custom_template;
    }

    return $template;
}
add_filter( 'template_include', 'mytheme_load_project_template', 99 );

function sidebar_projects_shortcode() {
    ob_start();

    $projects_args = array(
        'post_type' => array('post'),
        'posts_per_page' => 4,
        'category_name' => 'projects',
        'orderby' => 'rand', // This makes it random
        'meta_query' => array(
            array(
                'key' => '_thumbnail_id', // Only posts with featured images
                'compare' => 'EXISTS'
            )
        )
    );
    
    $projects_query = new WP_Query($projects_args); ?>

    <?php if ($projects_query->have_posts()) : ?>
        <div class="sidebar-gallery mb-4">
            <h5 class="text-white mb-3">Projects</h5>
            <div class="row g-2">
                <?php while ($projects_query->have_posts()) :
                    $projects_query->the_post();
                    $project_url = esc_url(add_query_arg('project_view', get_the_ID(), get_permalink()));
                    $featured_image = has_post_thumbnail() ? esc_url(get_the_post_thumbnail_url(get_the_ID(), 'medium')) : esc_url(get_template_directory_uri() . '/assets/images/photo-placeholder.jpg');
                    $alt_text = get_the_title() ? esc_attr(get_the_title()) : 'Project Image';
                ?>
                <div class="col-6">
                    <div class="gallery-item">
                        <a href="<?php echo $project_url; ?>">
                            <img src="<?php echo $featured_image; ?>" alt="<?php echo $alt_text; ?>" class="img-fluid rounded">
                        </a>
                    </div>
                </div>
                <?php endwhile;
                wp_reset_postdata();
                ?>
            </div>
        </div>
    <?php endif; ?>

    <?php
    return ob_get_clean();
}
add_shortcode('sidebar_projects', 'sidebar_projects_shortcode');

// Add Gallery Metabox
function ls_add_gallery_metabox() {
    add_meta_box(
        'ls_gallery_metabox',
        'Gallery Images',
        'ls_gallery_metabox_callback',
        array('post', 'projects'), // Add to posts and custom post types
        'normal',
        'high'
    );
}
add_action('add_meta_boxes', 'ls_add_gallery_metabox');

// Metabox Callback Function
function ls_gallery_metabox_callback($post) {
    wp_nonce_field('ls_gallery_metabox', 'ls_gallery_metabox_nonce');
    $gallery_images = get_post_meta($post->ID, 'gallery_images', true);
    ?>
    <div id="ls-gallery-container">
        <p><strong>Add images to the gallery:</strong></p>
        <button type="button" class="button button-primary" id="ls-add-gallery-images">Add Images</button>
        <button type="button" class="button" id="ls-clear-gallery">Clear All</button>
        <div id="ls-gallery-images-container" style="margin-top: 15px; border: 1px dashed #ccc; padding: 15px; min-height: 100px;">
            <?php if (!empty($gallery_images) && is_array($gallery_images)): ?>
                <?php foreach ($gallery_images as $index => $image): ?>
                    <div class="ls-gallery-item" style="display: inline-block; margin: 8px; position: relative; border: 2px solid #ddd; border-radius: 4px;" data-index="<?php echo $index; ?>">
                        <img src="<?php echo esc_url($image['thumbnail']); ?>" style="width: 80px; height: 80px; object-fit: cover; display: block;">
                        <input type="hidden" name="gallery_images[<?php echo $index; ?>][image]" value="<?php echo esc_url($image['image']); ?>">
                        <input type="hidden" name="gallery_images[<?php echo $index; ?>][thumbnail]" value="<?php echo esc_url($image['thumbnail']); ?>">
                        <input type="hidden" name="gallery_images[<?php echo $index; ?>][title]" value="<?php echo esc_attr($image['title'] ?? ''); ?>">
                        <input type="hidden" name="gallery_images[<?php echo $index; ?>][caption]" value="<?php echo esc_attr($image['caption'] ?? ''); ?>">
                        <button type="button" class="ls-remove-image button-link" style="position: absolute; top: -8px; right: -8px; background: #dc3232; color: white; border-radius: 50%; width: 20px; height: 20px; border: none; cursor: pointer; font-size: 14px; line-height: 1;">×</button>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <p style="text-align: center; color: #666; font-style: italic;">No images added yet. Click "Add Images" to get started.</p>
            <?php endif; ?>
        </div>
        <p><small>You can select multiple images at once. Drag to reorder (coming soon).</small></p>
    </div>
    
    <script>
    jQuery(document).ready(function($) {
        var mediaUploader;
        var galleryContainer = $('#ls-gallery-images-container');
        
        // Function to update indices after removal
        function updateIndices() {
            galleryContainer.find('.ls-gallery-item').each(function(newIndex) {
                $(this).attr('data-index', newIndex);
                $(this).find('input[type="hidden"]').each(function() {
                    var name = $(this).attr('name');
                    if (name) {
                        var newName = name.replace(/gallery_images\[\d+\]/, 'gallery_images[' + newIndex + ']');
                        $(this).attr('name', newName);
                    }
                });
            });
        }
        
        // Add images
        $('#ls-add-gallery-images').click(function(e) {
            e.preventDefault();
            
            // Remove empty message if exists
            galleryContainer.find('p').remove();
            
            if (mediaUploader) {
                mediaUploader.open();
                return;
            }
            
            mediaUploader = wp.media({
                title: 'Select Gallery Images',
                button: { text: 'Add to Gallery' },
                multiple: true,
                library: { type: 'image' }
            });
            
            mediaUploader.on('select', function() {
                var attachments = mediaUploader.state().get('selection').toJSON();
                var currentCount = galleryContainer.find('.ls-gallery-item').length;
                
                attachments.forEach(function(attachment, index) {
                    var itemIndex = currentCount + index;
                    var imageUrl = attachment.sizes.large ? attachment.sizes.large.url : attachment.url;
                    var thumbnailUrl = attachment.sizes.medium ? attachment.sizes.medium.url : attachment.url;
                    var thumbDisplay = attachment.sizes.thumbnail ? attachment.sizes.thumbnail.url : thumbnailUrl;
                    
                    var itemHtml = '<div class="ls-gallery-item" style="display: inline-block; margin: 8px; position: relative; border: 2px solid #ddd; border-radius: 4px;" data-index="' + itemIndex + '">' +
                        '<img src="' + thumbDisplay + '" style="width: 80px; height: 80px; object-fit: cover; display: block;">' +
                        '<input type="hidden" name="gallery_images[' + itemIndex + '][image]" value="' + imageUrl + '">' +
                        '<input type="hidden" name="gallery_images[' + itemIndex + '][thumbnail]" value="' + thumbnailUrl + '">' +
                        '<input type="hidden" name="gallery_images[' + itemIndex + '][title]" value="' + (attachment.title || '') + '">' +
                        '<input type="hidden" name="gallery_images[' + itemIndex + '][caption]" value="' + (attachment.caption || '') + '">' +
                        '<button type="button" class="ls-remove-image button-link" style="position: absolute; top: -8px; right: -8px; background: #dc3232; color: white; border-radius: 50%; width: 20px; height: 20px; border: none; cursor: pointer; font-size: 14px; line-height: 1;">×</button>' +
                        '</div>';
                    galleryContainer.append(itemHtml);
                });
                
                // Show success message
                var successMsg = $('<div class="notice notice-success" style="margin: 10px 0; padding: 5px 10px;"><p>Images added successfully!</p></div>');
                $('#ls-gallery-container').prepend(successMsg);
                setTimeout(function() { successMsg.fadeOut(); }, 3000);
            });
            
            mediaUploader.open();
        });
        
        // Remove single image
        $(document).on('click', '.ls-remove-image', function(e) {
            e.preventDefault();
            $(this).parent().fadeOut(300, function() {
                $(this).remove();
                updateIndices();
                
                // Show empty message if no images left
                if (galleryContainer.find('.ls-gallery-item').length === 0) {
                    galleryContainer.html('<p style="text-align: center; color: #666; font-style: italic;">No images added yet. Click "Add Images" to get started.</p>');
                }
            });
        });
        
        // Clear all images
        $('#ls-clear-gallery').click(function(e) {
            e.preventDefault();
            if (confirm('Are you sure you want to remove all gallery images?')) {
                galleryContainer.find('.ls-gallery-item').fadeOut(300, function() {
                    $(this).remove();
                    galleryContainer.html('<p style="text-align: center; color: #666; font-style: italic;">No images added yet. Click "Add Images" to get started.</p>');
                });
            }
        });
    });
    </script>
    <?php
}

// Save Gallery Metabox Data
function ls_save_gallery_metabox($post_id) {
    if (!isset($_POST['ls_gallery_metabox_nonce']) || !wp_verify_nonce($_POST['ls_gallery_metabox_nonce'], 'ls_gallery_metabox')) {
        return;
    }
    
    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }
    
    if (!current_user_can('edit_post', $post_id)) {
        return;
    }
    
    if (isset($_POST['gallery_images'])) {
        update_post_meta($post_id, 'gallery_images', $_POST['gallery_images']);
    } else {
        delete_post_meta($post_id, 'gallery_images');
    }
}
add_action('save_post', 'ls_save_gallery_metabox');
?>