<?php /* Template Name: Services Pages Template */ 
get_header(); 
include get_template_directory() . '/inc/menus/menu.php'; 
?>
<main role="main">
    <?php $backgroundImg = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID), 'full'); ?>
    <div class="header-wrap1" style="background: linear-gradient(to top, rgba(0, 0, 0, 0.95), rgba(0, 0, 0, 0)), url('<?php echo $backgroundImg[0]; ?>') no-repeat; background-size: cover; background-position: center center;">
        <div class="container">
            <div class="row">
                <div class="col-lg-8 text-center" data-aos="fade-up">
                    <h1 class="news-title aos-init aos-animate"><?php the_title(); ?></h1>
                </div>
                <div class="col-md-5 col-sm-5 align-self-center breadcrumb" data-aos="fade-up">
                    <?php custom_breadcrumb(); ?>
                </div>
            </div>
        </div>
    </div>

    <div class="kpy_intro_curve">
        <img src="https://lwegatech.net/bhf/wp-content/uploads/2025/03/svg_image.png" alt="Wave SVG">
    </div>

    <section>
        <div class="content-area container" data-aos="fade-up">
            <div class="row">
                <div class="col-lg-9 col-md-9 col-sm-9">
                    <div class="post-content">
                        <?php the_content(); ?>
                    </div>
                </div>         
                <div class="col-lg-3 col-md-3 col-sm-3">
                    <h3>Related Projects</h3>
                    <?php include get_template_directory() . '/inc/related-news.php'; ?>
                    <div class="about-side">
                        <ul class="navbar-nav mx-auto mb-2 mb-md-0">
                            <li class="menu-item nav-item"><a href="#" class="nav-link">Event Activities</a></li>
                            <li class="menu-item nav-item"><a href="#" class="nav-link">Speakers</a></li>
                            <li class="menu-item nav-item"><a href="#" class="nav-link">How to Register</a></li>
                            <li class="menu-item nav-item"><a href="#" class="nav-link">Accredited Delegates</a></li>
                        </ul>
                    </div>
                </div>
            </div>
            <?php edit_post_link(); ?>
        </div>
    </section>
</main>
<?php get_footer(); ?>
