<?php

function webinar_events_shortcode() {
    ob_start();

$args = [
    'post_type'      => 'events',
    'posts_per_page' => 1,
    'tax_query'      => [
        [
            'taxonomy' => 'event_category', 
            'field'    => 'slug',
            'terms'    => 'cdp',
        ],
    ],
];

$event_query = new WP_Query($args);

if ($event_query->have_posts()) :
    while ($event_query->have_posts()) : $event_query->the_post();
        $post_id = get_the_ID();
        $location =  get_post_meta(get_the_ID(), '_location', true);
        $start_date = get_post_meta(get_the_ID(), '_start_date', true);
        $formatted_start_date = date('jS, F Y', strtotime($start_date)); // Format for Date
        $formatted_start_month = date('F', strtotime($start_date)); // Format for Month
        $formatted_start_time = date('g:i A', strtotime($start_date)); // Format for Time
        $event_timestamp = strtotime($start_date);
        $datetime_iso = date('Y-m-d\TH:i:s', $event_timestamp);
        ?>
        <div class="event-banner">
            <a href="<?= the_permalink(); ?>" style="cursor: pointer;">
            <div class="card">
                <div class="card-image">
                        <?php if (has_post_thumbnail()) : ?>
                            <?php the_post_thumbnail('large', ['class' => 'event-photo img-fluid']); ?>
                        <?php endif; ?>
                </div>
                <div class="card-body"></div>
            </div>
            </a>
        </div>
    <?php
    endwhile;
    wp_reset_postdata();
endif;

return ob_get_clean();
}

add_shortcode('cdp-banner', 'webinar_events_shortcode');
?>

