<?php //Custom Post Type :: SLIDING TEXT WITH STATIC PHOTO or VIDEO

function register_text_slider_post_type() {
    register_post_type('text_slider',
        array(
            'labels'      => array(
                'name'          => __('Text Sliders'),
                'singular_name' => __('Text Slider'),
            ),
            'public'      => true,
            'menu_icon'   => 'dashicons-slides',
            'supports'    => array('title', 'editor', 'thumbnail'),
            'menu_position' => 5,
        )
    );
}
add_action('init', 'register_text_slider_post_type');

//Add Custom Fields (Meta Box)
function text_slider_meta_boxes() {
    add_meta_box('text_slider_meta', 'Text Slider Details', 'text_slider_meta_callback', 'text_slider', 'normal', 'high');
}
add_action('add_meta_boxes', 'text_slider_meta_boxes');

function text_slider_meta_callback($post) {
    $subtitles = get_post_meta($post->ID, '_subtitles', true);
    $link = get_post_meta($post->ID, '_slider_link', true);
    $video_url = get_post_meta($post->ID, '_video_url', true);
    ?>

    <p><strong>Upload Video URL (Optional):</strong></p>
    <input type="text" name="video_url" value="<?php echo esc_url($video_url); ?>" style="width: 100%;" placeholder="https://yourvideo.mp4" />

    <p><strong>Enter up to 4 Subtitles:</strong></p>
    <?php for ($i = 0; $i < 4; $i++) { ?>
        <input type="text" name="subtitles[]" value="<?php echo esc_attr($subtitles[$i] ?? ''); ?>" style="width: 100%; margin-bottom: 10px;" />
    <?php } ?>

    <p><strong>Button Link:</strong></p>
    <input type="text" name="slider_link" value="<?php echo esc_url($link); ?>" style="width: 100%;" placeholder="https://example.com" />

    <?php
}

function save_text_slider_meta($post_id) {
    if (isset($_POST['subtitles'])) {
        update_post_meta($post_id, '_subtitles', array_map('sanitize_text_field', $_POST['subtitles']));
    }
    if (isset($_POST['slider_link'])) {
        update_post_meta($post_id, '_slider_link', esc_url($_POST['slider_link']));
    }
    if (isset($_POST['video_url'])) {
        update_post_meta($post_id, '_video_url', esc_url($_POST['video_url']));
    }
}
add_action('save_post', 'save_text_slider_meta');


//Shortcode Display Slider
function text_slider_shortcode() {
    $args = array(
        'post_type'      => 'text_slider',
        'posts_per_page' => 1, // Only one slider at a time
        'orderby'        => 'date',
        'order'          => 'DESC',
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        ob_start();

        while ($query->have_posts()) {
            $query->the_post();
            $background = get_the_post_thumbnail_url(get_the_ID(), 'full');
            $video = get_post_meta(get_the_ID(), '_video_url', true);
            $title = get_the_title();
            $subtitles = get_post_meta(get_the_ID(), '_subtitles', true);
            $link = get_post_meta(get_the_ID(), '_slider_link', true);
        }

        wp_reset_postdata();
        ?>

        <div class="text-slider">
            <?php if ($video) : ?>
                <video autoplay loop muted playsinline class="slider-video">
                    <source src="<?php echo esc_url($video); ?>" type="video/mp4">
                    Your browser does not support the video tag.
                </video>
            <?php else : ?>
                <div class="slider-bg" style="background-image: url('<?php echo esc_url($background); ?>');"></div>
            <?php endif; ?>

            <div class="overlay">
                <h2 class="main-title"><?php echo esc_html($title); ?></h2>
                <h3 id="changing-subtitle" class="subtitle"></h3>
                <?php if (!empty($link)) : ?>
                    <a href="<?php echo esc_url($link); ?>" class="slider-btn">Learn More</a>
                <?php endif; ?>
            </div>
        </div>

        <script>
            document.addEventListener("DOMContentLoaded", function() {
                let subtitles = <?php echo json_encode($subtitles); ?>;
                let subtitleElement = document.getElementById("changing-subtitle");
                let index = 0;

                function typeWriter(text, i, callback) {
                    if (i < text.length) {
                        subtitleElement.innerHTML += text.charAt(i);
                        setTimeout(() => typeWriter(text, i + 1, callback), 100);
                    } else {
                        setTimeout(callback, 2000);
                    }
                }

                function changeSubtitle() {
                    subtitleElement.innerHTML = "";
                    typeWriter(subtitles[index], 0, function() {
                        index = (index + 1) % subtitles.length;
                        setTimeout(changeSubtitle, 1000);
                    });
                }

                changeSubtitle();
            });
        </script>

        <style>
            .text-slider {
                position: relative;
                width: 100%;
                height: 500px;
                overflow: hidden;
                display: flex;
                align-items: center;
                justify-content: center;
                text-align: center;
                color: white;
            }
            .slider-bg {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                background-size: cover;
                background-position: center;
            }
            .slider-video {
                position: absolute;
                top: 0;
                left: 0;
                width: 100%;
                height: 100%;
                object-fit: cover;
            }
            .overlay {
                position: relative;
                background: rgba(0, 0, 0, 0.6);
                padding: 30px;
                border-radius: 10px;
            }
            .main-title {
                font-size: 40px;
                margin-bottom: 10px;
            }
            .subtitle {
                font-size: 24px;
                height: 30px;
            }
            .slider-btn {
                display: inline-block;
                margin-top: 15px;
                padding: 10px 20px;
                color: white;
                background: #ff9900;
                text-decoration: none;
                border-radius: 5px;
            }
        </style>

        <?php
        return ob_get_clean();
    } else {
        return '<p>No sliders found.</p>';
    }
}
add_shortcode('text_slider', 'text_slider_shortcode');

