<!-- News Loop -->
<?php
$current_post_id = get_the_ID();

// Get the latest 5 news articles excluding the current one
$news_args = array(
    'post_type' => 'page',
    'posts_per_page' => 3,
    'category_name' => 'program',  // Fixed category argument
    'orderby' => 'rand',           // Order should be defined correctly
    'post__not_in' => array($current_post_id), // Exclude the current post
);

$news_query = new WP_Query($news_args);

if ($news_query->have_posts()) :
    while ($news_query->have_posts()) : $news_query->the_post(); ?>
        <div class="item kpy-news">
            <a href="<?= esc_url(get_permalink()); ?>">
                <div class="card card-body ev-details shadow mb-3" data-aos="fade-up">
                    <div class="post-thumbnail">
                        <?php 
                        if (has_post_thumbnail()) {
                            the_post_thumbnail();
                        } else {
                            echo '<img src="' . get_template_directory_uri() . '/assets/images/placeholder-image.jpg" alt="Afiego" class="img-fluid card-img-top"/>';
                        }
                        ?>
                    </div>
                    <div class="card-body">
                        <h5><?php the_title(); ?></h5>
                        <div class="catz">
                            <i class="bi bi-calendar-check"></i> <?php echo get_the_date(); ?>
                        </div>
                    </div>
                </div>
            </a>
        </div>
    <?php endwhile;
    wp_reset_postdata();
else :
    echo 'No news found.';
endif;
?>
