<?php
//Home Latest News 
function homeNews_shortcode($atts) {
    ob_start(); // Start output buffering
    $atts = shortcode_atts(
        array(
            'category' => '',
            'number' => 8, 
            'order' => 'DESC',
        ),
        $atts,
        'post' // Changed from 'post' to match your shortcode name
    );
    
    $news_args = array(
        'post_type' => 'post',
        'posts_per_page' => $atts['number'],
        'orderby' => 'date', 
        'order' => $atts['order'],
        'ignore_sticky_posts' => true,
    );

    if (!empty($atts['category'])) {
        $news_args['category_name'] = $atts['category']; // Simplified category query
        // Alternative if you need to use tax_query:
        /*
        $news_args['tax_query'] = array(
            array(
                'taxonomy' => 'category', // Changed from 'category_name'
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
        */
    }
    
    $news_query = new WP_Query($news_args);
    
    if ($news_query->have_posts()) : ?>
        <div class="row">
            <?php while ($news_query->have_posts()) :
                $news_query->the_post();
                $categories = get_the_category();
            ?>
            <div class="col-md-3 col-sm-6 kpy-news">
                <article>
                    <a href="<?php echo esc_url(get_permalink()); ?>">
                        <div class="card mb-3 border-0" data-aos="fade-up">
                            <div class="post-thumbnail">
                                <?php // Display the post thumbnail
                                    if (has_post_thumbnail()) {
                                        the_post_thumbnail('medium'); 
                                    } else {
                                        echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="'.esc_attr(get_the_title()).'" class="img-fluid"/>';
                                    }
                                ?>
                            </div>
                            <div class="card-body">
                                <h3><?php the_title(); ?></h3>
                                <div class="catz">
                                    <i class="bi bi-calendar-check"></i> 
                                    <?php echo get_the_date(); ?>
                                </div><!-- Date !-->
                                <a href="<?php echo esc_url(get_permalink()); ?>" class="btn btn-outline-info read-more">Read More</a>
                            </div><!-- card body !-->
                        </div><!-- card !-->
                    </a>
                </article>
            </div><!-- col !-->
            <?php endwhile; ?>
        </div><!-- Row !-->
    <?php else : ?>
        <p>No articles found in this category.</p>
    <?php endif;
    
    wp_reset_postdata();
    return ob_get_clean(); 
}

// Register the shortcode
add_shortcode('front-news', 'homeNews_shortcode');