<?php
function enqueue_owl_carousel_assets() {
    wp_enqueue_style('owl-carousel-css', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css');
    wp_enqueue_style('owl-theme-css', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css');
    wp_enqueue_script('jquery');
    wp_enqueue_script('owl-carousel-js', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js', array('jquery'), '', true);
    wp_enqueue_script('custom-owl-js', get_template_directory_uri() . '/js/custom-owl.js', array('jquery', 'owl-carousel-js'), '', true);
}
add_action('wp_enqueue_scripts', 'enqueue_owl_carousel_assets');

function generate_news_carousel() {
    $carousel = '<div id="newsCarousel" class="owl-carousel owl-theme fade-up">';

    $args = array(
        'post_type' => 'post',
        'posts_per_page' => 20,
        'category_name' => 'latest_news',
        'order' => 'DESC',
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $image = get_the_post_thumbnail(null, 'medium', array('class' => 'card-img-top'));

            $carousel .= '
            <div class="item kpy-news">
                <div class="card shadow-sm border-0 h-100">
                    <div class="post-thumbnail">
                        ' . ($image ? $image : '<img class="card-img-top" src="' . get_template_directory_uri() . '/default.jpg" alt="No Image">') . '
                    </div>
                    <div class="card-body">
                        <h5 class="card-title">' . get_the_title() . '</h5>
                        <p class="card-date"><i class="bi bi-calendar-check"></i> ' . get_the_date() . '</p>
                        <a href="' . get_permalink() . '" class="btn btn-outline-info read-more">Read More</a>
                    </div>
                </div>
            </div>';
        }
    } else {
        $carousel .= '<div class="item"><p>No posts available.</p></div>';
    }

    wp_reset_postdata();

    $carousel .= '</div>'; 
    return $carousel;
}

function generate_events_carousel() {
    $carousel = '<div id="eventsCarousel" class="owl-carousel owl-theme fade-up">';
  
    $args = array(
        'post_type' => 'events',
        'posts_per_page' => 20,
       'order' => 'DESC',
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $image = get_the_post_thumbnail(null, 'medium', array('class' => 'card-img-top'));
            
            $post_id = get_the_ID();
            $location =  get_post_meta(get_the_ID(), '_location', true);
            $start_date = get_post_meta(get_the_ID(), '_start_date', true);
            $formatted_start_date = date('jS, F Y', strtotime($start_date)); // Format for Date
            $formatted_start_month = date('F', strtotime($start_date)); // Format for Month
            $formatted_start_time = date('g:i A', strtotime($start_date)); // Format for Time

            $carousel .= '
                <div class="item kpy-news">
                    <div class="card shadow-sm border-0">
                        <div class="post-thumbnail">
                            ' . ($image ? $image : '<img class="card-img-top" src="' . get_template_directory_uri() . '/default.jpg" alt="No Image">') . '
                        </div>
                        <div class="card-body">
                            
                            <h3 class="card-title">' . get_the_title() . '</h3>
                            <p class="card-text"><i class="bi bi-calendar-check"></i> ' . esc_html($formatted_start_date) . '</p>
                           <p> <span class="location"><i class="bi bi-geo-alt"></i> ' . esc_html($location) . '</span></p>
                            <a href="' . get_permalink() . '" class="btn btn-outline-info read-more">Read More</a>
                        </div>
                    </div>
                </div>';

        }
    } else {
        $carousel .= '<div class="item"><p>No events available.</p></div>';
    }

    wp_reset_postdata();

    $carousel .= '</div>'; 
    return $carousel;
}

function generate_media_carousel() {
    $carousel = '<div id="mediaCarousel" class="owl-carousel owl-theme">';

    $args = array(
        'post_type' => 'page',
        'posts_per_page' => 20,
        'category_name' => 'media',
    );

    $query = new WP_Query($args);

    if ($query->have_posts()) {
        while ($query->have_posts()) {
            $query->the_post();
            $image = get_the_post_thumbnail(null, 'medium', array('class' => 'card-img-top'));

            $carousel .= '
            <div class="item kpy-media">
                    <div class="card">' . get_the_content() . '</div>
            </div>';
        }
    }

    wp_reset_postdata();
    $carousel .= '</div>'; 
    return $carousel;
}

function news_events_media_tabs_shortcode($atts) {
    $news_content = '<div class="tab-pane fade py-3 active show" id="news-tab-pane">' . generate_news_carousel() . '</div>';
    $events_content = '<div class="tab-pane fade py-3" id="events-tab-pane">' . generate_events_carousel() . '</div>';
    $media_content = '<div class="tab-pane fade py-3" id="media-tab-pane">
        <div class="row">
            <div class="col-md-6 mb-3">
                <div class="twitter-embed p-3">
                    <h3>Latest from BusogaHealth</h3>
                    <div class="tweet-embed">
                        <blockquote class="twitter-tweet">
                            <a href="https://x.com/BusogaHealth"></a>
                        </blockquote>
                    </div>
                    <a href="https://x.com/BusogaHealth" target="_blank" class="view-more">View More on X</a>
                </div>
                <script async src="https://platform.twitter.com/widgets.js" charset="utf-8"></script>
    
            </div>
            <div class="col-md-6 mb-3">
                <iframe width="100%" height="315" src="https://www.youtube.com/embed/videoseries?si=OuN8qKkRzygv25M-&amp;list=PLnEAtU_7I97qod-FGqXjF0cfd4gqDpNNJ" title="YouTube video player" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture; web-share" referrerpolicy="strict-origin-when-cross-origin" allowfullscreen></iframe>
            </div>
        </div>
    </div>';

    return '

    <div class="col-md-12 bhf fade-up">
        <ul class="nav nav-pills flex-column flex-sm-row nav-tabs" id="myTab">
            <li class="nav-item"><a class="nav-link active" id="news-tab" data-bs-toggle="tab" href="#news-tab-pane">Latest News</a></li>
            <li class="nav-item"><a class="nav-link" id="events-tab" data-bs-toggle="tab" href="#events-tab-pane">Events</a></li>
            <li class="nav-item"><a class="nav-link" id="media-tab" data-bs-toggle="tab" href="#media-tab-pane">Media</a></li>
        </ul>
        <div class="tab-content shadow">' . $news_content . $events_content . $media_content . '</div>
    </div>';
}
add_shortcode('news_events_media_tabs', 'news_events_media_tabs_shortcode');
?>
