<?php
function allprograms_shortcode() {
    ob_start(); // Start output buffering

    wp_enqueue_style('owl-carousel-css', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.carousel.min.css');
    wp_enqueue_style('owl-theme-css', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/assets/owl.theme.default.min.css');
    wp_enqueue_script('jquery');
    wp_enqueue_script('owl-carousel-js', 'https://cdnjs.cloudflare.com/ajax/libs/OwlCarousel2/2.3.4/owl.carousel.min.js', array('jquery'), '', true);
    wp_enqueue_script('custom-owl-js', get_template_directory_uri() . '/js/custom-owl.js', array('jquery', 'owl-carousel-js'), '', true);

    $news_args = array(
        'post_type' => array('page'),
        'posts_per_page' => 20,
        'page_category' => 'all-programs',
    );

    ?>
    
    <?php $news_query = new WP_Query($news_args); ?>
    <?php if ($news_query->have_posts()) : ?>
    <div id="programsCarousel" class="owl-carousel owl-theme news-section">
        <?php while ($news_query->have_posts()) :
            $news_query->the_post();
            $categories = get_the_category();
        ?>
        <div class="item">
            <article>
                <div class="card card-body mb-3 border-0" data-aos="fade-up">
                    <a class="icon" href="<?= esc_url(get_permalink()); ?>"><?php the_excerpt(); ?></a>
                    <a href="<?= esc_url(get_permalink()); ?>"><h3><?php the_title(); ?></h3></a>
                    <div class="post-thumbnail d-none">
                        <?php 
                            if (has_post_thumbnail()) {
                                the_post_thumbnail('full'); 
                            } else {
                                echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="BHF" class="img-fluid"/>';
                            }
                        ?>
                    </div>
                    <a href="<?= esc_url(get_permalink()); ?>" class="read-more">Read More </a>
                </div><!-- card -->
            </article>
        </div><!-- item -->
        <?php endwhile;
            wp_reset_postdata();
        else :
            echo '<div class="item"><p>No programs found.</p></div>';
        endif;
        ?>
    </div><!-- Owl Carousel -->

    <script>
    jQuery(document).ready(function($) {
        function initializeCarousel(selector) {
            var totalItems = $(selector).find('.item').length;

            $(selector).owlCarousel({
                loop: totalItems > 4,
                rewind: totalItems <= 4,
                margin: 15,
                nav: true,
                dots: false,
                autoplay: false,
                smartSpeed: 600,
                stagePadding: 20,
                lazyLoad: false, // Ensure all images load immediately
                animateOut: false, // Prevent fade-out animation
                animateIn: false, // Prevent fade-in animation
                navText: [
                    '<span class="custom-prev">&#9665;</span>', 
                    '<span class="custom-next">&#9655;</span>'
                ],
                responsive: {
                    0: { items: 1, stagePadding: 10 },  
                    600: { items: 2, stagePadding: 15 },  
                    1000: { items: Math.min(4, totalItems), stagePadding: 20 }  
                }
            });

            function equalizeHeights() {
                let maxHeight = 0;
                $(selector + " .card").each(function() {
                    let thisHeight = $(this).outerHeight();
                    if (thisHeight > maxHeight) {
                        maxHeight = thisHeight;
                    }
                });
                $(selector + " .card").css("height", maxHeight + "px");
            }

            $(selector).on('initialized.owl.carousel resized.owl.carousel', function() {
                equalizeHeights();
            });
        }
        initializeCarousel('#programsCarousel');
    });
    </script>
    
    <?php
    return ob_get_clean(); // Return the buffered content
}

// Register the shortcode
add_shortcode('myprograms', 'allprograms_shortcode');

//ALL PROGRAMs TABs 
function bhfProgramz_shortcode($atts) {
    ob_start(); // Start output buffering
    $atts = shortcode_atts(
        array(
            'category' => '',
            'number' => -1, 
            'order' => 'RAND',
        ),
        $atts,
        'page'
    );
	$news_args = array(
		'post_type' => 'page',
		'posts_per_page' => $atts['number'],
        'orderby' => 'date', 
        'order' => $atts['order'],
	);

    if (!empty($atts['category'])) {
        $news_args['tax_query'] = array(
            array(
                'taxonomy' => 'page_category',
                'field' => 'slug',
                'terms' => $atts['category'],
            ),
        );
    }
 ?>

    <?php $news_query = new WP_Query($news_args);?>
		<?php if ($news_query->have_posts()) : ?>
		<div class="row">
			<?php while ($news_query->have_posts()) :
				$news_query->the_post();
				$categories = get_the_category();
			?>
			<div class="col-md-4 col-sm-6 kpy-services">
				<article>
					<a href="<?= esc_url(get_permalink()); ?>">
						<div class="card shadow-sm mb-3 border-0" data-aos="fade-up">
							<div class="post-thumbnail">
								<?php // Display the post thumbnail
									if (has_post_thumbnail()) {
										the_post_thumbnail('full'); 
									}else{
										echo '<img src="'. get_template_directory_uri().'/assets/images/photo-placeholder.jpg" alt="NGO" class="img-fluid"/>';
									}
								?>
							</div>
							<div class="card-body">
								<h3><?php the_title(); ?></h3>
							</div><!-- card body !-->
						</div><!-- card !-->
						</a>
				</article>
			</div><!-- col !-->
			<?php endwhile;
				wp_reset_postdata();
			else :
				echo 'No news found.';
			endif;
			?>
	</div><!-- Row !-->
    <?php

    return ob_get_clean(); 
}

// Register the shortcode
add_shortcode('bhf-cats', 'bhfProgramz_shortcode');

?>
