<?php 
    get_header(); 
    include get_template_directory() . '/inc/menus/menu.php'; 
?>
	<main role="main">
	<?php $backgroundImg = wp_get_attachment_image_src( get_post_thumbnail_id($post->ID), 'full' );?>
    <div class="header-wrap1" style="background: linear-gradient(90deg, rgba(6, 6, 5, 0.8), rgba(12, 12, 12, 0.5)), url('<?php echo $backgroundImg[0]; ?>') no-repeat;background-size: cover;background-position: center center;">
        <div class="container"><div class="row">
			<div class="col-lg-12 entry-title" data-aos="fade-up">
				<h1><?php the_title(); ?></h1>
				<?php custom_breadcrumb(); ?>
        	</div>
		</div></div>
    </div>
		<section>
		    <div class="container page-content2 py-md-4 py-2">
		        <div class="row">
		            <div class="col-lg-12" data-aos="fade-up">
		                <?php if (have_posts()): while (have_posts()) : the_post(); ?>
		                <!-- article -->
		                <article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
		                    <div class="sing-content">
		                        <!-- post thumbnail -->
		                        <div class="post-thumbnail">
		                        <?php if ( has_post_thumbnail()) : ?>
		                            <?php the_post_thumbnail(); ?>
		                        <?php endif; ?>
		                        </div>
		                        <!-- /post thumbnail -->
		                        
		                        <h1 class="sing-title"><?php the_title(); ?></h1>
		                        <p class="author date post-details"><?php the_time('F j, Y'); ?></p>
		                        
		                        <div class="sing-body">
		                            <?php the_content(); ?>
		                        </div>
		                        
		                        <!-- social media sharing -->
		                        <div class="d-flex justify-content-center bd-highlight mb-1">
		                            <div class="bd-highlight p-1">
		                                <small class="text-muted">share this article</small>
		                            </div>
		                            <div class="bd-highlight p-1">
		                                <a class="btn btn-sm btn-facebook" href="https://www.facebook.com/sharer/sharer.php?u=<?= esc_url(get_permalink()); ?>" target="_blank" rel="noopener noreferrer" title="Facebook">
		                                <small>Share on <i class="bi bi-facebook"></i> </small>
		                                </a>
		                            </div>
		                            <div class="bd-highlight p-1">
		                                <a class="btn btn-sm btn-twitter" href="https://twitter.com/intent/tweet?url=<?= esc_url(get_permalink()); ?>&text=<?= the_title(); ?>" target="_blank" rel="noopener noreferrer" title="Twitter">
		                                <small> Share on <i class="bi bi-twitter-x"></i></small>
		                                </a>
		                            </div>
		                            <div class="bd-highlight p-1">
		                                <a class="btn btn-sm btn-whatsapp" href="whatsapp://send?text=Check out this product: <?= the_title(); ?> - <?= esc_url(get_permalink());?>" data-action="share/whatsapp/share" title="WhatsApp">
		                                <small><i class="bi bi-whatsapp"></i> WhatsApp</small>
		                                </a>
		                            </div>
		                        </div>
		                        <!-- End of Social Media sharing -->
		                        
		                        <?php edit_post_link(); ?>
		                    </div>
		                </article>
		                <!-- /article -->
		                <?php endwhile; ?>

		                <?php else: ?>
		                <!-- article -->
		                <article>
		                    <div class="sing-content">
		                        <h2><?php _e( 'Sorry, nothing to display.', 'kipya' ); ?></h2>
		                    </div>
		                </article>
		                <!-- /article -->
		                <?php endif; ?>
		            </div>
		        </div>
		    </div>
		</section>

		<!-- Latest Stories Section -->
		<section class="latest-stories-section">
		    <div class="container-xxl py-5">
		        <div class="stories-header text-center mb-5">
		            <h2 class="sing-stories-title">Latest Stories</h2>
		            <p class="sing-stories-subtitle">Discover more interesting articles from our blog</p>
		        </div>
		        <div class="stories-grid">
		            <?php
		            // Get latest posts
		            $latest_posts = get_posts(array(
		                'numberposts' => 3,
		                'post_status' => 'publish',
		                'exclude' => array(get_the_ID())
		            ));
		            
		            if ($latest_posts) :
		                foreach ($latest_posts as $post) :
		                setup_postdata($post);
		                $thumbnail_url = get_the_post_thumbnail_url($post->ID, 'medium');
		            ?>
		            <div class="story-card">
		                <div class="sing-story-card">
		                    <div class="sing-story-thumb">
		                        <img src="<?php echo $thumbnail_url ?: 'https://via.placeholder.com/400x250'; ?>" alt="<?php the_title(); ?>">
		                    </div>
		                    <div class="sing-story-content">
		                        <div class="sing-story-meta">
		                            <span><?php the_time('M j, Y'); ?></span>
		                        </div>
		                        <h4><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h4>
		                        <p class="sing-story-excerpt"><?php echo wp_trim_words(get_the_excerpt(), 12); ?></p>
		                        <a href="<?php the_permalink(); ?>" class="sing-read-more">Read More →</a>
		                    </div>
		                </div>
		            </div>
		            <?php
		                endforeach;
		                wp_reset_postdata();
		            else :
		            ?>
		            <div class="no-stories">
		                <p>No latest stories found.</p>
		            </div>
		            <?php endif; ?>
		        </div>
		    </div>
		</section>
	</main>

<style>
/* Single Post & Related News Styles */
.sing-content { background: #fff; border-radius: 8px; overflow: hidden; box-shadow: 0 4px 6px rgba(0,0,0,0.1); padding: 2rem; }
.sing-title { font-size: 2.2rem; color: #1a365d; margin-bottom: 0.5rem; line-height: 1.3; border-bottom: 1px solid #e2e8f0; padding-bottom: 1rem; }
.sing-body h2 { font-size: 1.8rem; color: #1a365d; margin: 2rem 0 1rem; padding-bottom: 0.5rem; border-bottom: 2px solid #d69e2e; }
.sing-body h3 { font-size: 1.4rem; color: #2d3748; margin: 1.5rem 0 0.75rem; }
.sing-body p { line-height: 1.7; color: #4a5568; margin-bottom: 1.5rem; }

/* Lists */
.sing-body ul, .sing-body ol { margin: 1.5rem 0; padding-left: 1.8rem; list-style: none; }
.sing-body ul li, .sing-body ol li { padding-left: 2rem; margin-bottom: 1rem; line-height: 1.7; background: #f9fafb; border-left: 3px solid #d69e2e; border-radius: 8px; padding: 0.75rem 1rem 0.75rem 2.5rem; box-shadow: 0 1px 3px rgba(0,0,0,0.1); transition: all 0.25s ease; position: relative; }
.sing-body ul li:hover, .sing-body ol li:hover { background: #fff8e1; transform: translateX(5px); }
.sing-body ul li::before { content: "✓"; color: #1a365d; position: absolute; left: 0.9rem; top: 50%; transform: translateY(-50%); }
.sing-body ol { counter-reset: list-counter; }
.sing-body ol li { counter-increment: list-counter; }
.sing-body ol li::before { content: counter(list-counter); position: absolute; left: 0.7rem; top: 50%; transform: translateY(-50%); background: #1a365d; color: white; width: 1.4rem; height: 1.4rem; display: flex; align-items: center; justify-content: center; font-size: 0.9rem; border-radius: 50%; }
.sing-body ul ul, .sing-body ol ol { margin-top: 0.8rem; margin-left: 1.5rem; }
.sing-body ul ul li::before { content: "›"; color: #2d3748; left: 0.9rem; }

.sing-body img { width: 100%; margin: 1.5rem 0; max-height: 400px; border-radius: 8px; transition: all 0.3s ease; }
.sing-body img:hover { transform: scale(1.01); box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
.sing-body blockquote { border-left: 4px solid #d69e2e; padding: 1.5rem; margin: 2rem 0; font-style: italic; color: #1a365d; background: #f8f9fa; border-radius: 0 8px 8px 0; }

/* Latest Stories Section */
.latest-stories-section { background: #f8f9fa; padding: 4rem 0; margin-top: 3rem; }
.sing-stories-title { font-size: 2.5rem; color: #1a365d; margin-bottom: 1rem; font-weight: 700; }
.sing-stories-subtitle { font-size: 1.2rem; color: #6b7280; margin-bottom: 0; }

/* Stories Grid with Container XXL */
.stories-grid {
    display: grid;
    grid-template-columns: repeat(3, 1fr);
    gap: 2rem;
    align-items: stretch;
}

.story-card {
    display: flex;
}

/* Related News Cards */
.sing-story-card { 
    background: #fff; 
    border-radius: 12px; 
    overflow: hidden; 
    box-shadow: 0 4px 12px rgba(0,0,0,0.1); 
    transition: all 0.3s ease; 
    flex: 1;
    display: flex;
    flex-direction: column;
}
.sing-story-card:hover { transform: translateY(-8px); box-shadow: 0 12px 30px rgba(0,0,0,0.15); }

.sing-story-thumb { height: 220px; overflow: hidden; flex-shrink: 0; }
.sing-story-thumb img { width: 100%; height: 100%; object-fit: cover; transition: all 0.3s ease; }
.sing-story-card:hover .sing-story-thumb img { transform: scale(1.1); }

.sing-story-content { padding: 1.75rem; flex-grow: 1; display: flex; flex-direction: column; }
.sing-story-meta { font-size: 0.85rem; color: #d69e2e; font-weight: 600; margin-bottom: 0.75rem; text-transform: uppercase; letter-spacing: 0.5px; }

.sing-story-content h4 { margin: 0 0 1rem 0; font-size: 1.3rem; line-height: 1.4; flex-grow: 1; }
.sing-story-content h4 a { color: #1a365d; text-decoration: none; transition: all 0.3s ease; }
.sing-story-content h4 a:hover { color: #d69e2e; }

.sing-story-excerpt { color: #6b7280; line-height: 1.6; margin-bottom: 1.5rem; font-size: 0.95rem; flex-grow: 1; }

.sing-read-more { color: #1a365d; text-decoration: none; font-weight: 600; font-size: 0.95rem; transition: all 0.3s ease; align-self: flex-start; margin-top: auto; }
.sing-read-more:hover { color: #d69e2e; transform: translateX(5px); }

.no-stories {
    grid-column: 1 / -1;
    text-align: center;
    padding: 2rem;
}

/* Responsive */
@media (max-width: 1200px) {
    .stories-grid {
        grid-template-columns: repeat(3, 1fr);
        gap: 1.5rem;
    }
}

@media (max-width: 992px) {
    .stories-grid {
        grid-template-columns: repeat(2, 1fr);
    }
}

@media (max-width: 768px) {
    .sing-content { padding: 1.5rem; }
    .latest-stories-section { padding: 3rem 0; }
    .sing-stories-title { font-size: 2rem; }
    .sing-stories-subtitle { font-size: 1.1rem; }
    .stories-grid {
        grid-template-columns: 1fr;
        max-width: 500px;
        margin: 0 auto;
        gap: 1.5rem;
    }
}

@media (max-width: 576px) {
    .sing-story-thumb { height: 200px; }
    .sing-story-content { padding: 1.5rem; }
    .sing-story-content h4 { font-size: 1.2rem; }
    .stories-grid {
        gap: 1rem;
    }
}
</style>

<?php get_footer(); ?>