<?php //Custom Post :: Video Gallery

//YouTube API Helper 
function fetch_youtube_playlist_items($api_key, $playlist_id, $max_results = 5) {
    $api_url = "https://www.googleapis.com/youtube/v3/playlistItems?part=snippet&maxResults=$max_results&playlistId=$playlist_id&key=$api_key";

    $response = wp_remote_get($api_url);
    if (is_wp_error($response)) return [];

    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);

    if (!isset($data['items'])) return [];

    $videos = [];
    foreach ($data['items'] as $item) {
        $video_id = $item['snippet']['resourceId']['videoId'];
        $videos[] = [
            'title' => $item['snippet']['title'],
            'link' => 'https://www.youtube.com/embed/' . $video_id,
            'thumbnail' => $item['snippet']['thumbnails']['medium']['url']
        ];
    }
    return $videos;
}



/** =================================================================
 *  SHORTCODE - Playlist - Home PAGE
 *===================================================================*/
function youtube_api_videos_shortcode($atts) {
    $atts = shortcode_atts(array(
        'api_key' => '',
        'playlist_id' => '',
        'number' => 5
    ), $atts, 'youtube-videos');

    if (empty($atts['api_key']) || empty($atts['playlist_id'])) return 'Missing API Key or Playlist ID.';

    $videos = fetch_youtube_playlist_items($atts['api_key'], $atts['playlist_id'], $atts['number']);

    ob_start();

    if (!empty($videos)) {
        ?>
        <div class="video-gallery">
            <div class="video-main">
                <iframe id="main-video-frame" width="100%" height="400" src="<?php echo esc_url($videos[0]['link']); ?>" frameborder="0" allowfullscreen></iframe>
            </div>
            <div class="video-thumbnails d-flex gap-2 mt-3">
                <?php foreach ($videos as $index => $video) : ?>
                    <div class="thumbnail" style="cursor:pointer;">
                        <img src="<?php echo esc_url($video['thumbnail']); ?>" style="width:160px;height:auto;" data-link="<?php echo esc_url($video['link']); ?>">
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <script>
            document.querySelectorAll('.video-thumbnails .thumbnail img').forEach((img, index) => {
                img.addEventListener('click', function() {
                    document.getElementById('main-video-frame').src = this.dataset.link;
                });
            });
        </script>
        <?php
    }

    return ob_get_clean();
}
add_shortcode('youtube-videos', 'youtube_api_videos_shortcode');




