<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.css">
<script src="https://cdn.jsdelivr.net/npm/swiper@8/swiper-bundle.min.js"></script>
<section class="main-slider">
    <?php $slider_query = new WP_Query([
        'post_type' => 'slides',
        'posts_per_page' => -1
    ]); ?>
    
    <div class="swiper-container thm-swiper__slider" data-swiper-options='{"slidesPerView":1,"loop":true,"effect":"fade","pagination":{"el":"#main-slider-pagination","type":"bullets","clickable":true},"navigation":{"nextEl":"#main-slider__swiper-button-next","prevEl":"#main-slider__swiper-button-prev"},"autoplay":{"delay":5000}}'>
        <div class="swiper-wrapper">
            <?php if ($slider_query->have_posts()): ?>
                <?php while ($slider_query->have_posts()): $slider_query->the_post();
                    $title = get_the_title();
                    $description = get_the_excerpt();
                    $backgroundImg = get_the_post_thumbnail_url(get_the_ID());
                ?>
                <div class="swiper-slide">
                    <div class="image-layer" style="background-image:url('<?= esc_url($backgroundImg); ?>');"></div>
                    <div class="slider-overlay"></div>
                    <div class="container">
                        <div class="row">
                            <div class="col-xl-12">
                                <div class="main-slider-content">
                                    <div class="main-slider-content__inner">
                                        <h2 class="slide-title"><?= esc_html($title) ?></h2>
                                        <p class="slide-excerpt"><?= esc_html($description) ?></p>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endwhile; ?>
            <?php endif; ?>
        </div>
        <div class="swiper-pagination" id="main-slider-pagination"></div>
    </div>
    <?php wp_reset_postdata(); ?>
</section>

<script>
    document.addEventListener('DOMContentLoaded', function() {
    const swiperElement = document.querySelector('.thm-swiper__slider');
    if (swiperElement) {
        new Swiper('.thm-swiper__slider', {
            slidesPerView: 1,
            loop: true,
            effect: 'fade',
            fadeEffect: {
                crossFade: true
            },
            pagination: {
                el: '#main-slider-pagination',
                type: 'bullets',
                clickable: true
            },
            autoplay: {
                delay: 5000,
                disableOnInteraction: false
            },
            speed: 800
        });
    }
});
</script>