<!-- Main Header -->
<header class="main-header">
    
    <!-- Top Header (hidden on mobile, not sticky) -->
    <div class="header-top d-none d-md-block">
        <div class="container-xxl">
            <div class="header-top-content">
                <div class="header-top-contact">
                    <a href="tel:+256777461759">
                        <i class="bi bi-telephone-fill"></i>
                        <span>+256 777461759 / 706960708</span>
                    </a>
                    <a href="mailto:info@uegcl.co.ug">
                        <i class="bi bi-envelope-fill"></i>
                        <span>info@uegcl.co.ug</span>
                    </a>
                </div>
                <div class="header-top-social">
                    <a href="https://x.com/uegcl?s=09" class="social-icon">
                        <i class="bi bi-twitter"></i>
                    </a>
                    <a href="#" class="social-icon">
                        <i class="bi bi-youtube"></i>
                    </a>
                    <a href="http://www.linkedin.com/in/uegcl-2421b3387" class="social-icon">
                        <i class="bi bi-linkedin"></i>
                    </a>
                    <a href="http://www.facebook.com/in/uegcl-2421b3387" class="social-icon">
                        <i class="bi bi-facebook"></i>
                    </a>
                    <a href="http://www.instagram.com/in/uegcl-2421b3387" class="social-icon">
                        <i class="bi bi-instagram"></i>
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Sticky Main Header -->
    <div class="header-main sticky-top">
        <div class="container-xxl">
            <div class="header-container">
                <!-- Logo -->
                <div class="logo">
                    <a href="<?php echo esc_url(home_url('/')); ?>">
                        <?php
                        $custom_logo_id = get_theme_mod('custom_logo');
                        $logo = wp_get_attachment_image_src($custom_logo_id, 'full');
                        if ($logo) {
                            echo '<img src="' . esc_url($logo[0]) . '" alt="' . get_bloginfo('name') . '">';
                        } else {
                            echo '<h2>' . get_bloginfo('name') . '</h2>';
                        }
                        ?>
                    </a>
                </div>

                <!-- Navigation Menu -->
                <nav class="main-nav">
                    <?php
                    wp_nav_menu(array(
                        'theme_location' => 'primary',
                        'container' => false,
                        'menu_class' => 'nav-menu',
                        'fallback_cb' => false,
                        'walker' => new Mega_Menu_Walker()
                    ));
                    ?>
                </nav>

                <!-- Header Actions -->
                <div class="header-actions">
                    <button class="search-toggle" id="searchToggle">
                        <i class="bi bi-search"></i>
                    </button>
                    <button class="mobile-nav-toggle" id="mobileNavToggle">
                        <i class="bi bi-list"></i>
                    </button>
                </div>
            </div>

            <!-- Search Bar -->
            <div class="header-search-bar" id="headerSearchBar">
                <form class="search-form" role="search" method="get" action="<?php echo esc_url(home_url('/')); ?>">
                    <input type="search" class="search-input" placeholder="Search..." value="<?php echo get_search_query(); ?>" name="s">
                    <button type="submit" class="search-button">
                        <i class="bi bi-search"></i>
                    </button>
                </form>
            </div>
        </div>
    </div>
</header>

<!-- Mobile Navigation Menu -->
<div class="mobile-nav-menu" id="mobileNavMenu">
    <div class="mobile-nav-header">
        <h3>Menu</h3>
        <button class="mobile-nav-close" id="mobileNavClose">
            <i class="bi bi-x-lg"></i>
        </button>
    </div>
    <?php
    wp_nav_menu(array(
        'theme_location' => 'primary',
        'container' => false,
        'menu_class' => 'mobile-nav-list',
        'fallback_cb' => false,
        'walker' => new Mobile_Menu_Walker()
    ));
    ?>
</div>

<!-- Mobile Navigation Overlay -->
<div class="mobile-nav-overlay" id="mobileNavOverlay"></div>
<script>
    document.addEventListener('DOMContentLoaded', function() {
            // Search Toggle
            const searchToggle = document.getElementById('searchToggle');
            const headerSearchBar = document.getElementById('headerSearchBar');
            
            searchToggle.addEventListener('click', function() {
                headerSearchBar.classList.toggle('active');
            });
            
            // Mobile Navigation Toggle
            const mobileNavToggle = document.getElementById('mobileNavToggle');
            const mobileNavMenu = document.getElementById('mobileNavMenu');
            const mobileNavClose = document.getElementById('mobileNavClose');
            const mobileNavOverlay = document.getElementById('mobileNavOverlay');
            
            mobileNavToggle.addEventListener('click', function() {
                mobileNavMenu.classList.add('active');
                mobileNavOverlay.classList.add('active');
            });
            
            mobileNavClose.addEventListener('click', function() {
                mobileNavMenu.classList.remove('active');
                mobileNavOverlay.classList.remove('active');
            });
            
            mobileNavOverlay.addEventListener('click', function() {
                mobileNavMenu.classList.remove('active');
                mobileNavOverlay.classList.remove('active');
            });
            
            // Close search when clicking outside
            document.addEventListener('click', function(event) {
                if (!searchToggle.contains(event.target) && !headerSearchBar.contains(event.target)) {
                    headerSearchBar.classList.remove('active');
                }
            });
            
            // Add scroll effect to header
            window.addEventListener('scroll', function() {
                const header = document.querySelector('.main-header');
                if (window.scrollY > 50) {
                    header.style.boxShadow = '0 5px 20px rgba(0, 0, 0, 0.1)';
                } else {
                    header.style.boxShadow = '0 2px 15px rgba(0, 0, 0, 0.1)';
                }
            });
        });



// Multi-Level Mobile Accordion Dropdowns
document.addEventListener('DOMContentLoaded', () => {
  const mobileMenu = document.getElementById('mobileNavMenu');

  mobileMenu.addEventListener('click', function (e) {
    const link = e.target.closest('.has-children > a');
    if (link) {
      e.preventDefault();
      const parentLi = link.parentElement;
      const submenu = parentLi.querySelector(':scope > .mobile-submenu');

      // Close sibling dropdowns at the same level
      const siblingLis = parentLi.parentElement.querySelectorAll('.has-children');
      siblingLis.forEach(sibling => {
        if (sibling !== parentLi) {
          sibling.classList.remove('open');
          const siblingSub = sibling.querySelector(':scope > .mobile-submenu');
          if (siblingSub) siblingSub.classList.remove('active');
        }
      });

      // Toggle this submenu
      if (submenu) {
        submenu.classList.toggle('active');
        parentLi.classList.toggle('open');
      }
    }
  });
});

</script>

    <?php
    // Custom Walker Class for mega dropdown navigation
    class Mega_Menu_Walker extends Walker_Nav_Menu {
        private $has_grandchildren = false;
        
        function start_lvl(&$output, $depth = 0, $args = null) {
            if ($depth == 0) {
                if ($this->has_grandchildren) {
                    $output .= '<div class="mega-menu"><div class="mega-menu-content">';
                } else {
                    $output .= '<ul class="simple-dropdown">';
                }
            } else {
                $output .= '<ul class="sub-menu">';
            }
        }
        
        function end_lvl(&$output, $depth = 0, $args = null) {
            if ($depth == 0) {
                if ($this->has_grandchildren) {
                    $output .= '</div></div>';
                } else {
                    $output .= '</ul>';
                }
                $this->has_grandchildren = false;
            } else {
                $output .= '</ul>';
            }
        }
        
        function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
            $classes = empty($item->classes) ? array() : (array) $item->classes;
            $classes[] = 'menu-item-' . $item->ID;
            
            $has_children = in_array('menu-item-has-children', $classes);
            
            if ($depth == 0 && $has_children) {
                $this->has_grandchildren = $this->check_for_grandchildren($item->ID);
                if ($this->has_grandchildren) {
                    $classes[] = 'has-mega-menu has-dropdown';
                } else {
                    $classes[] = 'has-simple-dropdown has-dropdown';
                }
            }
            
            $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
            $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
            
            if ($depth == 0) {
                $output .= '<li' . $class_names . '>';
            } elseif ($depth == 1 && $this->has_grandchildren) {
                $output .= '<div class="mega-menu-column"><h4>';
            } else {
                $output .= '<li' . $class_names . '>';
            }
            
            $atts = array();
            $atts['title']  = !empty($item->attr_title) ? $item->attr_title : '';
            $atts['target'] = !empty($item->target) ? $item->target : '';
            $atts['rel']    = !empty($item->xfn) ? $item->xfn : '';
            $atts['href']   = !empty($item->url) ? $item->url : '';
            
            if ($depth == 0) {
                $atts['class'] = 'nav-item' . ($has_children ? ' dropdown-toggle' : '');
            }
            
            $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args, $depth);
            
            $attributes = '';
            foreach ($atts as $attr => $value) {
                if (!empty($value)) {
                    $value = ('href' === $attr) ? esc_url($value) : esc_attr($value);
                    $attributes .= ' ' . $attr . '="' . $value . '"';
                }
            }
            
            $item_output = $args->before;
            
            if ($depth == 1 && $this->has_grandchildren) {
                $item_output .= '<a' . $attributes . '>';
                $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
                $item_output .= '</a>';
                $item_output .= '</h4><ul>';
            } else {
                $item_output .= '<a' . $attributes . '>';
                $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
                if ($depth == 0 && $has_children) {
                   
                }
                $item_output .= '</a>';
            }
            
            $item_output .= $args->after;
            
            $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
        }
        
        function end_el(&$output, $item, $depth = 0, $args = null) {
            if ($depth == 0) {
                $output .= '</li>';
            } elseif ($depth == 1 && $this->has_grandchildren) {
                $output .= '</ul></div>';
            } else {
                $output .= '</li>';
            }
        }
        
        private function check_for_grandchildren($parent_id) {
            $menu_items = wp_get_nav_menu_items(get_nav_menu_locations()['primary']);
            if (!$menu_items) return false;
            
            $children = array();
            foreach ($menu_items as $item) {
                if ($item->menu_item_parent == $parent_id) {
                    $children[] = $item->ID;
                }
            }
            
            foreach ($children as $child_id) {
                foreach ($menu_items as $item) {
                    if ($item->menu_item_parent == $child_id) {
                        return true;
                    }
                }
            }
            
            return false;
        }
    }

    // Mobile Menu Walker
    class Mobile_Menu_Walker extends Walker_Nav_Menu {
        function start_lvl(&$output, $depth = 0, $args = null) {
            $output .= '<ul class="mobile-submenu">';
        }
        
        function start_el(&$output, $item, $depth = 0, $args = null, $id = 0) {
            $classes = empty($item->classes) ? array() : (array) $item->classes;
            $classes[] = 'menu-item-' . $item->ID;
            
            $has_children = in_array('menu-item-has-children', $classes);
            if ($has_children) {
                $classes[] = 'has-children';
            }
            
            $class_names = join(' ', apply_filters('nav_menu_css_class', array_filter($classes), $item, $args));
            $class_names = $class_names ? ' class="' . esc_attr($class_names) . '"' : '';
            
            $output .= '<li' . $class_names . '>';
            
            $atts = array();
            $atts['title'] = !empty($item->attr_title) ? $item->attr_title : '';
            $atts['target'] = !empty($item->target) ? $item->target : '';
            $atts['rel'] = !empty($item->xfn) ? $item->xfn : '';
            $atts['href'] = !empty($item->url) ? $item->url : '';
            $atts['class'] = 'mobile-nav-item';
            
            $atts = apply_filters('nav_menu_link_attributes', $atts, $item, $args, $depth);
            
            $attributes = '';
            foreach ($atts as $attr => $value) {
                if (!empty($value)) {
                    $value = ('href' === $attr) ? esc_url($value) : esc_attr($value);
                    $attributes .= ' ' . $attr . '="' . $value . '"';
                }
            }
            
            $item_output = $args->before;
            $item_output .= '<a' . $attributes . '>';
            $item_output .= $args->link_before . apply_filters('the_title', $item->title, $item->ID) . $args->link_after;
            if ($has_children) {
                
            }
            $item_output .= '</a>';
            $item_output .= $args->after;
            
            $output .= apply_filters('walker_nav_menu_start_el', $item_output, $item, $depth, $args);
        }
    }
    ?>
