<?php
// Register shortcode
add_shortcode('uegcl_about_section', 'uegcl_about_section_callback');

function uegcl_about_section_callback($atts) {
    // Parse attributes
    $atts = shortcode_atts(array(
        'title' => 'Who We Are',
        'subtitle' => 'ABOUT UEGCL',
        'description' => 'Uganda Electricity Generation Company Limited (UEGCL) was incorporated in 2001 to assume the electricity generation functions previously held by the defunct Uganda Electricity Board (UEB) under the Companies Act and the Electricity Act of the Laws of Uganda. The Assets acquired then included Nalubaale HPP (180MW) and Kiira HPP (200MW) in Jinja. The portfolio has since expanded to include the majestic 600 MW Karuma HPP, 183 MW Isimba HPP, Namanve TPP (50MW), and the 6.6 MW Nyagak III HPP. UEGCL is regulated by the country\'s Electricity Regulatory Authority (ERA).',
        'mission_title' => 'Our Mission',
        'mission_text' => 'To generate and deliver reliable, affordable, and sustainable electricity that powers Uganda\'s development and transforms lives.',
        'mission_point_1' => 'Excellence in power generation',
        'mission_point_2' => 'Commitment to safety and sustainability',
        'mission_point_3' => 'Driving national development',
        'cta_text' => 'Powering Uganda\'s future with clean, reliable energy for generations to come.',
        'button_text' => 'Learn More',
        'button_url' => '#',
        'image_url' => 'https://lwegatech.net/uegcl/wp-content/uploads/2025/10/uegcl-slide.jpg',
        'safety_title' => 'Safety Indicators by Plant',
        'card_1_days' => '1324',
        'card_1_title' => 'Namanve TPP',
        'card_2_days' => '1711',
        'card_2_title' => 'Isimba HPP',
        'card_3_days' => '932',
        'card_3_title' => 'Nalubaale-Kiira Power Stations',
        'card_4_days' => 'TBD',
        'card_4_title' => 'Karuma HPP'
    ), $atts);
    
    ob_start();
    ?>
    
    <section class="uegcl-about-section">
        <div class="uegcl-about-container">
            <div class="uegcl-about-grid">
                <div class="uegcl-about-image-wrapper">
                    <div class="uegcl-about-image">
                        <?php if (!empty($atts['image_url'])): ?>
                            <img src="<?php echo esc_url($atts['image_url']); ?>" alt="<?php echo esc_attr($atts['title']); ?>">
                        <?php else: ?>
                            <div style="background: #f0f0f0; height: 400px; display: flex; align-items: center; justify-content: center; color: #666;">
                                Image not found
                            </div>
                        <?php endif; ?>
                    </div>
                    <div class="uegcl-about-image-secondary">
                        <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/gcl.jpeg" alt="UEGCL Facilities">
                    </div>
                </div>
                
                <div class="uegcl-about-content">
                    <span class="uegcl-about-subtitle"><?php echo esc_html($atts['subtitle']); ?></span>
                    <h2 class="uegcl-about-title"><?php echo esc_html($atts['title']); ?></h2>
                    <p class="uegcl-about-description"><?php echo esc_html($atts['description']); ?></p>
                    
                    <div class="uegcl-mission-cta-wrapper">
                        <div class="uegcl-mission-box">
                            <h3 class="uegcl-mission-title"><?php echo esc_html($atts['mission_title']); ?></h3>
                            <p class="uegcl-mission-text"><?php echo esc_html($atts['mission_text']); ?></p>
                            <ul class="uegcl-mission-list">
                                <li><svg class="uegcl-check-icon" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/></svg><?php echo esc_html($atts['mission_point_1']); ?></li>
                                <li><svg class="uegcl-check-icon" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/></svg><?php echo esc_html($atts['mission_point_2']); ?></li>
                                <li><svg class="uegcl-check-icon" viewBox="0 0 20 20" fill="currentColor"><path fill-rule="evenodd" d="M16.707 5.293a1 1 0 010 1.414l-8 8a1 1 0 01-1.414 0l-4-4a1 1 0 011.414-1.414L8 12.586l7.293-7.293a1 1 0 011.414 0z" clip-rule="evenodd"/></svg><?php echo esc_html($atts['mission_point_3']); ?></li>
                            </ul>
                        </div>
                        
                        <div class="uegcl-cta-box">
                            <p class="uegcl-cta-text"><?php echo esc_html($atts['cta_text']); ?></p>
                            <a href="<?php echo esc_url($atts['button_url']); ?>" class="uegcl-cta-button"><?php echo esc_html($atts['button_text']); ?></a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <section class="uegcl-safety-section">
        <div class="uegcl-safety-container">
            <h2 class="uegcl-safety-title"><?php echo esc_html($atts['safety_title']); ?></h2>
            <div class="uegcl-safety-grid">
                <div class="uegcl-safety-card">
                    <div class="uegcl-safety-icon"><?php echo uegcl_get_safety_icon(); ?></div>
                    <div class="uegcl-safety-content">
                        <div class="uegcl-safety-days"><?php echo esc_html($atts['card_1_days']); ?></div>
                        <div class="uegcl-safety-label">Days without LTI</div>
                        <h3><?php echo esc_html($atts['card_1_title']); ?></h3>
                    </div>
                </div>
                
                <div class="uegcl-safety-card">
                    <div class="uegcl-safety-icon"><?php echo uegcl_get_safety_icon(); ?></div>
                    <div class="uegcl-safety-content">
                        <div class="uegcl-safety-days"><?php echo esc_html($atts['card_2_days']); ?></div>
                        <div class="uegcl-safety-label">Days without LTI</div>
                        <h3><?php echo esc_html($atts['card_2_title']); ?></h3>
                    </div>
                </div>
                
                <div class="uegcl-safety-card">
                    <div class="uegcl-safety-icon"><?php echo uegcl_get_safety_icon(); ?></div>
                    <div class="uegcl-safety-content">
                        <div class="uegcl-safety-days"><?php echo esc_html($atts['card_3_days']); ?></div>
                        <div class="uegcl-safety-label">Days without LTI</div>
                        <h3><?php echo esc_html($atts['card_3_title']); ?></h3>
                    </div>
                </div>
                
                <div class="uegcl-safety-card">
                    <div class="uegcl-safety-icon"><?php echo uegcl_get_safety_icon(); ?></div>
                    <div class="uegcl-safety-content">
                        <div class="uegcl-safety-days"><?php echo esc_html($atts['card_4_days']); ?></div>
                        <div class="uegcl-safety-label">Days without LTI</div>
                        <h3><?php echo esc_html($atts['card_4_title']); ?></h3>
                    </div>
                </div>
            </div>
        </div>
    </section>
    
    <?php
    return ob_get_clean();
}

// Helper function for safety icon
function uegcl_get_safety_icon() {
    return '<svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M12 22s8-4 8-10V5l-8-3-8 3v7c0 6 8 10 8 10z"/></svg>';
}


function uegcl_powerplants_section_callback($atts) {
    $atts = shortcode_atts(array(
        'bg_image' => '',
        'title' => 'Major Hydro Powerplants',
        'description' => 'UEGCL offers expert professional services for all types of hydropower development projects from Mini to Large development schemes, low to high head projects, run of the river to storage schemes, surface to subsurface development projects etc.',
        'button_text' => 'SEE ALL STATIONS',
        'button_link' => '#all-stations'
    ), $atts);
    
    $plants = array(
        array('name' => 'Kiira Power Station', 'image' => 'https://lwegatech.net/uegcl/wp-content/uploads/2025/10/kiira-power-station.jpg'),
        array('name' => 'Isimba Hydro Power Station', 'image' => 'https://lwegatech.net/uegcl/wp-content/uploads/2025/10/Isimba-Hydro.jpg'),
        array('name' => 'Nalubaale Power Station', 'image' => 'https://lwegatech.net/uegcl/wp-content/uploads/2025/10/Nalubaale.jpg'),
        array('name' => 'Karuma Hydro Power Station', 'image' => 'https://lwegatech.net/uegcl/wp-content/uploads/2025/10/Karuma.jpg'),
    );
    
    ob_start();
    ?>
    <section class="pp-section">
        <div class="pp-parallax" style="background-image:linear-gradient(135deg,rgba(var(--kpy-primary-rgb),.95),rgba(var(--kpy-primary-rgb),.85)),url('<?php echo esc_url($atts['bg_image']); ?>');"></div>
        <div class="pp-overlay"></div>
        
        <div class="pp-container">
            <div class="pp-content-wrapper">
                <div class="pp-text-content">
                    <h2 class="pp-title"><?php echo wp_kses_post(nl2br($atts['title'])); ?></h2>
                    <p class="pp-description"><?php echo esc_html($atts['description']); ?></p>
                    <a href="<?php echo esc_url($atts['button_link']); ?>" class="pp-cta-btn"><?php echo esc_html($atts['button_text']); ?></a>
                </div>
                
                <div class="pp-carousel-wrapper">
                    <div class="pp-carousel">
                        <?php foreach($plants as $index => $plant): ?>
                            <div class="pp-card" style="--delay: <?php echo $index * 0.2; ?>s">
                                <div class="pp-card-image">
                                    <img src="<?php echo esc_url($plant['image']); ?>" alt="<?php echo esc_attr($plant['name']); ?>">
                                    <div class="pp-card-overlay"></div>
                                </div>
                                <div class="pp-card-footer">
                                    <h3 class="pp-card-title"><?php echo esc_html($plant['name']); ?></h3>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        
                        <?php foreach($plants as $index => $plant): ?>
                            <div class="pp-card" style="--delay: <?php echo ($index + count($plants)) * 0.2; ?>s">
                                <div class="pp-card-image">
                                    <img src="<?php echo esc_url($plant['image']); ?>" alt="<?php echo esc_attr($plant['name']); ?>">
                                    <div class="pp-card-overlay"></div>
                                </div>
                                <div class="pp-card-footer">
                                    <h3 class="pp-card-title"><?php echo esc_html($plant['name']); ?></h3>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const parallax = document.querySelector('.pp-parallax');
            if (parallax && window.matchMedia('(prefers-reduced-motion: no-preference)').matches) {
                let ticking = false;
                window.addEventListener('scroll', function() {
                    if (!ticking) {
                        window.requestAnimationFrame(function() {
                            const scrolled = window.pageYOffset;
                            const sectionTop = parallax.closest('.pp-section').offsetTop;
                            const offset = (scrolled - sectionTop) * 0.5;
                            parallax.style.transform = `translateY(${offset}px)`;
                            ticking = false;
                        });
                        ticking = true;
                    }
                });
            }
        });
    </script>
    <?php
    return ob_get_clean();
}

add_shortcode('uegcl_powerplants_section', 'uegcl_powerplants_section_callback');

?>