<?php
/**
 * Company Overview Shortcode 
 * Usage: [company_overview]
 */

function uegcl_company_overview_shortcode() {
    ob_start();
    ?>
    
    <div class="co-wrapper">
        <!-- Who We Are -->
        <section class="co-section">
            <div class="co-about-grid">
                <div class="co-about-image-wrapper">
                    <div class="co-about-image">
                        <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/kiira-power-station.jpg" alt="UEGCL Power Plant" />
                    </div>
                </div>
                <div class="co-about-content">
                    <div class="co-section-subtitle">About Our Company</div>
                    <h2 class="co-section-title">Who We Are</h2>
                    <p class="co-content" style="text-align:left; margin:0 0 20px">
                        Uganda Electricity Generation Company Limited ("UEGCL or the Company") was incorporated in 2001 under the Companies Act (Cap 110) and the Electricity Act Cap 145 with the main objective of taking over the generation activities of the now defunct Uganda Electricity Board (UEB) together with all or any part of the property, assets, and liabilities associated with it, as was transferred to the Company by UEB as per the Public Enterprise Reform and Divestiture Act. These assets transferred to the Company from UEB were the 180 MW Nalubaale and 200 MW Kira Hydro Power Stations in Jinja.
                    </p>
                    <p class="co-content" style="text-align:left; margin:0">
                        The Company's portfolio has since grown to include the 183MW Isimba Hydro Power Plant, 50MW Namanve Thermal Power Plant, and 600MW Karuma Hydro Power Plant. Uganda Electricity Generation Company Limited is regulated by the Electricity Regulatory Authority (ERA).
                    </p>
                </div>
            </div>
        </section>
        
        <!-- Vision & Mission -->
        <section class="co-section">
            <div class="co-section-subtitle">Our Purpose</div>
            <h2 class="co-section-title">Vision & Mission</h2>
            <div class="co-vision-mission">
                <div class="co-vm-card">
                    <div class="co-vm-icon">👁️</div>
                    <h3 class="co-vm-title">Our Vision</h3>
                    <p class="co-vm-text">To be Africa's leading electricity-generating utility through innovation and sustainable practices.</p>
                </div>
                <div class="co-vm-card">
                    <div class="co-vm-icon">🎯</div>
                    <h3 class="co-vm-title">Our Mission</h3>
                    <p class="co-vm-text">To sustainably generate reliable, quality, and reasonably priced electricity for Uganda's socio-economic development.</p>
                </div>
                <div class="co-vm-card">
                    <div class="co-vm-icon">⚡</div>
                    <h3 class="co-vm-title">Our Purpose</h3>
                    <p class="co-vm-text">Making electricity safely available for supply at all times from all our plants across the nation.</p>
                </div>
            </div>
        </section>
        
                        <!-- Core Values -->
        <section class="co-section">
            <div class="co-section-subtitle">Our Foundation</div>
            <h2 class="co-section-title">Our Core Values</h2>
            
            <div class="co-values-grid">
                <div class="co-values-list">
                    <div class="co-value-item-new">
                        <div class="co-value-icon-new">🛡️</div>
                        <h4 class="co-value-name-new">Integrity</h4>
                    </div>
                    <div class="co-value-item-new">
                        <div class="co-value-icon-new">💡</div>
                        <h4 class="co-value-name-new">Innovation</h4>
                    </div>
                    <div class="co-value-item-new">
                        <div class="co-value-icon-new">📊</div>
                        <h4 class="co-value-name-new">Accountability</h4>
                    </div>
                    <div class="co-value-item-new">
                        <div class="co-value-icon-new">🛡️</div>
                        <h4 class="co-value-name-new">Safety</h4>
                    </div>
                    <div class="co-value-item-new">
                        <div class="co-value-icon-new">🌱</div>
                        <h4 class="co-value-name-new">Sustainability</h4>
                    </div>
                    <div class="co-value-item-new">
                        <div class="co-value-icon-new">🤝</div>
                        <h4 class="co-value-name-new">Collaboration</h4>
                    </div>
                </div>
                <div class="co-values-images">
                    <div class="co-values-image-primary">
                        <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/gcl.jpeg" alt="UEGCL Values" />
                    </div>
                    <div class="co-values-image-secondary">
                        <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/uegcl-slide.jpg" alt="UEGCL Teamwork" />
                    </div>
                </div>
            </div>
        </section>
    </div>
        
    <!-- Partners - Full Width Section -->
    <section class="co-partners-full">
        <div class="co-partners-inner">
            <div class="co-section-subtitle" style="color:var(--kpy-black)">Global Collaboration</div>
            <h2 class="co-section-title">Our Valued Partners</h2>
            <p class="co-content">We collaborate with leading international organizations and institutions to deliver excellence in energy generation</p>
            
            <div class="co-partners-grid">
                <a href="https://www.icold-cigb.org/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/logo-cigb.png" alt="ICOLD" class="co-partner-logo" />
                    <div class="co-partner-overlay">International Commission on Large Dams</div>
                </a>
                <a href="https://www.leeds.ac.uk/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/University-of-LEEDS-1.gif" alt="University of Leeds" class="co-partner-logo" />
                    <div class="co-partner-overlay">University of Leeds</div>
                </a>
                <a href="https://www.afd.fr/en" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/AFD-Logo.jpg" alt="AFD" class="co-partner-logo" />
                    <div class="co-partner-overlay">French Development Agency</div>
                </a>
                <a href="https://www.ilf.com/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/ILF-logo.jpg" alt="ILF Consulting" class="co-partner-logo" />
                    <div class="co-partner-overlay">ILF Consulting Engineers</div>
                </a>
                <a href="https://uetcl.go.ug/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/uegcl-logo.jpg" alt="UETCL" class="co-partner-logo" />
                    <div class="co-partner-overlay">Uganda Electricity Transmission Company</div>
                </a>
                <a href="https://ug.china-embassy.gov.cn/eng/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/Chinese-Embassy.jpg" alt="Chinese Embassy" class="co-partner-logo" />
                    <div class="co-partner-overlay">Chinese Embassy Uganda</div>
                </a>
                <a href="https://www.edfenergy.com/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/edf-energy.jpg" alt="EDF Energy" class="co-partner-logo" />
                    <div class="co-partner-overlay">EDF Energy</div>
                </a>
                <a href="https://ug.ambafrance.org/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/French-Embassy-Scholarship-for-Young-Professionals.jpg" alt="French Embassy" class="co-partner-logo" />
                    <div class="co-partner-overlay">French Embassy Uganda</div>
                </a>
                <a href="https://ug.ambafrance.org/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/Norway_Logo_Positive_CMYK.png" alt="French Embassy" class="co-partner-logo" />
                    <div class="co-partner-overlay">Norway</div>
                </a>
                <a href="https://ug.ambafrance.org/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/molg-uganda.jpg" alt="French Embassy" class="co-partner-logo" />
                    <div class="co-partner-overlay">Ministry of Local Government Uganda</div>
                </a>
                <a href="https://ug.ambafrance.org/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/nema-uganda.jpg" alt="French Embassy" class="co-partner-logo" />
                    <div class="co-partner-overlay">NEMA Uganda</div>
                </a>
                <a href="https://ug.ambafrance.org/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/dwrw-uganda.jpg" alt="French Embassy" class="co-partner-logo" />
                    <div class="co-partner-overlay">Directorate of Water Resource Management</div>
                </a>
                <a href="https://ug.ambafrance.org/" target="_blank" rel="noopener" class="co-partner-item">
                    <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/mowe.jpg" alt="French Embassy" class="co-partner-logo" />
                    <div class="co-partner-overlay">Ministry of Water and Environment Uganda</div>
                </a>
            </div>
        </div>
    </section>
    
    <?php
    return ob_get_clean();
}
add_shortcode('company_overview', 'uegcl_company_overview_shortcode');



function uegcl_objectives_shortcode() {
    ob_start();
    ?>
    
    <div class="objectives-container">
        <!-- Hero Section -->
        <section class="obj-hero">
            <h1>Our Objectives</h1>
            <div class="obj-hero-content">
                <div class="obj-mandate">
                    <h2>UEGCL Mandate</h2>
                    <p>UEGCL's Mandate is to "establish, acquire, maintain and operate electricity generation facilities, and to promote research and development in the electricity generation sector while running the company on sound business principles".</p>
                </div>
                <div class="obj-main">
                    <h2>Our Main Objective</h2>
                    <p>Our main objective is the development, efficient operation and maintenance of Power plants and the sustainable generation and sale of affordable electricity to consumers.</p>
                </div>
            </div>
        </section>

        <!-- Specific Objectives Grid -->
        <section class="obj-specific">
            <h2>Specific Objectives</h2>
            <p class="obj-intro">The Objectives of UEGCL have since expanded to include project development including development of Hydro Power Stations and other renewable energy projects. Below are our specific objectives.</p>
            
            <div class="obj-grid">
                <div class="obj-card">
                    <div class="obj-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                            <circle cx="9" cy="7" r="4"></circle>
                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                        </svg>
                    </div>
                    <h3>Improving UEGCL’s staff knowledge and skills:</h3>
                    <p>Acquire, develop and retain an inclusive workforce to drive the company strategy</p>
                </div>

                <div class="obj-card">
                    <div class="obj-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M3 9l9-7 9 7v11a2 2 0 0 1-2 2H5a2 2 0 0 1-2-2z"></path>
                            <polyline points="9 22 9 12 15 12 15 22"></polyline>
                        </svg>
                    </div>
                    <h3>Enhancing UEGCL’s Corporate Culture:</h3>
                    <p> A company’s beliefs, values and attitudes and how these influence the behavior of its employees</p>
                </div>

                <div class="obj-card">
                    <div class="obj-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <rect x="3" y="3" width="18" height="18" rx="2" ry="2"></rect>
                            <line x1="9" y1="9" x2="15" y2="15"></line>
                            <line x1="15" y1="9" x2="9" y2="15"></line>
                        </svg>
                    </div>
                    <h3>Improving UEGCL’s Asset Management:</h3>
                    <p>Coordinated activity of the organization to realize value from Assets. Activity includes:- planning, the approach, plans and their implementation while realizing value involves balancing risks, opportunities and performance benefits</p>
                </div>

                <div class="obj-card">
                    <div class="obj-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <rect x="2" y="3" width="20" height="14" rx="2" ry="2"></rect>
                            <line x1="8" y1="21" x2="16" y2="21"></line>
                            <line x1="12" y1="17" x2="12" y2="21"></line>
                        </svg>
                    </div>
                    <h3>Strengthening UEGCL’s ICT Infrastructure and Technology:</h3>
                    <p>Design and application information and communication technology for business processes to support data processing, secure workflows and business continuity.</p>
                </div>

                <div class="obj-card">
                    <div class="obj-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <line x1="12" y1="1" x2="12" y2="23"></line>
                            <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                        </svg>
                    </div>
                    <h3>Enhancing UEGCL’s Business Portfolio:</h3>
                    <p>Grow and diversify our core and non-core business undertakings to ensure energy security, increased revenue and hedge against financial risks.</p>
                </div>

                <div class="obj-card">
                    <div class="obj-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M17 21v-2a4 4 0 0 0-4-4H5a4 4 0 0 0-4 4v2"></path>
                            <circle cx="9" cy="7" r="4"></circle>
                            <path d="M23 21v-2a4 4 0 0 0-3-3.87"></path>
                            <path d="M16 3.13a4 4 0 0 1 0 7.75"></path>
                        </svg>
                    </div>
                    <h3>Strengthening Collaboration:</h3>
                    <p>Entails proactive approaches of working well with stakeholders with a view of realizing mutual benefits. </p>
                </div>

                <div class="obj-card">
                    <div class="obj-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M14 2H6a2 2 0 0 0-2 2v16a2 2 0 0 0 2 2h12a2 2 0 0 0 2-2V8z"></path>
                            <polyline points="14 2 14 8 20 8"></polyline>
                            <line x1="9" y1="15" x2="15" y2="15"></line>
                        </svg>
                    </div>
                    <h3>Improving Governance:</h3>
                    <p>Processes and structures designed to ensure accountability and responsiveness to applicable policies, standards, regulatory and statutory requirements aimed to safeguard against reputational damage and financial loss</p>
                </div>

                <div class="obj-card">
                    <div class="obj-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <line x1="12" y1="1" x2="12" y2="23"></line>
                            <path d="M17 5H9.5a3.5 3.5 0 0 0 0 7h5a3.5 3.5 0 0 1 0 7H6"></path>
                        </svg>
                    </div>
                    <h3>Enhancing UEGCL’s Financial Performance:</h3>
                    <p>In line with the financial recovery plan, this entails the generation of adequate revenue and having in place appropriate controls towards meeting the company’s operational and strategic obligations. </p>
                </div>

                <div class="obj-card">
                    <div class="obj-icon">
                        <svg viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2">
                            <path d="M20.84 4.61a5.5 5.5 0 0 0-7.78 0L12 5.67l-1.06-1.06a5.5 5.5 0 0 0-7.78 7.78l1.06 1.06L12 21.23l7.78-7.78 1.06-1.06a5.5 5.5 0 0 0 0-7.78z"></path>
                        </svg>
                    </div>
                    <h3>Improving UEGCL’s stakeholder Satisfaction:</h3>
                    <p>The level of contentment of our stakeholders with our services</p>
                </div>
            </div>
        </section>
    </div>

    <style>
    .objectives-container{max-width:1200px;margin:0 auto;padding:20px;}
    .obj-hero{background:linear-gradient(135deg,var(--kpy-primary) 0%,rgba(var(--kpy-primary-rgb),0.8) 100%);color:var(--kpy-white);padding:60px 40px;border-radius:8px;margin-bottom:60px;}
    .obj-hero h1{font-size:3rem;margin:0 0 40px 0;text-align:center;}
    .obj-hero-content{display:grid;grid-template-columns:1fr 1fr;gap:40px;}
    .obj-mandate,.obj-main{background:rgba(var(--kpy-white-rgb),0.1);padding:30px;border-radius:6px;border-left:4px solid var(--kpy-secondary);}
    .obj-hero h2{font-size:1.8rem;margin:0 0 15px 0;color:var(--kpy-gold);}
    .obj-hero p{font-size:1rem;line-height:1.8;margin:0;}
    .obj-specific{margin-bottom:60px;}
    .obj-specific h2{font-size:2.5rem;color:var(--kpy-primary);text-align:center;margin:0 0 20px 0;}
    .obj-intro{text-align:center;max-width:800px;margin:0 auto 50px;font-size:1.1rem;color:var(--kpy-grey);}
    .obj-grid{display:grid;grid-template-columns:repeat(3,1fr);gap:30px;}
    .obj-card{background:var(--kpy-white);border:1px solid rgba(var(--kpy-primary-rgb),0.1);border-radius:8px;padding:30px;text-align:center;transition:all 0.3s ease;box-shadow:0 2px 8px rgba(0,0,0,0.05);}
    .obj-card:hover{transform:translateY(-5px);box-shadow:0 8px 20px rgba(var(--kpy-primary-rgb),0.15);border-color:var(--kpy-primary);}
    .obj-icon{width:60px;height:60px;margin:0 auto 20px;background:linear-gradient(135deg,var(--kpy-primary),var(--kpy-secondary));border-radius:50%;display:flex;align-items:center;justify-content:center;color:var(--kpy-white);}
    .obj-icon svg{width:30px;height:30px;}
    .obj-card h3{font-size:1.3rem;color:var(--kpy-primary);margin:0 0 15px 0;}
    .obj-card p{font-size:0.95rem;color:var(--kpy-grey);line-height:1.6;margin:0;}
    @media(max-width:992px){.obj-hero-content{grid-template-columns:1fr;}.obj-grid{grid-template-columns:repeat(2,1fr);}}
    @media(max-width:768px){.obj-hero{padding:40px 20px;}.obj-hero h1{font-size:2rem;}.obj-grid{grid-template-columns:1fr;gap:20px;}.obj-card{padding:25px;}}
    </style>

    <?php
    return ob_get_clean();
}
add_shortcode('uegcl_objectives', 'uegcl_objectives_shortcode');


function uegcl_ceo_message_shortcode() {
    ob_start();
    ?>
    
    <section class="ceo-msg-section">
        <div class="ceo-msg-container">
            <div class="ceo-msg-header">
                <span class="ceo-msg-subtitle">Leadership</span>
                <h1 class="ceo-msg-title">CEO's Message</h1>
            </div>
            
            <div class="ceo-msg-grid">
                <div class="ceo-msg-sidebar">
                    <div class="ceo-img-wrapper">
                        <div class="ceo-img">
                            <img src="https://lwegatech.net/uegcl/wp-content/uploads/2025/10/Dr.-Eng.-Harrison-.E.-MUTIKANGA-UEGCL.jpg" alt="Dr. Eng. Harrison E. Mutikanga">
                        </div>
                    </div>
                    
                    <div class="ceo-info-card">
                        <h4>Dr. Eng. Harrison E. MUTIKANGA</h4>
                        <p class="ceo-position">Chief Executive Officer</p>
                        <p class="ceo-org">UEGCL</p>
                        <div class="ceo-social">
                            <a href="https://twitter.com/UEGCL_CEO" target="_blank" rel="noopener">
                                <svg width="20" height="20" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2"><path d="M23 3a10.9 10.9 0 01-3.14 1.53 4.48 4.48 0 00-7.86 3v1A10.66 10.66 0 013 4s-4 9 5 13a11.64 11.64 0 01-7 2c9 5 20 0 20-11.5a4.5 4.5 0 00-.08-.83A7.72 7.72 0 0023 3z"></path></svg>
                                @UEGCL_CEO
                            </a>
                        </div>
                    </div>
                </div>
                
                <div class="ceo-msg-content">
                    <p class="ceo-msg-greeting">Dear Reader,</p>
                    
                    <p>I welcome you to the UEGCL website as we celebrate 20 years of UEGCL under the theme "20 years of Generating for GENERATIONS". It has been a great journey characterized by the exponential growth of UEGCL's mandate and infrastructural developments.</p>
                    
                    <p>It will be recalled that UEGCL was borne out of a restructuring process, which led to the unbundling of the then UEB, and the creation of among others UEGCL in 2001. In 2003, the major assets of the Company (Kira 200 MW and Nalubaale 183 MW) were concessioned to ESKOM Uganda Ltd for a period of 20 years. UEGCL's role was limited to monitoring the Concession performance with a paltry staff of about 38 persons. For most of the years since inception in 2001, UEGCL's financial performance was abysmal with the company posting bottom line losses on the profit and loss account. This was partly because there was a mismatch between the revenues of the company and the assets that were being managed under the concession. In 2014, the Company's mandate was expanded to include project development via a Ministerial Directive. Since then, UEGCL has made a number of strides. These include:</p>
                    
                    <h3>Key Achievements</h3>
                    
                    <p><strong>Strategic Planning:</strong> Two consecutive strategic plans were formulated for 3 years (2015-2018) and subsequently the 5-year Strategic plan for the period 2018–2023. These have ably guided the activities of the Company.</p>
                    
                    <p><strong>Human Resource Growth:</strong> Our human resource complement increased from 38 staff to currently 201 to meet our work demands. The biggest growth factor was the commencement of Operations and Maintenance of the Isimba (183MW) hydropower Plant under the jurisdiction of UEGCL.</p>
                    
                    <p><strong>Project Development:</strong> Prudent Contract administration of the flagship projects, has since led to the fruition of the Karuma (600MW) hydropower project which is due for commissioning in June 2022. These have added to the energy mix within the country. Other ongoing projects include; Muzizi hydropower plant (48MW), Nyagak III (6.6MW), and the Maziba (1 MW) for which detailed feasibility studies have been completed and funds are being sought. Relatedly, UEGCL has formulated an Energy Mix Strategy that will see UEGCL explore other sources of Energy to include Solar, Geothermal, and Thermal. This will help in diversifying from the current high dependency on hydropower.</p>
                    <p><strong>Operational Excellence:</strong> Consequent to the establishment of the above hydropower facilities, UEGCL is now focusing on consolidating its footprint in operation and maintenance of the Isimba HPP, and yet to be commissioned Karuma HPP. This will be a paradigm shift that shall see the Company operate sustainably and enabling her to contribute towards further development of the generation capacity in the country through leveraging her internal resources. UEGCL futuristic aspirations aim at operating the Karuma and Isimba plants as semi-autonomous Operation and Maintenance Business entities as opposed to the conventional Concession monitoring dispensation.</p>
                    <p><strong>Digital Transformation:</strong> A number of initiatives are also underway to automate the operations of the Company. In this regard, UEGCL has benchmarked its operations with a number of utilities operating best practices in Asset Management, Dam Safety, and Cyber Security. In line with this, the coming years will focus on the acquisition of software tools required to support asset management and dam safety and build capacity in data analytics.</p>
                </div>
                
                <div class="ceo-msg-content">
                    
                    <p><strong>Financial Turnaround:</strong> On the financial perspective, after more than a decade of loss-making, UEGCL made a turnaround and posted a bottom-line profit during the financial year ended June 2019. It is envisaged that this profit will be sustained with the increasing proficient O&M activities. UEGCL also plans to commence activities leading to its eventual listing on the Stock Exchange. Its short-term plans to achieve the latter include; restructuring of the UEGCL Balance Sheet, ability to bill for full costs in accordance with the Concession and Assignment Agreement (CAA), and finally, the build-up of history (not less than 3 years) of profitability and creditworthiness.</p>
                    
                    <p><strong>Strategic Partnerships:</strong> In the last twenty years, UEGCL made deliberate efforts in building strategic partnerships with These include; Centre for Research in Energy and Energy Conservation (CREEC), College of Engineering, Design, Art, and Technology (CEDAT), Compagnie Nationale Du Rhone (CNR) a French Hydropower Utility, Uganda Industrial Research Institute (UIRI), and the International Centre for Hydropower Development (ICH). These Partnerships were aimed at promoting the exchange of trainers, expertise, promotion of Research and Development, and capacity building through benchmarking of best practices.</p>
                    
                    <p><strong>Hydropower Resource Centre:</strong> UEGCL plans to establish a Hydropower Resource Centre as a Centre of excellence. The Centre will ensure continuous and cost-effective capacity building for Operations & Maintenance (O&M) within and beyond Uganda and most especially for Independent Power Producers. This will support government initiatives of providing employment to the youth. The resource center will also cater for coordinated research, innovation, benchmarking, training, and best practice sharing. It is envisaged that the Centre will eventually be self-sustaining offering practical insights and best practices in hydropower development and management.</p>
                    
                    <p><strong>ISO Certification:</strong> In order to ensure process efficiency, UEGCL attained ISO 9001:2015 certification on 8th, June 2017, making it the first public company to attain this achievement. Our clamor for this certification was and remains an illustration of our unwavering commitment to improving and streamlining our various processes and activities in the company to enhance operational efficiency. Furthermore, UEGCL is to explore certification in other areas, such as Health and Safety, Asset Management, and Risk Management, given the value and magnitude of assets within the remit of the Company.</p>
                    
                    
                    <p class="ceo-msg-conclusion">In conclusion, the outlook for UEGCL is very promising as the company edges towards achieving its Vision, Mission and Mandate. Critical activities will be hinged upon the streamlining of its operational and functional areas. This will be achieved through concerted stakeholder management efforts and continued quest for best practices. In line with UEGCL's mandate of Project Development and Management of the existing and new generation Plants, the Company is contributing towards realization of the Governments Vision of a Transformed Ugandan Society from a Peasantry to a Modern and Prosperous Country within 30 years.</p>
                </div>
            </div>
        </div>
    </section>
    
    <?php
    return ob_get_clean();
}
add_shortcode('ceo_message', 'uegcl_ceo_message_shortcode');


?>